/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicListDefinition;

@XmlRootElement(name="YoGraphicGroup")
public class YoGraphicGroupDefinition
extends YoGraphicDefinition {
    private List<YoGraphicDefinition> children;

    public YoGraphicGroupDefinition() {
    }

    public YoGraphicGroupDefinition(String name) {
        this();
        this.setName(name);
    }

    public YoGraphicGroupDefinition(YoGraphicGroupDefinition other) {
        super(other);
        if (other.children != null) {
            this.children = other.children.stream().map(YoGraphicDefinition::copy).collect(Collectors.toList());
        }
    }

    @Override
    protected void registerFields() {
        super.registerFields();
        this.registerListField("children", this::getChildren, this::setChildren, "child", YoGraphicDefinition::toParsableString, YoGraphicDefinition::parse);
    }

    public YoGraphicGroupDefinition(String name, YoGraphicDefinition ... children) {
        this(name, Arrays.asList(children));
    }

    public YoGraphicGroupDefinition(String name, Collection<? extends YoGraphicDefinition> children) {
        this(name);
        if (children != null) {
            this.children = new ArrayList<YoGraphicDefinition>(children);
        }
    }

    public void addChild(YoGraphicDefinition child) {
        if (child == null) {
            return;
        }
        if (child instanceof YoGraphicListDefinition) {
            YoGraphicListDefinition list = (YoGraphicListDefinition)child;
            if (list == null || list.getYoGraphics() == null) {
                return;
            }
            for (int i = 0; i < list.getYoGraphics().size(); ++i) {
                this.addChild(list.getYoGraphics().get(i));
            }
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList<YoGraphicDefinition>();
        }
        this.children.add(child);
    }

    @XmlElement
    public void setChildren(List<YoGraphicDefinition> children) {
        this.children = children;
    }

    public void unwrapLists() {
        if (this.children == null) {
            return;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            YoGraphicDefinition child = this.children.get(i);
            if (child instanceof YoGraphicListDefinition) {
                YoGraphicListDefinition list = (YoGraphicListDefinition)child;
                this.children.remove(i);
                if (list.getYoGraphics() == null) continue;
                list.unwrapNestedLists();
                this.children.addAll(i, list.getYoGraphics());
                continue;
            }
            if (!(child instanceof YoGraphicGroupDefinition)) continue;
            YoGraphicGroupDefinition subGroup = (YoGraphicGroupDefinition)child;
            subGroup.unwrapLists();
        }
    }

    public void unwrapNestedGroups() {
        if (this.children == null) {
            return;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            YoGraphicDefinition child = this.children.get(i);
            if (!(child instanceof YoGraphicGroupDefinition)) continue;
            YoGraphicGroupDefinition subGroup = (YoGraphicGroupDefinition)child;
            this.children.remove(i);
            if (subGroup.getChildren() == null) continue;
            subGroup.unwrapNestedGroups();
            this.children.addAll(i, subGroup.getChildren());
        }
    }

    public void mergeNestedGroupsByName() {
        if (this.children == null) {
            return;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            YoGraphicDefinition child = this.children.get(i);
            if (child instanceof YoGraphicGroupDefinition) {
                YoGraphicGroupDefinition subGroup = (YoGraphicGroupDefinition)child;
                subGroup.mergeNestedGroupsByName();
                for (int j = this.children.size() - 1; j > i; --j) {
                    YoGraphicDefinition otherChild = this.children.get(j);
                    if (!(otherChild instanceof YoGraphicGroupDefinition)) continue;
                    YoGraphicGroupDefinition otherSubGroup = (YoGraphicGroupDefinition)otherChild;
                    if (!subGroup.getName().equals(otherSubGroup.getName())) continue;
                    this.children.remove(j);
                    subGroup.getChildren().addAll(otherSubGroup.getChildren());
                }
                continue;
            }
            if (!(child instanceof YoGraphicListDefinition)) continue;
            YoGraphicListDefinition list = (YoGraphicListDefinition)child;
            list.mergeGroupsByName();
        }
    }

    public boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    public List<YoGraphicDefinition> getChildren() {
        return this.children;
    }

    @Override
    public YoGraphicGroupDefinition copy() {
        return new YoGraphicGroupDefinition(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof YoGraphicGroupDefinition) {
            YoGraphicGroupDefinition other = (YoGraphicGroupDefinition)object;
            return Objects.equals(this.children, other.children);
        }
        return false;
    }

    @Override
    public String toString(int indent) {
        String out = "%s [name=%s, visible=%b, children=%s]";
        return out.formatted(this.getClass().getSimpleName(), this.name, this.visible, YoGraphicGroupDefinition.indentedListString(indent, true, this.children, child -> child.toString(indent + 1)));
    }
}

