/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.urdf.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.scs2.definition.robot.urdf.items.URDFFilenameHolder;

public interface URDFItem {
    public String getContentAsString();

    default public String format(String format, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof URDFItem)) continue;
            args[i] = ((URDFItem)args[i]).getContentAsString();
        }
        return String.format(format, args);
    }

    default public String itemToString() {
        return this.getClass().getSimpleName() + ": " + this.getContentAsString();
    }

    public List<URDFFilenameHolder> getFilenameHolders();

    public static List<URDFFilenameHolder> combineItemFilenameHolders(URDFItem ... urdfItems) {
        if (urdfItems == null || urdfItems.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<URDFFilenameHolder> filenameHolders = new ArrayList<URDFFilenameHolder>();
        for (URDFItem urdfItem : urdfItems) {
            if (urdfItem == null) continue;
            filenameHolders.addAll(urdfItem.getFilenameHolders());
        }
        return filenameHolders;
    }

    @SafeVarargs
    public static List<URDFFilenameHolder> combineItemListsFilenameHolders(List<? extends URDFItem> ... urdfItemLists) {
        if (urdfItemLists == null || urdfItemLists.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<URDFFilenameHolder> filenameHolders = new ArrayList<URDFFilenameHolder>();
        for (List<? extends URDFItem> urdfItemList : urdfItemLists) {
            if (urdfItemList == null) continue;
            for (URDFItem uRDFItem : urdfItemList) {
                if (uRDFItem == null) continue;
                filenameHolders.addAll(uRDFItem.getFilenameHolders());
            }
        }
        return filenameHolders;
    }
}

