/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.urdf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.CrossFourBarJointDefinition;
import us.ihmc.scs2.definition.robot.FixedJointDefinition;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.LidarSensorDefinition;
import us.ihmc.scs2.definition.robot.MomentOfInertiaDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.PlanarJointDefinition;
import us.ihmc.scs2.definition.robot.PrismaticJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteTwinsJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.definition.robot.sdf.SDFTools;
import us.ihmc.scs2.definition.robot.urdf.items.URDFAxis;
import us.ihmc.scs2.definition.robot.urdf.items.URDFBox;
import us.ihmc.scs2.definition.robot.urdf.items.URDFCollision;
import us.ihmc.scs2.definition.robot.urdf.items.URDFColor;
import us.ihmc.scs2.definition.robot.urdf.items.URDFCylinder;
import us.ihmc.scs2.definition.robot.urdf.items.URDFDynamics;
import us.ihmc.scs2.definition.robot.urdf.items.URDFFilenameHolder;
import us.ihmc.scs2.definition.robot.urdf.items.URDFGazebo;
import us.ihmc.scs2.definition.robot.urdf.items.URDFGeometry;
import us.ihmc.scs2.definition.robot.urdf.items.URDFInertia;
import us.ihmc.scs2.definition.robot.urdf.items.URDFInertial;
import us.ihmc.scs2.definition.robot.urdf.items.URDFItem;
import us.ihmc.scs2.definition.robot.urdf.items.URDFJoint;
import us.ihmc.scs2.definition.robot.urdf.items.URDFLimit;
import us.ihmc.scs2.definition.robot.urdf.items.URDFLink;
import us.ihmc.scs2.definition.robot.urdf.items.URDFLinkReference;
import us.ihmc.scs2.definition.robot.urdf.items.URDFMass;
import us.ihmc.scs2.definition.robot.urdf.items.URDFMaterial;
import us.ihmc.scs2.definition.robot.urdf.items.URDFMesh;
import us.ihmc.scs2.definition.robot.urdf.items.URDFModel;
import us.ihmc.scs2.definition.robot.urdf.items.URDFOrigin;
import us.ihmc.scs2.definition.robot.urdf.items.URDFSensor;
import us.ihmc.scs2.definition.robot.urdf.items.URDFSphere;
import us.ihmc.scs2.definition.robot.urdf.items.URDFTexture;
import us.ihmc.scs2.definition.robot.urdf.items.URDFVisual;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.TextureDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class URDFTools {
    private static final Vector3D DEFAULT_ORIGIN_XYZ = new Vector3D();
    private static final Vector3D DEFAULT_ORIGIN_RPY = new Vector3D();
    private static final double DEFAULT_MASS = 0.0;
    private static final double DEFAULT_IXX = 0.0;
    private static final double DEFAULT_IYY = 0.0;
    private static final double DEFAULT_IZZ = 0.0;
    private static final double DEFAULT_IXY = 0.0;
    private static final double DEFAULT_IXZ = 0.0;
    private static final double DEFAULT_IYZ = 0.0;
    private static final Vector3DReadOnly DEFAULT_AXIS = new Vector3D(1.0, 0.0, 0.0);
    private static final double DEFAULT_LOWER_LIMIT = Double.NEGATIVE_INFINITY;
    private static final double DEFAULT_UPPER_LIMIT = Double.POSITIVE_INFINITY;
    private static final double DEFAULT_EFFORT_LIMIT = Double.POSITIVE_INFINITY;
    private static final double DEFAULT_VELOCITY_LIMIT = Double.POSITIVE_INFINITY;
    public static final URDFParserProperties DEFAULT_URDF_PARSER_PROPERTIES = new URDFParserProperties();
    public static final URDFGeneratorProperties DEFAULT_URDF_GENERATOR_PROPERTIES = new URDFGeneratorProperties();

    public static URDFModel loadURDFModel(File urdfFile) throws JAXBException {
        return URDFTools.loadURDFModel(urdfFile, Collections.emptyList());
    }

    public static URDFModel loadURDFModel(File urdfFile, Collection<String> resourceDirectories) throws JAXBException {
        return URDFTools.loadURDFModel(urdfFile, resourceDirectories, DEFAULT_URDF_PARSER_PROPERTIES);
    }

    public static URDFModel loadURDFModel(File urdfFile, Collection<String> resourceDirectories, URDFParserProperties parserProperties) throws JAXBException {
        try {
            return URDFTools.loadURDFModel(new BufferedInputStream(new FileInputStream(urdfFile)), resourceDirectories, null, parserProperties);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static URDFModel loadURDFModel(InputStream inputStream, Collection<String> resourceDirectories, ClassLoader resourceClassLoader) throws JAXBException {
        return URDFTools.loadURDFModel(inputStream, resourceDirectories, resourceClassLoader, DEFAULT_URDF_PARSER_PROPERTIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URDFModel loadURDFModel(InputStream inputStream, Collection<String> resourceDirectories, ClassLoader resourceClassLoader, URDFParserProperties parserProperties) throws JAXBException {
        try {
            URDFModel urdfModel;
            HashSet<String> allResourceDirectories = new HashSet<String>(resourceDirectories);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{URDFModel.class});
            Unmarshaller um = context.createUnmarshaller();
            if (!parserProperties.ignoreNamespace) {
                urdfModel = (URDFModel)um.unmarshal(inputStream);
            } else {
                XMLReader reader;
                InputSource is = new InputSource(inputStream);
                SAXParserFactory sax = SAXParserFactory.newInstance();
                sax.setNamespaceAware(false);
                try {
                    reader = sax.newSAXParser().getXMLReader();
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new JAXBException((Throwable)e);
                }
                SAXSource source = new SAXSource(reader, is);
                urdfModel = (URDFModel)um.unmarshal((Source)source);
            }
            URDFTools.resolvePaths(urdfModel, allResourceDirectories, resourceClassLoader);
            if (!parserProperties.linksToIgnore.isEmpty() && urdfModel.getLinks() != null) {
                urdfModel.getLinks().removeIf(urdfLink -> parserProperties.linksToIgnore.contains(urdfLink.getName()));
            }
            if (!parserProperties.jointsToIgnore.isEmpty() && urdfModel.getJoints() != null) {
                urdfModel.getJoints().removeIf(urdfJoint -> parserProperties.jointsToIgnore.contains(urdfJoint.getName()));
            }
            if (!parserProperties.parseSensors) {
                urdfModel.getGazebos().removeIf(gazebo -> gazebo.getSensor() != null);
            }
            URDFModel uRDFModel = urdfModel;
            return uRDFModel;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LogTools.error((String)e.getMessage());
            }
        }
    }

    public static void resolvePaths(URDFModel urdfModel, Collection<String> resourceDirectories) {
        URDFTools.resolvePaths(urdfModel, resourceDirectories, null);
    }

    public static void resolvePaths(URDFModel urdfModel, Collection<String> resourceDirectories, ClassLoader resourceClassLoader) {
        if (resourceClassLoader == null) {
            resourceClassLoader = URDFTools.class.getClassLoader();
        }
        List<URDFFilenameHolder> filenameHolders = urdfModel.getFilenameHolders();
        for (URDFFilenameHolder urdfFilenameHolder : filenameHolders) {
            urdfFilenameHolder.setFilename(URDFTools.tryToConvertToPath(urdfFilenameHolder.getFilename(), resourceDirectories, resourceClassLoader));
        }
    }

    public static String tryToConvertToPath(String filename, Collection<String> resourceDirectories, ClassLoader resourceClassLoader) {
        return SDFTools.tryToConvertToPath(filename, resourceDirectories, resourceClassLoader);
    }

    public static RobotDefinition toRobotDefinition(URDFModel urdfModel) {
        return URDFTools.toRobotDefinition(urdfModel, DEFAULT_URDF_PARSER_PROPERTIES);
    }

    public static RobotDefinition toRobotDefinition(URDFModel urdfModel, URDFParserProperties parserProperties) {
        RigidBodyDefinition rootBodyDefinition;
        List<URDFLink> urdfLinks = urdfModel.getLinks();
        List<URDFJoint> urdfJoints = urdfModel.getJoints();
        List<URDFGazebo> urdfGazebos = urdfModel.getGazebos();
        ArrayList<RigidBodyDefinition> rigidBodyDefinitions = new ArrayList<RigidBodyDefinition>();
        for (URDFLink uRDFLink : urdfLinks) {
            rigidBodyDefinitions.add(URDFTools.toRigidBodyDefinition(uRDFLink, parserProperties));
        }
        ArrayList<JointDefinition> jointDefinitions = new ArrayList<JointDefinition>();
        if (urdfJoints != null) {
            jointDefinitions = new ArrayList();
            for (URDFJoint urdfJoint : urdfJoints) {
                jointDefinitions.add(URDFTools.toJointDefinition(urdfJoint, parserProperties));
            }
        }
        RigidBodyDefinition rigidBodyDefinition = URDFTools.connectKinematics(rigidBodyDefinitions, jointDefinitions, urdfJoints);
        if (parserProperties.rootJointFactory != null) {
            JointDefinition rootJointDefinition = parserProperties.rootJointFactory.get();
            if (rootJointDefinition.getName() == null) {
                rootJointDefinition.setName(rigidBodyDefinition.getName());
            }
            rootJointDefinition.setSuccessor(rigidBodyDefinition);
            rootBodyDefinition = new RigidBodyDefinition("rootBody");
            rootBodyDefinition.addChildJoint(rootJointDefinition);
            jointDefinitions.add(rootJointDefinition);
        } else {
            rootBodyDefinition = rigidBodyDefinition;
        }
        URDFTools.addSensors(urdfGazebos, jointDefinitions, parserProperties);
        RobotDefinition robotDefinition = new RobotDefinition(urdfModel.getName());
        robotDefinition.setRootBodyDefinition(rootBodyDefinition);
        if (parserProperties.simplifyKinematics) {
            robotDefinition.simplifyKinematics();
        }
        if (parserProperties.transformToZUp) {
            robotDefinition.transformAllFramesToZUp();
        }
        return robotDefinition;
    }

    public static void addSensors(List<URDFGazebo> urdfGazebos, List<JointDefinition> jointDefinitions, URDFParserProperties parserProperties) {
        if (urdfGazebos == null || urdfGazebos.isEmpty()) {
            return;
        }
        Map jointDefinitionMap = jointDefinitions.stream().collect(Collectors.toMap(JointDefinition::getName, Function.identity()));
        Map linkNameToJointDefinitionMap = jointDefinitions.stream().collect(Collectors.toMap(joint -> joint.getSuccessor().getName(), Function.identity()));
        for (URDFGazebo urdfGazebo : urdfGazebos) {
            if (urdfGazebo.getSensor() == null) continue;
            List<SensorDefinition> sensorDefinitions = URDFTools.toSensorDefinition(urdfGazebo.getSensor(), parserProperties);
            JointDefinition jointDefinition = (JointDefinition)jointDefinitionMap.get(urdfGazebo.getReference());
            if (jointDefinition == null) {
                jointDefinition = (JointDefinition)linkNameToJointDefinitionMap.get(urdfGazebo.getReference());
            }
            if (jointDefinition == null) {
                LogTools.error((String)("Could not find reference: " + urdfGazebo.getReference()));
                continue;
            }
            if (sensorDefinitions == null) continue;
            sensorDefinitions.forEach(jointDefinition::addSensorDefinition);
        }
    }

    public static RigidBodyDefinition connectKinematics(List<RigidBodyDefinition> rigidBodyDefinitions, List<JointDefinition> jointDefinitions, List<URDFJoint> urdfJoints) {
        Map rigidBodyDefinitionMap = rigidBodyDefinitions.stream().collect(Collectors.toMap(RigidBodyDefinition::getName, Function.identity()));
        Map jointDefinitionMap = jointDefinitions.stream().collect(Collectors.toMap(JointDefinition::getName, Function.identity()));
        if (urdfJoints != null) {
            for (URDFJoint urdfJoint2 : urdfJoints) {
                URDFLinkReference parent = urdfJoint2.getParent();
                URDFLinkReference child = urdfJoint2.getChild();
                RigidBodyDefinition parentRigidBodyDefinition = (RigidBodyDefinition)rigidBodyDefinitionMap.get(parent.getLink());
                Objects.requireNonNull(parentRigidBodyDefinition, "Could not find parent rigid-body (%s) for joint (%s)".formatted(parent.getLink(), urdfJoint2.getName()));
                RigidBodyDefinition childRigidBodyDefinition = (RigidBodyDefinition)rigidBodyDefinitionMap.get(child.getLink());
                Objects.requireNonNull(parentRigidBodyDefinition, "Could not find child rigid-body (%s) for joint (%s)".formatted(child.getLink(), urdfJoint2.getName()));
                JointDefinition jointDefinition = (JointDefinition)jointDefinitionMap.get(urdfJoint2.getName());
                jointDefinition.setSuccessor(childRigidBodyDefinition);
                parentRigidBodyDefinition.addChildJoint(jointDefinition);
            }
        }
        if (urdfJoints == null) {
            return rigidBodyDefinitions.get(0);
        }
        Map childToParentJoint = urdfJoints.stream().collect(Collectors.toMap(urdfJoint -> urdfJoint.getChild().getLink(), Function.identity()));
        String rootBodyName = urdfJoints.iterator().next().getParent().getLink();
        URDFJoint parentJoint = (URDFJoint)childToParentJoint.get(rootBodyName);
        while (parentJoint != null) {
            rootBodyName = parentJoint.getParent().getLink();
            parentJoint = (URDFJoint)childToParentJoint.get(rootBodyName);
        }
        return (RigidBodyDefinition)rigidBodyDefinitionMap.get(rootBodyName);
    }

    public static RigidBodyDefinition toRigidBodyDefinition(URDFLink urdfLink, URDFParserProperties parserProperties) {
        int i;
        RigidBodyDefinition definition = new RigidBodyDefinition(urdfLink.getName());
        URDFInertial urdfInertial = urdfLink.getInertial();
        if (urdfInertial == null) {
            definition.setMass(URDFTools.parseMass(null, parserProperties));
            definition.getMomentOfInertia().set((Matrix3DReadOnly)URDFTools.parseMomentOfInertia(null, parserProperties));
            definition.getInertiaPose().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(null, parserProperties));
        } else {
            definition.setMass(URDFTools.parseMass(urdfInertial.getMass(), parserProperties));
            definition.getMomentOfInertia().set((Matrix3DReadOnly)URDFTools.parseMomentOfInertia(urdfInertial.getInertia(), parserProperties));
            definition.getInertiaPose().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfInertial.getOrigin(), parserProperties));
        }
        if (urdfLink.getVisual() != null) {
            List<URDFVisual> urdfVisuals = urdfLink.getVisual();
            for (i = 0; i < urdfVisuals.size(); ++i) {
                URDFVisual urdfVisual = urdfVisuals.get(i);
                VisualDefinition visual = URDFTools.toVisualDefinition(urdfVisual, parserProperties);
                if (visual == null) continue;
                if (parserProperties.autoGenerateVisualName && visual.getName() == null) {
                    if (i == 0) {
                        visual.setName(urdfLink.getName() + "_visual");
                    } else {
                        visual.setName(urdfLink.getName() + "_visual_" + urdfLink.getName() + "_" + i);
                    }
                }
                definition.addVisualDefinition(visual);
            }
        }
        if (urdfLink.getCollision() != null) {
            List<URDFCollision> urdfCollisions = urdfLink.getCollision();
            for (i = 0; i < urdfCollisions.size(); ++i) {
                URDFCollision urdfCollision = urdfCollisions.get(i);
                CollisionShapeDefinition collision = URDFTools.toCollisionShapeDefinition(urdfCollision, parserProperties);
                if (collision == null) continue;
                if (parserProperties.autoGenerateCollisionName && collision.getName() == null) {
                    if (i == 0) {
                        collision.setName(urdfLink.getName() + "_collision");
                    } else {
                        collision.setName(urdfLink.getName() + "_collision_" + urdfLink.getName() + "_" + i);
                    }
                }
                definition.addCollisionShapeDefinition(collision);
            }
        }
        return definition;
    }

    public static JointDefinition toJointDefinition(URDFJoint urdfJoint, URDFParserProperties parserProperties) {
        URDFJoint.URDFJointType type = URDFJoint.URDFJointType.parse(urdfJoint.getType());
        if (type == null) {
            throw new RuntimeException("Unexpected value for the joint type: " + urdfJoint.getType());
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case URDFJoint.URDFJointType.continuous -> URDFTools.toRevoluteJointDefinition(urdfJoint, true, parserProperties);
            case URDFJoint.URDFJointType.revolute -> URDFTools.toRevoluteJointDefinition(urdfJoint, false, parserProperties);
            case URDFJoint.URDFJointType.prismatic -> URDFTools.toPrismaticJointDefinition(urdfJoint, parserProperties);
            case URDFJoint.URDFJointType.fixed -> URDFTools.toFixedJointDefinition(urdfJoint, parserProperties);
            case URDFJoint.URDFJointType.floating -> URDFTools.toSixDoFJointDefinition(urdfJoint, parserProperties);
            case URDFJoint.URDFJointType.planar -> URDFTools.toPlanarJointDefinition(urdfJoint, parserProperties);
            case URDFJoint.URDFJointType.cross_four_bar -> URDFTools.toCrossFourBarJointDefinition(urdfJoint, parserProperties);
            case URDFJoint.URDFJointType.revolute_twins -> URDFTools.toRevoluteTwinsJointDefinition(urdfJoint, parserProperties);
        };
    }

    public static RevoluteJointDefinition toRevoluteJointDefinition(URDFJoint urdfJoint, boolean ignorePositionLimits, URDFParserProperties parserProperties) {
        RevoluteJointDefinition definition = new RevoluteJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin(), parserProperties));
        definition.getAxis().set(URDFTools.parseAxis(urdfJoint.getAxis(), parserProperties));
        URDFTools.parseLimit(urdfJoint.getLimit(), definition, ignorePositionLimits, parserProperties);
        URDFTools.parseDynamics(urdfJoint.getDynamics(), definition, parserProperties);
        return definition;
    }

    public static PrismaticJointDefinition toPrismaticJointDefinition(URDFJoint urdfJoint, URDFParserProperties parserProperties) {
        PrismaticJointDefinition definition = new PrismaticJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin(), parserProperties));
        definition.getAxis().set(URDFTools.parseAxis(urdfJoint.getAxis(), parserProperties));
        URDFTools.parseLimit(urdfJoint.getLimit(), definition, false, parserProperties);
        URDFTools.parseDynamics(urdfJoint.getDynamics(), definition, parserProperties);
        return definition;
    }

    public static FixedJointDefinition toFixedJointDefinition(URDFJoint urdfJoint, URDFParserProperties parserProperties) {
        FixedJointDefinition definition = new FixedJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin(), parserProperties));
        return definition;
    }

    public static SixDoFJointDefinition toSixDoFJointDefinition(URDFJoint urdfJoint, URDFParserProperties parserProperties) {
        SixDoFJointDefinition definition = new SixDoFJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin(), parserProperties));
        return definition;
    }

    public static PlanarJointDefinition toPlanarJointDefinition(URDFJoint urdfJoint, URDFParserProperties parserProperties) {
        PlanarJointDefinition definition = new PlanarJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin(), parserProperties));
        Vector3D surfaceNormal = URDFTools.parseAxis(urdfJoint.getAxis(), parserProperties);
        if (!surfaceNormal.geometricallyEquals((EuclidGeometry)Axis3D.Y, 1.0E-5)) {
            throw new UnsupportedOperationException("Planar joint are supported only with a surface normal equal to: " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)Axis3D.Y) + ", received:" + surfaceNormal);
        }
        return definition;
    }

    public static CrossFourBarJointDefinition toCrossFourBarJointDefinition(URDFJoint urdfJoint, URDFParserProperties parserProperties) {
        URDFJoint urdfJointC;
        URDFJoint urdfJointD;
        URDFLink urdfLinkBC;
        URDFLink urdfLinkDA;
        CrossFourBarJointDefinition definition = new CrossFourBarJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin(), parserProperties));
        definition.getAxis().set(URDFTools.parseAxis(urdfJoint.getAxis(), parserProperties));
        URDFTools.parseLimit(urdfJoint.getLimit(), definition, false, parserProperties);
        URDFTools.parseDynamics(urdfJoint.getDynamics(), definition, parserProperties);
        if (urdfJoint.getSubJoints() == null || urdfJoint.getSubJoints().size() != 4) {
            throw new IllegalArgumentException("Cross four bar joint requires 4 sub-joints.");
        }
        if (urdfJoint.getSubLinks() == null || urdfJoint.getSubLinks().size() != 2) {
            throw new IllegalArgumentException("Cross four bar joint requires 2 sub-links.");
        }
        for (URDFJoint subJoint : urdfJoint.getSubJoints()) {
            if (URDFJoint.URDFJointType.parse(subJoint.getType()) == URDFJoint.URDFJointType.revolute) continue;
            throw new IllegalArgumentException("Cross four bar joint requires all sub-joints to be revolute.");
        }
        URDFJoint urdfJoint0 = urdfJoint.getSubJoints().get(0);
        URDFJoint urdfJoint1 = urdfJoint.getSubJoints().get(1);
        URDFJoint urdfJoint2 = urdfJoint.getSubJoints().get(2);
        URDFJoint urdfJoint3 = urdfJoint.getSubJoints().get(3);
        if (!Objects.equals(urdfJoint0.getParent().getLink(), urdfJoint.getParent().getLink()) || !Objects.equals(urdfJoint1.getParent().getLink(), urdfJoint.getParent().getLink())) {
            throw new IllegalArgumentException("The 2 first sub-joints of the cross four bar joint must closest to the robot root and share the same parent link as the cross four bar joint.");
        }
        if (!Objects.equals(urdfJoint2.getChild().getLink(), urdfJoint.getChild().getLink()) || !Objects.equals(urdfJoint3.getChild().getLink(), urdfJoint.getChild().getLink())) {
            throw new IllegalArgumentException("The 2 last sub-joints of the cross four bar joint must farthest from the robot root and share the same child link as the cross four bar joint.");
        }
        URDFLink urdfLink0 = urdfJoint.getSubLinks().get(0);
        URDFLink urdfLink1 = urdfJoint.getSubLinks().get(1);
        int actuatedJointIndex = URDFTools.parseInteger(urdfJoint.getActuatedJointIndex(), -1);
        if (actuatedJointIndex < 0 || actuatedJointIndex > 3) {
            throw new IllegalArgumentException("The actuated joint index must be in [0, 3], was: " + actuatedJointIndex);
        }
        URDFJoint urdfJointA = urdfJoint0;
        URDFJoint urdfJointB = urdfJoint1;
        if (Objects.equals(urdfJointA.getChild().getLink(), urdfLink0.getName())) {
            if (!Objects.equals(urdfJointB.getChild().getLink(), urdfLink1.getName())) {
                throw new IllegalArgumentException("Error when parsing the cross-bars, jointA child: " + urdfJointA.getChild().getLink() + ", jointB child: " + urdfJointB.getChild().getLink() + ", link0: " + urdfLink0.getName() + ", link1: " + urdfLink1.getName());
            }
            urdfLinkDA = urdfLink0;
            urdfLinkBC = urdfLink1;
        } else {
            if (!Objects.equals(urdfJointB.getChild().getLink(), urdfLink0.getName())) {
                throw new IllegalArgumentException("Error when parsing the cross-bars, jointA child: " + urdfJointA.getChild().getLink() + ", jointB child: " + urdfJointB.getChild().getLink() + ", link0: " + urdfLink0.getName() + ", link1: " + urdfLink1.getName());
            }
            urdfLinkDA = urdfLink1;
            urdfLinkBC = urdfLink0;
        }
        if (Objects.equals(urdfJoint2.getParent().getLink(), urdfLinkDA.getName())) {
            if (!Objects.equals(urdfJoint3.getParent().getLink(), urdfLinkBC.getName())) {
                throw new IllegalArgumentException("Error when parsing the cross-bars, joint2 parent: " + urdfJoint2.getParent().getLink() + ", joint3 parent: " + urdfJoint3.getParent().getLink() + ", linkDA: " + urdfLinkDA.getName() + ", linkBC: " + urdfLinkBC.getName());
            }
            urdfJointD = urdfJoint2;
            urdfJointC = urdfJoint3;
            if (actuatedJointIndex == 2) {
                actuatedJointIndex = 3;
            } else if (actuatedJointIndex == 3) {
                actuatedJointIndex = 2;
            }
        } else {
            if (!Objects.equals(urdfJoint2.getParent().getLink(), urdfLinkBC.getName())) {
                throw new IllegalArgumentException("Error when parsing the cross-bars, joint2 parent: " + urdfJoint2.getParent().getLink() + ", joint3 parent: " + urdfJoint3.getParent().getLink() + ", linkDA: " + urdfLinkDA.getName() + ", linkBC: " + urdfLinkBC.getName());
            }
            if (!Objects.equals(urdfJoint3.getParent().getLink(), urdfLinkDA.getName())) {
                throw new IllegalArgumentException("Error when parsing the cross-bars, joint2 parent: " + urdfJoint2.getParent().getLink() + ", joint3 parent: " + urdfJoint3.getParent().getLink() + ", linkDA: " + urdfLinkDA.getName() + ", linkBC: " + urdfLinkBC.getName());
            }
            urdfJointC = urdfJoint2;
            urdfJointD = urdfJoint3;
        }
        definition.setJointNameA(urdfJointA.getName());
        definition.setJointNameB(urdfJointB.getName());
        definition.setJointNameC(urdfJointC.getName());
        definition.setJointNameD(urdfJointD.getName());
        definition.setBodyDA(URDFTools.toRigidBodyDefinition(urdfLinkDA, parserProperties));
        definition.setBodyBC(URDFTools.toRigidBodyDefinition(urdfLinkBC, parserProperties));
        definition.setActuatedJointIndex(actuatedJointIndex);
        definition.setTransformAToPredecessor(URDFTools.parseRigidBodyTransform(urdfJointA.getOrigin(), parserProperties));
        definition.setTransformBToPredecessor(URDFTools.parseRigidBodyTransform(urdfJointB.getOrigin(), parserProperties));
        definition.setTransformCToB(URDFTools.parseRigidBodyTransform(urdfJointC.getOrigin(), parserProperties));
        definition.setTransformDToA(URDFTools.parseRigidBodyTransform(urdfJointD.getOrigin(), parserProperties));
        int loopClosureJointIndex = switch (actuatedJointIndex) {
            case 0 -> 3;
            case 1 -> 2;
            case 2 -> 1;
            case 3 -> 0;
            default -> -1;
        };
        definition.setLoopClosureJointIndex(loopClosureJointIndex);
        return definition;
    }

    public static RevoluteTwinsJointDefinition toRevoluteTwinsJointDefinition(URDFJoint urdfJoint, URDFParserProperties parserProperties) {
        URDFJoint constrainedJoint;
        RevoluteTwinsJointDefinition definition = new RevoluteTwinsJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin(), parserProperties));
        definition.getAxis().set(URDFTools.parseAxis(urdfJoint.getAxis(), parserProperties));
        URDFTools.parseLimit(urdfJoint.getLimit(), definition, false, parserProperties);
        URDFTools.parseDynamics(urdfJoint.getDynamics(), definition, parserProperties);
        if (urdfJoint.getSubJoints() == null || urdfJoint.getSubJoints().size() != 2) {
            throw new IllegalArgumentException("Revolute twins joint requires 2 sub-joints.");
        }
        if (urdfJoint.getSubLinks() == null || urdfJoint.getSubLinks().size() != 1) {
            throw new IllegalArgumentException("Revolute twins joint requires 1 sub-links.");
        }
        for (URDFJoint subJoint : urdfJoint.getSubJoints()) {
            if (URDFJoint.URDFJointType.parse(subJoint.getType()) == URDFJoint.URDFJointType.revolute) continue;
            throw new IllegalArgumentException("Revolute twins joint requires all sub-joints to be revolute.");
        }
        URDFJoint urdfJointA = urdfJoint.getSubJoints().get(0);
        URDFJoint urdfJointB = urdfJoint.getSubJoints().get(1);
        if (!Objects.equals(urdfJointA.getParent().getLink(), urdfJoint.getParent().getLink())) {
            throw new IllegalArgumentException("The first sub-joint of the revolute twins joint must share the same parent link as the revolute twins joint.");
        }
        if (!Objects.equals(urdfJointB.getChild().getLink(), urdfJoint.getChild().getLink())) {
            throw new IllegalArgumentException("The second sub-joint of the revolute twins joint must share the same child link as the revolute twins joint.");
        }
        URDFLink urdfLinkAB = urdfJoint.getSubLinks().get(0);
        if (!Objects.equals(urdfJointA.getChild().getLink(), urdfLinkAB.getName())) {
            throw new IllegalArgumentException("Error when parsing the revolute twins joint.");
        }
        if (!Objects.equals(urdfJointB.getParent().getLink(), urdfLinkAB.getName())) {
            throw new IllegalArgumentException("Error when parsing the revolute twins joint.");
        }
        int actuatedJointIndex = URDFTools.parseInteger(urdfJoint.getActuatedJointIndex(), -1);
        if (actuatedJointIndex < 0 || actuatedJointIndex > 1) {
            throw new IllegalArgumentException("The actuated joint index must be in [0, 1].");
        }
        URDFJoint uRDFJoint = constrainedJoint = actuatedJointIndex == 0 ? urdfJointB : urdfJointA;
        if (constrainedJoint.getMimic() == null) {
            throw new IllegalArgumentException("The constrained sub-joint of the revolute twins joint must have a mimic.");
        }
        Objects.requireNonNull(constrainedJoint.getMimic().getMultiplier(), "The constrained sub-joint of the revolute twins joint must have a mimic multiplier.");
        Objects.requireNonNull(constrainedJoint.getMimic().getOffset(), "The constrained sub-joint of the revolute twins joint must have a mimic offset.");
        double constraintRatio = URDFTools.parseDouble(constrainedJoint.getMimic().getMultiplier(), Double.NaN);
        double constraintOffset = URDFTools.parseDouble(constrainedJoint.getMimic().getOffset(), Double.NaN);
        definition.setJointNameA(urdfJointA.getName());
        definition.setJointNameB(urdfJointB.getName());
        definition.setBodyAB(URDFTools.toRigidBodyDefinition(urdfLinkAB, parserProperties));
        definition.setTransformAToPredecessor(URDFTools.parseRigidBodyTransform(urdfJointA.getOrigin(), parserProperties));
        definition.setTransformBToA(URDFTools.parseRigidBodyTransform(urdfJointB.getOrigin(), parserProperties));
        definition.setActuatedJointIndex(actuatedJointIndex);
        definition.setConstraintRatio(constraintRatio);
        definition.setConstraintOffset(constraintOffset);
        return definition;
    }

    public static List<SensorDefinition> toSensorDefinition(URDFSensor urdfSensor, URDFParserProperties parserProperties) {
        ArrayList<SensorDefinition> definitions = new ArrayList<SensorDefinition>();
        URDFSensor.URDFSensorType type = URDFSensor.URDFSensorType.parse(urdfSensor.getType());
        if (type == null) {
            LogTools.error((String)("Unsupported sensor type: " + urdfSensor.getType()));
            return null;
        }
        switch (type) {
            case camera: 
            case multicamera: 
            case depth: {
                definitions.addAll(URDFTools.toCameraSensorDefinition(urdfSensor.getCamera(), parserProperties));
                break;
            }
            case imu: {
                definitions.add(URDFTools.toIMUSensorDefinition(urdfSensor.getImu(), parserProperties));
                break;
            }
            case gpu_ray: 
            case ray: {
                definitions.add(URDFTools.toLidarSensorDefinition(urdfSensor.getRay(), parserProperties));
                break;
            }
            case force_torque: {
                definitions.add(new WrenchSensorDefinition());
                break;
            }
            default: {
                LogTools.error((String)("Unsupported sensor type: " + urdfSensor.getType()));
                return null;
            }
        }
        int updatePeriod = urdfSensor.getUpdateRate() == null ? -1 : (int)(1000.0 / URDFTools.parseDouble(urdfSensor.getUpdateRate(), 1000.0));
        for (SensorDefinition definition : definitions) {
            if (definition.getName() != null && !definition.getName().isEmpty()) {
                definition.setName(urdfSensor.getName() + "_" + definition.getName());
            } else {
                definition.setName(urdfSensor.getName());
            }
            definition.getTransformToJoint().preMultiply((RigidBodyTransformReadOnly)URDFTools.parsePose(urdfSensor.getPose(), parserProperties));
            definition.setUpdatePeriod(updatePeriod);
        }
        return definitions;
    }

    public static List<CameraSensorDefinition> toCameraSensorDefinition(List<URDFSensor.URDFCamera> urdfCameras, URDFParserProperties parserProperties) {
        if (urdfCameras == null) {
            return Collections.emptyList();
        }
        return urdfCameras.stream().map(urdfCamera -> URDFTools.toCameraSensorDefinition(urdfCamera, parserProperties)).collect(Collectors.toList());
    }

    public static CameraSensorDefinition toCameraSensorDefinition(URDFSensor.URDFCamera urdfCamera, URDFParserProperties parserProperties) {
        CameraSensorDefinition definition = new CameraSensorDefinition();
        definition.setName(urdfCamera.getName());
        definition.getTransformToJoint().set((RigidBodyTransformReadOnly)URDFTools.parsePose(urdfCamera.getPose(), parserProperties));
        definition.setFieldOfView(URDFTools.parseDouble(urdfCamera.getHorizontalFov(), Double.NaN));
        definition.setClipNear(URDFTools.parseDouble(urdfCamera.getClip().getNear(), Double.NaN));
        definition.setClipFar(URDFTools.parseDouble(urdfCamera.getClip().getFar(), Double.NaN));
        definition.setImageWidth(URDFTools.parseInteger(urdfCamera.getImage().getWidth(), -1));
        definition.setImageHeight(URDFTools.parseInteger(urdfCamera.getImage().getHeight(), -1));
        return definition;
    }

    public static LidarSensorDefinition toLidarSensorDefinition(URDFSensor.URDFRay urdfRay, URDFParserProperties parserProperties) {
        LidarSensorDefinition definition = new LidarSensorDefinition();
        URDFSensor.URDFRay.URDFRange urdfRange = urdfRay.getRange();
        double urdfRangeMax = URDFTools.parseDouble(urdfRange.getMax(), Double.NaN);
        double urdfRangeMin = URDFTools.parseDouble(urdfRange.getMin(), Double.NaN);
        double urdfRangeResolution = URDFTools.parseDouble(urdfRange.getResolution(), Double.NaN);
        URDFSensor.URDFRay.URDFScan.URDFHorizontalScan urdfHorizontalScan = urdfRay.getScan().getHorizontal();
        URDFSensor.URDFRay.URDFScan.URDFVerticalScan urdfVerticalScan = urdfRay.getScan().getVertical();
        double maxSweepAngle = URDFTools.parseDouble(urdfHorizontalScan.getMaxAngle(), 0.0);
        double minSweepAngle = URDFTools.parseDouble(urdfHorizontalScan.getMinAngle(), 0.0);
        double maxHeightAngle = urdfVerticalScan == null ? 0.0 : URDFTools.parseDouble(urdfVerticalScan.getMaxAngle(), 0.0);
        double minHeightAngle = urdfVerticalScan == null ? 0.0 : URDFTools.parseDouble(urdfVerticalScan.getMinAngle(), 0.0);
        int samples = URDFTools.parseInteger(urdfHorizontalScan.getSamples(), -1) / 3 * 3;
        int scanHeight = urdfVerticalScan == null ? 1 : URDFTools.parseInteger(urdfVerticalScan.getSamples(), 1);
        URDFSensor.URDFRay.URDFNoise urdfNoise = urdfRay.getNoise();
        if (urdfNoise != null) {
            if (URDFSensor.URDFRay.URDFNoise.URDFNoiseType.gaussian.equals((Object)URDFSensor.URDFRay.URDFNoise.URDFNoiseType.parse(urdfNoise.getType()))) {
                definition.setGaussianNoiseMean(URDFTools.parseDouble(urdfNoise.getMean(), 0.0));
                definition.setGaussianNoiseStandardDeviation(URDFTools.parseDouble(urdfNoise.getStddev(), 0.0));
            } else {
                LogTools.error((String)"Unknown noise model: {}.", (Object)urdfNoise.getType());
            }
        }
        definition.getTransformToJoint().set((RigidBodyTransformReadOnly)URDFTools.parsePose(urdfRay.getPose(), parserProperties));
        definition.setPointsPerSweep(samples);
        definition.setSweepYawLimits(minSweepAngle, maxSweepAngle);
        definition.setHeightPitchLimits(minHeightAngle, maxHeightAngle);
        definition.setRangeLimits(urdfRangeMin, urdfRangeMax);
        definition.setRangeResolution(urdfRangeResolution);
        definition.setScanHeight(scanHeight);
        return definition;
    }

    public static IMUSensorDefinition toIMUSensorDefinition(URDFSensor.URDFIMU urdfIMU, URDFParserProperties parserProperties) {
        URDFSensor.URDFIMU.URDFIMUNoise urdfNoise;
        IMUSensorDefinition definition = new IMUSensorDefinition();
        if (urdfIMU != null && (urdfNoise = urdfIMU.getNoise()) != null) {
            if (URDFSensor.URDFIMU.URDFIMUNoise.URDFIMUNoiseType.gaussian.equals((Object)URDFSensor.URDFIMU.URDFIMUNoise.URDFIMUNoiseType.parse(urdfNoise.getType()))) {
                URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters accelerationNoise = urdfNoise.getAccel();
                URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters angularVelocityNoise = urdfNoise.getRate();
                definition.setAccelerationNoiseParameters(URDFTools.parseDouble(accelerationNoise.getMean(), 0.0), URDFTools.parseDouble(accelerationNoise.getStddev(), 0.0));
                definition.setAccelerationBiasParameters(URDFTools.parseDouble(accelerationNoise.getBias_mean(), 0.0), URDFTools.parseDouble(accelerationNoise.getBias_stddev(), 0.0));
                definition.setAngularVelocityNoiseParameters(URDFTools.parseDouble(angularVelocityNoise.getMean(), 0.0), URDFTools.parseDouble(angularVelocityNoise.getStddev(), 0.0));
                definition.setAngularVelocityBiasParameters(URDFTools.parseDouble(angularVelocityNoise.getBias_mean(), 0.0), URDFTools.parseDouble(angularVelocityNoise.getBias_stddev(), 0.0));
            } else {
                LogTools.error((String)"Unknown IMU noise model: {}.", (Object)urdfNoise.getType());
            }
        }
        return definition;
    }

    public static VisualDefinition toVisualDefinition(URDFVisual urdfVisual, URDFParserProperties parserProperties) {
        if (urdfVisual == null) {
            return null;
        }
        VisualDefinition visualDefinition = new VisualDefinition();
        visualDefinition.setName(urdfVisual.getName());
        visualDefinition.setOriginPose((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfVisual.getOrigin(), parserProperties));
        visualDefinition.setMaterialDefinition(URDFTools.toMaterialDefinition(urdfVisual.getMaterial(), parserProperties));
        visualDefinition.setGeometryDefinition(URDFTools.toGeometryDefinition(urdfVisual.getGeometry(), parserProperties));
        return visualDefinition;
    }

    public static CollisionShapeDefinition toCollisionShapeDefinition(URDFCollision urdfCollision, URDFParserProperties parserProperties) {
        if (urdfCollision == null) {
            return null;
        }
        CollisionShapeDefinition collisionShapeDefinition = new CollisionShapeDefinition();
        collisionShapeDefinition.setName(urdfCollision.getName());
        collisionShapeDefinition.setOriginPose(URDFTools.parseRigidBodyTransform(urdfCollision.getOrigin(), parserProperties));
        collisionShapeDefinition.setGeometryDefinition(URDFTools.toGeometryDefinition(urdfCollision.getGeometry(), parserProperties));
        return collisionShapeDefinition;
    }

    public static GeometryDefinition toGeometryDefinition(URDFGeometry urdfGeometry, URDFParserProperties parserProperties) {
        return URDFTools.toGeometryDefinition(urdfGeometry, Collections.emptyList());
    }

    public static GeometryDefinition toGeometryDefinition(URDFGeometry urdfGeometry, List<String> resourceDirectories) {
        if (urdfGeometry.getBox() != null) {
            Box3DDefinition boxGeometryDefinition = new Box3DDefinition();
            boxGeometryDefinition.setSize((Tuple3DReadOnly)URDFTools.parseVector3D(urdfGeometry.getBox().getSize(), null));
            return boxGeometryDefinition;
        }
        if (urdfGeometry.getCylinder() != null) {
            Cylinder3DDefinition cylinderGeometryDefinition = new Cylinder3DDefinition();
            cylinderGeometryDefinition.setRadius(URDFTools.parseDouble(urdfGeometry.getCylinder().getRadius(), 0.0));
            cylinderGeometryDefinition.setLength(URDFTools.parseDouble(urdfGeometry.getCylinder().getLength(), 0.0));
            return cylinderGeometryDefinition;
        }
        if (urdfGeometry.getSphere() != null) {
            Sphere3DDefinition sphereGeometryDefinition = new Sphere3DDefinition();
            sphereGeometryDefinition.setRadius(URDFTools.parseDouble(urdfGeometry.getSphere().getRadius(), 0.0));
            return sphereGeometryDefinition;
        }
        if (urdfGeometry.getMesh() != null) {
            ModelFileGeometryDefinition modelFileGeometryDefinition = new ModelFileGeometryDefinition();
            modelFileGeometryDefinition.setResourceDirectories(resourceDirectories);
            modelFileGeometryDefinition.setFileName(urdfGeometry.getMesh().getFilename());
            modelFileGeometryDefinition.setScale(URDFTools.parseVector3D(urdfGeometry.getMesh().getScale(), new Vector3D(1.0, 1.0, 1.0)));
            return modelFileGeometryDefinition;
        }
        return null;
    }

    public static MaterialDefinition toMaterialDefinition(URDFMaterial urdfMaterial, URDFParserProperties parserProperties) {
        if (urdfMaterial == null) {
            return null;
        }
        MaterialDefinition materialDefinition = new MaterialDefinition();
        materialDefinition.setName(urdfMaterial.getName());
        materialDefinition.setDiffuseColor(URDFTools.toColorDefinition(urdfMaterial.getColor(), parserProperties));
        materialDefinition.setDiffuseMap(URDFTools.toTextureDefinition(urdfMaterial.getTexture(), parserProperties));
        return materialDefinition;
    }

    public static TextureDefinition toTextureDefinition(URDFTexture urdfTexture, URDFParserProperties parserProperties) {
        if (urdfTexture == null) {
            return null;
        }
        TextureDefinition textureDefinition = new TextureDefinition();
        textureDefinition.setFilename(urdfTexture.getFilename());
        return textureDefinition;
    }

    public static ColorDefinition toColorDefinition(URDFColor urdfColor, URDFParserProperties parserProperties) {
        if (urdfColor == null) {
            return null;
        }
        double[] colorArray = URDFTools.parseArray(urdfColor.getRGBA(), null);
        if (colorArray == null) {
            return null;
        }
        if (colorArray.length < 4) {
            return ColorDefinitions.rgb(colorArray);
        }
        return ColorDefinitions.rgba(colorArray);
    }

    public static RigidBodyTransform parsePose(String pose, URDFParserProperties parserProperties) {
        RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
        if (pose != null) {
            String[] split = pose.strip().split("\\s+");
            Vector3D position = new Vector3D(Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]));
            YawPitchRoll orientation = new YawPitchRoll(Double.parseDouble(split[5]), Double.parseDouble(split[4]), Double.parseDouble(split[3]));
            rigidBodyTransform.set((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position);
        }
        return rigidBodyTransform;
    }

    public static YawPitchRollTransformDefinition parseRigidBodyTransform(URDFOrigin origin, URDFParserProperties parserProperties) {
        if (origin == null) {
            origin = new URDFOrigin();
        }
        YawPitchRollTransformDefinition rigidBodyTransform = new YawPitchRollTransformDefinition();
        rigidBodyTransform.getTranslation().set(URDFTools.parseVector3D(origin.getXYZ(), DEFAULT_ORIGIN_XYZ));
        rigidBodyTransform.getRotation().setEuler((Vector3DReadOnly)URDFTools.parseVector3D(origin.getRPY(), DEFAULT_ORIGIN_RPY));
        return rigidBodyTransform;
    }

    public static Matrix3D parseMomentOfInertia(URDFInertia inertia, URDFParserProperties parserProperties) {
        if (inertia == null) {
            inertia = new URDFInertia();
        }
        Matrix3D momentOfInertia = new Matrix3D();
        double ixx = URDFTools.parseDouble(inertia.getIxx(), 0.0);
        double iyy = URDFTools.parseDouble(inertia.getIyy(), 0.0);
        double izz = URDFTools.parseDouble(inertia.getIzz(), 0.0);
        double ixy = URDFTools.parseDouble(inertia.getIxy(), 0.0);
        double ixz = URDFTools.parseDouble(inertia.getIxz(), 0.0);
        double iyz = URDFTools.parseDouble(inertia.getIyz(), 0.0);
        momentOfInertia.setM00(ixx);
        momentOfInertia.setM11(iyy);
        momentOfInertia.setM22(izz);
        momentOfInertia.setM01(ixy);
        momentOfInertia.setM02(ixz);
        momentOfInertia.setM12(iyz);
        momentOfInertia.setM10(ixy);
        momentOfInertia.setM20(ixz);
        momentOfInertia.setM21(iyz);
        return momentOfInertia;
    }

    public static double parseMass(URDFMass urdfMass, URDFParserProperties parserProperties) {
        if (urdfMass == null) {
            return 0.0;
        }
        return URDFTools.parseDouble(urdfMass.getValue(), 0.0);
    }

    public static void parseLimit(URDFLimit urdfLimit, OneDoFJointDefinition jointDefinitionToParseLimitInto, boolean ignorePositionLimits, URDFParserProperties parserProperties) {
        jointDefinitionToParseLimitInto.setPositionLimits(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        jointDefinitionToParseLimitInto.setEffortLimits(Double.POSITIVE_INFINITY);
        jointDefinitionToParseLimitInto.setVelocityLimits(Double.POSITIVE_INFINITY);
        if (urdfLimit != null) {
            double velocityLimit;
            double effortLimit;
            double positionUpperLimit;
            double positionLowerLimit;
            if (!ignorePositionLimits && (positionLowerLimit = URDFTools.parseDouble(urdfLimit.getLower(), Double.NEGATIVE_INFINITY)) < (positionUpperLimit = URDFTools.parseDouble(urdfLimit.getUpper(), Double.POSITIVE_INFINITY))) {
                jointDefinitionToParseLimitInto.setPositionLimits(positionLowerLimit, positionUpperLimit);
            }
            if (Double.isFinite(effortLimit = URDFTools.parseDouble(urdfLimit.getEffort(), Double.POSITIVE_INFINITY)) && effortLimit >= 0.0) {
                jointDefinitionToParseLimitInto.setEffortLimits(effortLimit);
            }
            if (Double.isFinite(velocityLimit = URDFTools.parseDouble(urdfLimit.getVelocity(), Double.POSITIVE_INFINITY)) && velocityLimit >= 0.0) {
                jointDefinitionToParseLimitInto.setVelocityLimits(velocityLimit);
            }
        }
    }

    public static void parseDynamics(URDFDynamics urdfDynamics, OneDoFJointDefinition jointDefinitionToParseDynamicsInto, URDFParserProperties parserProperties) {
        double damping = 0.0;
        double stiction = 0.0;
        if (urdfDynamics != null) {
            damping = URDFTools.parseDouble(urdfDynamics.getDamping(), 0.0);
            stiction = URDFTools.parseDouble(urdfDynamics.getFriction(), 0.0);
        }
        jointDefinitionToParseDynamicsInto.setDamping(damping);
        jointDefinitionToParseDynamicsInto.setStiction(stiction);
    }

    public static Vector3D parseAxis(URDFAxis axis, URDFParserProperties parserProperties) {
        if (axis == null) {
            return new Vector3D((Tuple3DReadOnly)DEFAULT_AXIS);
        }
        Vector3D parsedAxis = URDFTools.parseVector3D(axis.getXYZ(), new Vector3D((Tuple3DReadOnly)DEFAULT_AXIS));
        parsedAxis.normalize();
        return parsedAxis;
    }

    public static double parseDouble(String value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public static int parseInteger(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Vector3D parseVector3D(String value, Vector3D defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String[] split = value.strip().split("\\s+");
        Vector3D vector = new Vector3D();
        vector.setX(Double.parseDouble(split[0]));
        vector.setY(Double.parseDouble(split[1]));
        vector.setZ(Double.parseDouble(split[2]));
        return vector;
    }

    public static double[] parseArray(String value, double[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String[] split = value.strip().split("\\s+");
        double[] array = new double[split.length];
        for (int i = 0; i < split.length; ++i) {
            array[i] = Double.parseDouble(split[i]);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveURDFModel(OutputStream outputStream, URDFModel urdfModel) throws JAXBException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{URDFModel.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)urdfModel, outputStream);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                LogTools.error((String)e.getMessage());
            }
        }
    }

    public static URDFModel toURDFModel(RobotDefinition robotDefinition) {
        return URDFTools.toURDFModel(robotDefinition, DEFAULT_URDF_GENERATOR_PROPERTIES);
    }

    public static URDFModel toURDFModel(RobotDefinition robotDefinition, URDFGeneratorProperties properties) {
        URDFModel urdfModel = new URDFModel();
        urdfModel.setName(robotDefinition.getName());
        urdfModel.setLinks(URDFTools.toURDFLinks(robotDefinition.getAllRigidBodies(), properties));
        urdfModel.setJoints(URDFTools.toURDFJoints(robotDefinition.getAllJoints(), properties));
        urdfModel.setGazebos(URDFTools.toURDFGazebos(robotDefinition.getAllJoints(), properties));
        return urdfModel;
    }

    public static List<URDFLink> toURDFLinks(List<RigidBodyDefinition> rigidBodyDefinitions, URDFGeneratorProperties properties) {
        if (rigidBodyDefinitions == null || rigidBodyDefinitions.isEmpty()) {
            return null;
        }
        ArrayList<URDFLink> urdfLinks = new ArrayList<URDFLink>();
        for (RigidBodyDefinition rigidBodyDefinition : rigidBodyDefinitions) {
            URDFLink urdfLink = URDFTools.toURDFLink(rigidBodyDefinition, properties);
            if (urdfLink == null) continue;
            urdfLinks.add(urdfLink);
        }
        return urdfLinks;
    }

    public static URDFLink toURDFLink(RigidBodyDefinition rigidBodyDefinition, URDFGeneratorProperties properties) {
        if (rigidBodyDefinition == null) {
            return null;
        }
        URDFLink urdfLink = new URDFLink();
        urdfLink.setName(rigidBodyDefinition.getName());
        urdfLink.setInertial(URDFTools.toURDFInterial(rigidBodyDefinition, properties));
        urdfLink.setVisual(URDFTools.toURDFVisuals(rigidBodyDefinition.getVisualDefinitions(), properties));
        urdfLink.setCollision(URDFTools.toURDFCollisions(rigidBodyDefinition.getCollisionShapeDefinitions(), properties));
        return urdfLink;
    }

    public static URDFInertial toURDFInterial(RigidBodyDefinition rigidBodyDefinition, URDFGeneratorProperties properties) {
        if (rigidBodyDefinition == null) {
            return null;
        }
        if (!properties.alwaysExportLinkInertial && rigidBodyDefinition.getMass() == 0.0 && rigidBodyDefinition.getMomentOfInertia().isZero(0.0)) {
            return null;
        }
        URDFInertial urdfInertial = new URDFInertial();
        urdfInertial.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)rigidBodyDefinition.getInertiaPose(), properties));
        urdfInertial.setMass(URDFTools.toURDFMass(rigidBodyDefinition.getMass(), properties));
        urdfInertial.setInertia(URDFTools.toURDFInertia(rigidBodyDefinition.getMomentOfInertia(), properties));
        return urdfInertial;
    }

    public static URDFMass toURDFMass(double mass, URDFGeneratorProperties properties) {
        URDFMass urdfMass = new URDFMass();
        urdfMass.setValue(properties.toString(URDFMass.class, "value", mass));
        return urdfMass;
    }

    public static URDFInertia toURDFInertia(MomentOfInertiaDefinition momentOfInertiaDefinition, URDFGeneratorProperties properties) {
        if (momentOfInertiaDefinition == null) {
            return null;
        }
        URDFInertia urdfInertia = new URDFInertia();
        urdfInertia.setIxx(properties.toString(URDFInertia.class, "ixx", momentOfInertiaDefinition.getIxx()));
        urdfInertia.setIyy(properties.toString(URDFInertia.class, "iyy", momentOfInertiaDefinition.getIyy()));
        urdfInertia.setIzz(properties.toString(URDFInertia.class, "izz", momentOfInertiaDefinition.getIzz()));
        urdfInertia.setIxy(properties.toString(URDFInertia.class, "ixy", momentOfInertiaDefinition.getIxy()));
        urdfInertia.setIxz(properties.toString(URDFInertia.class, "ixz", momentOfInertiaDefinition.getIxz()));
        urdfInertia.setIyz(properties.toString(URDFInertia.class, "iyz", momentOfInertiaDefinition.getIyz()));
        return urdfInertia;
    }

    public static List<URDFVisual> toURDFVisuals(List<VisualDefinition> visualDefinitions, URDFGeneratorProperties properties) {
        if (visualDefinitions == null || visualDefinitions.isEmpty()) {
            return null;
        }
        ArrayList<URDFVisual> urdfVisuals = new ArrayList<URDFVisual>();
        for (VisualDefinition visualDefinition : visualDefinitions) {
            URDFVisual urdfVisual = URDFTools.toURDFVisual(visualDefinition, properties);
            if (urdfVisual == null) continue;
            urdfVisuals.add(urdfVisual);
        }
        return urdfVisuals;
    }

    public static URDFVisual toURDFVisual(VisualDefinition visualDefinition, URDFGeneratorProperties properties) {
        if (visualDefinition == null) {
            return null;
        }
        URDFVisual urdfVisual = new URDFVisual();
        urdfVisual.setName(visualDefinition.getName());
        urdfVisual.setOrigin(URDFTools.toURDFOrigin((AffineTransformReadOnly)visualDefinition.getOriginPose(), properties));
        urdfVisual.setGeometry(URDFTools.toURDFGeometry(visualDefinition.getGeometryDefinition(), properties));
        urdfVisual.setMaterial(URDFTools.toURDFMaterial(visualDefinition.getMaterialDefinition(), properties));
        return urdfVisual;
    }

    public static List<URDFCollision> toURDFCollisions(List<CollisionShapeDefinition> collisionShapeDefinitions, URDFGeneratorProperties properties) {
        if (collisionShapeDefinitions == null || collisionShapeDefinitions.isEmpty()) {
            return null;
        }
        ArrayList<URDFCollision> urdfCollisions = new ArrayList<URDFCollision>();
        for (CollisionShapeDefinition collisionShapeDefinition : collisionShapeDefinitions) {
            URDFCollision urdfCollision = URDFTools.toURDFCollision(collisionShapeDefinition, properties);
            if (urdfCollision == null) continue;
            urdfCollisions.add(urdfCollision);
        }
        return urdfCollisions;
    }

    public static URDFCollision toURDFCollision(CollisionShapeDefinition collisionShapeDefinition, URDFGeneratorProperties properties) {
        if (collisionShapeDefinition == null) {
            return null;
        }
        URDFCollision urdfCollision = new URDFCollision();
        urdfCollision.setName(collisionShapeDefinition.getName());
        urdfCollision.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)collisionShapeDefinition.getOriginPose(), properties));
        urdfCollision.setGeometry(URDFTools.toURDFGeometry(collisionShapeDefinition.getGeometryDefinition(), properties));
        return urdfCollision;
    }

    public static URDFGeometry toURDFGeometry(GeometryDefinition geometryDefinition, URDFGeneratorProperties properties) {
        if (geometryDefinition == null) {
            return null;
        }
        URDFGeometry urdfGeometry = new URDFGeometry();
        if (geometryDefinition instanceof Box3DDefinition) {
            Box3DDefinition box3DGeometry = (Box3DDefinition)geometryDefinition;
            urdfGeometry.setBox(URDFTools.toURDFBox(box3DGeometry, properties));
        } else if (geometryDefinition instanceof Cylinder3DDefinition) {
            Cylinder3DDefinition cylinder3DDefinition = (Cylinder3DDefinition)geometryDefinition;
            urdfGeometry.setCylinder(URDFTools.toURDFCylinder(cylinder3DDefinition, properties));
        } else if (geometryDefinition instanceof Sphere3DDefinition) {
            Sphere3DDefinition sphere3DDefinition = (Sphere3DDefinition)geometryDefinition;
            urdfGeometry.setSphere(URDFTools.toURDFSphere(sphere3DDefinition, properties));
        } else if (geometryDefinition instanceof ModelFileGeometryDefinition) {
            ModelFileGeometryDefinition modelFileGeometryDefinition = (ModelFileGeometryDefinition)geometryDefinition;
            urdfGeometry.setMesh(URDFTools.toURDFMesh(modelFileGeometryDefinition, properties));
        } else {
            LogTools.warn((String)"Unhandled geometry: {}", (Object)geometryDefinition);
        }
        return urdfGeometry;
    }

    public static URDFBox toURDFBox(Box3DDefinition box3DDefinition, URDFGeneratorProperties properties) {
        if (box3DDefinition == null) {
            return null;
        }
        URDFBox urdfBox = new URDFBox();
        urdfBox.setSize(properties.toString(URDFBox.class, "size", box3DDefinition.getSizeX(), box3DDefinition.getSizeY(), box3DDefinition.getSizeZ()));
        return urdfBox;
    }

    public static URDFCylinder toURDFCylinder(Cylinder3DDefinition cylinder3DDefinition, URDFGeneratorProperties properties) {
        if (cylinder3DDefinition == null) {
            return null;
        }
        URDFCylinder urdfCylinder = new URDFCylinder();
        urdfCylinder.setRadius(properties.toString(URDFCylinder.class, "radius", cylinder3DDefinition.getRadius()));
        urdfCylinder.setLength(properties.toString(URDFCylinder.class, "length", cylinder3DDefinition.getLength()));
        return urdfCylinder;
    }

    public static URDFSphere toURDFSphere(Sphere3DDefinition sphere3DDefinition, URDFGeneratorProperties properties) {
        if (sphere3DDefinition == null) {
            return null;
        }
        URDFSphere urdfSphere = new URDFSphere();
        urdfSphere.setRadius(properties.toString(URDFSphere.class, "radius", sphere3DDefinition.getRadius()));
        return urdfSphere;
    }

    public static URDFMesh toURDFMesh(ModelFileGeometryDefinition modelFileGeometryDefinition, URDFGeneratorProperties properties) {
        if (modelFileGeometryDefinition == null) {
            return null;
        }
        URDFMesh urdfMesh = new URDFMesh();
        urdfMesh.setFilename(modelFileGeometryDefinition.getFileName());
        Vector3D scale = modelFileGeometryDefinition.getScale();
        if (scale != null && !scale.equals((EuclidGeometry)new Vector3D(1.0, 1.0, 1.0))) {
            urdfMesh.setScale(properties.toString(URDFMesh.class, "scale", scale.getX(), scale.getY(), scale.getZ()));
        }
        return urdfMesh;
    }

    public static URDFMaterial toURDFMaterial(MaterialDefinition materialDefinition, URDFGeneratorProperties properties) {
        if (materialDefinition == null) {
            return null;
        }
        URDFMaterial urdfMaterial = new URDFMaterial();
        urdfMaterial.setName(materialDefinition.getName());
        urdfMaterial.setColor(URDFTools.toURDFColor(materialDefinition.getDiffuseColor(), properties));
        urdfMaterial.setTexture(URDFTools.toURDFTexture(materialDefinition.getDiffuseMap(), properties));
        return urdfMaterial;
    }

    public static URDFColor toURDFColor(ColorDefinition colorDefinition, URDFGeneratorProperties properties) {
        if (colorDefinition == null) {
            return null;
        }
        URDFColor urdfColor = new URDFColor();
        urdfColor.setRGBA(properties.toString(URDFColor.class, "rgba", colorDefinition.getRed(), colorDefinition.getGreen(), colorDefinition.getBlue(), colorDefinition.getAlpha()));
        return urdfColor;
    }

    public static URDFTexture toURDFTexture(TextureDefinition diffuseMap, URDFGeneratorProperties properties) {
        if (diffuseMap == null) {
            return null;
        }
        URDFTexture urdfTexture = new URDFTexture();
        urdfTexture.setFilename(diffuseMap.getFilename());
        return urdfTexture;
    }

    public static List<URDFJoint> toURDFJoints(List<JointDefinition> jointDefinitions, URDFGeneratorProperties properties) {
        if (jointDefinitions == null || jointDefinitions.isEmpty()) {
            return null;
        }
        ArrayList<URDFJoint> urdfJoints = new ArrayList<URDFJoint>();
        for (JointDefinition jointDefinition : jointDefinitions) {
            URDFJoint urdfJoint = URDFTools.toURDFJoint(jointDefinition, properties);
            if (urdfJoint == null) continue;
            urdfJoints.add(urdfJoint);
        }
        return urdfJoints;
    }

    public static URDFJoint toURDFJoint(JointDefinition jointDefinition, URDFGeneratorProperties properties) {
        if (jointDefinition == null) {
            return null;
        }
        if (jointDefinition instanceof RevoluteJointDefinition) {
            RevoluteJointDefinition revoluteJointDefinition = (RevoluteJointDefinition)jointDefinition;
            return URDFTools.toURDFJoint(revoluteJointDefinition, properties);
        }
        if (jointDefinition instanceof PrismaticJointDefinition) {
            PrismaticJointDefinition prismaticJointDefinition = (PrismaticJointDefinition)jointDefinition;
            return URDFTools.toURDFJoint(prismaticJointDefinition, properties);
        }
        if (jointDefinition instanceof FixedJointDefinition) {
            FixedJointDefinition fixedJointDefinition = (FixedJointDefinition)jointDefinition;
            return URDFTools.toURDFJoint(fixedJointDefinition, properties);
        }
        if (jointDefinition instanceof SixDoFJointDefinition) {
            SixDoFJointDefinition sixDoFJointDefinition = (SixDoFJointDefinition)jointDefinition;
            return URDFTools.toURDFJoint(sixDoFJointDefinition, properties);
        }
        if (jointDefinition instanceof PlanarJointDefinition) {
            PlanarJointDefinition planarJointDefinition = (PlanarJointDefinition)jointDefinition;
            return URDFTools.toURDFJoint(planarJointDefinition, properties);
        }
        if (jointDefinition instanceof CrossFourBarJointDefinition) {
            CrossFourBarJointDefinition crossFourBarJointDefinition = (CrossFourBarJointDefinition)jointDefinition;
            return URDFTools.toURDFJoint(crossFourBarJointDefinition, properties);
        }
        throw new UnsupportedOperationException("Unsupported joint type: " + jointDefinition);
    }

    public static URDFJoint toURDFJoint(RevoluteJointDefinition jointDefinition, URDFGeneratorProperties properties) {
        if (jointDefinition == null) {
            return null;
        }
        URDFJoint urdfJoint = new URDFJoint();
        urdfJoint.setName(jointDefinition.getName());
        if (Double.isInfinite(jointDefinition.getPositionLowerLimit()) && Double.isInfinite(jointDefinition.getPositionLowerLimit())) {
            urdfJoint.setType(URDFJoint.URDFJointType.continuous);
        } else {
            urdfJoint.setType(URDFJoint.URDFJointType.revolute);
        }
        urdfJoint.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)jointDefinition.getTransformToParent(), properties));
        urdfJoint.setParent(URDFTools.toURDFLinkReference(jointDefinition.getPredecessor(), properties));
        urdfJoint.setChild(URDFTools.toURDFLinkReference(jointDefinition.getSuccessor(), properties));
        urdfJoint.setAxis(URDFTools.toURDFAxis((Tuple3DReadOnly)jointDefinition.getAxis(), properties));
        urdfJoint.setLimit(URDFTools.toURDFLimit(jointDefinition, properties));
        urdfJoint.setDynamics(URDFTools.toURDFDynamics(jointDefinition, properties));
        return urdfJoint;
    }

    public static URDFJoint toURDFJoint(PrismaticJointDefinition jointDefinition, URDFGeneratorProperties properties) {
        if (jointDefinition == null) {
            return null;
        }
        URDFJoint urdfJoint = new URDFJoint();
        urdfJoint.setName(jointDefinition.getName());
        urdfJoint.setType(URDFJoint.URDFJointType.prismatic);
        urdfJoint.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)jointDefinition.getTransformToParent(), properties));
        urdfJoint.setParent(URDFTools.toURDFLinkReference(jointDefinition.getPredecessor(), properties));
        urdfJoint.setChild(URDFTools.toURDFLinkReference(jointDefinition.getSuccessor(), properties));
        urdfJoint.setAxis(URDFTools.toURDFAxis((Tuple3DReadOnly)jointDefinition.getAxis(), properties));
        urdfJoint.setLimit(URDFTools.toURDFLimit(jointDefinition, properties));
        urdfJoint.setDynamics(URDFTools.toURDFDynamics(jointDefinition, properties));
        return urdfJoint;
    }

    public static URDFJoint toURDFJoint(FixedJointDefinition jointDefinition, URDFGeneratorProperties properties) {
        if (jointDefinition == null) {
            return null;
        }
        URDFJoint urdfJoint = new URDFJoint();
        urdfJoint.setName(jointDefinition.getName());
        urdfJoint.setType(URDFJoint.URDFJointType.fixed);
        urdfJoint.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)jointDefinition.getTransformToParent(), properties));
        urdfJoint.setParent(URDFTools.toURDFLinkReference(jointDefinition.getPredecessor(), properties));
        urdfJoint.setChild(URDFTools.toURDFLinkReference(jointDefinition.getSuccessor(), properties));
        if (properties.alwaysExportJointAxis) {
            urdfJoint.setAxis(URDFTools.toURDFAxis((Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, properties));
        }
        return urdfJoint;
    }

    public static URDFJoint toURDFJoint(SixDoFJointDefinition jointDefinition, URDFGeneratorProperties properties) {
        if (jointDefinition == null) {
            return null;
        }
        URDFJoint urdfJoint = new URDFJoint();
        urdfJoint.setName(jointDefinition.getName());
        urdfJoint.setType(URDFJoint.URDFJointType.floating);
        urdfJoint.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)jointDefinition.getTransformToParent(), properties));
        urdfJoint.setParent(URDFTools.toURDFLinkReference(jointDefinition.getPredecessor(), properties));
        urdfJoint.setChild(URDFTools.toURDFLinkReference(jointDefinition.getSuccessor(), properties));
        if (properties.alwaysExportJointAxis) {
            urdfJoint.setAxis(URDFTools.toURDFAxis((Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, properties));
        }
        return urdfJoint;
    }

    public static URDFJoint toURDFJoint(PlanarJointDefinition jointDefinition, URDFGeneratorProperties properties) {
        if (jointDefinition == null) {
            return null;
        }
        URDFJoint urdfJoint = new URDFJoint();
        urdfJoint.setName(jointDefinition.getName());
        urdfJoint.setType(URDFJoint.URDFJointType.planar);
        urdfJoint.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)jointDefinition.getTransformToParent(), properties));
        urdfJoint.setParent(URDFTools.toURDFLinkReference(jointDefinition.getPredecessor(), properties));
        urdfJoint.setChild(URDFTools.toURDFLinkReference(jointDefinition.getSuccessor(), properties));
        urdfJoint.setAxis(URDFTools.toURDFAxis((Tuple3DReadOnly)Axis3D.Y, properties));
        return urdfJoint;
    }

    public static URDFJoint toURDFJoint(CrossFourBarJointDefinition jointDefinition, URDFGeneratorProperties properties) {
        if (jointDefinition == null) {
            return null;
        }
        URDFJoint urdfJoint = new URDFJoint();
        urdfJoint.setName(jointDefinition.getName());
        urdfJoint.setType(URDFJoint.URDFJointType.cross_four_bar);
        urdfJoint.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)jointDefinition.getTransformToParent(), properties));
        urdfJoint.setParent(URDFTools.toURDFLinkReference(jointDefinition.getPredecessor(), properties));
        urdfJoint.setChild(URDFTools.toURDFLinkReference(jointDefinition.getSuccessor(), properties));
        urdfJoint.setAxis(URDFTools.toURDFAxis((Tuple3DReadOnly)jointDefinition.getAxis(), properties));
        urdfJoint.setLimit(URDFTools.toURDFLimit(jointDefinition, properties));
        urdfJoint.setDynamics(URDFTools.toURDFDynamics(jointDefinition, properties));
        urdfJoint.setActuatedJointIndex(Integer.toString(jointDefinition.getActuatedJointIndex()));
        URDFLink urdfLinkDA = URDFTools.toURDFLink(jointDefinition.getBodyDA(), properties);
        URDFLink urdfLinkBC = URDFTools.toURDFLink(jointDefinition.getBodyBC(), properties);
        URDFJoint urdfJointA = new URDFJoint();
        URDFJoint urdfJointB = new URDFJoint();
        URDFJoint urdfJointC = new URDFJoint();
        URDFJoint urdfJointD = new URDFJoint();
        urdfJointA.setName(jointDefinition.getJointNameA());
        urdfJointB.setName(jointDefinition.getJointNameB());
        urdfJointC.setName(jointDefinition.getJointNameC());
        urdfJointD.setName(jointDefinition.getJointNameD());
        urdfJointA.setParent(URDFTools.toURDFLinkReference(jointDefinition.getPredecessor(), properties));
        urdfJointB.setParent(URDFTools.toURDFLinkReference(jointDefinition.getPredecessor(), properties));
        urdfJointC.setParent(URDFTools.toURDFLinkReference(jointDefinition.getBodyBC(), properties));
        urdfJointD.setParent(URDFTools.toURDFLinkReference(jointDefinition.getBodyDA(), properties));
        urdfJointA.setChild(URDFTools.toURDFLinkReference(jointDefinition.getBodyDA(), properties));
        urdfJointB.setChild(URDFTools.toURDFLinkReference(jointDefinition.getBodyBC(), properties));
        urdfJointC.setChild(URDFTools.toURDFLinkReference(jointDefinition.getSuccessor(), properties));
        urdfJointD.setChild(URDFTools.toURDFLinkReference(jointDefinition.getSuccessor(), properties));
        urdfJointA.setLimit(URDFTools.toURDFLimit(jointDefinition, properties));
        urdfJointB.setLimit(URDFTools.toURDFLimit(jointDefinition, properties));
        urdfJointC.setLimit(URDFTools.toURDFLimit(jointDefinition, properties));
        urdfJointD.setLimit(URDFTools.toURDFLimit(jointDefinition, properties));
        urdfJointA.setType(URDFJoint.URDFJointType.revolute);
        urdfJointB.setType(URDFJoint.URDFJointType.revolute);
        urdfJointC.setType(URDFJoint.URDFJointType.revolute);
        urdfJointD.setType(URDFJoint.URDFJointType.revolute);
        urdfJointA.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)jointDefinition.getTransformAToPredecessor(), properties));
        urdfJointB.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)jointDefinition.getTransformBToPredecessor(), properties));
        urdfJointC.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)jointDefinition.getTransformCToB(), properties));
        urdfJointD.setOrigin(URDFTools.toURDFOrigin((RigidBodyTransformReadOnly)jointDefinition.getTransformDToA(), properties));
        urdfJoint.setSubJoints(new ArrayList<URDFJoint>());
        urdfJoint.getSubJoints().add(urdfJointA);
        urdfJoint.getSubJoints().add(urdfJointB);
        urdfJoint.getSubJoints().add(urdfJointC);
        urdfJoint.getSubJoints().add(urdfJointD);
        urdfJoint.setSubLinks(new ArrayList<URDFLink>());
        urdfJoint.getSubLinks().add(urdfLinkDA);
        urdfJoint.getSubLinks().add(urdfLinkBC);
        return urdfJoint;
    }

    public static List<URDFGazebo> toURDFGazebos(List<JointDefinition> jointDefinitions, URDFGeneratorProperties properties) {
        if (jointDefinitions == null || jointDefinitions.isEmpty()) {
            return null;
        }
        ArrayList<URDFGazebo> urdfGazebos = new ArrayList<URDFGazebo>();
        for (JointDefinition jointDefinition : jointDefinitions) {
            List<URDFGazebo> jointURDFGazebos = URDFTools.toURDFGazebos(jointDefinition, properties);
            if (jointURDFGazebos == null) continue;
            urdfGazebos.addAll(jointURDFGazebos);
        }
        return urdfGazebos;
    }

    public static List<URDFGazebo> toURDFGazebos(JointDefinition jointDefinition, URDFGeneratorProperties properties) {
        if (jointDefinition == null) {
            return null;
        }
        List<URDFSensor> urdfSensors = URDFTools.toURDFSensors(jointDefinition.getSensorDefinitions(), properties);
        if (urdfSensors == null) {
            return null;
        }
        ArrayList<URDFGazebo> urdfGazebos = new ArrayList<URDFGazebo>();
        for (URDFSensor urdfSensor : urdfSensors) {
            URDFGazebo urdfGazebo = new URDFGazebo();
            urdfGazebo.setReference(jointDefinition.getName());
            urdfGazebo.setSensor(urdfSensor);
            urdfGazebos.add(urdfGazebo);
        }
        return urdfGazebos;
    }

    public static List<URDFSensor> toURDFSensors(List<SensorDefinition> sensorDefinitions, URDFGeneratorProperties properties) {
        if (sensorDefinitions == null || sensorDefinitions.isEmpty()) {
            return null;
        }
        ArrayList<URDFSensor> urdfSensors = new ArrayList<URDFSensor>();
        for (SensorDefinition sensorDefinition : sensorDefinitions) {
            URDFSensor urdfSensor = URDFTools.toURDFSensor(sensorDefinition, properties);
            if (urdfSensor == null) continue;
            urdfSensors.add(urdfSensor);
        }
        return urdfSensors;
    }

    public static URDFSensor toURDFSensor(SensorDefinition sensorDefinition, URDFGeneratorProperties properties) {
        if (sensorDefinition == null) {
            return null;
        }
        if (sensorDefinition instanceof CameraSensorDefinition) {
            CameraSensorDefinition cameraSensorDefinition = (CameraSensorDefinition)sensorDefinition;
            return URDFTools.toURDFSensor(cameraSensorDefinition, properties);
        }
        if (sensorDefinition instanceof LidarSensorDefinition) {
            LidarSensorDefinition lidarSensorDefinition = (LidarSensorDefinition)sensorDefinition;
            return URDFTools.toURDFSensor(lidarSensorDefinition, properties);
        }
        if (sensorDefinition instanceof IMUSensorDefinition) {
            IMUSensorDefinition imuSensorDefinition = (IMUSensorDefinition)sensorDefinition;
            return URDFTools.toURDFSensor(imuSensorDefinition, properties);
        }
        if (sensorDefinition instanceof WrenchSensorDefinition) {
            WrenchSensorDefinition wrenchSensorDefinition = (WrenchSensorDefinition)sensorDefinition;
            return URDFTools.toURDFSensor(wrenchSensorDefinition, properties);
        }
        LogTools.warn((String)("Unsupported sensor type: " + sensorDefinition));
        return null;
    }

    public static URDFSensor toURDFSensor(WrenchSensorDefinition sensorDefinition, URDFGeneratorProperties properties) {
        if (sensorDefinition == null) {
            return null;
        }
        URDFSensor urdfSensor = new URDFSensor();
        urdfSensor.setName(sensorDefinition.getName());
        urdfSensor.setPose(URDFTools.toPoseString((RigidBodyTransformReadOnly)sensorDefinition.getTransformToJoint(), properties.getDoubleFormatter(URDFSensor.class, "pose")));
        if (sensorDefinition.getUpdatePeriod() > 0) {
            urdfSensor.setUpdateRate(properties.toString(URDFSensor.class, "update_rate", 1000.0 / (double)sensorDefinition.getUpdatePeriod()));
        }
        urdfSensor.setType(URDFSensor.URDFSensorType.force_torque);
        return urdfSensor;
    }

    public static URDFSensor toURDFSensor(IMUSensorDefinition sensorDefinition, URDFGeneratorProperties properties) {
        if (sensorDefinition == null) {
            return null;
        }
        URDFSensor urdfSensor = new URDFSensor();
        urdfSensor.setName(sensorDefinition.getName());
        urdfSensor.setPose(URDFTools.toPoseString((RigidBodyTransformReadOnly)sensorDefinition.getTransformToJoint(), properties.getDoubleFormatter(URDFSensor.class, "pose")));
        if (sensorDefinition.getUpdatePeriod() > 0) {
            urdfSensor.setUpdateRate(properties.toString(URDFSensor.class, "update_rate", 1000.0 / (double)sensorDefinition.getUpdatePeriod()));
        }
        urdfSensor.setType(URDFSensor.URDFSensorType.imu);
        URDFSensor.URDFIMU urdfIMU = new URDFSensor.URDFIMU();
        URDFSensor.URDFIMU.URDFIMUNoise urdfIMUNoise = new URDFSensor.URDFIMU.URDFIMUNoise();
        urdfIMUNoise.setType(URDFSensor.URDFIMU.URDFIMUNoise.URDFIMUNoiseType.gaussian);
        URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters urdfNoiseParameters = new URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters();
        String mean = properties.toString(URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters.class, "mean", sensorDefinition.getAngularVelocityNoiseMean());
        String stddev = properties.toString(URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters.class, "stddev", sensorDefinition.getAngularVelocityNoiseStandardDeviation());
        String bias_mean = properties.toString(URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters.class, "bias_mean", sensorDefinition.getAngularVelocityBiasMean());
        String bias_stddev = properties.toString(URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters.class, "bias_stddev", sensorDefinition.getAngularVelocityBiasStandardDeviation());
        urdfNoiseParameters.setMean(mean);
        urdfNoiseParameters.setStddev(stddev);
        urdfNoiseParameters.setBias_mean(bias_mean);
        urdfNoiseParameters.setBias_stddev(bias_stddev);
        urdfIMUNoise.setRate(urdfNoiseParameters);
        String mean2 = properties.toString(URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters.class, "mean", sensorDefinition.getAccelerationNoiseMean());
        String stddev2 = properties.toString(URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters.class, "stddev", sensorDefinition.getAccelerationNoiseStandardDeviation());
        String bias_mean2 = properties.toString(URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters.class, "bias_mean", sensorDefinition.getAccelerationBiasMean());
        String bias_stddev2 = properties.toString(URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters.class, "bias_stddev", sensorDefinition.getAccelerationBiasStandardDeviation());
        URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters urdfNoiseParameters2 = new URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters();
        urdfNoiseParameters2.setMean(mean2);
        urdfNoiseParameters2.setStddev(stddev2);
        urdfNoiseParameters2.setBias_mean(bias_mean2);
        urdfNoiseParameters2.setBias_stddev(bias_stddev2);
        urdfIMUNoise.setAccel(urdfNoiseParameters2);
        urdfIMU.setNoise(urdfIMUNoise);
        return urdfSensor;
    }

    public static URDFSensor toURDFSensor(LidarSensorDefinition sensorDefinition, URDFGeneratorProperties properties) {
        if (sensorDefinition == null) {
            return null;
        }
        URDFSensor urdfSensor = new URDFSensor();
        urdfSensor.setName(sensorDefinition.getName());
        urdfSensor.setPose(URDFTools.toPoseString((RigidBodyTransformReadOnly)sensorDefinition.getTransformToJoint(), properties.getDoubleFormatter(URDFSensor.class, "pose")));
        if (sensorDefinition.getUpdatePeriod() > 0) {
            urdfSensor.setUpdateRate(properties.toString(URDFSensor.class, "update_rate", 1000.0 / (double)sensorDefinition.getUpdatePeriod()));
        }
        urdfSensor.setType(URDFSensor.URDFSensorType.ray);
        urdfSensor.setRay(URDFTools.toURDFRay(sensorDefinition, properties));
        return urdfSensor;
    }

    public static URDFSensor.URDFRay toURDFRay(LidarSensorDefinition sensorDefinition, URDFGeneratorProperties properties) {
        if (sensorDefinition == null) {
            return null;
        }
        URDFSensor.URDFRay urdfRay = new URDFSensor.URDFRay();
        URDFSensor.URDFRay.URDFRange urdfRange = new URDFSensor.URDFRay.URDFRange();
        urdfRange.setMin(properties.toString(URDFSensor.URDFRay.URDFRange.class, "min", sensorDefinition.getMinRange()));
        urdfRange.setMax(properties.toString(URDFSensor.URDFRay.URDFRange.class, "max", sensorDefinition.getMaxRange()));
        urdfRange.setResolution(properties.toString(URDFSensor.URDFRay.URDFRange.class, "resolution", sensorDefinition.getRangeResolution()));
        urdfRay.setRange(urdfRange);
        URDFSensor.URDFRay.URDFScan urdfScan = new URDFSensor.URDFRay.URDFScan();
        URDFSensor.URDFRay.URDFScan.URDFHorizontalScan urdfHorizontalScan = new URDFSensor.URDFRay.URDFScan.URDFHorizontalScan();
        urdfHorizontalScan.setMinAngle(properties.toString(URDFSensor.URDFRay.URDFScan.URDFHorizontalScan.class, "min_angle", sensorDefinition.getSweepYawMin()));
        urdfHorizontalScan.setMaxAngle(properties.toString(URDFSensor.URDFRay.URDFScan.URDFHorizontalScan.class, "max_angle", sensorDefinition.getSweepYawMax()));
        urdfHorizontalScan.setSamples(Integer.toString(sensorDefinition.getPointsPerSweep()));
        urdfScan.setHorizontal(urdfHorizontalScan);
        URDFSensor.URDFRay.URDFScan.URDFVerticalScan urdfVerticalScan = new URDFSensor.URDFRay.URDFScan.URDFVerticalScan();
        urdfVerticalScan.setMinAngle(properties.toString(URDFSensor.URDFRay.URDFScan.URDFVerticalScan.class, "min_angle", sensorDefinition.getHeightPitchMin()));
        urdfVerticalScan.setMaxAngle(properties.toString(URDFSensor.URDFRay.URDFScan.URDFVerticalScan.class, "max_angle", sensorDefinition.getHeightPitchMax()));
        urdfVerticalScan.setSamples(Integer.toString(sensorDefinition.getScanHeight()));
        urdfScan.setVertical(urdfVerticalScan);
        urdfRay.setScan(urdfScan);
        URDFSensor.URDFRay.URDFNoise urdfNoise = new URDFSensor.URDFRay.URDFNoise();
        urdfNoise.setType(URDFSensor.URDFRay.URDFNoise.URDFNoiseType.gaussian);
        urdfNoise.setMean(properties.toString(URDFSensor.URDFRay.URDFNoise.class, "mean", sensorDefinition.getGaussianNoiseMean()));
        urdfNoise.setStddev(properties.toString(URDFSensor.URDFRay.URDFNoise.class, "stddev", sensorDefinition.getGaussianNoiseStandardDeviation()));
        urdfRay.setNoise(urdfNoise);
        return urdfRay;
    }

    public static URDFSensor toURDFSensor(CameraSensorDefinition sensorDefinition, URDFGeneratorProperties properties) {
        if (sensorDefinition == null) {
            return null;
        }
        URDFSensor urdfSensor = new URDFSensor();
        String name = sensorDefinition.getName();
        if (name.contains("_")) {
            urdfSensor.setName(name.substring(0, name.lastIndexOf("_")));
        } else {
            urdfSensor.setName(name);
        }
        urdfSensor.setPose(URDFTools.toPoseString((RigidBodyTransformReadOnly)sensorDefinition.getTransformToJoint(), properties.getDoubleFormatter(URDFSensor.class, "pose")));
        if (sensorDefinition.getUpdatePeriod() > 0) {
            urdfSensor.setUpdateRate(properties.toString(URDFSensor.class, "update_rate", 1000.0 / (double)sensorDefinition.getUpdatePeriod()));
        }
        urdfSensor.setType(URDFSensor.URDFSensorType.camera);
        urdfSensor.setCamera(Collections.singletonList(URDFTools.toURDFCamera(sensorDefinition, properties)));
        return urdfSensor;
    }

    public static URDFSensor.URDFCamera toURDFCamera(CameraSensorDefinition sensorDefinition, URDFGeneratorProperties properties) {
        if (sensorDefinition == null) {
            return null;
        }
        URDFSensor.URDFCamera urdfCamera = new URDFSensor.URDFCamera();
        String name = sensorDefinition.getName();
        if (name != null && name.contains("_")) {
            urdfCamera.setName(name.substring(name.lastIndexOf("_") + 1));
        }
        urdfCamera.setPose(URDFTools.toPoseString((RigidBodyTransformReadOnly)sensorDefinition.getTransformToJoint(), properties.getDoubleFormatter(URDFSensor.class, "pose")));
        urdfCamera.setHorizontalFov(properties.toString(URDFSensor.URDFCamera.class, "horizontal_fov", sensorDefinition.getFieldOfView()));
        urdfCamera.setImage(URDFTools.toURDFSensorImage(sensorDefinition.getImageWidth(), sensorDefinition.getImageHeight(), properties));
        urdfCamera.setClip(URDFTools.toURDFClip(sensorDefinition.getClipNear(), sensorDefinition.getClipFar(), properties));
        return urdfCamera;
    }

    public static URDFSensor.URDFCamera.URDFSensorImage toURDFSensorImage(int width, int height, URDFGeneratorProperties properties) {
        return URDFTools.toURDFSensorImage(width, height, null, properties);
    }

    public static URDFSensor.URDFCamera.URDFSensorImage toURDFSensorImage(int width, int height, String format, URDFGeneratorProperties properties) {
        URDFSensor.URDFCamera.URDFSensorImage urdfSensorImage = new URDFSensor.URDFCamera.URDFSensorImage();
        urdfSensorImage.setWidth(Integer.toString(width));
        urdfSensorImage.setHeight(Integer.toString(height));
        urdfSensorImage.setFormat(format);
        return urdfSensorImage;
    }

    public static URDFSensor.URDFCamera.URDFClip toURDFClip(double near, double far, URDFGeneratorProperties properties) {
        URDFSensor.URDFCamera.URDFClip urdfClip = new URDFSensor.URDFCamera.URDFClip();
        urdfClip.setNear(properties.toString(URDFSensor.URDFCamera.URDFClip.class, "near", near));
        urdfClip.setFar(properties.toString(URDFSensor.URDFCamera.URDFClip.class, "far", far));
        return urdfClip;
    }

    public static URDFOrigin toURDFOrigin(RigidBodyTransformReadOnly pose, URDFGeneratorProperties properties) {
        if (pose == null) {
            return null;
        }
        URDFOrigin urdfOrigin = new URDFOrigin();
        Tuple3DReadOnly translation = pose.getTranslation();
        Orientation3DReadOnly rotation = pose.getRotation();
        urdfOrigin.setXYZ(properties.toString(URDFOrigin.class, "xyz", translation.getX(), translation.getY(), translation.getZ()));
        urdfOrigin.setRPY(properties.toString(URDFOrigin.class, "rpy", rotation.getRoll(), rotation.getPitch(), rotation.getYaw()));
        return urdfOrigin;
    }

    public static URDFOrigin toURDFOrigin(AffineTransformReadOnly pose, URDFGeneratorProperties properties) {
        if (pose == null) {
            return null;
        }
        URDFOrigin urdfOrigin = new URDFOrigin();
        Vector3DReadOnly translation = pose.getTranslation();
        QuaternionReadOnly rotation = pose.getLinearTransform().getAsQuaternion();
        urdfOrigin.setXYZ(properties.toString(URDFOrigin.class, "xyz", translation.getX(), translation.getY(), translation.getZ()));
        urdfOrigin.setRPY(properties.toString(URDFOrigin.class, "rpy", rotation.getRoll(), rotation.getPitch(), rotation.getYaw()));
        if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)new Vector3D(1.0, 1.0, 1.0), (EuclidGeometry)pose.getLinearTransform().getScaleVector(), (double)1.0E-7)) {
            LogTools.warn((String)"Discarding scale from affine trane transform.");
        }
        return urdfOrigin;
    }

    public static String toPoseString(RigidBodyTransformReadOnly pose, DoubleFormatter doubleFormatter) {
        return URDFTools.toPoseString(pose, 1, doubleFormatter);
    }

    public static String toPoseString(RigidBodyTransformReadOnly pose, int spaceCount, DoubleFormatter doubleFormatter) {
        if (pose == null) {
            return null;
        }
        Tuple3DReadOnly translation = pose.getTranslation();
        Orientation3DReadOnly rotation = pose.getRotation();
        return doubleFormatter.toString(spaceCount, translation.getX(), translation.getY(), translation.getZ(), rotation.getRoll(), rotation.getPitch(), rotation.getYaw());
    }

    public static URDFAxis toURDFAxis(Tuple3DReadOnly axis, URDFGeneratorProperties properties) {
        if (axis == null) {
            return null;
        }
        URDFAxis urdfAxis = new URDFAxis();
        urdfAxis.setXYZ(properties.toString(URDFAxis.class, "xyz", axis.getX(), axis.getY(), axis.getZ()));
        return urdfAxis;
    }

    public static URDFLimit toURDFLimit(OneDoFJointDefinition jointDefinition, URDFGeneratorProperties properties) {
        if (jointDefinition == null) {
            return null;
        }
        URDFLimit urdfLimit = new URDFLimit();
        urdfLimit.setLower(properties.toString(URDFLimit.class, "lower", jointDefinition.getPositionLowerLimit()));
        urdfLimit.setUpper(properties.toString(URDFLimit.class, "upper", jointDefinition.getPositionUpperLimit()));
        if (-jointDefinition.getVelocityLowerLimit() != jointDefinition.getVelocityUpperLimit()) {
            LogTools.warn((String)"Velocity limits no symmetric for joint {}, exporting smallest limit", (Object)jointDefinition.getName());
        }
        double velocity = Math.min(Math.abs(jointDefinition.getVelocityLowerLimit()), jointDefinition.getVelocityUpperLimit());
        urdfLimit.setVelocity(properties.toString(URDFLimit.class, "velocity", velocity));
        if (-jointDefinition.getEffortLowerLimit() != jointDefinition.getEffortUpperLimit()) {
            LogTools.warn((String)"Effort limits no symmetric for joint {}, exporting smallest limit", (Object)jointDefinition.getName());
        }
        double effort = Math.min(Math.abs(jointDefinition.getEffortLowerLimit()), jointDefinition.getEffortUpperLimit());
        urdfLimit.setEffort(properties.toString(URDFLimit.class, "effort", effort));
        return urdfLimit;
    }

    public static URDFDynamics toURDFDynamics(OneDoFJointDefinition jointDefinition, URDFGeneratorProperties properties) {
        if (jointDefinition == null) {
            return null;
        }
        if (!properties.alwaysExportJointDynamics && jointDefinition.getStiction() == 0.0 && jointDefinition.getDamping() == 0.0) {
            return null;
        }
        URDFDynamics urdfDynamics = new URDFDynamics();
        urdfDynamics.setFriction(properties.toString(URDFDynamics.class, "friction", jointDefinition.getStiction()));
        urdfDynamics.setDamping(properties.toString(URDFDynamics.class, "damping", jointDefinition.getDamping()));
        return urdfDynamics;
    }

    public static URDFLinkReference toURDFLinkReference(RigidBodyDefinition rigidBodyDefinition, URDFGeneratorProperties properties) {
        if (rigidBodyDefinition == null) {
            return null;
        }
        URDFLinkReference urdfLinkReference = new URDFLinkReference();
        urdfLinkReference.setLink(rigidBodyDefinition.getName());
        return urdfLinkReference;
    }

    public static class URDFParserProperties {
        private boolean ignoreNamespace = false;
        private final Set<String> jointsToIgnore = new HashSet<String>();
        private final Set<String> linksToIgnore = new HashSet<String>();
        private Supplier<? extends JointDefinition> rootJointFactory = SixDoFJointDefinition::new;
        private boolean autoGenerateVisualName = true;
        private boolean autoGenerateCollisionName = true;
        private boolean parseSensors = true;
        private boolean simplifyKinematics = true;
        private boolean transformToZUp = true;

        public void setIgnoreNamespace(boolean ignoreNamespace) {
            this.ignoreNamespace = ignoreNamespace;
        }

        public void addJointToIgnore(String nameOfJointToIgnore) {
            this.jointsToIgnore.add(nameOfJointToIgnore);
        }

        public void addLinkToIgnore(String nameOfLinkToIgnore) {
            this.linksToIgnore.add(nameOfLinkToIgnore);
        }

        public void setRootJointFactory(Supplier<? extends JointDefinition> rootJointFactory) {
            this.rootJointFactory = rootJointFactory;
        }

        public void setAutoGenerateVisualName(boolean autoGenerateVisualName) {
            this.autoGenerateVisualName = autoGenerateVisualName;
        }

        public void setAutoGenerateCollisionName(boolean autoGenerateCollisionName) {
            this.autoGenerateCollisionName = autoGenerateCollisionName;
        }

        public void setParseSensors(boolean parseSensors) {
            this.parseSensors = parseSensors;
        }

        public void setSimplifyKinematics(boolean simplifyKinematics) {
            this.simplifyKinematics = simplifyKinematics;
        }

        public void setTransformToZUp(boolean transformToZUp) {
            this.transformToZUp = transformToZUp;
        }
    }

    public static class URDFGeneratorProperties {
        private boolean alwaysExportJointDynamics = false;
        private boolean alwaysExportJointAxis = false;
        private boolean alwaysExportLinkInertial = false;
        private int defaultSpaceCount = 1;
        private DoubleFormatter defaultDoubleFormatter = Double::toString;
        private final Map<Class<? extends URDFItem>, URDFItemGeneratorProperties> urdfTypeFormatters = new HashMap<Class<? extends URDFItem>, URDFItemGeneratorProperties>();

        public void setAlwaysExportJointAxis(boolean alwaysExportJointAxis) {
            this.alwaysExportJointAxis = alwaysExportJointAxis;
        }

        public void setAlwaysExportJointDynamics(boolean alwaysExportJointDynamics) {
            this.alwaysExportJointDynamics = alwaysExportJointDynamics;
        }

        public void setAlwaysExportLinkInertial(boolean alwaysExportLinkInertial) {
            this.alwaysExportLinkInertial = alwaysExportLinkInertial;
        }

        public void setDefaultSpaceCount(int defaultSpaceCount) {
            this.defaultSpaceCount = defaultSpaceCount;
        }

        public void setSpaceCount(Class<? extends URDFItem> urdfType, int spaceCount) {
            URDFItemGeneratorProperties urdfTypeFormatter = this.urdfTypeFormatters.get(urdfType);
            if (urdfTypeFormatter == null) {
                urdfTypeFormatter = new URDFItemGeneratorProperties();
                this.urdfTypeFormatters.put(urdfType, urdfTypeFormatter);
            }
            urdfTypeFormatter.setDefaultSpaceCount(spaceCount);
        }

        public void setDefaultDoubleFormatter(DoubleFormatter formatter) {
            this.defaultDoubleFormatter = formatter;
        }

        public void addDoubleFormatter(Class<? extends URDFItem> urdfType, DoubleFormatter formatter) {
            URDFItemGeneratorProperties urdfTypeFormatter = this.urdfTypeFormatters.get(urdfType);
            if (urdfTypeFormatter == null) {
                urdfTypeFormatter = new URDFItemGeneratorProperties();
                this.urdfTypeFormatters.put(urdfType, urdfTypeFormatter);
            }
            urdfTypeFormatter.setDefaultDoubleFormatter(formatter);
        }

        public void addDoubleFormatter(Class<? extends URDFItem> urdfType, String fieldName, DoubleFormatter formatter) {
            URDFItemGeneratorProperties urdfTypeFormatter = this.urdfTypeFormatters.get(urdfType);
            if (urdfTypeFormatter == null) {
                urdfTypeFormatter = new URDFItemGeneratorProperties();
                this.urdfTypeFormatters.put(urdfType, urdfTypeFormatter);
            }
            urdfTypeFormatter.addFormatter(fieldName, formatter);
        }

        private String toString(Class<? extends URDFItem> urdfType, String fieldName, double ... values) {
            DoubleFormatter formatter = this.getDoubleFormatter(urdfType, fieldName);
            int spaceCount = Math.max(1, this.getSpaceCount(urdfType));
            return formatter.toString(spaceCount, values);
        }

        private int getSpaceCount(Class<? extends URDFItem> urdfType) {
            URDFItemGeneratorProperties urdfTypeFormatter = this.urdfTypeFormatters.get(urdfType);
            if (urdfTypeFormatter != null && urdfTypeFormatter.defaultSpaceCount != -1) {
                return urdfTypeFormatter.defaultSpaceCount;
            }
            return this.defaultSpaceCount;
        }

        private DoubleFormatter getDoubleFormatter(Class<? extends URDFItem> urdfType, String fieldName) {
            URDFItemGeneratorProperties urdfTypeFormatter = this.urdfTypeFormatters.get(urdfType);
            if (urdfTypeFormatter != null) {
                if (fieldName == null) {
                    if (urdfTypeFormatter.defaultDoubleFormatter != null) {
                        return urdfTypeFormatter.defaultDoubleFormatter;
                    }
                } else {
                    DoubleFormatter formatter = urdfTypeFormatter.getDoubleFormatter(fieldName.toLowerCase());
                    if (formatter != null) {
                        return formatter;
                    }
                }
            }
            return this.defaultDoubleFormatter;
        }
    }

    public static interface DoubleFormatter {
        public String toString(double var1);

        default public String toString(int spaceCount, double ... values) {
            if (values == null) {
                return null;
            }
            if (values.length == 0) {
                return "";
            }
            if (values.length == 1) {
                return this.toString(values[0]);
            }
            String separator = " ".repeat(spaceCount);
            StringBuilder sb = new StringBuilder(this.toString(values[0]));
            for (int i = 1; i < values.length; ++i) {
                sb.append(separator).append(this.toString(values[i]));
            }
            return sb.toString();
        }
    }

    private static class URDFItemGeneratorProperties {
        private int defaultSpaceCount = -1;
        private DoubleFormatter defaultDoubleFormatter;
        private final Map<String, DoubleFormatter> fieldToDoubleFormatterMap = new HashMap<String, DoubleFormatter>();

        public void setDefaultSpaceCount(int defaultSpaceCount) {
            this.defaultSpaceCount = defaultSpaceCount;
        }

        public void setDefaultDoubleFormatter(DoubleFormatter formatter) {
            this.defaultDoubleFormatter = formatter;
        }

        public void addFormatter(String fieldName, DoubleFormatter formatter) {
            this.fieldToDoubleFormatterMap.put(fieldName.toLowerCase(), formatter);
        }

        private DoubleFormatter getDoubleFormatter(String fieldName) {
            DoubleFormatter formatter = this.fieldToDoubleFormatterMap.get(fieldName.toLowerCase());
            if (formatter != null) {
                return formatter;
            }
            if (this.defaultDoubleFormatter != null) {
                return this.defaultDoubleFormatter;
            }
            return null;
        }
    }
}

