/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;

public interface OneDoFJointStateReadOnly
extends JointStateReadOnly {
    public double getConfiguration();

    public double getVelocity();

    public double getAcceleration();

    public double getEffort();

    @Override
    default public boolean hasOutputFor(JointStateType query) {
        switch (query) {
            case CONFIGURATION: {
                return !Double.isNaN(this.getConfiguration());
            }
            case VELOCITY: {
                return !Double.isNaN(this.getVelocity());
            }
            case ACCELERATION: {
                return !Double.isNaN(this.getAcceleration());
            }
            case EFFORT: {
                return !Double.isNaN(this.getEffort());
            }
        }
        throw new IllegalStateException("Should not get here.");
    }

    @Override
    default public int getConfigurationSize() {
        return 1;
    }

    @Override
    default public int getDegreesOfFreedom() {
        return 1;
    }

    @Override
    default public int getConfiguration(int startRow, DMatrix configurationToPack) {
        configurationToPack.set(startRow, 0, this.getConfiguration());
        return startRow + 1;
    }

    @Override
    default public int getVelocity(int startRow, DMatrix velocityToPack) {
        velocityToPack.set(startRow, 0, this.getVelocity());
        return startRow + 1;
    }

    @Override
    default public int getAcceleration(int startRow, DMatrix accelerationToPack) {
        accelerationToPack.set(startRow, 0, this.getAcceleration());
        return startRow + 1;
    }

    @Override
    default public int getEffort(int startRow, DMatrix effortToPack) {
        effortToPack.set(startRow, 0, this.getEffort());
        return startRow + 1;
    }

    @Override
    default public void getConfiguration(JointBasics jointToUpdate) {
        ((OneDoFJointBasics)jointToUpdate).setQ(this.getConfiguration());
    }

    @Override
    default public void getVelocity(JointBasics jointToUpdate) {
        ((OneDoFJointBasics)jointToUpdate).setQd(this.getVelocity());
    }

    @Override
    default public void getAcceleration(JointBasics jointToUpdate) {
        ((OneDoFJointBasics)jointToUpdate).setQdd(this.getAcceleration());
    }

    @Override
    default public void getEffort(JointBasics jointToUpdate) {
        ((OneDoFJointBasics)jointToUpdate).setTau(this.getEffort());
    }
}

