/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.awt.image.BufferedImage;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.TextureDefinition;
import us.ihmc.scs2.definition.visual.TextureDefinitionColorPalette;

public class TextureDefinitionColorPalette2D
implements TextureDefinitionColorPalette {
    private static final boolean PRINT_PALETTE = false;
    private static final int DEFAULT_RESOLUTION = 256;
    private int hueResolution = -1;
    private int saturationResolution = -1;
    private int brightnessResolution = -1;
    private double hueConstant = Double.NaN;
    private double saturationConstant = Double.NaN;
    private double brightnessConstant = Double.NaN;
    private BufferedImage colorPalette;

    public TextureDefinitionColorPalette2D() {
        this.setHueSaturationBased(1.0);
    }

    public void setHueSaturationBased(double brightnessConstant) {
        this.setHueSaturationBased(256, 256, brightnessConstant);
    }

    public void setHueSaturationBased(int hueResolution, int saturationResolution, double brightnessConstant) {
        MathTools.checkGreaterThanOrEquals((double)hueResolution, (double)1.0);
        MathTools.checkGreaterThanOrEquals((double)saturationResolution, (double)1.0);
        MathTools.checkIntervalContains((double)brightnessConstant, (double)0.0, (double)1.0);
        this.hueResolution = hueResolution;
        this.saturationResolution = saturationResolution;
        this.brightnessResolution = -1;
        this.hueConstant = Double.NaN;
        this.saturationConstant = Double.NaN;
        this.brightnessConstant = brightnessConstant;
        this.updateColorPalette();
    }

    public void setHueBrightnessBased(double saturationConstant) {
        this.setHueBrightnessBased(256, 256, saturationConstant);
    }

    public void setHueBrightnessBased(int hueResolution, int brightnessResolution, double saturationConstant) {
        MathTools.checkGreaterThanOrEquals((double)hueResolution, (double)1.0);
        MathTools.checkGreaterThanOrEquals((double)brightnessResolution, (double)1.0);
        MathTools.checkIntervalContains((double)saturationConstant, (double)0.0, (double)1.0);
        this.hueResolution = hueResolution;
        this.saturationResolution = -1;
        this.brightnessResolution = brightnessResolution;
        this.hueConstant = Double.NaN;
        this.saturationConstant = saturationConstant;
        this.brightnessConstant = Double.NaN;
        this.updateColorPalette();
    }

    public void setSaturationBrightnessBased(double hueConstant) {
        this.setSaturationBrightnessBased(256, 256, hueConstant);
    }

    public void setSaturationBrightnessBased(int saturationResolution, int brightnessResolution, double hueConstant) {
        MathTools.checkGreaterThanOrEquals((double)saturationResolution, (double)1.0);
        MathTools.checkGreaterThanOrEquals((double)brightnessResolution, (double)1.0);
        MathTools.checkIntervalContains((double)hueConstant, (double)0.0, (double)1.0);
        this.hueResolution = -1;
        this.saturationResolution = saturationResolution;
        this.brightnessResolution = brightnessResolution;
        this.hueConstant = hueConstant;
        this.saturationConstant = Double.NaN;
        this.brightnessConstant = Double.NaN;
        this.updateColorPalette();
    }

    private void updateColorPalette() {
        int width = this.hueResolution != -1 ? this.hueResolution : this.saturationResolution;
        int height = this.brightnessResolution != -1 ? this.brightnessResolution : this.saturationResolution;
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, this.getColorAtLocation(x, y));
            }
        }
        this.colorPalette = image;
    }

    private int getColorAtLocation(int x, int y) {
        double saturation;
        double hue = this.hueResolution != -1 ? 360.0 * (double)x / (double)this.hueResolution : 360.0 * this.hueConstant;
        if (this.saturationResolution != -1) {
            int index = this.hueResolution == -1 ? x : y;
            saturation = (double)index / (double)this.saturationResolution;
        } else {
            saturation = this.saturationConstant;
        }
        double brightness = this.brightnessResolution != -1 ? (double)y / (double)this.brightnessResolution : this.brightnessConstant;
        return ColorDefinitions.hsb(hue, saturation, brightness).toARGB();
    }

    @Override
    public Point2D32 getTextureLocation(ColorDefinition color) {
        float x = (float)(this.hueResolution != -1 ? color.getHue() / 360.0 : color.getSaturation());
        float y = (float)(this.brightnessResolution != -1 ? color.getBrightness() : color.getSaturation());
        return new Point2D32(x, y);
    }

    @Override
    public TextureDefinition getTextureDefinition() {
        return new TextureDefinition(this.colorPalette);
    }
}

