/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;

public interface PlanarJointStateReadOnly
extends JointStateReadOnly {
    public double getPitch();

    public double getPositionX();

    public double getPositionZ();

    public double getPitchVelocity();

    public double getLinearVelocityX();

    public double getLinearVelocityZ();

    public double getPitchAcceleration();

    public double getLinearAccelerationX();

    public double getLinearAccelerationZ();

    public double getTorqueY();

    public double getForceX();

    public double getForceZ();

    @Override
    default public int getConfigurationSize() {
        return 3;
    }

    @Override
    default public int getDegreesOfFreedom() {
        return 3;
    }

    @Override
    default public boolean hasOutputFor(JointStateType query) {
        switch (query) {
            case CONFIGURATION: {
                return !EuclidCoreTools.containsNaN((double)this.getPitch(), (double)this.getPositionX(), (double)this.getPositionZ());
            }
            case VELOCITY: {
                return !EuclidCoreTools.containsNaN((double)this.getPitchVelocity(), (double)this.getLinearVelocityX(), (double)this.getLinearVelocityZ());
            }
            case ACCELERATION: {
                return !EuclidCoreTools.containsNaN((double)this.getPitchAcceleration(), (double)this.getLinearAccelerationX(), (double)this.getLinearAccelerationZ());
            }
            case EFFORT: {
                return !EuclidCoreTools.containsNaN((double)this.getTorqueY(), (double)this.getForceX(), (double)this.getForceZ());
            }
        }
        throw new IllegalStateException("Should not get here.");
    }

    @Override
    default public int getConfiguration(int startRow, DMatrix configurationToPack) {
        configurationToPack.set(startRow++, 0, this.getPitch());
        configurationToPack.set(startRow++, 0, this.getPositionX());
        configurationToPack.set(startRow++, 0, this.getPositionZ());
        return startRow;
    }

    @Override
    default public int getVelocity(int startRow, DMatrix velocityToPack) {
        velocityToPack.set(startRow++, 0, this.getPitchVelocity());
        velocityToPack.set(startRow++, 0, this.getLinearVelocityX());
        velocityToPack.set(startRow++, 0, this.getLinearVelocityZ());
        return startRow;
    }

    @Override
    default public int getAcceleration(int startRow, DMatrix accelerationToPack) {
        accelerationToPack.set(startRow++, 0, this.getPitchAcceleration());
        accelerationToPack.set(startRow++, 0, this.getLinearAccelerationX());
        accelerationToPack.set(startRow++, 0, this.getLinearAccelerationZ());
        return startRow;
    }

    @Override
    default public int getEffort(int startRow, DMatrix effortToPack) {
        effortToPack.set(startRow++, 0, this.getTorqueY());
        effortToPack.set(startRow++, 0, this.getForceX());
        effortToPack.set(startRow++, 0, this.getForceZ());
        return startRow;
    }

    @Override
    default public void getConfiguration(JointBasics jointToUpdate) {
        Pose3DBasics jointPose = ((PlanarJointBasics)jointToUpdate).getJointPose();
        jointPose.getOrientation().setToPitchOrientation(this.getPitch());
        jointPose.getPosition().setX(this.getPositionX());
        jointPose.getPosition().setZ(this.getPositionZ());
    }

    @Override
    default public void getVelocity(JointBasics jointToUpdate) {
        FixedFrameTwistBasics jointTwist = ((PlanarJointBasics)jointToUpdate).getJointTwist();
        jointTwist.setAngularPartY(this.getPitchVelocity());
        jointTwist.setLinearPartX(this.getLinearVelocityX());
        jointTwist.setLinearPartZ(this.getLinearVelocityZ());
    }

    @Override
    default public void getAcceleration(JointBasics jointToUpdate) {
        FixedFrameSpatialAccelerationBasics jointAcceleration = ((PlanarJointBasics)jointToUpdate).getJointAcceleration();
        jointAcceleration.setAngularPartY(this.getPitchAcceleration());
        jointAcceleration.setLinearPartX(this.getLinearAccelerationX());
        jointAcceleration.setLinearPartZ(this.getLinearAccelerationZ());
    }

    @Override
    default public void getEffort(JointBasics jointToUpdate) {
        FixedFrameWrenchBasics jointWrench = ((PlanarJointBasics)jointToUpdate).getJointWrench();
        jointWrench.setAngularPartY(this.getTorqueY());
        jointWrench.setLinearPartX(this.getForceX());
        jointWrench.setLinearPartZ(this.getForceZ());
    }
}

