/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;

public class VisualDefinitionFactoryTest {
    static final double EPS = 1.0E-10;

    @Test
    public void testAddArrowPreviousTransform() {
        Random random = new Random(23943L);
        VisualDefinitionFactory v = new VisualDefinitionFactory();
        RigidBodyTransform initialTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        v.appendTransform((RigidBodyTransformReadOnly)initialTransform);
        v.saveCurrentTransform();
        RigidBodyTransform t1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        v.appendTransform((RigidBodyTransformReadOnly)t1);
        v.addArrow(EuclidCoreRandomTools.nextAxis3D((Random)random), random.nextDouble());
        v.resetCurrentTransform();
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)new AffineTransform((RigidBodyTransformReadOnly)initialTransform), (EuclidGeometry)v.getCurrentTransform(), (double)1.0E-10);
    }

    @Test
    public void testAddShapePreviousTransform() {
        Random random = new Random(23943L);
        VisualDefinitionFactory v = new VisualDefinitionFactory();
        RigidBodyTransform initialTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        v.appendTransform((RigidBodyTransformReadOnly)initialTransform);
        v.saveCurrentTransform();
        RigidBodyTransform t1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        v.appendTransform((RigidBodyTransformReadOnly)t1);
        v.addShape((Shape3DReadOnly)EuclidShapeRandomTools.nextShape3D((Random)random));
        v.resetCurrentTransform();
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)new AffineTransform((RigidBodyTransformReadOnly)initialTransform), (EuclidGeometry)v.getCurrentTransform(), (double)1.0E-10);
    }
}

