/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.definition.DefinitionRandomTools;
import us.ihmc.scs2.definition.yoComposite.YoTuple2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;

public class YoGraphicDefinitionTest {
    @Test
    public void testListToStringAndParse() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            int size = random.nextInt(20);
            ArrayList<YoTuple2DDefinition> original = new ArrayList<YoTuple2DDefinition>();
            while (original.size() < size) {
                original.add(DefinitionRandomTools.nextYoTuple2DDefinition(random));
            }
            String elementLabel = "dsf";
            String listStringValue = YoGraphicDefinition.listToParsableString(original, (String)elementLabel, Object::toString);
            List parsed = YoGraphicDefinition.parseList((String)listStringValue, (String)elementLabel, YoTuple2DDefinition::parse);
            Assertions.assertEquals(original, (Object)parsed);
        }
        List original = null;
        String elementLabel = "dsf";
        String listStringValue = YoGraphicDefinition.listToParsableString(original, (String)elementLabel, Object::toString);
        List parsed = YoGraphicDefinition.parseList((String)listStringValue, (String)elementLabel, YoTuple2DDefinition::parse);
        Assertions.assertEquals(original, (Object)parsed);
    }

    @Test
    public void testToStringAndParse() throws Exception {
        Random random = new Random(345L);
        for (int i = 0; i < 1000; ++i) {
            YoGraphicDefinition original = DefinitionRandomTools.nextYoGraphicDefinition(random);
            YoGraphicDefinition parsed = YoGraphicDefinition.parse((String)original.toParsableString());
            Assertions.assertEquals(original.getClass(), parsed.getClass());
            Assertions.assertEquals((Object)original.getName(), (Object)parsed.getName());
        }
    }

    @Test
    public void testToStringMapAndParseMap() throws Exception {
        int i;
        Random random = new Random(5456L);
        for (i = 0; i < 1000; ++i) {
            YoGraphicGroupDefinition originalRoot = DefinitionRandomTools.nextYoGraphicGroupDefinition(random, 5);
            List subtreeFieldValueStringMaps = YoGraphicDefinition.exportSubtreeYoGraphicFieldsSummaryList((YoGraphicGroupDefinition)originalRoot);
            List parsed = YoGraphicGroupDefinition.parseTreeYoGraphicFieldsSummary((List)subtreeFieldValueStringMaps);
            Assertions.assertEquals((int)1, (int)parsed.size());
            Assertions.assertEquals((Object)originalRoot, parsed.get(0));
        }
        for (i = 0; i < 1000; ++i) {
            int numberOfRoots = random.nextInt(5);
            ArrayList<YoGraphicGroupDefinition> originalRoots = new ArrayList<YoGraphicGroupDefinition>();
            for (int j = 0; j < numberOfRoots; ++j) {
                originalRoots.add(DefinitionRandomTools.nextYoGraphicGroupDefinition(random, 5));
            }
            List subtreeFieldValueStringMaps = YoGraphicDefinition.exportSubtreeYoGraphicFieldsSummaryList(originalRoots);
            List parsed = YoGraphicGroupDefinition.parseTreeYoGraphicFieldsSummary((List)subtreeFieldValueStringMaps);
            Assertions.assertEquals((int)numberOfRoots, (int)parsed.size());
            Assertions.assertEquals(originalRoots, (Object)parsed);
        }
    }
}

