/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.ArrayList;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyLinkCollider;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkJoint;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkRoot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotPhysics;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotExtension;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BulletRobot
extends RobotExtension {
    private final BulletRobotPhysics robotPhysics;
    private final BulletMultiBodyRobot bulletMultiBodyRobot;
    private BulletRobotLinkRoot rootLink;
    private final ArrayList<BulletRobotLinkJoint> afterRootLinks = new ArrayList();
    private final YoRegistry yoRegistry;

    public BulletRobot(Robot robot, YoRegistry physicsRegistry, BulletMultiBodyRobot bulletMultiBodyRobot) {
        super(robot, physicsRegistry);
        this.robotPhysics = new BulletRobotPhysics((RobotInterface)this);
        this.yoRegistry = new YoRegistry(this.getRobotDefinition().getName() + ((Object)((Object)this)).getClass().getSimpleName());
        robot.getRegistry().addChild(this.yoRegistry);
        this.bulletMultiBodyRobot = bulletMultiBodyRobot;
        for (BulletMultiBodyLinkCollider bulletLinkCollider : bulletMultiBodyRobot.getBulletMultiBodyLinkColliderArray()) {
            int bulletJointIndex = bulletMultiBodyRobot.getJointNameToBulletJointIndexMap().get(bulletLinkCollider.getJointName());
            SimJointBasics joint = robot.getJoint(bulletLinkCollider.getJointName());
            if (bulletJointIndex == -1) {
                if (!(joint instanceof SimFloatingRootJoint)) {
                    throw new RuntimeException("Expecting a SimFloatingRootJoint, not a " + joint.getClass().getSimpleName());
                }
                this.rootLink = new BulletRobotLinkRoot((SimFloatingRootJoint)joint, this.robotPhysics.getRigidBodyWrenchRegistry(), this.yoRegistry, bulletLinkCollider);
                continue;
            }
            if (joint instanceof SimOneDoFJointBasics) {
                this.afterRootLinks.add(new BulletRobotLinkJoint((SimOneDoFJointBasics)joint, bulletJointIndex, this.robotPhysics.getRigidBodyWrenchRegistry(), this.yoRegistry, bulletLinkCollider));
                continue;
            }
            throw new RuntimeException("Expecting a SimOneDoFJointBasics, not a " + joint.getClass().getSimpleName());
        }
    }

    public void pushStateToBullet() {
        this.robotPhysics.reset();
        if (this.rootLink != null) {
            this.rootLink.pushStateToBullet();
        }
        for (BulletRobotLinkJoint afterRootLink : this.afterRootLinks) {
            afterRootLink.pushStateToBullet();
        }
    }

    public void pullStateFromBullet(double dt) {
        if (this.rootLink != null) {
            this.rootLink.pullStateFromBullet(dt);
        }
        for (BulletRobotLinkJoint afterRootLink : this.afterRootLinks) {
            afterRootLink.pullStateFromBullet(dt);
        }
        this.robotPhysics.update(dt);
    }

    public BulletMultiBodyRobot getBulletMultiBodyRobot() {
        return this.bulletMultiBodyRobot;
    }

    public void updateSensors() {
        this.getRootBody().updateAuxiliaryDataRecursively(this.robotPhysics.getPhysicsOutput());
    }
}

