/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.ArrayList;
import org.bytedeco.bullet.BulletCollision.btCollisionShape;
import org.bytedeco.bullet.BulletCollision.btCompoundShape;
import org.bytedeco.bullet.BulletDynamics.btMultiBody;
import org.bytedeco.bullet.BulletDynamics.btMultiBodyLinkCollider;
import org.bytedeco.bullet.LinearMath.btTransform;
import org.bytedeco.bullet.LinearMath.btVector3;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;

public class BulletMultiBodyLinkCollider {
    private final btMultiBodyLinkCollider btMultiBodyLinkCollider;
    private final btMultiBody btMultiBody;
    private final String jointName;
    private final int linkColliderIndex;
    private final btTransform bulletTempConversionBtTransform = new btTransform();
    private final btVector3 bulletTempConversionVector3 = new btVector3();
    private final btVector3 linkForce;
    private final btVector3 linkTorque;
    private int collisionGroup;
    private int collisionGroupMask;
    private btCompoundShape shape;
    private ArrayList<btCollisionShape> btCollisionShapes = new ArrayList();

    public BulletMultiBodyLinkCollider(btMultiBody btMultibody, int index, String jointName) {
        this.btMultiBodyLinkCollider = new btMultiBodyLinkCollider(btMultibody, index);
        this.linkColliderIndex = index;
        this.jointName = jointName;
        this.collisionGroup = 2;
        this.collisionGroupMask = 3;
        this.btMultiBody = this.btMultiBodyLinkCollider.m_multiBody();
        this.linkForce = this.btMultiBody.getLink(this.linkColliderIndex).m_appliedConstraintForce();
        this.linkTorque = this.btMultiBody.getLink(this.linkColliderIndex).m_appliedConstraintTorque();
    }

    public void setCollisionGroupMask(int collisionGroup, int collisionGroupMask) {
        this.collisionGroup = collisionGroup;
        this.collisionGroupMask = collisionGroupMask;
    }

    public void setCollisionShape(btCompoundShape shape, ArrayList<btCollisionShape> btCollisionShapes) {
        this.setShape(shape);
        this.setBtCollisionShapes(btCollisionShapes);
        this.btMultiBodyLinkCollider.setCollisionShape((btCollisionShape)shape);
    }

    public void setFriction(double friction) {
        this.btMultiBodyLinkCollider.setFriction(friction);
    }

    public void setRestitution(double restitution) {
        this.btMultiBodyLinkCollider.setRestitution(restitution);
    }

    public void setHitFraction(double hitFraction) {
        this.btMultiBodyLinkCollider.setHitFraction(hitFraction);
    }

    public void setRollingFriction(double rollingFriction) {
        this.btMultiBodyLinkCollider.setRollingFriction(rollingFriction);
    }

    public void setSpinningFriction(double spinningFriction) {
        this.btMultiBodyLinkCollider.setSpinningFriction(spinningFriction);
    }

    public void setContactProcessingThreshold(double contactProcessingThreshold) {
        this.btMultiBodyLinkCollider.setContactProcessingThreshold(contactProcessingThreshold);
    }

    public btMultiBodyLinkCollider getBtMultiBodyLinkCollider() {
        return this.btMultiBodyLinkCollider;
    }

    public int getCollisionGroup() {
        return this.collisionGroup;
    }

    public int getCollisionGroupMask() {
        return this.collisionGroupMask;
    }

    public String getJointName() {
        return this.jointName;
    }

    public void getWorldTransform(RigidBodyTransform jointSuccessorBodyFixedFrameToWorldEuclid) {
        BulletTools.toEuclid(this.btMultiBodyLinkCollider.getWorldTransform(), jointSuccessorBodyFixedFrameToWorldEuclid);
    }

    public void setWorldTransform(RigidBodyTransform bulletColliderCenterOfMassTransformToWorldEuclid) {
        BulletTools.toBullet(bulletColliderCenterOfMassTransformToWorldEuclid, this.bulletTempConversionBtTransform);
        this.btMultiBodyLinkCollider.setWorldTransform(this.bulletTempConversionBtTransform);
        if (this.linkColliderIndex == -1) {
            this.btMultiBody.setBaseWorldTransform(this.bulletTempConversionBtTransform);
        }
    }

    public void setJointPos(double jointPosition) {
        this.btMultiBody.setJointPos(this.linkColliderIndex, jointPosition);
    }

    public void setJointVel(double jointVelocity) {
        this.btMultiBody.setJointVel(this.linkColliderIndex, jointVelocity);
    }

    public void addJointTorque(double jointTau) {
        this.btMultiBody.addJointTorque(this.linkColliderIndex, jointTau);
    }

    public double getJointPos() {
        return this.btMultiBody.getJointPos(this.linkColliderIndex);
    }

    public double getJointVel() {
        return this.btMultiBody.getJointVel(this.linkColliderIndex);
    }

    public void getAppliedConstraintForce(Vector3D force) {
        force.set(this.linkForce.getX(), this.linkForce.getY(), this.linkForce.getZ());
    }

    public void getAppliedConstraintTorque(Vector3D torque) {
        torque.set(this.linkTorque.getX(), this.linkTorque.getY(), this.linkTorque.getZ());
    }

    public void setBaseVel(Vector3DReadOnly linearVelocityEuclid) {
        BulletTools.toBullet((Tuple3DReadOnly)linearVelocityEuclid, this.bulletTempConversionVector3);
        this.btMultiBody.setBaseVel(this.bulletTempConversionVector3);
    }

    public void setBaseOmega(Vector3DReadOnly angularVelocityBulletEuclid) {
        BulletTools.toBullet((Tuple3DReadOnly)angularVelocityBulletEuclid, this.bulletTempConversionVector3);
        this.btMultiBody.setBaseOmega(this.bulletTempConversionVector3);
    }

    public void getBaseVel(Vector3D bulletBaseLinearVelocityEuclid) {
        BulletTools.toEuclid(this.btMultiBody.getBaseVel(), (Vector3DBasics)bulletBaseLinearVelocityEuclid);
    }

    public void getBaseOmega(Vector3D bulletBaseAngularVelocityEuclid) {
        BulletTools.toEuclid(this.btMultiBody.getBaseOmega(), (Vector3DBasics)bulletBaseAngularVelocityEuclid);
    }

    public btCompoundShape getShape() {
        return this.shape;
    }

    public void setShape(btCompoundShape shape) {
        this.shape = shape;
    }

    public ArrayList<btCollisionShape> getBtCollisionShapes() {
        return this.btCollisionShapes;
    }

    public void setBtCollisionShapes(ArrayList<btCollisionShape> btCollisionShapes) {
        this.btCollisionShapes = btCollisionShapes;
    }
}

