/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine.modelLoader;

import java.nio.ByteBuffer;
import org.apache.logging.log4j.Level;
import org.lwjgl.assimp.AIFileCloseProcI;
import org.lwjgl.assimp.AIFileIO;
import org.lwjgl.assimp.AIFileOpenProcI;
import org.lwjgl.assimp.AILogStream;
import org.lwjgl.assimp.AILogStreamCallbackI;
import org.lwjgl.assimp.AIPropertyStore;
import org.lwjgl.assimp.AIScene;
import org.lwjgl.assimp.Assimp;
import org.lwjgl.system.MemoryUtil;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.modelLoader.AssimpOpenedFile;

public class AssimpResourceImporter {
    public static boolean ASSIMP_INITIAL_SETUP = false;

    public AIScene importScene(String resourcePath, int postProcessingSteps, AIPropertyStore assimpPropertyStore) {
        AssimpResourceImporter.ensureAssimpInitialSetup();
        AIFileOpenProcI assimpFileOpenFunction = new AIFileOpenProcI(){

            public long invoke(long assimpFileIOAddress, long fileNameAddress, long openModeAddress) {
                AssimpOpenedFile assimpOpenedFile = new AssimpOpenedFile(assimpFileIOAddress, fileNameAddress, openModeAddress);
                return assimpOpenedFile.getAssimpFileStructAddress();
            }
        };
        AIFileCloseProcI assimpFileCloseFunction = new AIFileCloseProcI(){

            public void invoke(long assimpFileIOAddress, long assimpFileAddress) {
                LogTools.debug((String)"Closing");
            }
        };
        AIFileIO assimpFileIO = AIFileIO.create();
        assimpFileIO.OpenProc(assimpFileOpenFunction);
        assimpFileIO.CloseProc(assimpFileCloseFunction);
        assimpFileIO.UserData(MemoryUtil.memAddress((ByteBuffer)MemoryUtil.memAlloc((int)1)));
        AIScene assimpScene = Assimp.aiImportFileExWithProperties((CharSequence)resourcePath, (int)postProcessingSteps, (AIFileIO)assimpFileIO, (AIPropertyStore)assimpPropertyStore);
        if (assimpScene == null) {
            LogTools.error((String)Assimp.aiGetErrorString());
        }
        return assimpScene;
    }

    private static void ensureAssimpInitialSetup() {
        if (!ASSIMP_INITIAL_SETUP) {
            ASSIMP_INITIAL_SETUP = true;
            LogTools.debug((String)"Using assimp {}.{}", (Object)Assimp.aiGetVersionMajor(), (Object)Assimp.aiGetVersionMinor());
            Assimp.aiEnableVerboseLogging((boolean)LogTools.getLevel().isLessSpecificThan(Level.DEBUG));
            AILogStreamCallbackI assimpLogStreamCallback = new AILogStreamCallbackI(){

                public void invoke(long messageAddress, long userDataAddress) {
                    String messageString = MemoryUtil.memUTF8((long)messageAddress);
                    LogTools.debug((String)"[Assimp] {}", (Object)messageString.trim());
                }
            };
            AILogStream assimpLogStream = AILogStream.create();
            assimpLogStream.callback(assimpLogStreamCallback);
            assimpLogStream.user(1);
            Assimp.aiAttachLogStream((AILogStream)assimpLogStream);
        }
    }
}

