/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletSimulationParameters;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoBulletSimulationParameters {
    private YoDouble timeStamp;
    private YoInteger maxSubSteps;
    private YoDouble fixedTimeStep;

    public YoBulletSimulationParameters(String prefix, YoRegistry registry) {
        String simulateFixedTimeStep;
        String simulateMaxSubSteps;
        String simulateTimeStamp;
        if (prefix == null || prefix.isEmpty()) {
            simulateTimeStamp = "TimeStamp";
            simulateMaxSubSteps = "MaxSubSteps";
            simulateFixedTimeStep = "FixedTimeStep";
        } else {
            simulateTimeStamp = prefix + "TimeStamp";
            simulateMaxSubSteps = prefix + "MaxSubSteps";
            simulateFixedTimeStep = prefix + "FixedTimeStep";
        }
        this.timeStamp = new YoDouble(simulateTimeStamp, registry);
        this.maxSubSteps = new YoInteger(simulateMaxSubSteps, registry);
        this.fixedTimeStep = new YoDouble(simulateFixedTimeStep, registry);
    }

    public void set(BulletSimulationParameters parameters) {
        this.setTimeStamp(parameters.getTimeStep());
        this.setMaxSubSteps(parameters.getMaxSubSteps());
        this.setFixedTimeStep(parameters.getFixedTimeStep());
    }

    public void setTimeStamp(Double timeStamp) {
        this.timeStamp.set(timeStamp.doubleValue());
    }

    public void setMaxSubSteps(int maxSubSteps) {
        this.maxSubSteps.set(maxSubSteps);
    }

    public void setFixedTimeStep(double fixedTimeStep) {
        this.fixedTimeStep.set(fixedTimeStep);
    }

    public double getTimeStamp() {
        return this.timeStamp.getValue();
    }

    public int getMaxSubSteps() {
        return this.maxSubSteps.getValue();
    }

    public double getFixedTimeStep() {
        return this.fixedTimeStep.getValue();
    }
}

