/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.physics.bullet.collision.btBoxShape;
import com.badlogic.gdx.physics.bullet.collision.btCapsuleShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btCompoundShape;
import com.badlogic.gdx.physics.bullet.collision.btConeShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btCylinderShape;
import com.badlogic.gdx.physics.bullet.collision.btSphereShape;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBody;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyLinkCollider;
import com.badlogic.gdx.physics.bullet.dynamics.btMultibodyLink;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMath;
import com.badlogic.gdx.physics.bullet.linearmath.btQuaternion;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.MomentOfInertiaDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.PrismaticJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobotFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyParameters;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimPrismaticJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRevoluteJoint;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BulletMultiBodyRobotFactoryTest {
    private final YawPitchRollTransformDefinition inertiaPose = new YawPitchRollTransformDefinition();
    private final YawPitchRollTransformDefinition collisionShapePose = new YawPitchRollTransformDefinition();
    private CollisionShapeDefinition shapeDefinition = new CollisionShapeDefinition();
    private static final RigidBodyTransform collisionShapeRigidBodyTransform;
    private static Matrix4 compoundShapeChildTransform;
    private static final Vector3 boxVertex;
    private static final YawPitchRollTransformDefinition TransformToParent;
    private static final RigidBodyTransform parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid;
    private static final RigidBodyTransform parentJointAfterFrameToLinkCenterOfMassTransformEuclid;
    private static final double EPSILON = 1.0E-5;
    private static final int ITERATIONS = 1;

    @Test
    public void testNewInstance() {
        BulletMultiBodyRobot bulletMultiBodyRobot;
        Robot robot;
        int i;
        Random random = new Random(42187L);
        String name = "TestRobot";
        YoRegistry physicsEngineRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoBulletMultiBodyParameters globalMultiBodyParameters = new YoBulletMultiBodyParameters("globalMultiBody", physicsEngineRegistry);
        globalMultiBodyParameters.set(BulletMultiBodyParameters.defaultBulletMultiBodyParameters());
        YoBulletMultiBodyJointParameters globalMultiBodyJointParameters = new YoBulletMultiBodyJointParameters("globalMultiJointBody", physicsEngineRegistry);
        globalMultiBodyJointParameters.set(BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            RobotDefinition robotDefinition = new RobotDefinition(name + "RootBody");
            RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RigidBody");
            robotDefinition.setRootBodyDefinition(rootBody);
            Robot robotNoJoints = new Robot(robotDefinition, ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
            BulletMultiBodyRobotFactory.newInstance((Robot)robotNoJoints, (YoBulletMultiBodyParameters)globalMultiBodyParameters, (YoBulletMultiBodyJointParameters)globalMultiBodyJointParameters);
        });
        for (i = 0; i < 1; ++i) {
            robot = BulletMultiBodyRobotFactoryTest.createTestRobotWithoutBaseCollider(random, name + i);
            bulletMultiBodyRobot = BulletMultiBodyRobotFactory.newInstance((Robot)robot, (YoBulletMultiBodyParameters)globalMultiBodyParameters, (YoBulletMultiBodyJointParameters)globalMultiBodyJointParameters);
            Assertions.assertTrue((bulletMultiBodyRobot.getBtMultiBody().getBaseCollider() == null ? 1 : 0) != 0, (String)"Assert btMultiBody does not have a Base Collider");
            this.assertBulletMultiBodyRobotCreatedCorrectly(robot, bulletMultiBodyRobot, globalMultiBodyParameters, globalMultiBodyJointParameters);
            globalMultiBodyParameters.set(BulletMultiBodyRobotFactoryTest.nextRandomMultiBodyParameters(random));
            globalMultiBodyJointParameters.set(BulletMultiBodyRobotFactoryTest.nextRandomMultiBodyJointParameters(random));
        }
        for (i = 0; i < 1; ++i) {
            robot = BulletMultiBodyRobotFactoryTest.createTestRobotWithBaseCollider(random, name + i);
            bulletMultiBodyRobot = BulletMultiBodyRobotFactory.newInstance((Robot)robot, (YoBulletMultiBodyParameters)globalMultiBodyParameters, (YoBulletMultiBodyJointParameters)globalMultiBodyJointParameters);
            Assertions.assertTrue((bulletMultiBodyRobot.getBtMultiBody().getBaseCollider() != null ? 1 : 0) != 0, (String)"Assert btMultiBody does not have a Base Collider");
            this.assertBulletMultiBodyRobotCreatedCorrectly(robot, bulletMultiBodyRobot, globalMultiBodyParameters, globalMultiBodyJointParameters);
            globalMultiBodyParameters.set(BulletMultiBodyRobotFactoryTest.nextRandomMultiBodyParameters(random));
            globalMultiBodyJointParameters.set(BulletMultiBodyRobotFactoryTest.nextRandomMultiBodyJointParameters(random));
        }
    }

    @Test
    public void testNewInstanceRegressionTest() {
        YoRegistry physicsEngineRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoBulletMultiBodyParameters globalMultiBodyParameters = new YoBulletMultiBodyParameters("globalMultiBody", physicsEngineRegistry);
        globalMultiBodyParameters.set(BulletMultiBodyParameters.defaultBulletMultiBodyParameters());
        YoBulletMultiBodyJointParameters globalMultiBodyJointParameters = new YoBulletMultiBodyJointParameters("globalMultiJointBody", physicsEngineRegistry);
        globalMultiBodyJointParameters.set(BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters());
        Robot robot = BulletMultiBodyRobotFactoryTest.createTestRobotWithKnownValues();
        BulletMultiBodyRobot bulletMultiBodyRobot = BulletMultiBodyRobotFactory.newInstance((Robot)robot, (YoBulletMultiBodyParameters)globalMultiBodyParameters, (YoBulletMultiBodyJointParameters)globalMultiBodyJointParameters);
        btMultiBody btMultibody = bulletMultiBodyRobot.getBtMultiBody();
        Assertions.assertEquals((int)btMultibody.getNumLinks(), (int)1);
        Assertions.assertEquals((int)bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(0).getCollisionGroup(), (int)64);
        Assertions.assertEquals((int)bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(0).getCollisionGroupMask(), (int)899);
        Assertions.assertEquals((int)bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(1).getCollisionGroup(), (int)1);
        Assertions.assertEquals((int)bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(1).getCollisionGroupMask(), (int)3);
        Vector3 linkAxis = bulletMultiBodyRobot.getBtMultiBody().getLink(0).getAxisTop(0);
        Assertions.assertEquals((float)linkAxis.x, (float)0.0f);
        Assertions.assertEquals((float)linkAxis.y, (float)0.0f);
        Assertions.assertEquals((float)linkAxis.z, (float)1.0f);
        btMultiBodyLinkCollider baseCollider = bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(0).getBtMultiBodyLinkCollider();
        btMultiBodyLinkCollider linkCollider = bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(1).getBtMultiBodyLinkCollider();
        btCompoundShape baseColliderCompoundShape = (btCompoundShape)baseCollider.getCollisionShape();
        Assertions.assertEquals((int)baseColliderCompoundShape.getChildShape(0).getShapeType(), (int)13);
        btCylinderShape cylinderShape = (btCylinderShape)baseColliderCompoundShape.getChildShape(0);
        Assertions.assertEquals((float)cylinderShape.getRadius(), (float)0.11f);
        Assertions.assertEquals((float)cylinderShape.getHalfExtentsWithMargin().z, (float)0.03f);
        Assertions.assertEquals((int)baseColliderCompoundShape.getChildShape(1).getShapeType(), (int)13);
        cylinderShape = (btCylinderShape)baseColliderCompoundShape.getChildShape(1);
        Assertions.assertEquals((float)cylinderShape.getRadius(), (float)0.12f);
        Assertions.assertEquals((float)cylinderShape.getHalfExtentsWithMargin().z, (float)0.02f);
        Assertions.assertEquals((int)baseColliderCompoundShape.getChildShape(2).getShapeType(), (int)13);
        cylinderShape = (btCylinderShape)baseColliderCompoundShape.getChildShape(2);
        Assertions.assertEquals((float)cylinderShape.getRadius(), (float)0.16f);
        Assertions.assertEquals((float)cylinderShape.getHalfExtentsWithMargin().z, (float)0.025f);
        btCompoundShape linkColliderCompoundShape = (btCompoundShape)linkCollider.getCollisionShape();
        Assertions.assertEquals((int)linkColliderCompoundShape.getChildShape(0).getShapeType(), (int)0);
        btBoxShape boxShape = (btBoxShape)linkColliderCompoundShape.getChildShape(0);
        boxShape.getVertex(0, boxVertex);
        Assertions.assertEquals((double)Math.abs(BulletMultiBodyRobotFactoryTest.boxVertex.x), (double)0.015f, (double)1.0E-5);
        Assertions.assertEquals((double)Math.abs(BulletMultiBodyRobotFactoryTest.boxVertex.y), (double)0.02f, (double)1.0E-5);
        Assertions.assertEquals((double)Math.abs(BulletMultiBodyRobotFactoryTest.boxVertex.z), (double)0.01f, (double)1.0E-5);
        Assertions.assertEquals((float)linkCollider.getFriction(), (float)((float)globalMultiBodyJointParameters.getJointFriction()));
        Assertions.assertEquals((float)linkCollider.getRestitution(), (float)((float)globalMultiBodyJointParameters.getJointRestitution()));
        Assertions.assertEquals((float)linkCollider.getHitFraction(), (float)((float)globalMultiBodyJointParameters.getJointHitFraction()));
        Assertions.assertEquals((float)linkCollider.getRollingFriction(), (float)((float)globalMultiBodyJointParameters.getJointRollingFriction()));
        Assertions.assertEquals((float)linkCollider.getSpinningFriction(), (float)((float)globalMultiBodyJointParameters.getJointSpinningFriction()));
        Assertions.assertEquals((float)linkCollider.getContactProcessingThreshold(), (float)((float)globalMultiBodyJointParameters.getJointContactProcessingThreshold()));
        Assertions.assertEquals((float)btMultibody.getBaseMass(), (float)9.609f);
        Assertions.assertEquals((float)btMultibody.getLinkMass(0), (float)2.27f);
    }

    @Test
    public void testBulletCollisionShapeLocalTransform() {
        this.inertiaPose.setTranslation(0.05, 0.08, 0.09);
        this.inertiaPose.setOrientation(0.01, 0.01, 0.01);
        this.collisionShapePose.setTranslation(this.inertiaPose.getX() - 0.01, this.inertiaPose.getY() - 0.01, this.inertiaPose.getZ() - 0.01);
        this.collisionShapePose.setOrientation(this.inertiaPose.getYaw() - 0.004, this.inertiaPose.getPitch() - 0.004, this.inertiaPose.getRoll() - 0.004);
        String robotName = "Robot1";
        Robot robot1 = BulletMultiBodyRobotFactoryTest.createRobotToTestLocalTransform(robotName, this.inertiaPose, this.collisionShapePose);
        this.shapeDefinition = (CollisionShapeDefinition)robot1.getRobotDefinition().getRigidBodyDefinition(robotName + "RigidBody").getCollisionShapeDefinitions().get(0);
        MovingReferenceFrame linkCenterOfMassFrame = ((JointBasics)robot1.getRootBody().getChildrenJoints().get(0)).getSuccessor().getBodyFixedFrame();
        Matrix4 bulletCollisionShapeLocalTransform = BulletMultiBodyRobotFactory.bulletCollisionShapeLocalTransform((CollisionShapeDefinition)this.shapeDefinition, (ReferenceFrame)linkCenterOfMassFrame);
        RigidBodyTransform rigidBodyTransformExpectedResults1 = new RigidBodyTransform(0.999984, -0.003959719, 0.004039708, 0.009999639, 0.0039757174, 0.99998426, -0.0039599594, 0.010000003, -0.004023964, 0.0039759567, 0.999984, 0.010000359);
        BulletMultiBodyRobotFactoryTest.assertMatrix4EqualsRigidBodyTransform(robotName, bulletCollisionShapeLocalTransform, rigidBodyTransformExpectedResults1);
        this.inertiaPose.setTranslation(0.07, 0.02, 0.01);
        this.inertiaPose.setOrientation(0.03, 0.02, 0.04);
        this.collisionShapePose.setTranslation(0.02, 0.06, 0.03);
        this.collisionShapePose.setOrientation(0.04, 0.02, 0.01);
        robotName = "Robot2";
        Robot robot2 = BulletMultiBodyRobotFactoryTest.createRobotToTestLocalTransform(robotName, this.inertiaPose, this.collisionShapePose);
        this.shapeDefinition = (CollisionShapeDefinition)robot2.getRobotDefinition().getRigidBodyDefinition(robotName + "RigidBody").getCollisionShapeDefinitions().get(0);
        linkCenterOfMassFrame = ((JointBasics)robot2.getRootBody().getChildrenJoints().get(0)).getSuccessor().getBodyFixedFrame();
        bulletCollisionShapeLocalTransform = BulletMultiBodyRobotFactory.bulletCollisionShapeLocalTransform((CollisionShapeDefinition)this.shapeDefinition, (ReferenceFrame)linkCenterOfMassFrame);
        RigidBodyTransform rigidBodyTransformExpectedResults2 = new RigidBodyTransform(0.99995, 0.009989796, -4.0080564E-4, 0.048750732, -0.009997344, 0.9994941, -0.030193394, -0.042155657, 9.897699E-5, 0.030195892, 0.999544, -0.018608237);
        BulletMultiBodyRobotFactoryTest.assertMatrix4EqualsRigidBodyTransform(robotName, bulletCollisionShapeLocalTransform, rigidBodyTransformExpectedResults2);
        this.inertiaPose.setTranslation(0.0, 0.0, 0.0);
        this.inertiaPose.setOrientation(0.0, 0.0, 0.0);
        this.collisionShapePose.setTranslation(0.0, 0.0, 0.0);
        this.collisionShapePose.setOrientation(0.0, 0.0, 0.0);
        robotName = "Robot3";
        Robot robot3 = BulletMultiBodyRobotFactoryTest.createRobotToTestLocalTransform(robotName, this.inertiaPose, this.collisionShapePose);
        this.shapeDefinition = (CollisionShapeDefinition)robot3.getRobotDefinition().getRigidBodyDefinition(robotName + "RigidBody").getCollisionShapeDefinitions().get(0);
        linkCenterOfMassFrame = ((JointBasics)robot3.getRootBody().getChildrenJoints().get(0)).getSuccessor().getBodyFixedFrame();
        bulletCollisionShapeLocalTransform = BulletMultiBodyRobotFactory.bulletCollisionShapeLocalTransform((CollisionShapeDefinition)this.shapeDefinition, (ReferenceFrame)linkCenterOfMassFrame);
        RigidBodyTransform rigidBodyTransformExpectedResults3 = new RigidBodyTransform(1.0, 0.0, 0.0, -0.0, 0.0, 1.0, 0.0, -0.0, 0.0, 0.0, 1.0, -0.0);
        BulletMultiBodyRobotFactoryTest.assertMatrix4EqualsRigidBodyTransform(robotName, bulletCollisionShapeLocalTransform, rigidBodyTransformExpectedResults3);
    }

    private static BulletMultiBodyParameters nextRandomMultiBodyParameters(Random random) {
        BulletMultiBodyParameters parameters = new BulletMultiBodyParameters(random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
        return parameters;
    }

    private static BulletMultiBodyJointParameters nextRandomMultiBodyJointParameters(Random random) {
        BulletMultiBodyJointParameters jointParameters = new BulletMultiBodyJointParameters(random.nextBoolean(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
        return jointParameters;
    }

    private void assertBulletMultiBodyRobotCreatedCorrectly(Robot robot, BulletMultiBodyRobot bulletMultiBodyRobot, YoBulletMultiBodyParameters globalMultiBodyParameters, YoBulletMultiBodyJointParameters globalMultiBodyJointParameters) {
        btMultiBody btMultiBody2 = bulletMultiBodyRobot.getBtMultiBody();
        JointBasics rootJoint = (JointBasics)robot.getRootBody().getChildrenJoints().get(0);
        boolean hasBaseCollider = rootJoint instanceof SimFloatingRootJoint;
        RigidBodyDefinition rigidBodyDefinition = ((JointDefinition)robot.getRobotDefinition().getRootBodyDefinition().getChildrenJoints().get(0)).getSuccessor();
        int numberOfLinks = 0;
        for (JointBasics joint : robot.getRootBody().getChildrenJoints()) {
            numberOfLinks += BulletMultiBodyRobotFactoryTest.countJointsAndCreateIndexMap(joint);
        }
        Assertions.assertEquals((float)((float)rigidBodyDefinition.getMass()), (float)btMultiBody2.getBaseMass());
        Assertions.assertEquals((int)(hasBaseCollider ? numberOfLinks - 1 : numberOfLinks), (int)btMultiBody2.getNumDofs());
        Assertions.assertEquals((int)(hasBaseCollider ? numberOfLinks - 1 : numberOfLinks), (int)btMultiBody2.getNumLinks());
        Assertions.assertEquals((int)numberOfLinks, (int)bulletMultiBodyRobot.getJointNameToBulletJointIndexMap().size());
        Assertions.assertEquals((int)numberOfLinks, (int)bulletMultiBodyRobot.getBulletMultiBodyLinkColliderArray().size());
        Assertions.assertEquals((Object)btMultiBody2.getCanSleep(), (Object)globalMultiBodyParameters.getCanSleep());
        Assertions.assertEquals((Object)btMultiBody2.hasSelfCollision(), (Object)globalMultiBodyParameters.getHasSelfCollision());
        Assertions.assertEquals((Object)btMultiBody2.getUseGyroTerm(), (Object)globalMultiBodyParameters.getUseGyroTerm());
        Assertions.assertEquals((Object)btMultiBody2.isUsingRK4Integration(), (Object)globalMultiBodyParameters.getUseRK4Integration());
        Assertions.assertEquals((double)btMultiBody2.getLinearDamping(), (double)((float)globalMultiBodyParameters.getLinearDamping()), (double)1.0E-5);
        Assertions.assertEquals((double)btMultiBody2.getAngularDamping(), (double)((float)globalMultiBodyParameters.getAngularDamping()), (double)1.0E-5);
        Assertions.assertEquals((double)btMultiBody2.getMaxAppliedImpulse(), (double)((float)globalMultiBodyParameters.getMaxAppliedImpulse()), (double)1.0E-5);
        Assertions.assertEquals((double)btMultiBody2.getMaxCoordinateVelocity(), (double)((float)globalMultiBodyParameters.getMaxCoordinateVelocity()), (double)1.0E-5);
        for (JointBasics joint : robot.getRootBody().getChildrenJoints()) {
            if (!(joint instanceof SimFloatingRootJoint)) {
                BulletMultiBodyRobotFactoryTest.assertJointAndLinkEqual(robot, bulletMultiBodyRobot, globalMultiBodyJointParameters, btMultiBody2, joint, hasBaseCollider);
            }
            BulletMultiBodyRobotFactoryTest.testChildJoints(robot, bulletMultiBodyRobot, globalMultiBodyJointParameters, btMultiBody2, joint, hasBaseCollider);
        }
    }

    private static void testChildJoints(Robot robot, BulletMultiBodyRobot bulletMultiBodyRobot, YoBulletMultiBodyJointParameters globalMultiBodyJointParameters, btMultiBody btMultiBody2, JointBasics jointBasics, boolean hasBaseCollider) {
        for (JointBasics childJoint : jointBasics.getSuccessor().getChildrenJoints()) {
            BulletMultiBodyRobotFactoryTest.assertJointAndLinkEqual(robot, bulletMultiBodyRobot, globalMultiBodyJointParameters, btMultiBody2, childJoint, hasBaseCollider);
            BulletMultiBodyRobotFactoryTest.testChildJoints(robot, bulletMultiBodyRobot, globalMultiBodyJointParameters, btMultiBody2, childJoint, hasBaseCollider);
        }
    }

    private static void assertJointAndLinkEqual(Robot robot, BulletMultiBodyRobot bulletMultiBodyRobot, YoBulletMultiBodyJointParameters globalMultiBodyJointParameters, btMultiBody btMultiBody2, JointBasics jointBasics, boolean hasBaseCollider) {
        int index = (Integer)bulletMultiBodyRobot.getJointNameToBulletJointIndexMap().get(jointBasics.getName());
        btMultiBodyLinkCollider linkCollider = btMultiBody2.getLinkCollider(index);
        Assertions.assertEquals((float)linkCollider.getFriction(), (float)((float)globalMultiBodyJointParameters.getJointFriction()));
        Assertions.assertEquals((float)linkCollider.getRestitution(), (float)((float)globalMultiBodyJointParameters.getJointRestitution()));
        Assertions.assertEquals((float)linkCollider.getHitFraction(), (float)((float)globalMultiBodyJointParameters.getJointHitFraction()));
        Assertions.assertEquals((float)linkCollider.getRollingFriction(), (float)((float)globalMultiBodyJointParameters.getJointRollingFriction()));
        Assertions.assertEquals((float)linkCollider.getSpinningFriction(), (float)((float)globalMultiBodyJointParameters.getJointSpinningFriction()));
        Assertions.assertEquals((float)linkCollider.getContactProcessingThreshold(), (float)((float)globalMultiBodyJointParameters.getJointContactProcessingThreshold()));
        Assertions.assertEquals((int)btMultiBody2.getLink(index).getFlags(), (int)(globalMultiBodyJointParameters.getJointDisableParentCollision() ? 1 : 0));
        JointDefinition jointDefinition = robot.getRobotDefinition().getJointDefinition(jointBasics.getName());
        RigidBodyDefinition jointRigidBodyDefinition = jointDefinition.getSuccessor();
        btMultiBodyLinkCollider btMultiBodyLinkCollider2 = bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(index + (hasBaseCollider ? 1 : 0)).getBtMultiBodyLinkCollider();
        List collisionShapes = jointRigidBodyDefinition.getCollisionShapeDefinitions();
        btCompoundShape compoundShape = (btCompoundShape)btMultiBodyLinkCollider2.getCollisionShape();
        MovingReferenceFrame linkCenterOfMassFrame = jointBasics.getSuccessor().getBodyFixedFrame();
        BulletMultiBodyRobotFactoryTest.assertCollisionShapesSame(collisionShapes, compoundShape, (ReferenceFrame)linkCenterOfMassFrame);
        Assertions.assertEquals((float)((float)jointRigidBodyDefinition.getMass()), (float)btMultiBody2.getLinkMass(index));
        OneDoFJointDefinition oneDoFJointDefinition = (OneDoFJointDefinition)jointDefinition;
        Vector3D jointAxis = oneDoFJointDefinition.getAxis();
        btMultibodyLink link = btMultiBody2.getLink(index);
        Quaternion euclidRotationFromParent = new Quaternion((Orientation3DReadOnly)jointDefinition.getTransformToParent().getRotation());
        euclidRotationFromParent.invert();
        BulletMultiBodyRobotFactoryTest.assertQuaternionEqualsBtQuaternion(euclidRotationFromParent, link.getZeroRotParentToThis());
        jointBasics.getPredecessor().getBodyFixedFrame().getTransformToDesiredFrame(parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid, (ReferenceFrame)jointBasics.getFrameBeforeJoint());
        parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid.invert();
        BulletMultiBodyRobotFactoryTest.assertVector3DBasicsEqualsBtVector3(parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid.getTranslation(), link.getEVector());
        jointBasics.getFrameAfterJoint().getTransformToDesiredFrame(parentJointAfterFrameToLinkCenterOfMassTransformEuclid, (ReferenceFrame)jointBasics.getSuccessor().getBodyFixedFrame());
        parentJointAfterFrameToLinkCenterOfMassTransformEuclid.invert();
        BulletMultiBodyRobotFactoryTest.assertVector3DBasicsEqualsBtVector3(parentJointAfterFrameToLinkCenterOfMassTransformEuclid.getTranslation(), link.getDVector());
        if (jointBasics instanceof SimRevoluteJoint) {
            Vector3 linkAxis = link.getAxisTop(0);
            BulletMultiBodyRobotFactoryTest.assertVector3DEqualsVector3(jointAxis, linkAxis);
            Assertions.assertEquals((int)link.getJointType(), (int)0);
        } else if (jointBasics instanceof SimPrismaticJoint) {
            Vector3 linkAxis = link.getAxisBottom(0);
            BulletMultiBodyRobotFactoryTest.assertVector3DEqualsVector3(jointAxis, linkAxis);
        }
    }

    private static int countJointsAndCreateIndexMap(JointBasics joint) {
        int numberOfJoints = 1;
        for (JointBasics childrenJoint : joint.getSuccessor().getChildrenJoints()) {
            numberOfJoints += BulletMultiBodyRobotFactoryTest.countJointsAndCreateIndexMap(childrenJoint);
        }
        return numberOfJoints;
    }

    private static void assertMatrix4EqualsRigidBodyTransform(String name, Matrix4 bulletCollisionShapeLocalTransform, RigidBodyTransform rigidBodyTransform) {
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[0], (double)rigidBodyTransform.getM00(), (double)1.0E-5, (String)(name + " - M00 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[4], (double)rigidBodyTransform.getM01(), (double)1.0E-5, (String)(name + " - M01 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[8], (double)rigidBodyTransform.getM02(), (double)1.0E-5, (String)(name + " - M02 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[12], (double)rigidBodyTransform.getM03(), (double)1.0E-5, (String)(name + " - M03 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[1], (double)rigidBodyTransform.getM10(), (double)1.0E-5, (String)(name + " - M10 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[5], (double)rigidBodyTransform.getM11(), (double)1.0E-5, (String)(name + " - M11 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[9], (double)rigidBodyTransform.getM12(), (double)1.0E-5, (String)(name + " - M12 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[13], (double)rigidBodyTransform.getM13(), (double)1.0E-5, (String)(name + " - M13 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[2], (double)rigidBodyTransform.getM20(), (double)1.0E-5, (String)(name + " - M20 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[6], (double)rigidBodyTransform.getM21(), (double)1.0E-5, (String)(name + " - M21 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[10], (double)rigidBodyTransform.getM22(), (double)1.0E-5, (String)(name + " - M22 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[14], (double)rigidBodyTransform.getM23(), (double)1.0E-5, (String)(name + " - M23 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[3], (double)rigidBodyTransform.getM30(), (double)1.0E-5, (String)(name + " - M30 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[7], (double)rigidBodyTransform.getM31(), (double)1.0E-5, (String)(name + " - M31 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[11], (double)rigidBodyTransform.getM32(), (double)1.0E-5, (String)(name + " - M32 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.val[15], (double)rigidBodyTransform.getM33(), (double)1.0E-5, (String)(name + " - M33 is not as expected"));
    }

    private static void assertQuaternionEqualsBtQuaternion(Quaternion quaterion, btQuaternion btQuaternion2) {
        Assertions.assertEquals((double)((float)quaterion.getX()), (double)btQuaternion2.getX(), (double)1.0E-5);
        Assertions.assertEquals((double)((float)quaterion.getY()), (double)btQuaternion2.getY(), (double)1.0E-5);
        Assertions.assertEquals((double)((float)quaterion.getZ()), (double)btQuaternion2.getZ(), (double)1.0E-5);
        Assertions.assertEquals((double)((float)quaterion.getS()), (double)btQuaternion2.getW(), (double)1.0E-5);
    }

    private static void assertVector3DEqualsVector3(Vector3D vector3D, Vector3 vector3) {
        Assertions.assertEquals((float)vector3D.getX32(), (float)vector3.x);
        Assertions.assertEquals((float)vector3D.getY32(), (float)vector3.y);
        Assertions.assertEquals((float)vector3D.getZ32(), (float)vector3.z);
    }

    private static void assertVector3DBasicsEqualsBtVector3(Vector3DBasics vector3DBasics, btVector3 btVector32) {
        Assertions.assertEquals((float)vector3DBasics.getX32(), (float)btVector32.getX());
        Assertions.assertEquals((float)vector3DBasics.getY32(), (float)btVector32.getY());
        Assertions.assertEquals((float)vector3DBasics.getZ32(), (float)btVector32.getZ());
    }

    private static void assertCollisionShapesSame(List<CollisionShapeDefinition> collisionShapes, btCompoundShape compoundShape, ReferenceFrame linkCenterOfMassFrame) {
        for (int j = 0; j < collisionShapes.size(); ++j) {
            int shapeType = switch (collisionShapes.get(j).getGeometryDefinition().getName()) {
                case "sphere" -> 8;
                case "cylinder" -> 13;
                case "box" -> 0;
                case "cone" -> 11;
                case "capsule" -> 10;
                default -> 9999;
            };
            if (shapeType == 8) {
                Sphere3DDefinition sphereShape = (Sphere3DDefinition)collisionShapes.get(j).getGeometryDefinition();
                btSphereShape btSphereShape2 = (btSphereShape)compoundShape.getChildShape(j);
                Assertions.assertEquals((float)((float)sphereShape.getRadius()), (float)btSphereShape2.getRadius());
            } else if (shapeType == 13) {
                Cylinder3DDefinition cylinderShape = (Cylinder3DDefinition)collisionShapes.get(j).getGeometryDefinition();
                btCylinderShape btCylinderShape2 = (btCylinderShape)compoundShape.getChildShape(j);
                Assertions.assertEquals((double)((float)cylinderShape.getRadius()), (double)btCylinderShape2.getRadius(), (double)1.0E-5);
                Assertions.assertEquals((double)btCylinderShape2.getHalfExtentsWithMargin().z, (double)((float)cylinderShape.getLength() / 2.0f), (double)1.0E-5);
            } else if (shapeType == 0) {
                Box3DDefinition boxShape = (Box3DDefinition)collisionShapes.get(j).getGeometryDefinition();
                btBoxShape btBoxShape2 = (btBoxShape)compoundShape.getChildShape(j);
                for (int k = 0; k < btBoxShape2.getNumEdges(); ++k) {
                    btBoxShape2.getVertex(j, boxVertex);
                    Assertions.assertEquals((double)Math.abs(BulletMultiBodyRobotFactoryTest.boxVertex.x), (double)((float)boxShape.getSizeX() / 2.0f), (double)1.0E-5);
                    Assertions.assertEquals((double)Math.abs(BulletMultiBodyRobotFactoryTest.boxVertex.y), (double)((float)boxShape.getSizeY() / 2.0f), (double)1.0E-5);
                    Assertions.assertEquals((double)Math.abs(BulletMultiBodyRobotFactoryTest.boxVertex.z), (double)((float)boxShape.getSizeZ() / 2.0f), (double)1.0E-5);
                }
            } else if (shapeType == 11) {
                Cone3DDefinition coneShape = (Cone3DDefinition)collisionShapes.get(j).getGeometryDefinition();
                btConeShapeZ btConeShape = (btConeShapeZ)compoundShape.getChildShape(j);
                Assertions.assertEquals((double)btConeShape.getRadius(), (double)((float)coneShape.getRadius()), (double)1.0E-5);
                Assertions.assertEquals((double)btConeShape.getHeight(), (double)((float)coneShape.getHeight()), (double)1.0E-5);
            } else if (shapeType == 10) {
                Capsule3DDefinition capsuleShape = (Capsule3DDefinition)collisionShapes.get(j).getGeometryDefinition();
                btCapsuleShapeZ btCapsuleShapeZ2 = (btCapsuleShapeZ)compoundShape.getChildShape(j);
                Assertions.assertEquals((double)btCapsuleShapeZ2.getRadius(), (double)((float)capsuleShape.getRadiusX()), (double)1.0E-5);
                Assertions.assertEquals((double)btCapsuleShapeZ2.getRadius(), (double)((float)capsuleShape.getRadiusY()), (double)1.0E-5);
                Assertions.assertEquals((double)btCapsuleShapeZ2.getRadius(), (double)((float)capsuleShape.getRadiusZ()), (double)1.0E-5);
                Assertions.assertEquals((double)btCapsuleShapeZ2.getHalfHeight(), (double)((float)capsuleShape.getLength() / 2.0f), (double)1.0E-5);
            }
            compoundShapeChildTransform = compoundShape.getChildTransform(j);
            collisionShapeRigidBodyTransform.setAndInvert((RigidBodyTransformReadOnly)linkCenterOfMassFrame.getTransformToParent());
            collisionShapeRigidBodyTransform.multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)collisionShapes.get(j).getOriginPose().getRotation(), (Tuple3DReadOnly)collisionShapes.get(j).getOriginPose().getTranslation()));
            BulletMultiBodyRobotFactoryTest.assertMatrix4EqualsRigidBodyTransform(collisionShapes.get(j).getName(), compoundShapeChildTransform, collisionShapeRigidBodyTransform);
            Assertions.assertEquals((int)compoundShape.getChildShape(j).getShapeType(), (int)shapeType);
        }
    }

    private static Robot createRobotToTestLocalTransform(String name, YawPitchRollTransformDefinition inertiaPose, YawPitchRollTransformDefinition collisionShapePose) {
        double boxLength = 0.1;
        RobotDefinition boxRobot = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(name + "RigidBody");
        rigidBody.getInertiaPose().set((RigidBodyTransformReadOnly)collisionShapePose);
        rootJoint.setSuccessor(rigidBody);
        boxRobot.setRootBodyDefinition(rootBody);
        CollisionShapeDefinition collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition(boxLength, boxLength, boxLength));
        collisionShapeDefinition.getOriginPose().set((RigidBodyTransformReadOnly)inertiaPose);
        boxRobot.getRigidBodyDefinition(name + "RigidBody").addCollisionShapeDefinition(collisionShapeDefinition);
        return new Robot(boxRobot, ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
    }

    private static Robot createTestRobotWithKnownValues() {
        String name = "TestRobot";
        RobotDefinition testRobot = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name + "RootJoint");
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition rigidBodyDefinition = new RigidBodyDefinition(name + "RigidBody");
        MomentOfInertiaDefinition momentOfInertiaRigidBody = new MomentOfInertiaDefinition();
        momentOfInertiaRigidBody.set(0.125568, 8.0E-4, -5.00733E-4, 8.0E-4, 0.0972042, -5.0E-4, -5.00733E-4, -5.0E-4, 0.117936);
        rigidBodyDefinition.setMass(9.609);
        rigidBodyDefinition.setMomentOfInertia(momentOfInertiaRigidBody);
        rigidBodyDefinition.getInertiaPose().setOrientation(0.0, -0.0, 0.0);
        rigidBodyDefinition.getInertiaPose().getTranslation().set(0.012, 0.0, 0.027);
        CollisionShapeDefinition collisionShapeDefinition1 = new CollisionShapeDefinition(new YawPitchRollTransformDefinition(0.046, 0.0, 0.01, 0.0, -0.0, 1.571), (GeometryDefinition)new Cylinder3DDefinition(0.06, 0.11));
        collisionShapeDefinition1.setCollisionGroup(899L);
        collisionShapeDefinition1.setCollisionMask(64L);
        rigidBodyDefinition.addCollisionShapeDefinition(collisionShapeDefinition1);
        CollisionShapeDefinition collisionShapeDefinition2 = new CollisionShapeDefinition(new YawPitchRollTransformDefinition(-0.03, 0.0, 0.01, 0.0, -0.0, 1.571), (GeometryDefinition)new Cylinder3DDefinition(0.04, 0.12));
        collisionShapeDefinition1.setCollisionGroup(899L);
        collisionShapeDefinition1.setCollisionMask(64L);
        rigidBodyDefinition.addCollisionShapeDefinition(collisionShapeDefinition2);
        CollisionShapeDefinition collisionShapeDefinition3 = new CollisionShapeDefinition(new YawPitchRollTransformDefinition(0.01, 0.042, 0.09, 0.0, -0.0, 0.0), (GeometryDefinition)new Cylinder3DDefinition(0.05, 0.16));
        collisionShapeDefinition1.setCollisionGroup(899L);
        collisionShapeDefinition1.setCollisionMask(64L);
        rigidBodyDefinition.addCollisionShapeDefinition(collisionShapeDefinition3);
        RevoluteJointDefinition revoluteJointDefinition = new RevoluteJointDefinition("RevoluteJoint");
        revoluteJointDefinition.setAxis((Vector3DReadOnly)Axis3D.Z);
        TransformToParent.setTranslation(-0.013, 0.0, 0.0);
        TransformToParent.setOrientation(0.0, 0.0, 0.0);
        revoluteJointDefinition.setTransformToParent(TransformToParent);
        RigidBodyDefinition jointRigidBodyDefinition = new RigidBodyDefinition(name + "RevoluteJointBody");
        MomentOfInertiaDefinition momentOfInertiaJoint = new MomentOfInertiaDefinition();
        momentOfInertiaJoint.set(0.0039092, -5.04491E-8, -3.42157E-4, -5.04491E-8, 0.00341694, 4.87119E-7, -3.42157E-4, 4.87119E-7, 0.00174492);
        jointRigidBodyDefinition.setMass(2.27);
        jointRigidBodyDefinition.setMomentOfInertia(momentOfInertiaJoint);
        jointRigidBodyDefinition.getInertiaPose().setOrientation(0.0, 0.0, 0.0);
        jointRigidBodyDefinition.getInertiaPose().getTranslation().set(-0.0112984, -3.15366E-6, 0.0746835);
        CollisionShapeDefinition jointCollisionShapeDefinition = new CollisionShapeDefinition(new YawPitchRollTransformDefinition(0.0, 0.0, -0.02, 0.0, 0.0, 0.0), (GeometryDefinition)new Box3DDefinition(0.03, 0.04, 0.02));
        jointCollisionShapeDefinition.setCollisionGroup(3L);
        jointCollisionShapeDefinition.setCollisionMask(1L);
        jointRigidBodyDefinition.addCollisionShapeDefinition(jointCollisionShapeDefinition);
        revoluteJointDefinition.setSuccessor(jointRigidBodyDefinition);
        rigidBodyDefinition.addChildJoint((JointDefinition)revoluteJointDefinition);
        rootJoint.setSuccessor(rigidBodyDefinition);
        testRobot.setRootBodyDefinition(rootBody);
        return new Robot(testRobot, ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
    }

    private static Robot createTestRobotWithoutBaseCollider(Random random, String name) {
        RobotDefinition robotDefinition = new RobotDefinition(name + "RootBody");
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RigidBody");
        int numberOfJoints = random.nextInt(10) + 1;
        OneDoFJointDefinition[] joints = new OneDoFJointDefinition[numberOfJoints];
        RigidBodyDefinition[] jointBodies = new RigidBodyDefinition[numberOfJoints];
        for (int i = 0; i < numberOfJoints; ++i) {
            int jointType = random.nextInt(2);
            switch (jointType) {
                case 0: {
                    joints[i] = new RevoluteJointDefinition(name + "Joint" + i);
                    break;
                }
                case 1: {
                    joints[i] = new PrismaticJointDefinition(name + "Joint" + i);
                    break;
                }
            }
            joints[i].setAxis(new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble()));
            TransformToParent.setTranslation(random.nextDouble(), random.nextDouble(), random.nextDouble());
            TransformToParent.setOrientation(random.nextDouble(), random.nextDouble(), random.nextDouble());
            joints[i].setTransformToParent(TransformToParent);
            jointBodies[i] = BulletMultiBodyRobotFactoryTest.createRandomShape(name + "JointBody" + i, random);
            joints[i].setSuccessor(jointBodies[i]);
            double lowerLimit = random.nextDouble();
            double upperLimit = lowerLimit + random.nextDouble();
            joints[i].setPositionLowerLimit(lowerLimit);
            joints[i].setPositionUpperLimit(upperLimit);
            if (i == 0) {
                joints[i].getTransformToParent().getTranslation().set(new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble()));
                rootBody.addChildJoint((JointDefinition)joints[i]);
                continue;
            }
            jointBodies[i - 1].addChildJoint((JointDefinition)joints[i]);
        }
        robotDefinition.setRootBodyDefinition(rootBody);
        return new Robot(robotDefinition, ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
    }

    private static Robot createTestRobotWithBaseCollider(Random random, String name) {
        RobotDefinition robotDefinition = new RobotDefinition(name + "RootBody");
        RigidBodyDefinition rootBodyDefinition = new RigidBodyDefinition(name + "RigidBody");
        SixDoFJointDefinition rootJointDefinition = new SixDoFJointDefinition("rootJoint");
        rootBodyDefinition.addChildJoint((JointDefinition)rootJointDefinition);
        TransformToParent.setTranslation(random.nextDouble(), random.nextDouble(), random.nextDouble());
        TransformToParent.setOrientation(random.nextDouble(), random.nextDouble(), random.nextDouble());
        SixDoFJointState initialRootJointState = new SixDoFJointState((Orientation3DReadOnly)TransformToParent.getRotation(), (Tuple3DReadOnly)TransformToParent.getTranslation());
        rootJointDefinition.setInitialJointState(initialRootJointState);
        OneDoFJointState initialPinJointState = new OneDoFJointState();
        initialPinJointState.setEffort(random.nextDouble());
        RigidBodyDefinition rootJointRigidBodyDefinition = BulletMultiBodyRobotFactoryTest.createRandomShape(name + "RootJointBody", random);
        rootJointDefinition.setSuccessor(rootJointRigidBodyDefinition);
        int numberOfJoints = random.nextInt(10) + 1;
        OneDoFJointDefinition[] joints = new OneDoFJointDefinition[numberOfJoints];
        RigidBodyDefinition[] jointBodies = new RigidBodyDefinition[numberOfJoints];
        for (int i = 0; i < numberOfJoints; ++i) {
            int jointType = random.nextInt(2);
            switch (jointType) {
                case 0: {
                    joints[i] = new RevoluteJointDefinition(name + "Joint" + i);
                    break;
                }
                case 1: {
                    joints[i] = new PrismaticJointDefinition(name + "Joint" + i);
                    break;
                }
            }
            joints[i].setAxis(new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble()));
            TransformToParent.setTranslation(random.nextDouble(), random.nextDouble(), random.nextDouble());
            TransformToParent.setOrientation(random.nextDouble(), random.nextDouble(), random.nextDouble());
            joints[i].setTransformToParent(TransformToParent);
            jointBodies[i] = BulletMultiBodyRobotFactoryTest.createRandomShape(name + "JointBody" + i, random);
            joints[i].setSuccessor(jointBodies[i]);
            double lowerLimit = random.nextDouble();
            double upperLimit = lowerLimit + random.nextDouble();
            joints[i].setPositionLowerLimit(lowerLimit);
            joints[i].setPositionUpperLimit(upperLimit);
            if (i == 0) {
                joints[i].getTransformToParent().getTranslation().set(new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble()));
                joints[i].setInitialJointState(initialPinJointState);
                rootJointRigidBodyDefinition.addChildJoint((JointDefinition)joints[i]);
                continue;
            }
            jointBodies[i - 1].addChildJoint((JointDefinition)joints[i]);
        }
        robotDefinition.setRootBodyDefinition(rootBodyDefinition);
        return new Robot(robotDefinition, ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
    }

    private static RigidBodyDefinition createRandomShape(String name, Random random) {
        RigidBodyDefinition rigidBodyDefinition = new RigidBodyDefinition(name);
        rigidBodyDefinition.setMass(random.nextDouble());
        rigidBodyDefinition.getMomentOfInertia().setToDiagonal(random.nextDouble(), random.nextDouble(), random.nextDouble());
        rigidBodyDefinition.getInertiaPose().getTranslation().set(random.nextDouble(), random.nextDouble(), random.nextDouble());
        int shapeSelection = random.nextInt(5);
        CollisionShapeDefinition collisionShapeDefinition = new CollisionShapeDefinition(rigidBodyDefinition.getInertiaPose(), (GeometryDefinition)(switch (shapeSelection) {
            case 0 -> new Sphere3DDefinition(random.nextDouble());
            case 1 -> new Cylinder3DDefinition(random.nextDouble(), random.nextDouble());
            case 2 -> new Box3DDefinition(random.nextDouble(), random.nextDouble(), random.nextDouble());
            case 3 -> new Cone3DDefinition(random.nextDouble(), random.nextDouble());
            default -> new Capsule3DDefinition(random.nextDouble(), random.nextDouble());
        }));
        rigidBodyDefinition.addCollisionShapeDefinition(collisionShapeDefinition);
        return rigidBodyDefinition;
    }

    static {
        Bullet.init();
        LogTools.info((String)"Loaded Bullet version {}", (Object)LinearMath.btGetVersion());
        collisionShapeRigidBodyTransform = new RigidBodyTransform();
        compoundShapeChildTransform = new Matrix4();
        boxVertex = new Vector3();
        TransformToParent = new YawPitchRollTransformDefinition();
        parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid = new RigidBodyTransform();
        parentJointAfterFrameToLinkCenterOfMassTransformEuclid = new RigidBodyTransform();
    }
}

