/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.MomentOfInertiaDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.simulation.SimulationEnergyStatistics;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.TimeConsumer;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.variable.YoDouble;

public class BulletFlyingBallSimulationTest {
    private static final double EPSILON = 0.01;
    private static final boolean BULLET_PHYSICS_ENGINE = true;
    private static final boolean VISUALIZE = false;
    private static final int numberOfSimulationTicks = 1000;
    private YoPoint3D expectedPosition;
    private SimFloatingRootJoint floatingRootJoint;
    private YoDouble orbitalEnergyVariable;

    public SimulationSession createSession() {
        Point3D initialPosition = new Point3D(0.0, 0.0, 0.0);
        Vector3D initialVelocity = new Vector3D(0.0, 0.0, 0.0);
        double dt = 0.01;
        double ballRadius = 0.2;
        double ballMass = 2.0;
        String name = "sphere";
        RobotDefinition sphereRobot = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(name + "RigidBody");
        rigidBody.setMass(ballMass);
        rigidBody.setMomentOfInertia(new MomentOfInertiaDefinition(0.1, 0.1, 0.1));
        rigidBody.addVisualDefinition(new VisualDefinition((GeometryDefinition)new Sphere3DDefinition(0.05), new MaterialDefinition(null, ColorDefinitions.Brown(), ColorDefinitions.LightGray(), null, 10.0)));
        rootJoint.setSuccessor(rigidBody);
        sphereRobot.setRootBodyDefinition(rootBody);
        sphereRobot.getRigidBodyDefinition(name + "RigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Sphere3DDefinition(ballRadius)));
        SixDoFJointState sphereInitialState = new SixDoFJointState();
        sphereInitialState.setConfiguration(null, (Tuple3DReadOnly)initialPosition);
        sphereInitialState.setVelocity(null, (Vector3DReadOnly)initialVelocity);
        ((JointDefinition)sphereRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)sphereInitialState);
        SimulationSession simulationSession = null;
        BulletMultiBodyParameters bulletMultiBodyParameters = BulletMultiBodyParameters.defaultBulletMultiBodyParameters();
        bulletMultiBodyParameters.setLinearDamping(0.0);
        bulletMultiBodyParameters.setMaxCoordinateVelocity(1.0E7);
        bulletMultiBodyParameters.setUseRK4Integration(true);
        BulletMultiBodyJointParameters bulletMultiBodyJointParameter = BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters();
        simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory((BulletMultiBodyParameters)bulletMultiBodyParameters, (BulletMultiBodyJointParameters)bulletMultiBodyJointParameter));
        simulationSession.addRobot(sphereRobot);
        simulationSession.setSessionDTSeconds(dt);
        simulationSession.initializeBufferSize(2000);
        SimulationEnergyStatistics.setupSimulationEnergyStatistics((SimulationSession)simulationSession);
        this.expectedPosition = new YoPoint3D("expectedSpherePosition", simulationSession.getRootRegistry());
        YoFrameVector3D gravity = simulationSession.getGravity();
        this.floatingRootJoint = (SimFloatingRootJoint)((Robot)simulationSession.getPhysicsEngine().getRobots().get(0)).getJoint(name);
        this.orbitalEnergyVariable = (YoDouble)simulationSession.getRootRegistry().findVariable(name + "OrbitalEnergy");
        simulationSession.addAfterPhysicsCallback(arg_0 -> this.lambda$createSession$0(initialPosition, initialVelocity, (FrameVector3DReadOnly)gravity, arg_0));
        return simulationSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlyingBall() throws Throwable {
        SimulationSession simulationSession = this.createSession();
        simulationSession.addAfterPhysicsCallback(new TimeConsumer(){
            double initialOrbitalEnergy = 0.0;

            public void accept(double time) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)BulletFlyingBallSimulationTest.this.expectedPosition, (EuclidGeometry)BulletFlyingBallSimulationTest.this.floatingRootJoint.getJointPose().getPosition(), (double)0.01);
                if (this.initialOrbitalEnergy == 0.0) {
                    this.initialOrbitalEnergy = BulletFlyingBallSimulationTest.this.orbitalEnergyVariable.getValue();
                }
                Assertions.assertEquals((double)this.initialOrbitalEnergy, (double)BulletFlyingBallSimulationTest.this.orbitalEnergyVariable.getValue(), (double)0.1, (String)("Orbital Energy failed at time = " + time));
            }
        });
        MutableObject caughtException = new MutableObject(null);
        simulationSession.addRunThrowableListener(t -> caughtException.setValue(t));
        Object visualizerControls = null;
        simulationSession.getSimulationSessionControls().simulateNow(1000L);
        if (caughtException.getValue() != null) {
            throw (Throwable)caughtException.getValue();
        }
        simulationSession.shutdownSession();
    }

    private static Vector3D heightAfterSeconds(Point3D initialPosition, Vector3D initialVelocity, double seconds, double gravity) {
        Vector3D height = new Vector3D();
        height.setX(initialVelocity.getX() * seconds + initialPosition.getX());
        height.setY(initialVelocity.getY() * seconds + initialPosition.getY());
        height.setZ(0.5 * gravity * seconds * seconds + initialVelocity.getZ() * seconds + initialPosition.getZ());
        return height;
    }

    private /* synthetic */ void lambda$createSession$0(Point3D initialPosition, Vector3D initialVelocity, FrameVector3DReadOnly gravity, double time) {
        this.expectedPosition.set((Tuple3DReadOnly)BulletFlyingBallSimulationTest.heightAfterSeconds(initialPosition, initialVelocity, time, gravity.getZ()));
    }
}

