/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.MomentOfInertiaDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletContactSolverInfoParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;

public class BulletCoefficientOfRestitutionTest {
    private static final int ITERATIONS = 100;
    private static final int NUMBER_OF_TRIES = 1000;
    private static final boolean BULLET_PHYSICS_ENGINE = true;
    private static final double EPSILON = 0.001;
    private static final double DT = 0.1;
    private static final String BALL_NAME1 = "ball1";
    private static final String BALL_NAME2 = "ball2";
    private static final MomentOfInertiaDefinition MOMENT_OF_INERTIA = new MomentOfInertiaDefinition(0.1, 0.1, 0.1);
    private static final double BALL_RADIUS1 = 0.4;
    private static final double BALL_RADIUS2 = 0.2;
    private static final double BALL_MASS1 = 2.0;
    private static final double BALL_MASS2 = 2.0;
    private static Vector3D initialVelocity1 = new Vector3D();
    private static Vector3D initialVelocity2 = new Vector3D();
    private static Vector3D finalVelocity1 = new Vector3D();
    private static Vector3D finalVelocity2 = new Vector3D();
    private static Vector3D differenceInitialVelocity = new Vector3D();
    private static Vector3D differenceFinalVelocity = new Vector3D();
    private static Point3D initialPosition1 = new Point3D();
    private static Point3D initialPosition2 = new Point3D();

    @Test
    public void testFlyingCollidingSpheres() {
        int i;
        Random random = new Random(1254257L);
        BulletCoefficientOfRestitutionTest.testCoefficientOfRestitution(0.0, random, true);
        BulletCoefficientOfRestitutionTest.testCoefficientOfRestitution(1.0, random, true);
        BulletCoefficientOfRestitutionTest.testCoefficientOfRestitution(0.0, random, false);
        BulletCoefficientOfRestitutionTest.testCoefficientOfRestitution(1.0, random, false);
        for (i = 0; i <= 100; ++i) {
            BulletCoefficientOfRestitutionTest.testCoefficientOfRestitution(random.nextDouble(), random, true);
        }
        for (i = 0; i <= 100; ++i) {
            BulletCoefficientOfRestitutionTest.testCoefficientOfRestitution(random.nextDouble(), random, false);
        }
    }

    private static void testCoefficientOfRestitution(double coefficientOfRestitution, Random random, boolean testHeadOnCollision) {
        double x1 = random.nextDouble();
        double y1 = random.nextDouble();
        double z1 = random.nextDouble();
        double x2 = random.nextDouble() + 2.0 * (x1 + 0.4 + 0.2);
        double y2 = random.nextDouble() + 2.0 * (y1 + 0.4 + 0.2);
        double z2 = random.nextDouble() + 2.0 * (z1 + 0.4 + 0.2);
        initialPosition1.set(x1, y1, z1);
        initialPosition2.set(x2, y2, z2);
        if (testHeadOnCollision) {
            initialVelocity1.sub((Tuple3DReadOnly)initialPosition2, (Tuple3DReadOnly)initialPosition1);
            initialVelocity1.scale(random.nextDouble());
            initialVelocity2.sub((Tuple3DReadOnly)initialPosition1, (Tuple3DReadOnly)initialPosition2);
            initialVelocity2.scale(random.nextDouble());
        } else {
            initialVelocity1.sub((Tuple3DReadOnly)initialPosition2, (Tuple3DReadOnly)initialPosition1);
            initialVelocity2.set(initialVelocity1);
            initialVelocity2.scale(0.2);
        }
        RobotDefinition sphereRobot1 = BulletCoefficientOfRestitutionTest.createSphereRobot(0.4, 2.0, BALL_NAME1, MOMENT_OF_INERTIA, initialPosition1, initialVelocity1);
        RobotDefinition sphereRobot2 = BulletCoefficientOfRestitutionTest.createSphereRobot(0.2, 2.0, BALL_NAME2, MOMENT_OF_INERTIA, initialPosition2, initialVelocity2);
        SimulationSession simulationSession = null;
        BulletMultiBodyParameters bulletMultiBodyParameters = BulletMultiBodyParameters.defaultBulletMultiBodyParameters();
        BulletMultiBodyJointParameters bulletMultiBodyJointParameters = BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters();
        BulletContactSolverInfoParameters bulletContactSolverInfoParameters = BulletContactSolverInfoParameters.defaultBulletContactSolverInfoParameters();
        bulletMultiBodyParameters.setLinearDamping(0.0);
        bulletMultiBodyParameters.setAngularDamping(0.0);
        bulletMultiBodyJointParameters.setJointRestitution(coefficientOfRestitution);
        bulletContactSolverInfoParameters.setSplitImpulse(1);
        bulletContactSolverInfoParameters.setSplitImpulseTurnErp(1.0);
        bulletContactSolverInfoParameters.setSplitImpulsePenetrationThreshold(-1.0E-7);
        bulletContactSolverInfoParameters.setErrorReductionForNonContactConstraints(0.0);
        bulletContactSolverInfoParameters.setErrorReductionForContactConstraints(0.0);
        simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory((BulletMultiBodyParameters)bulletMultiBodyParameters, (BulletMultiBodyJointParameters)bulletMultiBodyJointParameters, (BulletContactSolverInfoParameters)bulletContactSolverInfoParameters));
        simulationSession.addRobot(sphereRobot1);
        simulationSession.addRobot(sphereRobot2);
        simulationSession.setSessionDTSeconds(0.1);
        simulationSession.setGravity(0.0, 0.0, 0.0);
        SimFloatingRootJoint floatingRootJoint1 = (SimFloatingRootJoint)((Robot)simulationSession.getPhysicsEngine().getRobots().get(0)).getAllJoints().get(0);
        SimFloatingRootJoint floatingRootJoint2 = (SimFloatingRootJoint)((Robot)simulationSession.getPhysicsEngine().getRobots().get(1)).getAllJoints().get(0);
        finalVelocity1.set(initialVelocity1);
        finalVelocity2.set(initialVelocity2);
        for (int j = 0; j < 1000 && initialVelocity1.epsilonEquals((EuclidGeometry)finalVelocity1, 0.001); ++j) {
            simulationSession.runTick();
            finalVelocity1.set((Tuple3DReadOnly)floatingRootJoint1.getSuccessor().getBodyFixedFrame().getTwistOfFrame().getLinearPart());
            finalVelocity2.set((Tuple3DReadOnly)floatingRootJoint2.getSuccessor().getBodyFixedFrame().getTwistOfFrame().getLinearPart());
        }
        if (!initialVelocity1.epsilonEquals((EuclidGeometry)finalVelocity1, 0.001)) {
            differenceInitialVelocity.set(initialVelocity1);
            differenceInitialVelocity.sub((Tuple3DReadOnly)initialVelocity2);
            differenceFinalVelocity.set(finalVelocity1);
            differenceFinalVelocity.sub((Tuple3DReadOnly)finalVelocity2);
            double calculatedCoefficientOfRestitution = differenceFinalVelocity.norm() / differenceInitialVelocity.norm();
            Assertions.assertEquals((double)(coefficientOfRestitution * coefficientOfRestitution), (double)calculatedCoefficientOfRestitution, (double)0.001);
        } else {
            System.out.println("No Collision");
        }
        simulationSession.shutdownSession();
    }

    private static RobotDefinition createSphereRobot(double radius, double mass, String name, MomentOfInertiaDefinition momentOfInertia, Point3D initialPosition, Vector3D initialVelocity) {
        RobotDefinition sphereRobot = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(name + "RigidBody");
        rigidBody.setMass(mass);
        rigidBody.setMomentOfInertia(momentOfInertia);
        rootJoint.setSuccessor(rigidBody);
        sphereRobot.setRootBodyDefinition(rootBody);
        CollisionShapeDefinition collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)new Sphere3DDefinition(radius));
        sphereRobot.getRigidBodyDefinition(name + "RigidBody").addCollisionShapeDefinition(collisionShapeDefinition);
        SixDoFJointState sphereInitialState = new SixDoFJointState();
        sphereInitialState.setConfiguration(null, (Tuple3DReadOnly)initialPosition);
        sphereInitialState.setVelocity(null, (Vector3DReadOnly)initialVelocity);
        ((JointDefinition)sphereRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)sphereInitialState);
        return sphereRobot;
    }
}

