/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.physics.bullet.collision.btBoxShape;
import com.badlogic.gdx.physics.bullet.collision.btCapsuleShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btConeShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btCylinderShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btSphereShape;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMath;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.Ellipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;

public class BulletToolsTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-5;
    private final Matrix4 bulletAffineToPack = new Matrix4();
    private final RigidBodyTransform rigidBodyTransformToPack = new RigidBodyTransform();
    private final Vector3 translation = new Vector3();
    private final Matrix4 bulletAffine = new Matrix4();
    private final Vector3 vector1 = new Vector3();
    private final Vector3 vector2 = new Vector3();
    private final Quaternion bulletQuaternion = new Quaternion();
    private final Vector3DBasics euclidVector3D32 = new Vector3D();
    private final Point3DBasics euclidPoint3D32 = new Point3D();

    @Test
    public void testRigidBodyTransformToMatrix4() {
        for (int i = 0; i < 1000; ++i) {
            Random random = new Random(14474L);
            RigidBodyTransform rigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            BulletTools.toBullet((RigidBodyTransform)rigidBodyTransform, (Matrix4)this.bulletAffineToPack);
            this.bulletAffineToPack.getTranslation(this.translation);
            Assertions.assertEquals((float)this.translation.x, (float)((float)rigidBodyTransform.getTranslationX()));
            Assertions.assertEquals((float)this.translation.y, (float)((float)rigidBodyTransform.getTranslationY()));
            Assertions.assertEquals((float)this.translation.z, (float)((float)rigidBodyTransform.getTranslationZ()));
            Assertions.assertEquals((float)this.bulletAffineToPack.val[0], (float)((float)rigidBodyTransform.getM00()));
            Assertions.assertEquals((float)this.bulletAffineToPack.val[4], (float)((float)rigidBodyTransform.getM01()));
            Assertions.assertEquals((float)this.bulletAffineToPack.val[8], (float)((float)rigidBodyTransform.getM02()));
            Assertions.assertEquals((float)this.bulletAffineToPack.val[1], (float)((float)rigidBodyTransform.getM10()));
            Assertions.assertEquals((float)this.bulletAffineToPack.val[5], (float)((float)rigidBodyTransform.getM11()));
            Assertions.assertEquals((float)this.bulletAffineToPack.val[9], (float)((float)rigidBodyTransform.getM12()));
            Assertions.assertEquals((float)this.bulletAffineToPack.val[2], (float)((float)rigidBodyTransform.getM20()));
            Assertions.assertEquals((float)this.bulletAffineToPack.val[6], (float)((float)rigidBodyTransform.getM21()));
            Assertions.assertEquals((float)this.bulletAffineToPack.val[10], (float)((float)rigidBodyTransform.getM22()));
        }
    }

    @Test
    public void testMatrix4ToRigidBodyTransform() {
        Random random = new Random(14474L);
        for (int i = 0; i < 1000; ++i) {
            this.vector1.x = random.nextFloat();
            this.vector1.y = random.nextFloat();
            this.vector1.z = random.nextFloat();
            this.vector2.x = random.nextFloat();
            this.vector2.y = random.nextFloat();
            this.vector2.z = random.nextFloat();
            this.bulletAffine.setToRotation(this.vector1, this.vector2);
            this.translation.x = random.nextFloat();
            this.translation.y = random.nextFloat();
            this.translation.z = random.nextFloat();
            this.bulletAffine.setTranslation(this.translation);
            BulletTools.toEuclid((Matrix4)this.bulletAffine, (RigidBodyTransform)this.rigidBodyTransformToPack);
            Assertions.assertEquals((double)this.bulletAffine.val[12], (double)((float)this.rigidBodyTransformToPack.getTranslationX()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[13], (double)((float)this.rigidBodyTransformToPack.getTranslationY()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[14], (double)((float)this.rigidBodyTransformToPack.getTranslationZ()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[0], (double)((float)this.rigidBodyTransformToPack.getM00()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[4], (double)((float)this.rigidBodyTransformToPack.getM01()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[8], (double)((float)this.rigidBodyTransformToPack.getM02()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[1], (double)((float)this.rigidBodyTransformToPack.getM10()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[5], (double)((float)this.rigidBodyTransformToPack.getM11()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[9], (double)((float)this.rigidBodyTransformToPack.getM12()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[2], (double)((float)this.rigidBodyTransformToPack.getM20()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[6], (double)((float)this.rigidBodyTransformToPack.getM21()), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.val[10], (double)((float)this.rigidBodyTransformToPack.getM22()), (double)1.0E-5);
        }
    }

    @Test
    public void testEuclidQuaternionToBulletQuaternion() {
        Random random = new Random(21714L);
        for (int i = 0; i < 1000; ++i) {
            us.ihmc.euclid.tuple4D.Quaternion euclidQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            BulletTools.toBullet((us.ihmc.euclid.tuple4D.Quaternion)euclidQuaternion, (Quaternion)this.bulletQuaternion);
            Assertions.assertEquals((double)euclidQuaternion.getX(), (double)this.bulletQuaternion.x, (double)1.0E-5);
            Assertions.assertEquals((double)euclidQuaternion.getY(), (double)this.bulletQuaternion.y, (double)1.0E-5);
            Assertions.assertEquals((double)euclidQuaternion.getZ(), (double)this.bulletQuaternion.z, (double)1.0E-5);
            Assertions.assertEquals((double)euclidQuaternion.getS(), (double)this.bulletQuaternion.w, (double)1.0E-5);
        }
    }

    @Test
    public void testTupleToVector3() {
        Random random = new Random(42518L);
        for (int i = 0; i < 1000; ++i) {
            Point3D euclidTuple = EuclidCoreRandomTools.nextPoint3D((Random)random);
            BulletTools.toBullet((Tuple3DReadOnly)euclidTuple, (Vector3)this.vector1);
            Assertions.assertEquals((double)euclidTuple.getX(), (double)this.vector1.x, (double)1.0E-5);
            Assertions.assertEquals((double)euclidTuple.getY(), (double)this.vector1.y, (double)1.0E-5);
            Assertions.assertEquals((double)euclidTuple.getZ(), (double)this.vector1.z, (double)1.0E-5);
        }
    }

    @Test
    public void testVector3ToVector3D() {
        Random random = new Random(96571L);
        for (int i = 0; i < 1000; ++i) {
            this.vector1.x = random.nextFloat();
            this.vector1.y = random.nextFloat();
            this.vector1.z = random.nextFloat();
            BulletTools.toEuclid((Vector3)this.vector1, (Vector3DBasics)this.euclidVector3D32);
            Assertions.assertEquals((double)this.euclidVector3D32.getX(), (double)this.vector1.x, (double)1.0E-5);
            Assertions.assertEquals((double)this.euclidVector3D32.getY(), (double)this.vector1.y, (double)1.0E-5);
            Assertions.assertEquals((double)this.euclidVector3D32.getZ(), (double)this.vector1.z, (double)1.0E-5);
        }
    }

    @Test
    public void testVector3ToPoint3DBasics() {
        Random random = new Random(54214L);
        for (int i = 0; i < 1000; ++i) {
            this.vector1.x = random.nextFloat();
            this.vector1.y = random.nextFloat();
            this.vector1.z = random.nextFloat();
            BulletTools.toEuclid((Vector3)this.vector1, (Point3DBasics)this.euclidPoint3D32);
            Assertions.assertEquals((double)this.euclidPoint3D32.getX(), (double)this.vector1.x, (double)1.0E-5);
            Assertions.assertEquals((double)this.euclidPoint3D32.getY(), (double)this.vector1.y, (double)1.0E-5);
            Assertions.assertEquals((double)this.euclidPoint3D32.getZ(), (double)this.vector1.z, (double)1.0E-5);
        }
    }

    @Test
    public void testCreateBulletCollisionShape() {
        btCollisionShape btCollisionShape2;
        CollisionShapeDefinition collisionShapeDefinition;
        int i;
        Random random = new Random(957123L);
        for (i = 0; i < 1000; ++i) {
            Box3DDefinition boxGeometryDefinition = new Box3DDefinition(random.nextDouble(), random.nextDouble(), random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)boxGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)0);
            btBoxShape btBoxShape2 = (btBoxShape)btCollisionShape2;
            for (int j = 0; j < btBoxShape2.getNumEdges(); ++j) {
                btBoxShape2.getVertex(j, this.vector1);
                Assertions.assertEquals((double)Math.abs(this.vector1.x), (double)((float)boxGeometryDefinition.getSizeX() / 2.0f), (double)1.0E-5);
                Assertions.assertEquals((double)Math.abs(this.vector1.y), (double)((float)boxGeometryDefinition.getSizeY() / 2.0f), (double)1.0E-5);
                Assertions.assertEquals((double)Math.abs(this.vector1.z), (double)((float)boxGeometryDefinition.getSizeZ() / 2.0f), (double)1.0E-5);
            }
        }
        for (i = 0; i < 1000; ++i) {
            Sphere3DDefinition sphereGeometryDefinition = new Sphere3DDefinition(random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)sphereGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)8);
            btSphereShape sphereShape = (btSphereShape)btCollisionShape2;
            Assertions.assertEquals((float)sphereShape.getRadius(), (float)((float)sphereGeometryDefinition.getRadius()));
        }
        for (i = 0; i < 1000; ++i) {
            Cylinder3DDefinition cylinderGeometryDefinition = new Cylinder3DDefinition(random.nextDouble(), random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)cylinderGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)13);
            btCylinderShapeZ cylinderShape = (btCylinderShapeZ)btCollisionShape2;
            Assertions.assertEquals((double)cylinderShape.getRadius(), (double)((float)cylinderGeometryDefinition.getRadius()), (double)1.0E-5);
            Assertions.assertEquals((double)cylinderShape.getHalfExtentsWithMargin().z, (double)((float)cylinderGeometryDefinition.getLength() / 2.0f), (double)1.0E-5);
        }
        for (i = 0; i < 1000; ++i) {
            Cone3DDefinition coneGeometryDefinition = new Cone3DDefinition(random.nextDouble(), random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)coneGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)11);
            btConeShapeZ coneShape = (btConeShapeZ)btCollisionShape2;
            Assertions.assertEquals((double)coneShape.getRadius(), (double)((float)coneGeometryDefinition.getRadius()), (double)1.0E-5);
            Assertions.assertEquals((double)coneShape.getHeight(), (double)((float)coneGeometryDefinition.getHeight()), (double)1.0E-5);
        }
        for (i = 0; i < 1000; ++i) {
            Capsule3DDefinition capsuleGeometryDefinition = new Capsule3DDefinition(random.nextDouble(), random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)capsuleGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)10);
            btCapsuleShapeZ capsuleShape = (btCapsuleShapeZ)btCollisionShape2;
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)((float)capsuleGeometryDefinition.getRadiusX()), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)((float)capsuleGeometryDefinition.getRadiusY()), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)((float)capsuleGeometryDefinition.getRadiusZ()), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getHalfHeight(), (double)((float)capsuleGeometryDefinition.getLength() / 2.0f), (double)1.0E-5);
        }
        Ellipsoid3DDefinition polytypeGeometryDefinition = new Ellipsoid3DDefinition(1.0, 1.0, 1.0);
        CollisionShapeDefinition collisionShapeDefinition2 = new CollisionShapeDefinition((GeometryDefinition)polytypeGeometryDefinition);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition2));
    }

    static {
        Bullet.init();
        LogTools.info((String)"Loaded Bullet version {}", (Object)LinearMath.btGetVersion());
    }
}

