/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.Collection;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.mecano.tools.MomentOfInertiaFactory;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.TimeConsumer;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.yoVariables.euclid.YoPoint3D;

public class BulletCoefficientOfFrictionTest {
    private static final double EPSILON = 0.01;
    private static final boolean VISUALIZE = false;
    private static final int ITERATIONS = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoefficientOfFriction() throws Throwable {
        Vector3D boxSize = new Vector3D(0.4, 0.4, 0.4);
        final double angleOfGround = 34.0;
        final Double friction = 0.7;
        double groundHeight = 0.01;
        double groundPitch = Math.toRadians(angleOfGround);
        String name = "box";
        double dt = 0.01;
        RobotDefinition boxRobot = BulletCoefficientOfFrictionTest.newBoxRobot(name, boxSize, 150.0, 0.8, ColorDefinitions.DarkCyan());
        SixDoFJointState initialState = new SixDoFJointState();
        final Point3D initialPosition = new Point3D(0.0, 0.0, BulletCoefficientOfFrictionTest.calculateZ(groundPitch));
        initialState.setConfiguration((Orientation3DReadOnly)new YawPitchRoll(0.0, groundPitch, 0.0), (Tuple3DReadOnly)initialPosition);
        initialState.setVelocity((Vector3DReadOnly)new Vector3D(0.0, 0.0, 0.0), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 0.0));
        ((JointDefinition)boxRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)initialState);
        boxRobot.getRigidBodyDefinition("boxRigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition((Tuple3DReadOnly)boxSize)));
        Box3DDefinition terrainGeometry = new Box3DDefinition(100.0, 100.0, groundHeight);
        RigidBodyTransform terrainPose = new RigidBodyTransform();
        terrainPose.appendPitchRotation(groundPitch);
        terrainPose.appendTranslation(0.0, 0.0, 0.0);
        TerrainObjectDefinition terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.Lavender())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
        BulletMultiBodyJointParameters bulletMultiBodyJointParameters = BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters();
        bulletMultiBodyJointParameters.setJointFriction(friction.doubleValue());
        SimulationSession simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory((BulletMultiBodyParameters)BulletMultiBodyParameters.defaultBulletMultiBodyParameters(), (BulletMultiBodyJointParameters)bulletMultiBodyJointParameters));
        int numberOfSimulationTicks = 1000;
        simulationSession.addRobot(boxRobot);
        simulationSession.addTerrainObject(terrain);
        simulationSession.setSessionDTSeconds(dt);
        Object visualizerControls = null;
        final YoPoint3D expectedPosition = new YoPoint3D("expectedSpherePosition", simulationSession.getRootRegistry());
        final SimFloatingRootJoint floatingRootJoint = (SimFloatingRootJoint)((Robot)simulationSession.getPhysicsEngine().getRobots().get(0)).getJoint(name);
        MutableObject caughtException = new MutableObject(null);
        simulationSession.addRunThrowableListener(t -> caughtException.setValue(t));
        simulationSession.addAfterPhysicsCallback(new TimeConsumer(){

            public void accept(double time) {
                expectedPosition.set((Tuple3DReadOnly)initialPosition);
                if (friction > Math.abs(Math.tan(angleOfGround))) {
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPosition, (EuclidGeometry)floatingRootJoint.getJointPose().getPosition(), (double)0.01);
                } else if (time > 0.5) {
                    Assertions.assertNotEquals((double)expectedPosition.getZ(), (double)floatingRootJoint.getJointPose().getPosition().getZ());
                }
            }
        });
        simulationSession.getSimulationSessionControls().simulateNow((long)numberOfSimulationTicks);
        if (caughtException.getValue() != null) {
            throw (Throwable)caughtException.getValue();
        }
    }

    @Test
    public void testCoefficientOfFrictionRandom() throws Throwable {
        Random random = new Random(1254147L);
        Vector3D boxSize = new Vector3D(0.4, 0.4, 0.4);
        double groundHeight = 0.01;
        String name = "box";
        for (int i = 0; i <= 100; ++i) {
            double angleOfGround = random.nextDouble() * 100.0 / 2.0;
            Double friction = random.nextDouble();
            double groundPitch = Math.toRadians(angleOfGround);
            RobotDefinition boxRobot = BulletCoefficientOfFrictionTest.newBoxRobot(name, boxSize, 150.0, 0.8, null);
            SixDoFJointState initialState = new SixDoFJointState();
            Point3D initialPosition = new Point3D(0.0, 0.0, BulletCoefficientOfFrictionTest.calculateZ(groundPitch));
            initialState.setConfiguration((Orientation3DReadOnly)new YawPitchRoll(0.0, groundPitch, 0.0), (Tuple3DReadOnly)initialPosition);
            initialState.setVelocity((Vector3DReadOnly)new Vector3D(0.0, 0.0, 0.0), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 0.0));
            ((JointDefinition)boxRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)initialState);
            boxRobot.getRigidBodyDefinition("boxRigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition((Tuple3DReadOnly)boxSize)));
            Box3DDefinition terrainGeometry = new Box3DDefinition(100.0, 100.0, groundHeight);
            RigidBodyTransform terrainPose = new RigidBodyTransform();
            terrainPose.appendPitchRotation(groundPitch);
            terrainPose.appendTranslation(0.0, 0.0, 0.0);
            TerrainObjectDefinition terrain = new TerrainObjectDefinition();
            terrain.addCollisionShapeDefinition(new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            BulletMultiBodyJointParameters bulletMultiBodyJointParameters = BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters();
            bulletMultiBodyJointParameters.setJointFriction(friction.doubleValue());
            SimulationSession simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory((BulletMultiBodyParameters)BulletMultiBodyParameters.defaultBulletMultiBodyParameters(), (BulletMultiBodyJointParameters)bulletMultiBodyJointParameters));
            int numberOfSimulationTicks = 1000;
            simulationSession.addRobot(boxRobot);
            simulationSession.addTerrainObject(terrain);
            YoPoint3D expectedPosition = new YoPoint3D("expectedSpherePosition", simulationSession.getRootRegistry());
            SimFloatingRootJoint floatingRootJoint = (SimFloatingRootJoint)((Robot)simulationSession.getPhysicsEngine().getRobots().get(0)).getJoint(name);
            expectedPosition.set((Tuple3DReadOnly)initialPosition);
            for (int j = 0; j <= numberOfSimulationTicks; ++j) {
                simulationSession.runTick();
            }
            if (friction > Math.abs(Math.tan(groundPitch))) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPosition, (EuclidGeometry)floatingRootJoint.getJointPose().getPosition(), (double)0.01);
                continue;
            }
            Assertions.assertNotEquals((double)expectedPosition.getZ(), (double)floatingRootJoint.getJointPose().getPosition().getZ());
        }
    }

    public static double calculateZ(double angleOfGround) {
        double a1 = 50.0 * Math.sin(angleOfGround);
        double b1 = 50.0 * Math.cos(angleOfGround);
        double a2 = b1 * Math.tan(angleOfGround - 0.00412);
        return a1 - a2;
    }

    public static RobotDefinition newBoxRobot(String name, Vector3D boxSize, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        RobotDefinition robotDefinition = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(name + "RigidBody");
        rigidBody.setMass(mass);
        rigidBody.setMomentOfInertia((Matrix3DReadOnly)MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)mass, (double)(radiusOfGyrationPercent * boxSize.getX()), (double)(radiusOfGyrationPercent * boxSize.getY()), (double)(radiusOfGyrationPercent * boxSize.getZ())));
        if (color != null) {
            VisualDefinitionFactory factory = new VisualDefinitionFactory();
            factory.addBox(boxSize.getX(), boxSize.getY(), boxSize.getZ(), new MaterialDefinition(color));
            rigidBody.addVisualDefinitions((Collection)factory.getVisualDefinitions());
        }
        rootJoint.setSuccessor(rigidBody);
        robotDefinition.setRootBodyDefinition(rootBody);
        return robotDefinition;
    }
}

