/*
 * Decompiled with CFR 0.152.
 */
package visualization_msgs.msg.dds;

import geometry_msgs.msg.dds.PosePubSubType;
import java.io.IOException;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import visualization_msgs.msg.dds.InteractiveMarker;
import visualization_msgs.msg.dds.InteractiveMarkerControl;
import visualization_msgs.msg.dds.InteractiveMarkerControlPubSubType;
import visualization_msgs.msg.dds.MenuEntry;
import visualization_msgs.msg.dds.MenuEntryPubSubType;

public class InteractiveMarkerPubSubType
implements TopicDataType<InteractiveMarker> {
    public static final String name = "visualization_msgs::msg::dds_::InteractiveMarker_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "e6dae6521c0d09978fed4ab3b17714a5b118f6232a0319a47ce57ae78eaf7318";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(InteractiveMarker data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        InteractiveMarkerPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, InteractiveMarker data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        InteractiveMarkerPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return InteractiveMarkerPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int i0;
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += PosePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 100; ++i0) {
            current_alignment += MenuEntryPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 100; ++i0) {
            current_alignment += InteractiveMarkerControlPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(InteractiveMarker data) {
        return InteractiveMarkerPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(InteractiveMarker data, int current_alignment) {
        int i0;
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += PosePubSubType.getCdrSerializedSize(data.getPose(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getDescription().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getMenuEntries().size(); ++i0) {
            current_alignment += MenuEntryPubSubType.getCdrSerializedSize((MenuEntry)((Object)data.getMenuEntries().get(i0)), current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getControls().size(); ++i0) {
            current_alignment += InteractiveMarkerControlPubSubType.getCdrSerializedSize((InteractiveMarkerControl)((Object)data.getControls().get(i0)), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(InteractiveMarker data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        PosePubSubType.write(data.getPose(), cdr);
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length: %d > %d".formatted(data.getName().length(), 255));
        }
        cdr.write_type_d(data.getName());
        if (data.getDescription().length() > 255) {
            throw new RuntimeException("description field exceeds the maximum length: %d > %d".formatted(data.getDescription().length(), 255));
        }
        cdr.write_type_d(data.getDescription());
        cdr.write_type_5(data.getScale());
        if (data.getMenuEntries().size() > 100) {
            throw new RuntimeException("menu_entries field exceeds the maximum length: %d > %d".formatted(data.getMenuEntries().size(), 100));
        }
        cdr.write_type_e(data.getMenuEntries());
        if (data.getControls().size() > 100) {
            throw new RuntimeException("controls field exceeds the maximum length: %d > %d".formatted(data.getControls().size(), 100));
        }
        cdr.write_type_e(data.getControls());
    }

    public static void read(InteractiveMarker data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        PosePubSubType.read(data.getPose(), cdr);
        cdr.read_type_d(data.getName());
        cdr.read_type_d(data.getDescription());
        data.setScale(cdr.read_type_5());
        cdr.read_type_e(data.getMenuEntries());
        cdr.read_type_e(data.getControls());
    }

    public final void serialize(InteractiveMarker data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_a("pose", (TopicDataType)new PosePubSubType(), (Object)data.getPose());
        ser.write_type_d("name", data.getName());
        ser.write_type_d("description", data.getDescription());
        ser.write_type_5("scale", data.getScale());
        ser.write_type_e("menu_entries", data.getMenuEntries());
        ser.write_type_e("controls", data.getControls());
    }

    public final void deserialize(InterchangeSerializer ser, InteractiveMarker data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_a("pose", (TopicDataType)new PosePubSubType(), (Object)data.getPose());
        ser.read_type_d("name", data.getName());
        ser.read_type_d("description", data.getDescription());
        data.setScale(ser.read_type_5("scale"));
        ser.read_type_e("menu_entries", data.getMenuEntries());
        ser.read_type_e("controls", data.getControls());
    }

    public static void staticCopy(InteractiveMarker src, InteractiveMarker dest) {
        dest.set(src);
    }

    public InteractiveMarker createData() {
        return new InteractiveMarker();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)InteractiveMarkerPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(InteractiveMarker data, CDR cdr) {
        InteractiveMarkerPubSubType.write(data, cdr);
    }

    public void deserialize(InteractiveMarker data, CDR cdr) {
        InteractiveMarkerPubSubType.read(data, cdr);
    }

    public void copy(InteractiveMarker src, InteractiveMarker dest) {
        InteractiveMarkerPubSubType.staticCopy(src, dest);
    }

    public InteractiveMarkerPubSubType newInstance() {
        return new InteractiveMarkerPubSubType();
    }
}

