/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.util.Arrays;
import java.util.function.Supplier;
import sensor_msgs.msg.dds.PointCloud2PubSubType;
import sensor_msgs.msg.dds.PointField;
import sensor_msgs.msg.dds.PointFieldPubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class PointCloud2
extends Packet<PointCloud2>
implements Settable<PointCloud2>,
EpsilonComparable<PointCloud2> {
    public Header header_ = new Header();
    public long height_;
    public long width_;
    public PointField[] fields_ = new PointField[16];
    public boolean is_bigendian_;
    public long point_step_;
    public long row_step_;
    public byte[] data_;
    public boolean is_dense_;

    public PointCloud2() {
        for (int i1 = 0; i1 < this.fields_.length; ++i1) {
            this.fields_[i1] = new PointField();
        }
        this.data_ = new byte[25000000];
    }

    public PointCloud2(PointCloud2 other) {
        this();
        this.set(other);
    }

    public void set(PointCloud2 other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        this.height_ = other.height_;
        this.width_ = other.width_;
        for (int i3 = 0; i3 < this.fields_.length; ++i3) {
            PointFieldPubSubType.staticCopy(other.fields_[i3], this.fields_[i3]);
        }
        this.is_bigendian_ = other.is_bigendian_;
        this.point_step_ = other.point_step_;
        this.row_step_ = other.row_step_;
        for (int i5 = 0; i5 < this.data_.length; ++i5) {
            this.data_[i5] = other.data_[i5];
        }
        this.is_dense_ = other.is_dense_;
    }

    public Header getHeader() {
        return this.header_;
    }

    public void setHeight(long height) {
        this.height_ = height;
    }

    public long getHeight() {
        return this.height_;
    }

    public void setWidth(long width) {
        this.width_ = width;
    }

    public long getWidth() {
        return this.width_;
    }

    public PointField[] getFields() {
        return this.fields_;
    }

    public void setIsBigendian(boolean is_bigendian) {
        this.is_bigendian_ = is_bigendian;
    }

    public boolean getIsBigendian() {
        return this.is_bigendian_;
    }

    public void setPointStep(long point_step) {
        this.point_step_ = point_step;
    }

    public long getPointStep() {
        return this.point_step_;
    }

    public void setRowStep(long row_step) {
        this.row_step_ = row_step;
    }

    public long getRowStep() {
        return this.row_step_;
    }

    public byte[] getData() {
        return this.data_;
    }

    public void setIsDense(boolean is_dense) {
        this.is_dense_ = is_dense;
    }

    public boolean getIsDense() {
        return this.is_dense_;
    }

    public static Supplier<PointCloud2PubSubType> getPubSubType() {
        return PointCloud2PubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return PointCloud2PubSubType::new;
    }

    public boolean epsilonEquals(PointCloud2 other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.height_, (double)other.height_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.width_, (double)other.width_, (double)epsilon)) {
            return false;
        }
        for (int i7 = 0; i7 < this.fields_.length; ++i7) {
            if (this.fields_[i7].epsilonEquals(other.fields_[i7], epsilon)) continue;
            return false;
        }
        if (!IDLTools.epsilonEqualsBoolean((boolean)this.is_bigendian_, (boolean)other.is_bigendian_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.point_step_, (double)other.point_step_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.row_step_, (double)other.row_step_, (double)epsilon)) {
            return false;
        }
        for (int i9 = 0; i9 < this.data_.length; ++i9) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.data_[i9], (double)other.data_[i9], (double)epsilon)) continue;
            return false;
        }
        return IDLTools.epsilonEqualsBoolean((boolean)this.is_dense_, (boolean)other.is_dense_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof PointCloud2)) {
            return false;
        }
        PointCloud2 otherMyClass = (PointCloud2)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (this.height_ != otherMyClass.height_) {
            return false;
        }
        if (this.width_ != otherMyClass.width_) {
            return false;
        }
        for (int i11 = 0; i11 < this.fields_.length; ++i11) {
            if (this.fields_[i11].equals((Object)otherMyClass.fields_[i11])) continue;
            return false;
        }
        if (this.is_bigendian_ != otherMyClass.is_bigendian_) {
            return false;
        }
        if (this.point_step_ != otherMyClass.point_step_) {
            return false;
        }
        if (this.row_step_ != otherMyClass.row_step_) {
            return false;
        }
        for (int i13 = 0; i13 < this.data_.length; ++i13) {
            if (this.data_[i13] == otherMyClass.data_[i13]) continue;
            return false;
        }
        return this.is_dense_ == otherMyClass.is_dense_;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PointCloud2 {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("height=");
        builder.append(this.height_);
        builder.append(", ");
        builder.append("width=");
        builder.append(this.width_);
        builder.append(", ");
        builder.append("fields=");
        builder.append(Arrays.toString((Object[])this.fields_));
        builder.append(", ");
        builder.append("is_bigendian=");
        builder.append(this.is_bigendian_);
        builder.append(", ");
        builder.append("point_step=");
        builder.append(this.point_step_);
        builder.append(", ");
        builder.append("row_step=");
        builder.append(this.row_step_);
        builder.append(", ");
        builder.append("data=");
        builder.append(Arrays.toString(this.data_));
        builder.append(", ");
        builder.append("is_dense=");
        builder.append(this.is_dense_);
        builder.append("}");
        return builder.toString();
    }
}

