/*
 * Decompiled with CFR 0.152.
 */
package service_msgs.msg.dds;

import builtin_interfaces.msg.dds.Time;
import builtin_interfaces.msg.dds.TimePubSubType;
import java.util.Arrays;
import java.util.function.Supplier;
import service_msgs.msg.dds.ServiceEventInfoPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class ServiceEventInfo
extends Packet<ServiceEventInfo>
implements Settable<ServiceEventInfo>,
EpsilonComparable<ServiceEventInfo> {
    public static final byte REQUEST_SENT = 0;
    public static final byte REQUEST_RECEIVED = 1;
    public static final byte RESPONSE_SENT = 2;
    public static final byte RESPONSE_RECEIVED = 3;
    public byte event_type_;
    public Time stamp_ = new Time();
    public char[] client_gid_ = new char[16];
    public long sequence_number_;

    public ServiceEventInfo() {
    }

    public ServiceEventInfo(ServiceEventInfo other) {
        this();
        this.set(other);
    }

    public void set(ServiceEventInfo other) {
        this.event_type_ = other.event_type_;
        TimePubSubType.staticCopy(other.stamp_, this.stamp_);
        for (int i1 = 0; i1 < this.client_gid_.length; ++i1) {
            this.client_gid_[i1] = other.client_gid_[i1];
        }
        this.sequence_number_ = other.sequence_number_;
    }

    public void setEventType(byte event_type) {
        this.event_type_ = event_type;
    }

    public byte getEventType() {
        return this.event_type_;
    }

    public Time getStamp() {
        return this.stamp_;
    }

    public char[] getClientGid() {
        return this.client_gid_;
    }

    public void setSequenceNumber(long sequence_number) {
        this.sequence_number_ = sequence_number;
    }

    public long getSequenceNumber() {
        return this.sequence_number_;
    }

    public static Supplier<ServiceEventInfoPubSubType> getPubSubType() {
        return ServiceEventInfoPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return ServiceEventInfoPubSubType::new;
    }

    public boolean epsilonEquals(ServiceEventInfo other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.event_type_, (double)other.event_type_, (double)epsilon)) {
            return false;
        }
        if (!this.stamp_.epsilonEquals(other.stamp_, epsilon)) {
            return false;
        }
        for (int i3 = 0; i3 < this.client_gid_.length; ++i3) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.client_gid_[i3], (double)other.client_gid_[i3], (double)epsilon)) continue;
            return false;
        }
        return IDLTools.epsilonEqualsPrimitive((double)this.sequence_number_, (double)other.sequence_number_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ServiceEventInfo)) {
            return false;
        }
        ServiceEventInfo otherMyClass = (ServiceEventInfo)((Object)other);
        if (this.event_type_ != otherMyClass.event_type_) {
            return false;
        }
        if (!this.stamp_.equals((Object)otherMyClass.stamp_)) {
            return false;
        }
        for (int i5 = 0; i5 < this.client_gid_.length; ++i5) {
            if (this.client_gid_[i5] == otherMyClass.client_gid_[i5]) continue;
            return false;
        }
        return this.sequence_number_ == otherMyClass.sequence_number_;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServiceEventInfo {");
        builder.append("event_type=");
        builder.append(this.event_type_);
        builder.append(", ");
        builder.append("stamp=");
        builder.append((Object)this.stamp_);
        builder.append(", ");
        builder.append("client_gid=");
        builder.append(Arrays.toString(this.client_gid_));
        builder.append(", ");
        builder.append("sequence_number=");
        builder.append(this.sequence_number_);
        builder.append("}");
        return builder.toString();
    }
}

