/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import geometry_msgs.msg.dds.QuaternionPubSubType;
import geometry_msgs.msg.dds.Vector3PubSubType;
import java.io.IOException;
import sensor_msgs.msg.dds.Imu;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class ImuPubSubType
implements TopicDataType<Imu> {
    public static final String name = "sensor_msgs::msg::dds_::Imu_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "94075a5f830aed0ff5bdd242aca148b7f5c8a919cdd43183c200280bc365e994";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(Imu data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        ImuPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Imu data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        ImuPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return ImuPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += QuaternionPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += Vector3PubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += Vector3PubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Imu data) {
        return ImuPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Imu data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += QuaternionPubSubType.getCdrSerializedSize(data.getOrientation(), current_alignment);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += Vector3PubSubType.getCdrSerializedSize(data.getAngularVelocity(), current_alignment);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += Vector3PubSubType.getCdrSerializedSize(data.getLinearAcceleration(), current_alignment);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        return current_alignment - initial_alignment;
    }

    public static void write(Imu data, CDR cdr) {
        int i0;
        HeaderPubSubType.write(data.getHeader(), cdr);
        QuaternionPubSubType.write(data.getOrientation(), cdr);
        for (i0 = 0; i0 < data.getOrientationCovariance().length; ++i0) {
            cdr.write_type_6(data.getOrientationCovariance()[i0]);
        }
        Vector3PubSubType.write(data.getAngularVelocity(), cdr);
        for (i0 = 0; i0 < data.getAngularVelocityCovariance().length; ++i0) {
            cdr.write_type_6(data.getAngularVelocityCovariance()[i0]);
        }
        Vector3PubSubType.write(data.getLinearAcceleration(), cdr);
        for (i0 = 0; i0 < data.getLinearAccelerationCovariance().length; ++i0) {
            cdr.write_type_6(data.getLinearAccelerationCovariance()[i0]);
        }
    }

    public static void read(Imu data, CDR cdr) {
        int i0;
        HeaderPubSubType.read(data.getHeader(), cdr);
        QuaternionPubSubType.read(data.getOrientation(), cdr);
        for (i0 = 0; i0 < data.getOrientationCovariance().length; ++i0) {
            data.getOrientationCovariance()[i0] = cdr.read_type_6();
        }
        Vector3PubSubType.read(data.getAngularVelocity(), cdr);
        for (i0 = 0; i0 < data.getAngularVelocityCovariance().length; ++i0) {
            data.getAngularVelocityCovariance()[i0] = cdr.read_type_6();
        }
        Vector3PubSubType.read(data.getLinearAcceleration(), cdr);
        for (i0 = 0; i0 < data.getLinearAccelerationCovariance().length; ++i0) {
            data.getLinearAccelerationCovariance()[i0] = cdr.read_type_6();
        }
    }

    public final void serialize(Imu data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_a("orientation", (TopicDataType)new QuaternionPubSubType(), (Object)data.getOrientation());
        ser.write_type_f("orientation_covariance", data.getOrientationCovariance());
        ser.write_type_a("angular_velocity", (TopicDataType)new Vector3PubSubType(), (Object)data.getAngularVelocity());
        ser.write_type_f("angular_velocity_covariance", data.getAngularVelocityCovariance());
        ser.write_type_a("linear_acceleration", (TopicDataType)new Vector3PubSubType(), (Object)data.getLinearAcceleration());
        ser.write_type_f("linear_acceleration_covariance", data.getLinearAccelerationCovariance());
    }

    public final void deserialize(InterchangeSerializer ser, Imu data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_a("orientation", (TopicDataType)new QuaternionPubSubType(), (Object)data.getOrientation());
        ser.read_type_f("orientation_covariance", data.getOrientationCovariance());
        ser.read_type_a("angular_velocity", (TopicDataType)new Vector3PubSubType(), (Object)data.getAngularVelocity());
        ser.read_type_f("angular_velocity_covariance", data.getAngularVelocityCovariance());
        ser.read_type_a("linear_acceleration", (TopicDataType)new Vector3PubSubType(), (Object)data.getLinearAcceleration());
        ser.read_type_f("linear_acceleration_covariance", data.getLinearAccelerationCovariance());
    }

    public static void staticCopy(Imu src, Imu dest) {
        dest.set(src);
    }

    public Imu createData() {
        return new Imu();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)ImuPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Imu data, CDR cdr) {
        ImuPubSubType.write(data, cdr);
    }

    public void deserialize(Imu data, CDR cdr) {
        ImuPubSubType.read(data, cdr);
    }

    public void copy(Imu src, Imu dest) {
        ImuPubSubType.staticCopy(src, dest);
    }

    public ImuPubSubType newInstance() {
        return new ImuPubSubType();
    }
}

