/*
 * Decompiled with CFR 0.152.
 */
package nav_msgs.msg.dds;

import builtin_interfaces.msg.dds.TimePubSubType;
import geometry_msgs.msg.dds.PosePubSubType;
import java.io.IOException;
import nav_msgs.msg.dds.MapMetaData;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class MapMetaDataPubSubType
implements TopicDataType<MapMetaData> {
    public static final String name = "nav_msgs::msg::dds_::MapMetaData_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "c36622dedfea05251c4d90fb3c9bf2ed67e17a6857299c6c289bc81bb26be196";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(MapMetaData data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        MapMetaDataPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, MapMetaData data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        MapMetaDataPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return MapMetaDataPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += TimePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += PosePubSubType.getMaxCdrSerializedSize(current_alignment);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(MapMetaData data) {
        return MapMetaDataPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(MapMetaData data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += TimePubSubType.getCdrSerializedSize(data.getMapLoadTime(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += PosePubSubType.getCdrSerializedSize(data.getOrigin(), current_alignment);
        return current_alignment - initial_alignment;
    }

    public static void write(MapMetaData data, CDR cdr) {
        TimePubSubType.write(data.getMapLoadTime(), cdr);
        cdr.write_type_5(data.getResolution());
        cdr.write_type_4(data.getWidth());
        cdr.write_type_4(data.getHeight());
        PosePubSubType.write(data.getOrigin(), cdr);
    }

    public static void read(MapMetaData data, CDR cdr) {
        TimePubSubType.read(data.getMapLoadTime(), cdr);
        data.setResolution(cdr.read_type_5());
        data.setWidth(cdr.read_type_4());
        data.setHeight(cdr.read_type_4());
        PosePubSubType.read(data.getOrigin(), cdr);
    }

    public final void serialize(MapMetaData data, InterchangeSerializer ser) {
        ser.write_type_a("map_load_time", (TopicDataType)new TimePubSubType(), (Object)data.getMapLoadTime());
        ser.write_type_5("resolution", data.getResolution());
        ser.write_type_4("width", data.getWidth());
        ser.write_type_4("height", data.getHeight());
        ser.write_type_a("origin", (TopicDataType)new PosePubSubType(), (Object)data.getOrigin());
    }

    public final void deserialize(InterchangeSerializer ser, MapMetaData data) {
        ser.read_type_a("map_load_time", (TopicDataType)new TimePubSubType(), (Object)data.getMapLoadTime());
        data.setResolution(ser.read_type_5("resolution"));
        data.setWidth(ser.read_type_4("width"));
        data.setHeight(ser.read_type_4("height"));
        ser.read_type_a("origin", (TopicDataType)new PosePubSubType(), (Object)data.getOrigin());
    }

    public static void staticCopy(MapMetaData src, MapMetaData dest) {
        dest.set(src);
    }

    public MapMetaData createData() {
        return new MapMetaData();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)MapMetaDataPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(MapMetaData data, CDR cdr) {
        MapMetaDataPubSubType.write(data, cdr);
    }

    public void deserialize(MapMetaData data, CDR cdr) {
        MapMetaDataPubSubType.read(data, cdr);
    }

    public void copy(MapMetaData src, MapMetaData dest) {
        MapMetaDataPubSubType.staticCopy(src, dest);
    }

    public MapMetaDataPubSubType newInstance() {
        return new MapMetaDataPubSubType();
    }
}

