/*
 * Decompiled with CFR 0.152.
 */
package visualization_msgs.msg.dds;

import builtin_interfaces.msg.dds.DurationPubSubType;
import geometry_msgs.msg.dds.PointPubSubType;
import geometry_msgs.msg.dds.PosePubSubType;
import geometry_msgs.msg.dds.Vector3PubSubType;
import java.io.IOException;
import std_msgs.msg.dds.ColorRGBA;
import std_msgs.msg.dds.ColorRGBAPubSubType;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import visualization_msgs.msg.dds.Marker;

public class MarkerPubSubType
implements TopicDataType<Marker> {
    public static final String name = "visualization_msgs::msg::dds_::Marker_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "0ba89abfd0b4563ffa4e28e58e39205ad6155e74820d864e2f95e224515d9685";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(Marker data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        MarkerPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Marker data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        MarkerPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return MarkerPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int i0;
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += PosePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += Vector3PubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += ColorRGBAPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += DurationPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 100; ++i0) {
            current_alignment += PointPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 100; ++i0) {
            current_alignment += ColorRGBAPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Marker data) {
        return MarkerPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Marker data, int current_alignment) {
        int i0;
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getNs().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += PosePubSubType.getCdrSerializedSize(data.getPose(), current_alignment);
        current_alignment += Vector3PubSubType.getCdrSerializedSize(data.getScale(), current_alignment);
        current_alignment += ColorRGBAPubSubType.getCdrSerializedSize(data.getColor(), current_alignment);
        current_alignment += DurationPubSubType.getCdrSerializedSize(data.getLifetime(), current_alignment);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getPoints().size(); ++i0) {
            current_alignment += PointPubSubType.getCdrSerializedSize((Point3D)data.getPoints().get(i0), current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getColors().size(); ++i0) {
            current_alignment += ColorRGBAPubSubType.getCdrSerializedSize((ColorRGBA)((Object)data.getColors().get(i0)), current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getText().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getMeshResource().length() + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(Marker data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        if (data.getNs().length() > 255) {
            throw new RuntimeException("ns field exceeds the maximum length");
        }
        cdr.write_type_d(data.getNs());
        cdr.write_type_2(data.getId());
        cdr.write_type_2(data.getType());
        cdr.write_type_2(data.getAction());
        PosePubSubType.write(data.getPose(), cdr);
        Vector3PubSubType.write(data.getScale(), cdr);
        ColorRGBAPubSubType.write(data.getColor(), cdr);
        DurationPubSubType.write(data.getLifetime(), cdr);
        cdr.write_type_7(data.getFrameLocked());
        if (data.getPoints().size() > 100) {
            throw new RuntimeException("points field exceeds the maximum length");
        }
        cdr.write_type_e(data.getPoints());
        if (data.getColors().size() > 100) {
            throw new RuntimeException("colors field exceeds the maximum length");
        }
        cdr.write_type_e(data.getColors());
        if (data.getText().length() > 255) {
            throw new RuntimeException("text field exceeds the maximum length");
        }
        cdr.write_type_d(data.getText());
        if (data.getMeshResource().length() > 255) {
            throw new RuntimeException("mesh_resource field exceeds the maximum length");
        }
        cdr.write_type_d(data.getMeshResource());
        cdr.write_type_7(data.getMeshUseEmbeddedMaterials());
    }

    public static void read(Marker data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        cdr.read_type_d(data.getNs());
        data.setId(cdr.read_type_2());
        data.setType(cdr.read_type_2());
        data.setAction(cdr.read_type_2());
        PosePubSubType.read(data.getPose(), cdr);
        Vector3PubSubType.read(data.getScale(), cdr);
        ColorRGBAPubSubType.read(data.getColor(), cdr);
        DurationPubSubType.read(data.getLifetime(), cdr);
        data.setFrameLocked(cdr.read_type_7());
        cdr.read_type_e(data.getPoints());
        cdr.read_type_e(data.getColors());
        cdr.read_type_d(data.getText());
        cdr.read_type_d(data.getMeshResource());
        data.setMeshUseEmbeddedMaterials(cdr.read_type_7());
    }

    public final void serialize(Marker data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_d("ns", data.getNs());
        ser.write_type_2("id", data.getId());
        ser.write_type_2("type", data.getType());
        ser.write_type_2("action", data.getAction());
        ser.write_type_a("pose", (TopicDataType)new PosePubSubType(), (Object)data.getPose());
        ser.write_type_a("scale", (TopicDataType)new Vector3PubSubType(), (Object)data.getScale());
        ser.write_type_a("color", (TopicDataType)new ColorRGBAPubSubType(), (Object)data.getColor());
        ser.write_type_a("lifetime", (TopicDataType)new DurationPubSubType(), (Object)data.getLifetime());
        ser.write_type_7("frame_locked", data.getFrameLocked());
        ser.write_type_e("points", data.getPoints());
        ser.write_type_e("colors", data.getColors());
        ser.write_type_d("text", data.getText());
        ser.write_type_d("mesh_resource", data.getMeshResource());
        ser.write_type_7("mesh_use_embedded_materials", data.getMeshUseEmbeddedMaterials());
    }

    public final void deserialize(InterchangeSerializer ser, Marker data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_d("ns", data.getNs());
        data.setId(ser.read_type_2("id"));
        data.setType(ser.read_type_2("type"));
        data.setAction(ser.read_type_2("action"));
        ser.read_type_a("pose", (TopicDataType)new PosePubSubType(), (Object)data.getPose());
        ser.read_type_a("scale", (TopicDataType)new Vector3PubSubType(), (Object)data.getScale());
        ser.read_type_a("color", (TopicDataType)new ColorRGBAPubSubType(), (Object)data.getColor());
        ser.read_type_a("lifetime", (TopicDataType)new DurationPubSubType(), (Object)data.getLifetime());
        data.setFrameLocked(ser.read_type_7("frame_locked"));
        ser.read_type_e("points", data.getPoints());
        ser.read_type_e("colors", data.getColors());
        ser.read_type_d("text", data.getText());
        ser.read_type_d("mesh_resource", data.getMeshResource());
        data.setMeshUseEmbeddedMaterials(ser.read_type_7("mesh_use_embedded_materials"));
    }

    public static void staticCopy(Marker src, Marker dest) {
        dest.set(src);
    }

    public Marker createData() {
        return new Marker();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)MarkerPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Marker data, CDR cdr) {
        MarkerPubSubType.write(data, cdr);
    }

    public void deserialize(Marker data, CDR cdr) {
        MarkerPubSubType.read(data, cdr);
    }

    public void copy(Marker src, Marker dest) {
        MarkerPubSubType.staticCopy(src, dest);
    }

    public MarkerPubSubType newInstance() {
        return new MarkerPubSubType();
    }
}

