/*
 * Decompiled with CFR 0.152.
 */
package std_msgs.msg.dds;

import builtin_interfaces.msg.dds.TimePubSubType;
import java.io.IOException;
import std_msgs.msg.dds.Header;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class HeaderPubSubType
implements TopicDataType<Header> {
    public static final String name = "std_msgs::msg::dds_::Header_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(Header data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        HeaderPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Header data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        HeaderPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return HeaderPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += TimePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Header data) {
        return HeaderPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Header data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += TimePubSubType.getCdrSerializedSize(data.getStamp(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getFrameId().length() + 1;
        return current_alignment - initial_alignment;
    }

    public static void write(Header data, CDR cdr) {
        TimePubSubType.write(data.getStamp(), cdr);
        if (data.getFrameId().length() > 255) {
            throw new RuntimeException("frame_id field exceeds the maximum length");
        }
        cdr.write_type_d(data.getFrameId());
    }

    public static void read(Header data, CDR cdr) {
        TimePubSubType.read(data.getStamp(), cdr);
        cdr.read_type_d(data.getFrameId());
    }

    public final void serialize(Header data, InterchangeSerializer ser) {
        ser.write_type_a("stamp", (TopicDataType)new TimePubSubType(), (Object)data.getStamp());
        ser.write_type_d("frame_id", data.getFrameId());
    }

    public final void deserialize(InterchangeSerializer ser, Header data) {
        ser.read_type_a("stamp", (TopicDataType)new TimePubSubType(), (Object)data.getStamp());
        ser.read_type_d("frame_id", data.getFrameId());
    }

    public static void staticCopy(Header src, Header dest) {
        dest.set(src);
    }

    public Header createData() {
        return new Header();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)HeaderPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Header data, CDR cdr) {
        HeaderPubSubType.write(data, cdr);
    }

    public void deserialize(Header data, CDR cdr) {
        HeaderPubSubType.read(data, cdr);
    }

    public void copy(Header src, Header dest) {
        HeaderPubSubType.staticCopy(src, dest);
    }

    public HeaderPubSubType newInstance() {
        return new HeaderPubSubType();
    }
}

