/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.io.IOException;
import sensor_msgs.msg.dds.PointCloud2;
import sensor_msgs.msg.dds.PointField;
import sensor_msgs.msg.dds.PointFieldPubSubType;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class PointCloud2PubSubType
implements TopicDataType<PointCloud2> {
    public static final String name = "sensor_msgs::msg::dds_::PointCloud2_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(PointCloud2 data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        PointCloud2PubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, PointCloud2 data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        PointCloud2PubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return PointCloud2PubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 100; ++i0) {
            current_alignment += PointFieldPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 100 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(PointCloud2 data) {
        return PointCloud2PubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(PointCloud2 data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getFields().size(); ++i0) {
            current_alignment += PointFieldPubSubType.getCdrSerializedSize((PointField)((Object)data.getFields().get(i0)), current_alignment);
        }
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getData().size() * 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(PointCloud2 data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        cdr.write_type_4(data.getHeight());
        cdr.write_type_4(data.getWidth());
        if (data.getFields().size() > 100) {
            throw new RuntimeException("fields field exceeds the maximum length");
        }
        cdr.write_type_e(data.getFields());
        cdr.write_type_7(data.getIsBigendian());
        cdr.write_type_4(data.getPointStep());
        cdr.write_type_4(data.getRowStep());
        if (data.getData().size() > 100) {
            throw new RuntimeException("data field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getData());
        cdr.write_type_7(data.getIsDense());
    }

    public static void read(PointCloud2 data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        data.setHeight(cdr.read_type_4());
        data.setWidth(cdr.read_type_4());
        cdr.read_type_e(data.getFields());
        data.setIsBigendian(cdr.read_type_7());
        data.setPointStep(cdr.read_type_4());
        data.setRowStep(cdr.read_type_4());
        cdr.read_type_e((IDLSequence)data.getData());
        data.setIsDense(cdr.read_type_7());
    }

    public final void serialize(PointCloud2 data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_4("height", data.getHeight());
        ser.write_type_4("width", data.getWidth());
        ser.write_type_e("fields", data.getFields());
        ser.write_type_7("is_bigendian", data.getIsBigendian());
        ser.write_type_4("point_step", data.getPointStep());
        ser.write_type_4("row_step", data.getRowStep());
        ser.write_type_e("data", (IDLSequence)data.getData());
        ser.write_type_7("is_dense", data.getIsDense());
    }

    public final void deserialize(InterchangeSerializer ser, PointCloud2 data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        data.setHeight(ser.read_type_4("height"));
        data.setWidth(ser.read_type_4("width"));
        ser.read_type_e("fields", data.getFields());
        data.setIsBigendian(ser.read_type_7("is_bigendian"));
        data.setPointStep(ser.read_type_4("point_step"));
        data.setRowStep(ser.read_type_4("row_step"));
        ser.read_type_e("data", (IDLSequence)data.getData());
        data.setIsDense(ser.read_type_7("is_dense"));
    }

    public static void staticCopy(PointCloud2 src, PointCloud2 dest) {
        dest.set(src);
    }

    public PointCloud2 createData() {
        return new PointCloud2();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)PointCloud2PubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(PointCloud2 data, CDR cdr) {
        PointCloud2PubSubType.write(data, cdr);
    }

    public void deserialize(PointCloud2 data, CDR cdr) {
        PointCloud2PubSubType.read(data, cdr);
    }

    public void copy(PointCloud2 src, PointCloud2 dest) {
        PointCloud2PubSubType.staticCopy(src, dest);
    }

    public PointCloud2PubSubType newInstance() {
        return new PointCloud2PubSubType();
    }
}

