/*
 * Decompiled with CFR 0.152.
 */
package nav_msgs.msg.dds;

import builtin_interfaces.msg.dds.Time;
import builtin_interfaces.msg.dds.TimePubSubType;
import geometry_msgs.msg.dds.PosePubSubType;
import java.util.function.Supplier;
import nav_msgs.msg.dds.MapMetaDataPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class MapMetaData
extends Packet<MapMetaData>
implements Settable<MapMetaData>,
EpsilonComparable<MapMetaData> {
    public Time map_load_time_ = new Time();
    public float resolution_;
    public long width_;
    public long height_;
    public Pose3D origin_ = new Pose3D();

    public MapMetaData() {
    }

    public MapMetaData(MapMetaData other) {
        this();
        this.set(other);
    }

    public void set(MapMetaData other) {
        TimePubSubType.staticCopy(other.map_load_time_, this.map_load_time_);
        this.resolution_ = other.resolution_;
        this.width_ = other.width_;
        this.height_ = other.height_;
        PosePubSubType.staticCopy(other.origin_, this.origin_);
    }

    public Time getMapLoadTime() {
        return this.map_load_time_;
    }

    public void setResolution(float resolution) {
        this.resolution_ = resolution;
    }

    public float getResolution() {
        return this.resolution_;
    }

    public void setWidth(long width) {
        this.width_ = width;
    }

    public long getWidth() {
        return this.width_;
    }

    public void setHeight(long height) {
        this.height_ = height;
    }

    public long getHeight() {
        return this.height_;
    }

    public Pose3D getOrigin() {
        return this.origin_;
    }

    public static Supplier<MapMetaDataPubSubType> getPubSubType() {
        return MapMetaDataPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return MapMetaDataPubSubType::new;
    }

    public boolean epsilonEquals(MapMetaData other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.map_load_time_.epsilonEquals(other.map_load_time_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.resolution_, (double)other.resolution_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.width_, (double)other.width_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.height_, (double)other.height_, (double)epsilon)) {
            return false;
        }
        return this.origin_.epsilonEquals(other.origin_, epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof MapMetaData)) {
            return false;
        }
        MapMetaData otherMyClass = (MapMetaData)((Object)other);
        if (!this.map_load_time_.equals((Object)otherMyClass.map_load_time_)) {
            return false;
        }
        if (this.resolution_ != otherMyClass.resolution_) {
            return false;
        }
        if (this.width_ != otherMyClass.width_) {
            return false;
        }
        if (this.height_ != otherMyClass.height_) {
            return false;
        }
        return this.origin_.equals((Pose3DReadOnly)otherMyClass.origin_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MapMetaData {");
        builder.append("map_load_time=");
        builder.append((Object)this.map_load_time_);
        builder.append(", ");
        builder.append("resolution=");
        builder.append(this.resolution_);
        builder.append(", ");
        builder.append("width=");
        builder.append(this.width_);
        builder.append(", ");
        builder.append("height=");
        builder.append(this.height_);
        builder.append(", ");
        builder.append("origin=");
        builder.append(this.origin_);
        builder.append("}");
        return builder.toString();
    }
}

