/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public interface WrenchReadOnly
extends SpatialForceReadOnly {
    public ReferenceFrame getBodyFrame();

    default public double dot(TwistReadOnly twist) {
        return twist.dot(this);
    }

    default public void checkReferenceFrameMatch(WrenchReadOnly other) throws ReferenceFrameMismatchException {
        this.checkReferenceFrameMatch(other.getBodyFrame(), other.getReferenceFrame());
    }

    default public void checkReferenceFrameMatch(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) throws ReferenceFrameMismatchException {
        this.checkBodyFrameMatch(bodyFrame);
        this.checkExpressedInFrameMatch(expressedInFrame);
    }

    default public void checkBodyFrameMatch(ReferenceFrame bodyFrame) {
        if (this.getBodyFrame() != bodyFrame) {
            throw new ReferenceFrameMismatchException("bodyFrame mismatch: this.bodyFrame = " + String.valueOf(this.getBodyFrame()) + ", other bodyFrame = " + String.valueOf(bodyFrame));
        }
    }

    default public void checkExpressedInFrameMatch(ReferenceFrame expressedInFrame) {
        if (this.getReferenceFrame() != expressedInFrame) {
            throw new ReferenceFrameMismatchException("expressedInFrame mismatch: this.expressedInFrame = " + String.valueOf(this.getReferenceFrame()) + ", other expressedInFrame = " + String.valueOf(expressedInFrame));
        }
    }

    default public boolean epsilonEquals(WrenchReadOnly other, double epsilon) {
        if (this.getBodyFrame() != other.getBodyFrame()) {
            return false;
        }
        return SpatialForceReadOnly.super.epsilonEquals(other, epsilon);
    }

    default public boolean geometricallyEquals(WrenchReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        if (!this.getAngularPart().geometricallyEquals((EuclidFrameGeometry)this.getAngularPart(), epsilon)) {
            return false;
        }
        return this.getLinearPart().geometricallyEquals((EuclidFrameGeometry)this.getLinearPart(), epsilon);
    }

    default public boolean equals(WrenchReadOnly other) {
        if (other == null) {
            return false;
        }
        if (this.getBodyFrame() != other.getBodyFrame()) {
            return false;
        }
        return SpatialForceReadOnly.super.equals(other);
    }
}

