/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.iterators;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.IteratorSearchMode;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class RigidBodyIterator<B extends RigidBodyReadOnly>
implements Iterator<B> {
    private final Deque<RigidBodyReadOnly> stack = new ArrayDeque<RigidBodyReadOnly>();
    private final Predicate<RigidBodyReadOnly> selectionRule;
    private final List<RigidBodyReadOnly> roots = new ArrayList<RigidBodyReadOnly>();
    private final IteratorSearchMode mode;
    private B next = null;
    private boolean hasNextHasBeenCalled = false;

    public RigidBodyIterator(Class<B> filteringClass, Predicate<B> selectionRule, IteratorSearchMode mode, RigidBodyReadOnly root) {
        this(filteringClass, selectionRule, mode, Collections.singletonList(root));
    }

    public RigidBodyIterator(Class<B> filteringClass, Predicate<B> selectionRule, IteratorSearchMode mode, Collection<? extends RigidBodyReadOnly> roots) {
        this.selectionRule = selectionRule == null ? body -> filteringClass.isInstance(body) : body -> filteringClass.isInstance(body) && selectionRule.test(body);
        this.mode = mode == null ? IteratorSearchMode.DEPTH_FIRST_SEARCH : mode;
        if (roots != null) {
            this.stack.addAll(roots);
            this.roots.addAll(roots);
        }
    }

    @Override
    public boolean hasNext() {
        this.next = null;
        if (this.stack.isEmpty()) {
            return false;
        }
        if (!this.hasNextHasBeenCalled) {
            this.next = this.searchNextRigidBodyPassingRule();
            this.hasNextHasBeenCalled = true;
        }
        return this.next != null;
    }

    @Override
    public B next() {
        if (!this.hasNextHasBeenCalled && !this.hasNext()) {
            throw new NullPointerException();
        }
        this.hasNextHasBeenCalled = false;
        B ret = this.next;
        this.next = null;
        return ret;
    }

    private B searchNextRigidBodyPassingRule() {
        while (!this.stack.isEmpty()) {
            RigidBodyReadOnly currentBody = this.searchNextRigidBody();
            if (currentBody == null || !this.selectionRule.test(currentBody)) continue;
            return (B)currentBody;
        }
        return null;
    }

    private RigidBodyReadOnly searchNextRigidBody() {
        RigidBodyReadOnly currentBody = this.stack.poll();
        List<? extends JointReadOnly> childrenJoints = currentBody.getChildrenJoints();
        if (childrenJoints != null) {
            switch (this.mode) {
                case DEPTH_FIRST_SEARCH: {
                    for (int i = childrenJoints.size() - 1; i >= 0; --i) {
                        this.addJointToStack(childrenJoints.get(i), false);
                    }
                    break;
                }
                case BREADTH_FIRST_SEARCH: {
                    for (int i = 0; i < childrenJoints.size(); ++i) {
                        this.addJointToStack(childrenJoints.get(i), true);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)this.mode));
                }
            }
        }
        return currentBody;
    }

    private void addJointToStack(JointReadOnly joint, boolean addLast) {
        RigidBodyReadOnly body = joint.getSuccessor();
        boolean registerBody = true;
        if (joint.isLoopClosure()) {
            for (int rootIndex = 0; rootIndex < this.roots.size(); ++rootIndex) {
                if (!MultiBodySystemTools.isAncestor(body, this.roots.get(rootIndex))) continue;
                registerBody = false;
            }
        }
        if (registerBody) {
            if (addLast) {
                this.stack.addLast(body);
            } else {
                this.stack.addFirst(body);
            }
        }
    }
}

