/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.iterators;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.IteratorSearchMode;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class JointIterator<J extends JointReadOnly>
implements Iterator<J> {
    private final Deque<JointReadOnly> stack = new ArrayDeque<JointReadOnly>();
    private final Predicate<JointReadOnly> selectionRule;
    private final List<JointReadOnly> roots = new ArrayList<JointReadOnly>();
    private final IteratorSearchMode mode;
    private J next = null;
    private boolean hasNextHasBeenCalled = false;

    public JointIterator(Class<J> filteringClass, Predicate<J> selectionRule, IteratorSearchMode mode, JointReadOnly root) {
        this(filteringClass, selectionRule, mode, Collections.singleton(root));
    }

    public JointIterator(Class<J> filteringClass, Predicate<J> selectionRule, IteratorSearchMode mode, Collection<? extends JointReadOnly> roots) {
        this.selectionRule = selectionRule == null ? joint -> filteringClass.isInstance(joint) : joint -> filteringClass.isInstance(joint) && selectionRule.test(joint);
        this.mode = mode == null ? IteratorSearchMode.DEPTH_FIRST_SEARCH : mode;
        if (roots != null) {
            this.stack.addAll(roots);
            this.roots.addAll(roots);
        }
    }

    @Override
    public boolean hasNext() {
        this.next = null;
        if (this.stack.isEmpty()) {
            return false;
        }
        if (!this.hasNextHasBeenCalled) {
            this.next = this.searchNextJointPassingRule();
            this.hasNextHasBeenCalled = true;
        }
        return this.next != null;
    }

    @Override
    public J next() {
        if (!this.hasNextHasBeenCalled && !this.hasNext()) {
            throw new NullPointerException();
        }
        this.hasNextHasBeenCalled = false;
        J ret = this.next;
        this.next = null;
        return ret;
    }

    private J searchNextJointPassingRule() {
        while (!this.stack.isEmpty()) {
            JointReadOnly currentJoint = this.searchNextJoint();
            if (currentJoint == null || !this.selectionRule.test(currentJoint)) continue;
            return (J)currentJoint;
        }
        return null;
    }

    private JointReadOnly searchNextJoint() {
        List<? extends JointReadOnly> childrenJoints;
        JointReadOnly currentJoint = this.stack.poll();
        RigidBodyReadOnly successor = currentJoint.getSuccessor();
        if (currentJoint.isLoopClosure()) {
            for (int rootIndex = 0; rootIndex < this.roots.size(); ++rootIndex) {
                if (!MultiBodySystemTools.isAncestor(successor, this.roots.get(rootIndex).getSuccessor())) continue;
                return currentJoint;
            }
        }
        if (successor != null && (childrenJoints = successor.getChildrenJoints()) != null) {
            switch (this.mode) {
                case DEPTH_FIRST_SEARCH: {
                    for (int i = childrenJoints.size() - 1; i >= 0; --i) {
                        this.stack.offerFirst(childrenJoints.get(i));
                    }
                    break;
                }
                case BREADTH_FIRST_SEARCH: {
                    this.stack.addAll(childrenJoints);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)this.mode));
                }
            }
        }
        return currentJoint;
    }
}

