/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.mecano.algorithms.ArticulatedBodyInertiaAlorigthmTools;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.tools.MecanoTools;

public class ArticulatedBodyInertia
implements Settable<ArticulatedBodyInertia>,
ReferenceFrameHolder,
FrameChangeable,
Clearable {
    private ReferenceFrame expressedInFrame = null;
    private final Matrix3D angularInertia = new Matrix3D();
    private final Matrix3D linearInertia = new Matrix3D();
    private final Matrix3D crossInertia = new Matrix3D();
    private final Matrix3DReadOnly crossInertiaTranspose = EuclidCoreFactories.newTransposeLinkedMatrix3DReadOnly((Matrix3DReadOnly)this.crossInertia);
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public ArticulatedBodyInertia() {
    }

    public ArticulatedBodyInertia(ReferenceFrame expressedInFrame) {
        this.setToZero(expressedInFrame);
    }

    public ArticulatedBodyInertia(ArticulatedBodyInertia other) {
        this.setIncludingFrame(other);
    }

    public void setReferenceFrame(ReferenceFrame expressedInFrame) {
        this.expressedInFrame = expressedInFrame;
    }

    public boolean containsNaN() {
        return this.angularInertia.containsNaN() || this.linearInertia.containsNaN() || this.crossInertia.containsNaN();
    }

    public void setToNaN() {
        this.angularInertia.setToNaN();
        this.linearInertia.setToNaN();
        this.crossInertia.setToNaN();
    }

    public void setToNaN(ReferenceFrame expressedInFrame) {
        this.setReferenceFrame(expressedInFrame);
        this.setToNaN();
    }

    public void setToZero() {
        this.angularInertia.setToZero();
        this.linearInertia.setToZero();
        this.crossInertia.setToZero();
    }

    public void setToZero(ReferenceFrame expressedInFrame) {
        this.setReferenceFrame(expressedInFrame);
        this.setToZero();
    }

    public void set(ArticulatedBodyInertia other) {
        this.checkReferenceFrameMatch(other);
        this.angularInertia.set(other.getAngularInertia());
        this.linearInertia.set(other.getLinearInertia());
        this.crossInertia.set(other.getCrossInertia());
    }

    public void setIncludingFrame(ArticulatedBodyInertia other) {
        this.setReferenceFrame(other.expressedInFrame);
        this.angularInertia.set(other.getAngularInertia());
        this.linearInertia.set(other.getLinearInertia());
        this.crossInertia.set(other.getCrossInertia());
    }

    public void setIncludingFrame(SpatialInertiaReadOnly spatialInertiaReadOnly) {
        this.expressedInFrame = spatialInertiaReadOnly.getReferenceFrame();
        this.angularInertia.set(spatialInertiaReadOnly.getMomentOfInertia());
        this.linearInertia.setToZero();
        this.linearInertia.setM00(spatialInertiaReadOnly.getMass());
        this.linearInertia.setM11(spatialInertiaReadOnly.getMass());
        this.linearInertia.setM22(spatialInertiaReadOnly.getMass());
        this.crossInertia.setToTildeForm((Tuple3DReadOnly)spatialInertiaReadOnly.getCenterOfMassOffset());
        this.crossInertia.scale(spatialInertiaReadOnly.getMass());
    }

    public void add(ArticulatedBodyInertia other) {
        this.checkReferenceFrameMatch(other);
        this.angularInertia.add((Matrix3DReadOnly)other.getAngularInertia());
        this.linearInertia.add((Matrix3DReadOnly)other.getLinearInertia());
        this.crossInertia.add((Matrix3DReadOnly)other.getCrossInertia());
    }

    public void add(DMatrix matrix) {
        MecanoTools.addEquals(0, 0, matrix, (Matrix3DBasics)this.angularInertia);
        MecanoTools.addEquals(3, 3, matrix, (Matrix3DBasics)this.linearInertia);
        MecanoTools.addEquals(0, 3, matrix, (Matrix3DBasics)this.crossInertia);
    }

    public void sub(ArticulatedBodyInertia other) {
        this.checkReferenceFrameMatch(other);
        this.angularInertia.sub((Matrix3DReadOnly)other.getAngularInertia());
        this.linearInertia.sub((Matrix3DReadOnly)other.getLinearInertia());
        this.crossInertia.sub((Matrix3DReadOnly)other.getCrossInertia());
    }

    public void sub(DMatrix matrix) {
        MecanoTools.subEquals(0, 0, matrix, (Matrix3DBasics)this.angularInertia);
        MecanoTools.subEquals(3, 3, matrix, (Matrix3DBasics)this.linearInertia);
        MecanoTools.subEquals(0, 3, matrix, (Matrix3DBasics)this.crossInertia);
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.getReferenceFrame()) {
            return;
        }
        this.getReferenceFrame().getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform(this.transformToDesiredFrame);
        this.setReferenceFrame(desiredFrame);
    }

    public Matrix3D getAngularInertia() {
        return this.angularInertia;
    }

    public Matrix3D getLinearInertia() {
        return this.linearInertia;
    }

    public Matrix3D getCrossInertia() {
        return this.crossInertia;
    }

    public Matrix3DReadOnly getCrossInertiaTranspose() {
        return this.crossInertiaTranspose;
    }

    public void get(DMatrix matrixToPack) {
        this.angularInertia.get(0, 0, matrixToPack);
        this.linearInertia.get(3, 3, matrixToPack);
        this.crossInertia.get(0, 3, matrixToPack);
        this.crossInertiaTranspose.get(3, 0, matrixToPack);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.expressedInFrame;
    }

    public void applyTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransform)) {
            throw new UnsupportedOperationException("The feature applyTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyTransform((RigidBodyTransform)transform);
    }

    public void applyInverseTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransform)) {
            throw new UnsupportedOperationException("The feature applyInverseTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyInverseTransform((RigidBodyTransform)transform);
    }

    public void applyTransform(RigidBodyTransform transform) {
        if (transform.hasRotation()) {
            RotationMatrixBasics rotationMatrix = transform.getRotation();
            MecanoTools.transformSymmetricMatrix3D((RotationMatrixReadOnly)rotationMatrix, (Matrix3DBasics)this.angularInertia);
            MecanoTools.transformSymmetricMatrix3D((RotationMatrixReadOnly)rotationMatrix, (Matrix3DBasics)this.linearInertia);
            rotationMatrix.transform((Matrix3DBasics)this.crossInertia);
        }
        if (transform.hasTranslation()) {
            Vector3DBasics translationVector = transform.getTranslation();
            ArticulatedBodyInertiaAlorigthmTools.translateAngularInertia(false, (Tuple3DReadOnly)translationVector, (Matrix3DReadOnly)this.linearInertia, (Matrix3DReadOnly)this.crossInertia, (Matrix3DBasics)this.angularInertia);
            ArticulatedBodyInertiaAlorigthmTools.translateCrossInertia(false, (Tuple3DReadOnly)translationVector, (Matrix3DReadOnly)this.linearInertia, (Matrix3DBasics)this.crossInertia);
        }
    }

    public void applyInverseTransform(RigidBodyTransform transform) {
        if (transform.hasTranslation()) {
            Vector3DBasics translationVector = transform.getTranslation();
            ArticulatedBodyInertiaAlorigthmTools.translateAngularInertia(true, (Tuple3DReadOnly)translationVector, (Matrix3DReadOnly)this.linearInertia, (Matrix3DReadOnly)this.crossInertia, (Matrix3DBasics)this.angularInertia);
            ArticulatedBodyInertiaAlorigthmTools.translateCrossInertia(true, (Tuple3DReadOnly)translationVector, (Matrix3DReadOnly)this.linearInertia, (Matrix3DBasics)this.crossInertia);
        }
        if (transform.hasRotation()) {
            RotationMatrixBasics rotationMatrix = transform.getRotation();
            MecanoTools.inverseTransformSymmetricMatrix3D((RotationMatrixReadOnly)rotationMatrix, (Matrix3DBasics)this.angularInertia);
            MecanoTools.inverseTransformSymmetricMatrix3D((RotationMatrixReadOnly)rotationMatrix, (Matrix3DBasics)this.linearInertia);
            rotationMatrix.inverseTransform((Matrix3DBasics)this.crossInertia);
        }
    }

    public boolean epsilonEquals(ArticulatedBodyInertia other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        if (!this.getAngularInertia().epsilonEquals((EuclidGeometry)other.getAngularInertia(), epsilon)) {
            return false;
        }
        if (!this.getLinearInertia().epsilonEquals((EuclidGeometry)other.getLinearInertia(), epsilon)) {
            return false;
        }
        return this.getCrossInertia().epsilonEquals((EuclidGeometry)other.getCrossInertia(), epsilon);
    }

    public boolean geometricallyEquals(ArticulatedBodyInertia other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return this.epsilonEquals(other, epsilon);
    }

    public String toString() {
        DMatrixRMaj matrix = new DMatrixRMaj(6, 6);
        this.get((DMatrix)matrix);
        return "Articulated-body inertia expressed in " + String.valueOf(this.expressedInFrame) + "\n" + MecanoIOTools.getDMatrixString((DMatrix)matrix);
    }
}

