/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;

public class CenterOfMassCalculator
implements ReferenceFrameHolder {
    private final ReferenceFrame referenceFrame;
    private final MultiBodySystemReadOnly input;
    private final RigidBodyReadOnly[] rigidBodies;
    private double totalMass;
    private final FramePoint3D centerOfMass = new FramePoint3D();
    private final FramePoint3D tempPoint = new FramePoint3D();
    private boolean isCenterOfMassUpToDate = false;

    public CenterOfMassCalculator(RigidBodyReadOnly rootBody, ReferenceFrame referenceFrame) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody), referenceFrame);
    }

    public CenterOfMassCalculator(MultiBodySystemReadOnly input, ReferenceFrame referenceFrame) {
        this.input = input;
        this.rigidBodies = (RigidBodyReadOnly[])input.getJointsToConsider().stream().map(JointReadOnly::getSuccessor).distinct().toArray(RigidBodyReadOnly[]::new);
        this.referenceFrame = referenceFrame;
    }

    public void reset() {
        this.isCenterOfMassUpToDate = false;
    }

    private void updateCenterOfMass() {
        if (this.isCenterOfMassUpToDate) {
            return;
        }
        this.centerOfMass.setToZero(this.referenceFrame);
        this.totalMass = 0.0;
        for (RigidBodyReadOnly rigidBody : this.rigidBodies) {
            SpatialInertiaReadOnly inertia = rigidBody.getInertia();
            this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)inertia.getCenterOfMassOffset());
            double mass = inertia.getMass();
            this.tempPoint.changeFrame(this.referenceFrame);
            this.tempPoint.scale(mass);
            this.centerOfMass.add((FrameTuple3DReadOnly)this.tempPoint);
            this.totalMass += mass;
        }
        this.centerOfMass.scale(1.0 / this.totalMass);
        this.isCenterOfMassUpToDate = true;
    }

    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    public double getTotalMass() {
        this.updateCenterOfMass();
        return this.totalMass;
    }

    public FramePoint3DReadOnly getCenterOfMass() {
        this.updateCenterOfMass();
        return this.centerOfMass;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }
}

