/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.ops.MatrixFeatures_D;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;

public class MecanoTestTools {
    private static final String DEFAULT_FORMAT = EuclidCoreIOTools.getStringFormat((int)15, (int)12);

    public static void assertSpatialVectorEquals(SpatialVectorReadOnly expected, SpatialVectorReadOnly actual, double epsilon) {
        MecanoTestTools.assertSpatialVectorEquals(null, expected, actual, epsilon);
    }

    public static void assertSpatialVectorEquals(String messagePrefix, SpatialVectorReadOnly expected, SpatialVectorReadOnly actual, double epsilon) {
        MecanoTestTools.assertSpatialVectorEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertSpatialVectorEquals(String messagePrefix, SpatialVectorReadOnly expected, SpatialVectorReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertSpatialForceEquals(SpatialForceReadOnly expected, SpatialForceReadOnly actual, double epsilon) {
        MecanoTestTools.assertSpatialForceEquals(null, expected, actual, epsilon);
    }

    public static void assertSpatialForceEquals(String messagePrefix, SpatialForceReadOnly expected, SpatialForceReadOnly actual, double epsilon) {
        MecanoTestTools.assertSpatialForceEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertSpatialForceEquals(String messagePrefix, SpatialForceReadOnly expected, SpatialForceReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertWrenchEquals(WrenchReadOnly expected, WrenchReadOnly actual, double epsilon) {
        MecanoTestTools.assertWrenchEquals(null, expected, actual, epsilon);
    }

    public static void assertWrenchEquals(String messagePrefix, WrenchReadOnly expected, WrenchReadOnly actual, double epsilon) {
        MecanoTestTools.assertWrenchEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertWrenchEquals(String messagePrefix, WrenchReadOnly expected, WrenchReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertTwistEquals(TwistReadOnly expected, TwistReadOnly actual, double epsilon) {
        MecanoTestTools.assertTwistEquals(null, expected, actual, epsilon);
    }

    public static void assertTwistEquals(String messagePrefix, TwistReadOnly expected, TwistReadOnly actual, double epsilon) {
        MecanoTestTools.assertTwistEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertTwistEquals(String messagePrefix, TwistReadOnly expected, TwistReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertSpatialAccelerationEquals(SpatialAccelerationReadOnly expected, SpatialAccelerationReadOnly actual, double epsilon) {
        MecanoTestTools.assertSpatialAccelerationEquals(null, expected, actual, epsilon);
    }

    public static void assertSpatialAccelerationEquals(String messagePrefix, SpatialAccelerationReadOnly expected, SpatialAccelerationReadOnly actual, double epsilon) {
        MecanoTestTools.assertSpatialAccelerationEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertSpatialAccelerationEquals(String messagePrefix, SpatialAccelerationReadOnly expected, SpatialAccelerationReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertMomentumEquals(MomentumReadOnly expected, MomentumReadOnly actual, double epsilon) {
        MecanoTestTools.assertMomentumEquals(null, expected, actual, epsilon);
    }

    public static void assertMomentumEquals(String messagePrefix, MomentumReadOnly expected, MomentumReadOnly actual, double epsilon) {
        MecanoTestTools.assertMomentumEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertMomentumEquals(String messagePrefix, MomentumReadOnly expected, MomentumReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertSpatialInertiaEquals(SpatialInertiaReadOnly expected, SpatialInertiaReadOnly actual, double epsilon) {
        MecanoTestTools.assertSpatialInertiaEquals(null, expected, actual, epsilon);
    }

    public static void assertSpatialInertiaEquals(String messagePrefix, SpatialInertiaReadOnly expected, SpatialInertiaReadOnly actual, double epsilon) {
        MecanoTestTools.assertSpatialInertiaEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertSpatialInertiaEquals(String messagePrefix, SpatialInertiaReadOnly expected, SpatialInertiaReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertDMatrixEquals(DMatrix expected, DMatrix actual, double epsilon) {
        MecanoTestTools.assertDMatrixEquals(null, expected, actual, epsilon);
    }

    public static void assertDMatrixEquals(String messagePrefix, DMatrix expected, DMatrix actual, double epsilon) {
        boolean equal;
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected == null ? "null" : expected.toString(), actual == null ? "null" : actual.toString());
        }
        if (!(equal = expected instanceof DMatrixD1 && actual instanceof DMatrixD1 ? MatrixFeatures_DDRM.isEquals((DMatrixD1)((DMatrixD1)expected), (DMatrixD1)((DMatrixD1)actual), (double)epsilon) : MatrixFeatures_D.isIdentical((DMatrix)expected, (DMatrix)actual, (double)epsilon))) {
            if (expected.getNumRows() != actual.getNumRows() || expected.getNumCols() != actual.getNumCols()) {
                MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected.toString(), actual.toString());
            } else {
                double max = 0.0;
                DMatrixRMaj difference = new DMatrixRMaj(expected.getNumRows(), expected.getNumCols());
                for (int row = 0; row < expected.getNumRows(); ++row) {
                    for (int col = 0; col < expected.getNumCols(); ++col) {
                        double diff = expected.unsafe_get(row, col) - actual.unsafe_get(row, col);
                        difference.unsafe_set(row, col, diff);
                        max = Math.max(max, Math.abs(diff));
                    }
                }
                MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expected.toString(), actual.toString(), difference.toString() + "\nMax difference of: " + max);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertExceptionIsThrown(Runnable runnable, Class<? extends Exception> expectedExceptionType) {
        block6: {
            Exception exceptionCaught = null;
            try {
                runnable.run();
            }
            catch (Exception e) {
                exceptionCaught = e;
            }
            finally {
                if (exceptionCaught == null) {
                    throw new AssertionError((Object)"The operation should have thrown an exception.");
                }
                if (exceptionCaught.getClass().equals(expectedExceptionType)) break block6;
                throw new AssertionError((Object)("Unexpected exception: expected = " + expectedExceptionType.getSimpleName() + ", actual = " + exceptionCaught.getClass().getSimpleName()));
            }
        }
    }

    private static void throwNotEqualAssertionError(String messagePrefix, SpatialVectorReadOnly expected, SpatialVectorReadOnly actual, String format) {
        String expectedAsString = MecanoIOTools.getSpatialVectorString(format, expected);
        String actualAsString = MecanoIOTools.getSpatialVectorString(format, actual);
        MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString, Double.toString(MecanoTestTools.computeNormError(expected, actual)));
    }

    private static void throwNotEqualAssertionError(String messagePrefix, SpatialForceReadOnly expected, SpatialForceReadOnly actual, String format) {
        String expectedAsString = MecanoIOTools.getSpatialForceString(format, expected);
        String actualAsString = MecanoIOTools.getSpatialForceString(format, actual);
        MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString, Double.toString(MecanoTestTools.computeNormError(expected, actual)));
    }

    private static void throwNotEqualAssertionError(String messagePrefix, WrenchReadOnly expected, WrenchReadOnly actual, String format) {
        String expectedAsString = MecanoIOTools.getWrenchString(format, expected);
        String actualAsString = MecanoIOTools.getWrenchString(format, actual);
        MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString, Double.toString(MecanoTestTools.computeNormError(expected, actual)));
    }

    private static void throwNotEqualAssertionError(String messagePrefix, TwistReadOnly expected, TwistReadOnly actual, String format) {
        String expectedAsString = MecanoIOTools.getTwistString(format, expected);
        String actualAsString = MecanoIOTools.getTwistString(format, actual);
        MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString, Double.toString(MecanoTestTools.computeNormError(expected, actual)));
    }

    private static void throwNotEqualAssertionError(String messagePrefix, SpatialAccelerationReadOnly expected, SpatialAccelerationReadOnly actual, String format) {
        String expectedAsString = MecanoIOTools.getSpatialAccelerationString(format, expected);
        String actualAsString = MecanoIOTools.getSpatialAccelerationString(format, actual);
        MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString, Double.toString(MecanoTestTools.computeNormError(expected, actual)));
    }

    private static void throwNotEqualAssertionError(String messagePrefix, MomentumReadOnly expected, MomentumReadOnly actual, String format) {
        String expectedAsString = MecanoIOTools.getMomentumString(format, expected);
        String actualAsString = MecanoIOTools.getMomentumString(format, actual);
        MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString, Double.toString(MecanoTestTools.computeNormError(expected, actual)));
    }

    private static void throwNotEqualAssertionError(String messagePrefix, SpatialInertiaReadOnly expected, SpatialInertiaReadOnly actual, String format) {
        String expectedAsString = MecanoIOTools.getSpatialInertiaString(format, expected);
        String actualAsString = MecanoIOTools.getSpatialInertiaString(format, actual);
        MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, String expectedAsString, String actualAsString) {
        MecanoTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString, null);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, String expectedAsString, String actualAsString, String differenceAsString) {
        Object errorMessage = MecanoTestTools.addPrefixToMessage(messagePrefix, "expected:\n" + expectedAsString + "\n but was:\n" + actualAsString);
        if (differenceAsString != null) {
            errorMessage = (String)errorMessage + "\nDifference of: " + differenceAsString;
        }
        throw new AssertionError(errorMessage);
    }

    private static String addPrefixToMessage(String prefix, String message) {
        if (prefix != null && !prefix.isEmpty()) {
            return prefix + " " + message;
        }
        return message;
    }

    private static double computeNormError(SpatialVectorReadOnly expected, SpatialVectorReadOnly actual) {
        if (expected == null || actual == null) {
            return Double.NaN;
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            return Double.NaN;
        }
        SpatialVector spatialError = new SpatialVector(expected);
        if (expected.getReferenceFrame() == null || actual.getReferenceFrame() == null) {
            spatialError.sub((Vector3DReadOnly)actual.getAngularPart(), (Vector3DReadOnly)expected.getLinearPart());
        } else {
            spatialError.sub(actual);
        }
        return spatialError.length();
    }
}

