/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.FixedJoint;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.PlanarJoint;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.SphericalJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MultiBodySystemRandomTools {
    public static void nextState(Random random, JointStateType stateToRandomize, JointBasics joint) {
        switch (stateToRandomize) {
            case CONFIGURATION: {
                joint.setJointOrientation((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
                joint.setJointPosition((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                break;
            }
            case VELOCITY: {
                joint.setJointAngularVelocity((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                joint.setJointLinearVelocity((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                break;
            }
            case ACCELERATION: {
                joint.setJointAngularAcceleration((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                joint.setJointLinearAcceleration((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                break;
            }
            case EFFORT: {
                joint.setJointTorque((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                joint.setJointForce((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                break;
            }
            default: {
                throw new RuntimeException("Unhandled state selection: " + stateToRandomize);
            }
        }
    }

    public static void nextState(Random random, JointStateType stateToRandomize, JointBasics[] joints) {
        for (JointBasics joint : joints) {
            MultiBodySystemRandomTools.nextState(random, stateToRandomize, joint);
        }
    }

    public static void nextState(Random random, JointStateType stateToRandomize, Iterable<? extends JointBasics> joints) {
        joints.forEach(joint -> MultiBodySystemRandomTools.nextState(random, stateToRandomize, joint));
    }

    public static void nextState(Random random, JointStateType stateToRandomize, double min, double max, OneDoFJointBasics joint) {
        switch (stateToRandomize) {
            case CONFIGURATION: {
                joint.setQ(EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max));
                break;
            }
            case VELOCITY: {
                joint.setQd(EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max));
                break;
            }
            case ACCELERATION: {
                joint.setQdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max));
                break;
            }
            case EFFORT: {
                joint.setTau(EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max));
                break;
            }
            default: {
                throw new RuntimeException("Unhandled state selection: " + stateToRandomize);
            }
        }
    }

    public static void nextStateWithinJointLimits(Random random, JointStateType stateToRandomize, OneDoFJointBasics[] joints) {
        for (OneDoFJointBasics joint : joints) {
            MultiBodySystemRandomTools.nextStateWithinJointLimits(random, stateToRandomize, joint);
        }
    }

    public static void nextStateWithinJointLimits(Random random, JointStateType stateToRandomize, Iterable<? extends OneDoFJointBasics> joints) {
        joints.forEach(joint -> MultiBodySystemRandomTools.nextStateWithinJointLimits(random, stateToRandomize, joint));
    }

    public static void nextStateWithinJointLimits(Random random, JointStateType stateToRandomize, OneDoFJointBasics joint) {
        switch (stateToRandomize) {
            case CONFIGURATION: {
                joint.setQ(EuclidCoreRandomTools.nextDouble((Random)random, (double)joint.getJointLimitLower(), (double)joint.getJointLimitUpper()));
                break;
            }
            case VELOCITY: {
                joint.setQd(EuclidCoreRandomTools.nextDouble((Random)random, (double)joint.getVelocityLimitLower(), (double)joint.getVelocityLimitUpper()));
                break;
            }
            case EFFORT: {
                joint.setTau(EuclidCoreRandomTools.nextDouble((Random)random, (double)joint.getEffortLimitLower(), (double)joint.getEffortLimitUpper()));
                break;
            }
            default: {
                throw new RuntimeException("Unhandled state selection: " + stateToRandomize);
            }
        }
    }

    public static void nextState(Random random, JointStateType stateToRandomize, double min, double max, OneDoFJointBasics[] joints) {
        for (OneDoFJointBasics joint : joints) {
            MultiBodySystemRandomTools.nextState(random, stateToRandomize, min, max, joint);
        }
    }

    public static void nextState(Random random, JointStateType stateToRandomize, double min, double max, Iterable<? extends OneDoFJointBasics> joints) {
        joints.forEach(joint -> MultiBodySystemRandomTools.nextState(random, stateToRandomize, min, max, joint));
    }

    public static List<PrismaticJoint> nextPrismaticJointChain(Random random, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextPrismaticJointChain(random, "", numberOfJoints);
    }

    public static List<PrismaticJoint> nextPrismaticJointChain(Random random, String prefix, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextPrismaticJointChain(random, prefix, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray(random, numberOfJoints, 1.0));
    }

    public static List<PrismaticJoint> nextPrismaticJointChain(Random random, String prefix, Vector3DReadOnly[] jointAxes) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody rootBody = new RigidBody(prefix + "RootBody", worldFrame);
        return MultiBodySystemRandomTools.nextPrismaticJointChain(random, prefix, (RigidBodyBasics)rootBody, jointAxes);
    }

    public static List<PrismaticJoint> nextPrismaticJointChain(Random random, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextPrismaticJointChain(random, "", rootBody, numberOfJoints);
    }

    public static List<PrismaticJoint> nextPrismaticJointChain(Random random, String prefix, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextPrismaticJointChain(random, prefix, rootBody, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray(random, numberOfJoints, 1.0));
    }

    public static List<PrismaticJoint> nextPrismaticJointChain(Random random, String prefix, RigidBodyBasics rootBody, Vector3DReadOnly[] jointAxes) {
        RigidBodyBasics predecessor = rootBody;
        ArrayList<PrismaticJoint> prismaticJoints = new ArrayList<PrismaticJoint>();
        for (int i = 0; i < jointAxes.length; ++i) {
            PrismaticJoint joint = MultiBodySystemRandomTools.nextPrismaticJoint(random, prefix + "Joint" + i, jointAxes[i], predecessor);
            prismaticJoints.add(joint);
            predecessor = MultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
        }
        return prismaticJoints;
    }

    public static List<RevoluteJoint> nextRevoluteJointChain(Random random, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextRevoluteJointChain(random, "", numberOfJoints);
    }

    public static List<RevoluteJoint> nextRevoluteJointChain(Random random, String prefix, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextRevoluteJointChain(random, prefix, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray(random, numberOfJoints, 1.0));
    }

    public static List<RevoluteJoint> nextRevoluteJointChain(Random random, String prefix, Vector3DReadOnly[] jointAxes) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody rootBody = new RigidBody(prefix + "RootBody", worldFrame);
        return MultiBodySystemRandomTools.nextRevoluteJointChain(random, prefix, (RigidBodyBasics)rootBody, jointAxes);
    }

    public static List<RevoluteJoint> nextRevoluteJointChain(Random random, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextRevoluteJointChain(random, "", rootBody, numberOfJoints);
    }

    public static List<RevoluteJoint> nextRevoluteJointChain(Random random, String prefix, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextRevoluteJointChain(random, prefix, rootBody, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray(random, numberOfJoints, 1.0));
    }

    public static List<RevoluteJoint> nextRevoluteJointChain(Random random, String prefix, RigidBodyBasics rootBody, Vector3DReadOnly[] jointAxes) {
        RigidBodyBasics predecessor = rootBody;
        ArrayList<RevoluteJoint> revoluteJoints = new ArrayList<RevoluteJoint>();
        for (int i = 0; i < jointAxes.length; ++i) {
            RevoluteJoint joint = MultiBodySystemRandomTools.nextRevoluteJoint(random, prefix + "Joint" + i, jointAxes[i], predecessor);
            revoluteJoints.add(joint);
            predecessor = MultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
        }
        return revoluteJoints;
    }

    public static List<OneDoFJoint> nextOneDoFJointChain(Random random, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextOneDoFJointChain(random, "", numberOfJoints);
    }

    public static List<OneDoFJoint> nextOneDoFJointChain(Random random, String prefix, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextOneDoFJointChain(random, prefix, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray(random, numberOfJoints, 1.0));
    }

    public static List<OneDoFJoint> nextOneDoFJointChain(Random random, String prefix, Vector3DReadOnly[] jointAxes) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody rootBody = new RigidBody(prefix + "RootBody", worldFrame);
        return MultiBodySystemRandomTools.nextOneDoFJointChain(random, prefix, (RigidBodyBasics)rootBody, jointAxes);
    }

    public static List<OneDoFJoint> nextOneDoFJointChain(Random random, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextOneDoFJointChain(random, "", rootBody, numberOfJoints);
    }

    public static List<OneDoFJoint> nextOneDoFJointChain(Random random, String prefix, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextOneDoFJointChain(random, prefix, rootBody, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray(random, numberOfJoints, 1.0));
    }

    public static List<OneDoFJoint> nextOneDoFJointChain(Random random, String prefix, RigidBodyBasics rootBody, Vector3DReadOnly[] jointAxes) {
        RigidBodyBasics predecessor = rootBody;
        ArrayList<OneDoFJoint> oneDoFJoints = new ArrayList<OneDoFJoint>();
        for (int i = 0; i < jointAxes.length; ++i) {
            OneDoFJoint joint = MultiBodySystemRandomTools.nextOneDoFJoint(random, prefix + "Joint" + i, jointAxes[i], predecessor);
            oneDoFJoints.add(joint);
            predecessor = MultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
        }
        return oneDoFJoints;
    }

    public static List<JointBasics> nextJointChain(Random random, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextJointChain(random, "", numberOfJoints);
    }

    public static List<JointBasics> nextJointChain(Random random, String prefix, int numberOfJoints) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody rootBody = new RigidBody(prefix + "RootBody", worldFrame);
        return MultiBodySystemRandomTools.nextJointChain(random, prefix, rootBody, numberOfJoints);
    }

    public static List<JointBasics> nextJointChain(Random random, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextJointChain(random, "", rootBody, numberOfJoints);
    }

    public static List<JointBasics> nextJointChain(Random random, String prefix, RigidBodyBasics rootBody, int numberOfJoints) {
        RigidBodyBasics predecessor = rootBody;
        ArrayList<JointBasics> joints = new ArrayList<JointBasics>();
        for (int i = 0; i < numberOfJoints; ++i) {
            JointBasics joint = MultiBodySystemRandomTools.nextJoint(random, prefix + "Joint" + i, predecessor);
            joints.add(joint);
            predecessor = MultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
        }
        return joints;
    }

    public static List<PrismaticJoint> nextPrismaticJointTree(Random random, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextPrismaticJointTree(random, "", numberOfJoints);
    }

    public static List<PrismaticJoint> nextPrismaticJointTree(Random random, String prefix, int numberOfJoints) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody rootBody = new RigidBody(prefix + "RootBody", worldFrame);
        return MultiBodySystemRandomTools.nextPrismaticJointTree(random, prefix, rootBody, numberOfJoints);
    }

    public static List<PrismaticJoint> nextPrismaticJointTree(Random random, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextPrismaticJointTree(random, "", rootBody, numberOfJoints);
    }

    public static List<PrismaticJoint> nextPrismaticJointTree(Random random, String prefix, RigidBodyBasics rootBody, int numberOfJoints) {
        ArrayList<PrismaticJoint> prismaticJoints = new ArrayList<PrismaticJoint>();
        RigidBodyBasics predecessor = rootBody;
        for (int i = 0; i < numberOfJoints; ++i) {
            PrismaticJoint joint = MultiBodySystemRandomTools.nextPrismaticJoint(random, prefix + "Joint" + i, predecessor);
            MultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
            prismaticJoints.add(joint);
            predecessor = ((PrismaticJoint)prismaticJoints.get(random.nextInt(prismaticJoints.size()))).getSuccessor();
        }
        return SubtreeStreams.from(PrismaticJoint.class, rootBody.getChildrenJoints()).collect(Collectors.toList());
    }

    public static List<RevoluteJoint> nextRevoluteJointTree(Random random, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextRevoluteJointTree(random, "", numberOfJoints);
    }

    public static List<RevoluteJoint> nextRevoluteJointTree(Random random, String prefix, int numberOfJoints) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody rootBody = new RigidBody("RootBody", worldFrame);
        return MultiBodySystemRandomTools.nextRevoluteJointTree(random, prefix, rootBody, numberOfJoints);
    }

    public static List<RevoluteJoint> nextRevoluteJointTree(Random random, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextRevoluteJointTree(random, "", rootBody, numberOfJoints);
    }

    public static List<RevoluteJoint> nextRevoluteJointTree(Random random, String prefix, RigidBodyBasics rootBody, int numberOfJoints) {
        ArrayList<RevoluteJoint> revoluteJoints = new ArrayList<RevoluteJoint>();
        RigidBodyBasics predecessor = rootBody;
        for (int i = 0; i < numberOfJoints; ++i) {
            RevoluteJoint joint = MultiBodySystemRandomTools.nextRevoluteJoint(random, prefix + "Joint" + i, predecessor);
            MultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
            revoluteJoints.add(joint);
            predecessor = ((RevoluteJoint)revoluteJoints.get(random.nextInt(revoluteJoints.size()))).getSuccessor();
        }
        return SubtreeStreams.from(RevoluteJoint.class, rootBody.getChildrenJoints()).collect(Collectors.toList());
    }

    public static List<OneDoFJoint> nextOneDoFJointTree(Random random, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextOneDoFJointTree(random, "", numberOfJoints);
    }

    public static List<OneDoFJoint> nextOneDoFJointTree(Random random, String prefix, int numberOfJoints) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody rootBody = new RigidBody("RootBody", worldFrame);
        return MultiBodySystemRandomTools.nextOneDoFJointTree(random, prefix, rootBody, numberOfJoints);
    }

    public static List<OneDoFJoint> nextOneDoFJointTree(Random random, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextOneDoFJointTree(random, "", rootBody, numberOfJoints);
    }

    public static List<OneDoFJoint> nextOneDoFJointTree(Random random, String prefix, RigidBodyBasics rootBody, int numberOfJoints) {
        ArrayList<OneDoFJoint> oneDoFJoints = new ArrayList<OneDoFJoint>();
        RigidBodyBasics predecessor = rootBody;
        for (int i = 0; i < numberOfJoints; ++i) {
            OneDoFJoint joint = MultiBodySystemRandomTools.nextOneDoFJoint(random, prefix + "Joint" + i, predecessor);
            MultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
            oneDoFJoints.add(joint);
            predecessor = ((OneDoFJoint)oneDoFJoints.get(random.nextInt(oneDoFJoints.size()))).getSuccessor();
        }
        return SubtreeStreams.from(OneDoFJoint.class, rootBody.getChildrenJoints()).collect(Collectors.toList());
    }

    public static List<JointBasics> nextJointTree(Random random, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextJointTree(random, "", numberOfJoints);
    }

    public static List<JointBasics> nextJointTree(Random random, String prefix, int numberOfJoints) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody rootBody = new RigidBody("RootBody", worldFrame);
        return MultiBodySystemRandomTools.nextJointTree(random, prefix, rootBody, numberOfJoints);
    }

    public static List<JointBasics> nextJointTree(Random random, RigidBodyBasics rootBody, int numberOfJoints) {
        return MultiBodySystemRandomTools.nextJointTree(random, "", rootBody, numberOfJoints);
    }

    public static List<JointBasics> nextJointTree(Random random, String prefix, RigidBodyBasics rootBody, int numberOfJoints) {
        ArrayList<JointBasics> joints = new ArrayList<JointBasics>();
        String jointName = prefix + "Joint";
        String bodyName = prefix + "Body";
        RigidBodyBasics predecessor = rootBody;
        for (int i = 0; i < numberOfJoints; ++i) {
            Object suffix;
            if (predecessor != rootBody) {
                String parentJointName = predecessor.getParentJoint().getName();
                suffix = parentJointName.substring(jointName.length()) + "_" + predecessor.getChildrenJoints().size();
            } else {
                suffix = Integer.toString(predecessor.getChildrenJoints().size());
            }
            JointBasics joint = MultiBodySystemRandomTools.nextJoint(random, jointName + (String)suffix, predecessor);
            MultiBodySystemRandomTools.nextRigidBody(random, bodyName + (String)suffix, joint);
            joints.add(joint);
            predecessor = ((JointBasics)joints.get(random.nextInt(joints.size()))).getSuccessor();
        }
        return SubtreeStreams.from(JointBasics.class, rootBody.getChildrenJoints()).collect(Collectors.toList());
    }

    public static List<RevoluteJoint> nextKinematicLoopRevoluteJoints(Random random, String prefix, RigidBodyBasics start, RigidBodyBasics end, int numberOfJoints) {
        if (!MultiBodySystemTools.isAncestor(end, start)) {
            throw new IllegalArgumentException("Improper rigid-bodies configuration: the end must be a descendant of start. Given bodies: [start: " + start.getName() + ", end: " + end.getName() + "].");
        }
        List<RevoluteJoint> loopChain = MultiBodySystemRandomTools.nextRevoluteJointChain(random, prefix, start, numberOfJoints);
        RevoluteJoint loopClosureJoint = loopChain.get(numberOfJoints - 1);
        start.updateFramesRecursively();
        RigidBodyTransform transformFromSuccessorParentJoint = end.getParentJoint().getFrameAfterJoint().getTransformToDesiredFrame(loopClosureJoint.getFrameAfterJoint());
        loopClosureJoint.setupLoopClosure(end, (RigidBodyTransformReadOnly)transformFromSuccessorParentJoint);
        return loopChain;
    }

    public static PrismaticJoint nextPrismaticJoint(Random random, String name, RigidBodyBasics predecessor) {
        Vector3D jointAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        return MultiBodySystemRandomTools.nextPrismaticJoint(random, name, (Vector3DReadOnly)jointAxis, predecessor);
    }

    public static PrismaticJoint nextPrismaticJoint(Random random, String name, Vector3DReadOnly jointAxis, RigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new PrismaticJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent, jointAxis);
    }

    public static RevoluteJoint nextRevoluteJoint(Random random, String name, RigidBodyBasics predecessor) {
        Vector3D jointAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        return MultiBodySystemRandomTools.nextRevoluteJoint(random, name, (Vector3DReadOnly)jointAxis, predecessor);
    }

    public static RevoluteJoint nextRevoluteJoint(Random random, String name, Vector3DReadOnly jointAxis, RigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new RevoluteJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent, jointAxis);
    }

    public static OneDoFJoint nextOneDoFJoint(Random random, String name, RigidBodyBasics predecessor) {
        if (random.nextBoolean()) {
            return MultiBodySystemRandomTools.nextPrismaticJoint(random, name, predecessor);
        }
        return MultiBodySystemRandomTools.nextRevoluteJoint(random, name, predecessor);
    }

    public static OneDoFJoint nextOneDoFJoint(Random random, String name, Vector3DReadOnly jointAxis, RigidBodyBasics predecessor) {
        if (random.nextBoolean()) {
            return MultiBodySystemRandomTools.nextPrismaticJoint(random, name, jointAxis, predecessor);
        }
        return MultiBodySystemRandomTools.nextRevoluteJoint(random, name, jointAxis, predecessor);
    }

    public static SixDoFJoint nextSixDoFJoint(Random random, String name, RigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new SixDoFJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static PlanarJoint nextPlanarJoint(Random random, String name, RigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new PlanarJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static SphericalJoint nextSphericalJoint(Random random, String name, RigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new SphericalJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static FixedJoint nextFixedJoint(Random random, String name, RigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new FixedJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static JointBasics nextJoint(Random random, String name, RigidBodyBasics predecessor) {
        switch (random.nextInt(6)) {
            case 0: {
                return MultiBodySystemRandomTools.nextSixDoFJoint(random, name, predecessor);
            }
            case 1: {
                return MultiBodySystemRandomTools.nextPlanarJoint(random, name, predecessor);
            }
            case 2: {
                return MultiBodySystemRandomTools.nextSphericalJoint(random, name, predecessor);
            }
            case 3: {
                return MultiBodySystemRandomTools.nextPrismaticJoint(random, name, predecessor);
            }
            case 4: {
                return MultiBodySystemRandomTools.nextRevoluteJoint(random, name, predecessor);
            }
        }
        return MultiBodySystemRandomTools.nextFixedJoint(random, name, predecessor);
    }

    public static RigidBody nextRigidBody(Random random, String name, JointBasics parentJoint) {
        Matrix3D momentOfInertia = MecanoRandomTools.nextSymmetricPositiveDefiniteMatrix3D(random, 1.0E-4, 2.0, 0.5);
        double mass = 0.1 + random.nextDouble();
        Vector3D comOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
        return new RigidBody(name, parentJoint, (Matrix3DReadOnly)momentOfInertia, mass, (Tuple3DReadOnly)comOffset);
    }

    public static class RandomFloatingRevoluteJointChain {
        private final RigidBody elevator;
        private final SixDoFJoint rootJoint;
        private final List<RevoluteJoint> revoluteJoints;
        private final List<Joint> joints = new ArrayList<Joint>();

        public RandomFloatingRevoluteJointChain(Random random, int numberOfRevoluteJoints) {
            this(random, MecanoRandomTools.nextVector3DArray(random, numberOfRevoluteJoints, 1.0));
        }

        public RandomFloatingRevoluteJointChain(Random random, Vector3D[] jointAxes) {
            this.elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
            this.rootJoint = new SixDoFJoint("rootJoint", this.elevator);
            RigidBody rootBody = MultiBodySystemRandomTools.nextRigidBody(random, "rootBody", this.rootJoint);
            this.revoluteJoints = MultiBodySystemRandomTools.nextRevoluteJointChain(random, "test", (RigidBodyBasics)rootBody, (Vector3DReadOnly[])jointAxes);
            this.joints.add(this.rootJoint);
            this.joints.addAll(this.revoluteJoints);
        }

        public void nextState(Random random, JointStateType ... stateSelections) {
            for (JointStateType selection : stateSelections) {
                MultiBodySystemRandomTools.nextState(random, selection, this.getJoints());
            }
            this.getElevator().updateFramesRecursively();
        }

        public RigidBody getElevator() {
            return this.elevator;
        }

        public SixDoFJoint getRootJoint() {
            return this.rootJoint;
        }

        public List<RevoluteJoint> getRevoluteJoints() {
            return this.revoluteJoints;
        }

        public List<Joint> getJoints() {
            return this.joints;
        }

        public RigidBodyBasics getLeafBody() {
            int nRevoluteJoints = this.revoluteJoints.size();
            if (nRevoluteJoints > 0) {
                return this.revoluteJoints.get(nRevoluteJoints - 1).getSuccessor();
            }
            return this.rootJoint.getSuccessor();
        }
    }
}

