/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoTools;

public class MecanoIOTools {
    public static String getSpatialVectorString(SpatialVectorReadOnly spatialVector) {
        return MecanoIOTools.getSpatialVectorString(EuclidCoreIOTools.DEFAULT_FORMAT, spatialVector);
    }

    public static String getSpatialVectorString(String format, SpatialVectorReadOnly spatialVector) {
        if (spatialVector == null) {
            return "null";
        }
        return MecanoIOTools.getSpatialVectorString(format, spatialVector.getReferenceFrame(), (Vector3DReadOnly)spatialVector.getAngularPart(), (Vector3DReadOnly)spatialVector.getLinearPart());
    }

    public static String getSpatialVectorString(String format, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        return "Spatial Vector: [angular = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)angularPart) + ", linear = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)linearPart) + "] - " + expressedInFrame;
    }

    public static String getSpatialForceVectorString(SpatialForceReadOnly spatialForce) {
        return MecanoIOTools.getSpatialForceString(EuclidCoreIOTools.DEFAULT_FORMAT, spatialForce);
    }

    public static String getSpatialForceString(String format, SpatialForceReadOnly spatialForce) {
        if (spatialForce == null) {
            return "null";
        }
        return MecanoIOTools.getSpatialForceVectorString(format, spatialForce.getReferenceFrame(), (Vector3DReadOnly)spatialForce.getAngularPart(), (Vector3DReadOnly)spatialForce.getLinearPart());
    }

    public static String getSpatialForceVectorString(String format, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        return "Spatial Force: [angular = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)angularPart) + ", linear = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)linearPart) + "] - " + expressedInFrame;
    }

    public static String getWrenchString(WrenchReadOnly wrench) {
        return MecanoIOTools.getWrenchString(EuclidCoreIOTools.DEFAULT_FORMAT, wrench);
    }

    public static String getWrenchString(String format, WrenchReadOnly wrench) {
        if (wrench == null) {
            return "null";
        }
        return MecanoIOTools.getWrenchString(format, wrench.getBodyFrame(), wrench.getReferenceFrame(), (Vector3DReadOnly)wrench.getAngularPart(), (Vector3DReadOnly)wrench.getLinearPart());
    }

    public static String getWrenchString(String format, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        return "Wrench exerted on " + bodyFrame + ": [angular = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)angularPart) + ", linear = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)linearPart) + "] - " + expressedInFrame;
    }

    public static String getSpatialImpulseString(SpatialImpulseReadOnly spatialImpulse) {
        return MecanoIOTools.getSpatialImpulseString(EuclidCoreIOTools.DEFAULT_FORMAT, spatialImpulse);
    }

    public static String getSpatialImpulseString(String format, SpatialImpulseReadOnly spatialImpulse) {
        if (spatialImpulse == null) {
            return "null";
        }
        return MecanoIOTools.getSpatialImpulseString(format, spatialImpulse.getBodyFrame(), spatialImpulse.getReferenceFrame(), (Vector3DReadOnly)spatialImpulse.getAngularPart(), (Vector3DReadOnly)spatialImpulse.getLinearPart());
    }

    public static String getSpatialImpulseString(String format, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        return "Spatial impulse exerted on " + bodyFrame + ": [angular = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)angularPart) + ", linear = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)linearPart) + "] - " + expressedInFrame;
    }

    public static String getTwistString(TwistReadOnly twist) {
        return MecanoIOTools.getTwistString(EuclidCoreIOTools.DEFAULT_FORMAT, twist);
    }

    public static String getTwistString(String format, TwistReadOnly twist) {
        if (twist == null) {
            return "null";
        }
        return MecanoIOTools.getTwistString(format, twist.getBodyFrame(), twist.getBaseFrame(), twist.getReferenceFrame(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart());
    }

    public static String getTwistString(String format, ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        return "Twist of " + bodyFrame + ", with respect to " + baseFrame + ": [angular = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)angularPart) + ", linear = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)linearPart) + "] - " + expressedInFrame;
    }

    public static String getSpatialAccelerationString(SpatialAccelerationReadOnly spatialAcceleration) {
        return MecanoIOTools.getSpatialAccelerationString(EuclidCoreIOTools.DEFAULT_FORMAT, spatialAcceleration);
    }

    public static String getSpatialAccelerationString(String format, SpatialAccelerationReadOnly spatialAcceleration) {
        if (spatialAcceleration == null) {
            return "null";
        }
        return MecanoIOTools.getSpatialAccelerationString(format, spatialAcceleration.getBodyFrame(), spatialAcceleration.getBaseFrame(), spatialAcceleration.getReferenceFrame(), (Vector3DReadOnly)spatialAcceleration.getAngularPart(), (Vector3DReadOnly)spatialAcceleration.getLinearPart());
    }

    public static String getSpatialAccelerationString(String format, ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        return "Spatial acceleration of " + bodyFrame + ", with respect to " + baseFrame + ": [angular = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)angularPart) + ", linear = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)linearPart) + "] - " + expressedInFrame;
    }

    public static String getMomentumString(MomentumReadOnly momentum) {
        return MecanoIOTools.getMomentumString(EuclidCoreIOTools.DEFAULT_FORMAT, momentum);
    }

    public static String getMomentumString(String format, MomentumReadOnly momentum) {
        if (momentum == null) {
            return "null";
        }
        return MecanoIOTools.getMomentumString(format, momentum.getReferenceFrame(), (Vector3DReadOnly)momentum.getAngularPart(), (Vector3DReadOnly)momentum.getLinearPart());
    }

    public static String getMomentumString(String format, ReferenceFrame expressedInFrame, Vector3DReadOnly angularMomentum, Vector3DReadOnly linearMomentum) {
        return "Spatial Force Vector: [angular = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)angularMomentum) + ", linear = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)linearMomentum) + "] - " + expressedInFrame;
    }

    public static String getSpatialInertiaString(SpatialInertiaReadOnly spatialInertia) {
        return MecanoIOTools.getSpatialInertiaString(EuclidCoreIOTools.DEFAULT_FORMAT, spatialInertia);
    }

    public static String getSpatialInertiaString(String format, SpatialInertiaReadOnly spatialInertia) {
        if (spatialInertia == null) {
            return "null";
        }
        DMatrixRMaj inertiaMatrix = new DMatrixRMaj(6, 6);
        spatialInertia.get((DMatrix)inertiaMatrix);
        return "Spatial inertia of " + spatialInertia.getBodyFrame() + " expressed in " + spatialInertia.getReferenceFrame() + ":\n" + MecanoIOTools.getDMatrixString(format, (DMatrix)inertiaMatrix);
    }

    public static String getSpatialInertiaString(String format, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, double mass, Vector3DReadOnly centerOfMassOffset, Matrix3DReadOnly massMomentOfInertia) {
        DMatrixRMaj inertiaMatrix = new DMatrixRMaj(6, 6);
        massMomentOfInertia.get((DMatrix)inertiaMatrix);
        MecanoTools.toTildeForm(mass, (Tuple3DReadOnly)centerOfMassOffset, false, 0, 3, (DMatrix)inertiaMatrix);
        MecanoTools.toTildeForm(mass, (Tuple3DReadOnly)centerOfMassOffset, true, 3, 0, (DMatrix)inertiaMatrix);
        for (int i = 3; i < 6; ++i) {
            inertiaMatrix.set(i, i, mass);
        }
        return "Spatial inertia of " + bodyFrame + " expressed in " + expressedInFrame + ":\n" + MecanoIOTools.getDMatrixString(format, (DMatrix)inertiaMatrix);
    }

    public static String getDMatrixString(DMatrix dMatrix) {
        return MecanoIOTools.getDMatrixString(EuclidCoreIOTools.DEFAULT_FORMAT, dMatrix);
    }

    public static String getDMatrixString(String format, DMatrix dMatrix) {
        Object ret = "";
        double[] rowValues = new double[dMatrix.getNumCols()];
        String separator = ", ";
        for (int row = 0; row < dMatrix.getNumRows(); ++row) {
            String suffix;
            String prefix;
            for (int col = 0; col < dMatrix.getNumCols(); ++col) {
                rowValues[col] = dMatrix.get(row, col);
            }
            if (row == 0) {
                prefix = "/";
                suffix = " \\\n";
            } else if (row == dMatrix.getNumRows() - 1) {
                prefix = "\\";
                suffix = " /";
            } else {
                prefix = "|";
                suffix = " |\n";
            }
            ret = (String)ret + EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (String)format, (double[])rowValues);
        }
        return ret;
    }
}

