/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.iterators;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.IteratorSearchMode;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterator;

public class JointIterable<J extends JointReadOnly>
implements Iterable<J> {
    private final Collection<? extends JointReadOnly> roots;
    private final Predicate<J> selectionRule;
    private final Class<J> filteringClass;
    private final IteratorSearchMode mode;

    public JointIterable(Class<J> filteringClass, Predicate<J> selectionRule, IteratorSearchMode mode, JointReadOnly root) {
        this(filteringClass, selectionRule, mode, Collections.singletonList(root));
    }

    public JointIterable(Class<J> filteringClass, Predicate<J> selectionRule, IteratorSearchMode mode, RigidBodyReadOnly rootBody) {
        this(filteringClass, selectionRule, mode, rootBody.getChildrenJoints());
    }

    public JointIterable(Class<J> filteringClass, Predicate<J> selectionRule, IteratorSearchMode mode, Collection<? extends JointReadOnly> roots) {
        this.filteringClass = filteringClass;
        this.selectionRule = selectionRule;
        this.mode = mode;
        this.roots = roots;
    }

    @Override
    public Iterator<J> iterator() {
        return new JointIterator<J>(this.filteringClass, this.selectionRule, this.mode, this.roots);
    }

    public Stream<J> toStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

