/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterable;
import us.ihmc.mecano.multiBodySystem.iterators.RigidBodyIterable;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;

public interface RigidBodyBasics
extends RigidBodyReadOnly {
    @Override
    public SpatialInertiaBasics getInertia();

    @Override
    public JointBasics getParentJoint();

    default public void addParentLoopClosureJoint(JointBasics parentLoopClosureJoint) {
        this.getParentLoopClosureJoints().add(parentLoopClosureJoint);
    }

    default public List<JointBasics> getParentLoopClosureJoints() {
        return Collections.emptyList();
    }

    default public void addChildJoint(JointBasics joint) {
        this.getChildrenJoints().add(joint);
    }

    public List<JointBasics> getChildrenJoints();

    default public void setCenterOfMass(FramePoint3DReadOnly centerOfMass) {
        this.getInertia().getCenterOfMassOffset().setMatchingFrame((FrameTuple3DReadOnly)centerOfMass);
    }

    default public void updateFramesRecursively() {
        this.getBodyFixedFrame().update();
        for (int childIndex = 0; childIndex < this.getChildrenJoints().size(); ++childIndex) {
            this.getChildrenJoints().get(childIndex).updateFramesRecursively();
        }
    }

    default public Iterable<? extends RigidBodyBasics> subtreeIterable() {
        return new RigidBodyIterable<RigidBodyBasics>(RigidBodyBasics.class, null, null, this);
    }

    default public Iterable<? extends JointBasics> childrenSubtreeIterable() {
        return new JointIterable<JointBasics>(JointBasics.class, null, null, this.getChildrenJoints());
    }

    default public Stream<? extends RigidBodyBasics> subtreeStream() {
        return SubtreeStreams.from(this);
    }

    default public List<? extends RigidBodyBasics> subtreeList() {
        return this.subtreeStream().collect(Collectors.toList());
    }

    default public RigidBodyBasics[] subtreeArray() {
        return (RigidBodyBasics[])this.subtreeStream().toArray(RigidBodyBasics[]::new);
    }
}

