/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem;

import java.util.List;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoTools;

public class SixDoFJoint
extends Joint
implements SixDoFJointBasics {
    private final Pose3D jointPose = new Pose3D();
    private final FixedFrameTwistBasics jointTwist = new Twist((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, this.afterJointFrame);
    private final FixedFrameSpatialAccelerationBasics jointAcceleration = new SpatialAcceleration((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, this.afterJointFrame);
    private FixedFrameWrenchBasics jointWrench;
    private final List<TwistReadOnly> unitTwists = MecanoTools.computeSixDoFJointMotionSubspace(this.beforeJointFrame, this.afterJointFrame);

    public SixDoFJoint(String name, RigidBodyBasics predecessor) {
        this(name, predecessor, null);
    }

    public SixDoFJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        super(name, predecessor, transformToParent);
    }

    @Override
    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        MovingReferenceFrame successorFrame = successor.getBodyFixedFrame();
        this.jointWrench = new Wrench((ReferenceFrame)successorFrame, this.afterJointFrame);
    }

    @Override
    public Pose3DBasics getJointPose() {
        return this.jointPose;
    }

    @Override
    public FixedFrameTwistBasics getJointTwist() {
        return this.jointTwist;
    }

    @Override
    public FixedFrameSpatialAccelerationBasics getJointAcceleration() {
        return this.jointAcceleration;
    }

    @Override
    public FixedFrameWrenchBasics getJointWrench() {
        return this.jointWrench;
    }

    @Override
    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }

    @Override
    public String toString() {
        return super.toString() + ", configuration: " + this.jointPose + ", velocity: " + this.jointTwist + ", acceleration: " + this.jointAcceleration + ", wrench" + this.jointWrench;
    }
}

