/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class InverseDynamicsCalculator {
    private static final boolean DEFAULT_CONSIDER_ACCELERATIONS = true;
    private static final boolean DEFAULT_CONSIDER_CORIOLIS = true;
    private final MultiBodySystemReadOnly input;
    private final RecursionStep initialRecursionStep;
    private final Map<RigidBodyReadOnly, RecursionStep> rigidBodyToRecursionStepMap = new LinkedHashMap<RigidBodyReadOnly, RecursionStep>();
    private final Map<JointReadOnly, RecursionStepBasics> jointToRecursionStepMap = new LinkedHashMap<JointReadOnly, RecursionStepBasics>();
    private final DMatrixRMaj allJointAccelerationMatrix;
    private final DMatrixRMaj allJointTauMatrix;
    private boolean considerJointAccelerations = true;
    private boolean considerCoriolisAndCentrifugalForces = true;
    private final RigidBodyAccelerationProvider accelerationProvider;
    private final SpatialForce jointForceFromChild = new SpatialForce();

    @Deprecated
    public InverseDynamicsCalculator(RigidBodyReadOnly rootBody, boolean considerCoriolisAndCentrifugalForces, boolean considerJointAccelerations) {
        this(rootBody);
        this.setConsiderCoriolisAndCentrifugalForces(considerCoriolisAndCentrifugalForces);
        this.setConsiderJointAccelerations(considerJointAccelerations);
    }

    @Deprecated
    public InverseDynamicsCalculator(MultiBodySystemReadOnly input, boolean considerCoriolisAndCentrifugalForces, boolean considerJointAccelerations) {
        this(input);
        this.setConsiderCoriolisAndCentrifugalForces(considerCoriolisAndCentrifugalForces);
        this.setConsiderJointAccelerations(considerJointAccelerations);
    }

    @Deprecated
    public InverseDynamicsCalculator(MultiBodySystemReadOnly input, boolean considerCoriolisAndCentrifugalForces, boolean considerJointAccelerations, boolean considerIgnoredSubtreesInertia) {
        this(input, considerIgnoredSubtreesInertia);
        this.setConsiderCoriolisAndCentrifugalForces(considerCoriolisAndCentrifugalForces);
        this.setConsiderJointAccelerations(considerJointAccelerations);
    }

    public InverseDynamicsCalculator(RigidBodyReadOnly rootBody) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody), true);
    }

    public InverseDynamicsCalculator(MultiBodySystemReadOnly input) {
        this(input, true);
    }

    public InverseDynamicsCalculator(MultiBodySystemReadOnly input, boolean considerIgnoredSubtreesInertia) {
        this.input = input;
        RigidBodyReadOnly rootBody = input.getRootBody();
        this.initialRecursionStep = new RecursionStep(rootBody, null, null);
        this.rigidBodyToRecursionStepMap.put(rootBody, this.initialRecursionStep);
        this.buildMultiBodyTree(this.initialRecursionStep, input.getJointsToIgnore());
        if (considerIgnoredSubtreesInertia) {
            this.initialRecursionStep.includeIgnoredSubtreeInertia();
        }
        int nDoFs = MultiBodySystemTools.computeDegreesOfFreedom(input.getJointsToConsider());
        this.allJointAccelerationMatrix = new DMatrixRMaj(nDoFs, 1);
        this.allJointTauMatrix = new DMatrixRMaj(nDoFs, 1);
        Function<RigidBodyReadOnly, SpatialAccelerationReadOnly> accelerationFunction = body -> {
            RecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(body);
            return recursionStep == null ? null : recursionStep.rigidBodyAcceleration;
        };
        this.accelerationProvider = RigidBodyAccelerationProvider.toRigidBodyAccelerationProvider(accelerationFunction, input.getInertialFrame(), this::areCoriolisAndCentrifugalForcesConsidered, this::areJointAccelerationsConsidered);
    }

    /*
     * WARNING - void declaration
     */
    private void buildMultiBodyTree(RecursionStep parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        ArrayList<? extends JointReadOnly> childrenJoints = new ArrayList<JointReadOnly>(parent.rigidBody.getChildrenJoints());
        if (childrenJoints.size() > 1) {
            void var5_6;
            ArrayList<JointReadOnly> loopClosureAncestors = new ArrayList<JointReadOnly>();
            boolean bl = false;
            while (var5_6 < childrenJoints.size()) {
                if (MultiBodySystemTools.doesSubtreeContainLoopClosure(((JointReadOnly)childrenJoints.get((int)var5_6)).getSuccessor())) {
                    loopClosureAncestors.add((JointReadOnly)childrenJoints.remove((int)var5_6));
                    continue;
                }
                ++var5_6;
            }
            childrenJoints.addAll(loopClosureAncestors);
        }
        for (JointReadOnly jointReadOnly : childrenJoints) {
            int[] jointIndices;
            RigidBodyReadOnly childBody;
            if (jointsToIgnore.contains(jointReadOnly) || (childBody = jointReadOnly.getSuccessor()) == null) continue;
            if (this.rigidBodyToRecursionStepMap.containsKey(childBody)) {
                jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(jointReadOnly);
                LoopClosureRecursionStep recursion = new LoopClosureRecursionStep(jointReadOnly, parent, this.rigidBodyToRecursionStepMap.get(childBody), jointIndices);
                this.jointToRecursionStepMap.put(jointReadOnly, recursion);
                continue;
            }
            jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(jointReadOnly);
            RecursionStep child = new RecursionStep(childBody, parent, jointIndices);
            this.rigidBodyToRecursionStepMap.put(childBody, child);
            this.jointToRecursionStepMap.put(jointReadOnly, child);
            this.buildMultiBodyTree(child, jointsToIgnore);
        }
    }

    public void setConsiderCoriolisAndCentrifugalForces(boolean considerCoriolisAndCentrifugalForces) {
        this.considerCoriolisAndCentrifugalForces = considerCoriolisAndCentrifugalForces;
    }

    public void setConsiderJointAccelerations(boolean considerJointAccelerations) {
        this.considerJointAccelerations = considerJointAccelerations;
    }

    public void setGravitionalAcceleration(FrameTuple3DReadOnly gravity) {
        gravity.checkReferenceFrameMatch(this.input.getInertialFrame());
        this.setGravitionalAcceleration((Tuple3DReadOnly)gravity);
    }

    public void setGravitionalAcceleration(Tuple3DReadOnly gravity) {
        SpatialAcceleration rootAcceleration = this.initialRecursionStep.rigidBodyAcceleration;
        rootAcceleration.setToZero();
        rootAcceleration.getLinearPart().setAndNegate(gravity);
    }

    public void setGravitionalAcceleration(double gravity) {
        this.setGravitionalAcceleration(0.0, 0.0, gravity);
    }

    public void setGravitionalAcceleration(double gravityX, double gravityY, double gravityZ) {
        SpatialAcceleration rootAcceleration = this.initialRecursionStep.rigidBodyAcceleration;
        rootAcceleration.setToZero();
        rootAcceleration.getLinearPart().set(gravityX, gravityY, gravityZ);
        rootAcceleration.negate();
    }

    public void setRootAcceleration(SpatialAccelerationReadOnly newRootAcceleration) {
        this.initialRecursionStep.rigidBodyAcceleration.set(newRootAcceleration);
    }

    public void setExternalWrenchesToZero() {
        this.initialRecursionStep.setExternalWrenchToZeroRecursive();
    }

    public FixedFrameWrenchBasics getExternalWrench(RigidBodyReadOnly rigidBody) {
        return this.rigidBodyToRecursionStepMap.get((Object)rigidBody).externalWrench;
    }

    public void setExternalWrench(RigidBodyReadOnly rigidBody, WrenchReadOnly externalWrench) {
        this.getExternalWrench(rigidBody).setMatchingFrame(externalWrench);
    }

    public void compute() {
        this.compute(null);
    }

    public void compute(DMatrix jointAccelerationMatrix) {
        if (jointAccelerationMatrix != null) {
            this.allJointAccelerationMatrix.set((Matrix)jointAccelerationMatrix);
        } else {
            List<? extends JointReadOnly> indexedJointsInOrder = this.input.getJointMatrixIndexProvider().getIndexedJointsInOrder();
            MultiBodySystemTools.extractJointsState(indexedJointsInOrder, JointStateType.ACCELERATION, (DMatrix)this.allJointAccelerationMatrix);
        }
        this.initialRecursionStep.passOne();
        this.initialRecursionStep.passTwo();
    }

    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    public boolean areJointAccelerationsConsidered() {
        return this.considerJointAccelerations;
    }

    public boolean areCoriolisAndCentrifugalForcesConsidered() {
        return this.considerCoriolisAndCentrifugalForces;
    }

    public DMatrixRMaj getJointTauMatrix() {
        return this.allJointTauMatrix;
    }

    public WrenchReadOnly getComputedJointWrench(JointReadOnly joint) {
        RecursionStepBasics recursionStep = this.jointToRecursionStepMap.get(joint);
        if (recursionStep == null) {
            return null;
        }
        return recursionStep.getJointWrench();
    }

    public DMatrixRMaj getComputedJointTau(JointReadOnly joint) {
        RecursionStepBasics recursionStep = this.jointToRecursionStepMap.get(joint);
        if (recursionStep == null) {
            return null;
        }
        return recursionStep.getTau();
    }

    public void writeComputedJointWrenches(JointBasics[] joints) {
        for (JointBasics joint : joints) {
            this.writeComputedJointWrench(joint);
        }
    }

    public void writeComputedJointWrenches(List<? extends JointBasics> joints) {
        for (int i = 0; i < joints.size(); ++i) {
            this.writeComputedJointWrench(joints.get(i));
        }
    }

    public boolean writeComputedJointWrench(JointBasics joint) {
        DMatrixRMaj jointTau = this.getComputedJointTau(joint);
        if (jointTau == null) {
            return false;
        }
        joint.setJointTau(0, (DMatrix)jointTau);
        return true;
    }

    public RigidBodyAccelerationProvider getAccelerationProvider() {
        return this.accelerationProvider;
    }

    private final class RecursionStep
    implements RecursionStepBasics {
        private final RigidBodyReadOnly rigidBody;
        private final JointReadOnly joint;
        private final SpatialInertia bodyInertia;
        private final RecursionStep parent;
        private final List<RecursionStepBasics> children = new ArrayList<RecursionStepBasics>();
        private final Wrench jointWrench;
        private final FixedFrameWrenchBasics externalWrench;
        private final SpatialAcceleration rigidBodyAcceleration;
        private final SpatialAcceleration localJointAcceleration = new SpatialAcceleration();
        private final Twist localJointTwist = new Twist();
        private final DMatrixRMaj S;
        private final DMatrixRMaj qdd;
        private final DMatrixRMaj a;
        private final DMatrixRMaj tau;
        private final DMatrixRMaj jointWrenchMatrix;
        private int[] jointIndices;

        public RecursionStep(RigidBodyReadOnly rigidBody, RecursionStep parent, int[] jointIndices) {
            this.rigidBody = rigidBody;
            this.parent = parent;
            this.jointIndices = jointIndices;
            this.rigidBodyAcceleration = new SpatialAcceleration((ReferenceFrame)this.getBodyFixedFrame(), InverseDynamicsCalculator.this.input.getInertialFrame(), this.getBodyFixedFrame());
            if (this.isRoot()) {
                this.joint = null;
                this.bodyInertia = null;
                this.jointWrench = null;
                this.externalWrench = null;
                this.S = null;
                this.qdd = null;
                this.a = null;
                this.tau = null;
                this.jointWrenchMatrix = null;
            } else {
                this.joint = rigidBody.getParentJoint();
                parent.children.add(this);
                int nDoFs = this.joint.getDegreesOfFreedom();
                this.bodyInertia = new SpatialInertia(rigidBody.getInertia());
                this.jointWrench = new Wrench();
                this.externalWrench = new Wrench((ReferenceFrame)this.getBodyFixedFrame(), this.getBodyFixedFrame());
                this.S = new DMatrixRMaj(6, nDoFs);
                this.qdd = new DMatrixRMaj(nDoFs, 1);
                this.a = new DMatrixRMaj(6, 1);
                this.tau = new DMatrixRMaj(nDoFs, 1);
                this.jointWrenchMatrix = new DMatrixRMaj(6, 1);
                if (!this.joint.isMotionSubspaceVariable()) {
                    this.joint.getMotionSubspace((DMatrix1Row)this.S);
                }
            }
        }

        @Override
        public void includeIgnoredSubtreeInertia() {
            if (!this.isRoot() && this.children.size() != this.rigidBody.getChildrenJoints().size()) {
                for (JointReadOnly jointReadOnly : this.rigidBody.getChildrenJoints()) {
                    if (!InverseDynamicsCalculator.this.input.getJointsToIgnore().contains(jointReadOnly)) continue;
                    SpatialInertia subtreeIneria = MultiBodySystemTools.computeSubtreeInertia(jointReadOnly);
                    subtreeIneria.changeFrame(this.getBodyFixedFrame());
                    this.bodyInertia.add(subtreeIneria);
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).includeIgnoredSubtreeInertia();
            }
        }

        @Override
        public void passOne() {
            if (!this.isRoot()) {
                TwistReadOnly bodyTwistToUse;
                if (this.joint.isMotionSubspaceVariable()) {
                    this.joint.getMotionSubspace((DMatrix1Row)this.S);
                }
                this.rigidBodyAcceleration.setIncludingFrame(this.parent.rigidBodyAcceleration);
                if (InverseDynamicsCalculator.this.considerCoriolisAndCentrifugalForces) {
                    this.joint.getPredecessorTwist(this.localJointTwist);
                    this.rigidBodyAcceleration.changeFrame(this.getBodyFixedFrame(), this.localJointTwist, this.parent.getBodyFixedFrame().getTwistOfFrame());
                    bodyTwistToUse = this.getBodyFixedFrame().getTwistOfFrame();
                } else {
                    this.rigidBodyAcceleration.changeFrame(this.getBodyFixedFrame());
                    bodyTwistToUse = null;
                }
                if (InverseDynamicsCalculator.this.considerJointAccelerations) {
                    int nDoFs = this.joint.getDegreesOfFreedom();
                    CommonOps_DDRM.extract((DMatrixRMaj)InverseDynamicsCalculator.this.allJointAccelerationMatrix, (int[])this.jointIndices, (int)nDoFs, (DMatrixRMaj)this.qdd);
                    CommonOps_DDRM.mult((DMatrix1Row)this.S, (DMatrix1Row)this.qdd, (DMatrix1Row)this.a);
                    this.localJointAcceleration.setIncludingFrame(this.joint.getFrameAfterJoint(), this.joint.getFrameBeforeJoint(), this.joint.getFrameAfterJoint(), (DMatrix)this.a);
                    if (this.joint.isMotionSubspaceVariable()) {
                        SpatialAccelerationReadOnly jointBiasAcceleration = this.joint.getJointBiasAcceleration();
                        this.localJointAcceleration.checkReferenceFrameMatch(jointBiasAcceleration);
                        this.localJointAcceleration.add(jointBiasAcceleration);
                    }
                    this.localJointAcceleration.changeFrame(this.getBodyFixedFrame());
                    this.localJointAcceleration.setBodyFrame(this.getBodyFixedFrame());
                    this.localJointAcceleration.setBaseFrame(this.parent.getBodyFixedFrame());
                    this.rigidBodyAcceleration.add(this.localJointAcceleration);
                } else {
                    this.rigidBodyAcceleration.setBodyFrame(this.getBodyFixedFrame());
                }
                this.bodyInertia.computeDynamicWrench(this.rigidBodyAcceleration, bodyTwistToUse, this.jointWrench);
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).passOne();
            }
        }

        @Override
        public void passTwo() {
            int childIndex;
            for (childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).passTwo();
            }
            if (this.isRoot()) {
                return;
            }
            this.jointWrench.sub(this.externalWrench);
            this.jointWrench.changeFrame(this.joint.getFrameAfterJoint());
            for (childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.addJointWrenchFromChild(this.children.get(childIndex));
            }
            this.jointWrench.get((DMatrix)this.jointWrenchMatrix);
            CommonOps_DDRM.multTransA((DMatrix1Row)this.S, (DMatrix1Row)this.jointWrenchMatrix, (DMatrix1Row)this.tau);
            for (int dofIndex = 0; dofIndex < this.joint.getDegreesOfFreedom(); ++dofIndex) {
                InverseDynamicsCalculator.this.allJointTauMatrix.set(this.jointIndices[dofIndex], 0, this.tau.get(dofIndex, 0));
            }
        }

        private void addJointWrenchFromChild(RecursionStepBasics child) {
            InverseDynamicsCalculator.this.jointForceFromChild.setIncludingFrame(child.getJointWrench());
            InverseDynamicsCalculator.this.jointForceFromChild.changeFrame(this.joint.getFrameAfterJoint());
            this.jointWrench.add(InverseDynamicsCalculator.this.jointForceFromChild);
        }

        @Override
        public void setExternalWrenchToZeroRecursive() {
            if (!this.isRoot()) {
                this.externalWrench.setToZero();
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).setExternalWrenchToZeroRecursive();
            }
        }

        @Override
        public RecursionStep getParent() {
            return this.parent;
        }

        @Override
        public RigidBodyReadOnly getRigidBody() {
            return this.rigidBody;
        }

        public MovingReferenceFrame getBodyFixedFrame() {
            return this.rigidBody.getBodyFixedFrame();
        }

        private boolean isRoot() {
            return this.parent == null;
        }

        @Override
        public Wrench getJointWrench() {
            return this.jointWrench;
        }

        @Override
        public DMatrixRMaj getTau() {
            return this.tau;
        }

        public String toString() {
            String bodyName = this.rigidBody == null ? "null" : this.rigidBody.getName();
            String jointName = this.joint == null ? "null" : this.joint.getName();
            String childrenBodyNames = EuclidCoreIOTools.getCollectionString((String)", ", this.children, RecursionStepBasics::getSimpleNameForParent);
            return String.format("Body: %s, joint: %s, children: [%s]", bodyName, jointName, childrenBodyNames);
        }
    }

    private final class LoopClosureRecursionStep
    implements RecursionStepBasics {
        private final JointReadOnly joint;
        private final RecursionStep parent;
        private final Wrench jointWrench;
        private final DMatrixRMaj tau;
        private int[] jointIndices;
        private RecursionStep successorRecursion;

        public LoopClosureRecursionStep(JointReadOnly loopClosureJoint, RecursionStep parent, RecursionStep successorRecursion, int[] jointIndices) {
            this.parent = parent;
            if (loopClosureJoint.getSuccessor() != successorRecursion.rigidBody) {
                throw new IllegalArgumentException("Rigid-body mismatch. Joint's successor: " + loopClosureJoint.getSuccessor() + ", recursion body: " + successorRecursion.rigidBody);
            }
            if (loopClosureJoint == successorRecursion.joint) {
                throw new IllegalArgumentException("This recursion joint should not be equal to the successor joint, joint: " + loopClosureJoint);
            }
            this.joint = loopClosureJoint;
            this.successorRecursion = successorRecursion;
            this.jointIndices = jointIndices;
            parent.children.add(this);
            int nDoFs = this.joint.getDegreesOfFreedom();
            this.jointWrench = new Wrench();
            this.tau = new DMatrixRMaj(nDoFs, 1);
        }

        @Override
        public void includeIgnoredSubtreeInertia() {
        }

        @Override
        public void passOne() {
        }

        @Override
        public void passTwo() {
            this.jointWrench.setToZero(this.getRigidBody().getBodyFixedFrame(), this.joint.getFrameAfterJoint());
            this.tau.zero();
            for (int dofIndex = 0; dofIndex < this.joint.getDegreesOfFreedom(); ++dofIndex) {
                InverseDynamicsCalculator.this.allJointTauMatrix.set(this.jointIndices[dofIndex], 0, this.tau.get(dofIndex, 0));
            }
        }

        @Override
        public void setExternalWrenchToZeroRecursive() {
        }

        @Override
        public RecursionStep getParent() {
            return this.parent;
        }

        @Override
        public RigidBodyReadOnly getRigidBody() {
            return this.successorRecursion.rigidBody;
        }

        @Override
        public Wrench getJointWrench() {
            return this.jointWrench;
        }

        @Override
        public DMatrixRMaj getTau() {
            return this.tau;
        }

        public String toString() {
            String bodyName = this.successorRecursion.rigidBody.getName();
            String jointName = this.joint.getName();
            return String.format("Body: %s, joint: %s, successor recursion: [%s]", bodyName, jointName, this.successorRecursion.toString());
        }
    }

    private static interface RecursionStepBasics {
        public void includeIgnoredSubtreeInertia();

        public void setExternalWrenchToZeroRecursive();

        public void passOne();

        public void passTwo();

        public RecursionStep getParent();

        public WrenchReadOnly getJointWrench();

        public RigidBodyReadOnly getRigidBody();

        public DMatrixRMaj getTau();

        default public String getSimpleNameForParent() {
            return String.format("{%s}", this.getRigidBody().getName());
        }
    }
}

