/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialInertiaBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.MecanoTools;

public interface SpatialInertiaBasics
extends FixedFrameSpatialInertiaBasics,
FrameChangeable {
    public void setBodyFrame(ReferenceFrame var1);

    default public void setToZero(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        this.setBodyFrame(bodyFrame);
        this.setReferenceFrame(expressedInFrame);
        this.setToZero();
    }

    default public void setToNaN(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        this.setBodyFrame(bodyFrame);
        this.setReferenceFrame(expressedInFrame);
        this.setToNaN();
    }

    default public void setIncludingFrame(SpatialInertiaReadOnly other) {
        this.setBodyFrame(other.getBodyFrame());
        this.setReferenceFrame(other.getReferenceFrame());
        this.getMomentOfInertia().set(other.getMomentOfInertia());
        this.setMass(other.getMass());
        this.getCenterOfMassOffset().set((FrameTuple3DReadOnly)other.getCenterOfMassOffset());
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, double Ixx, double Iyy, double Izz, double mass) {
        this.setBodyFrame(bodyFrame);
        this.setReferenceFrame(expressedInFrame);
        this.setMomentOfInertia(Ixx, Iyy, Izz);
        this.setMass(mass);
        this.getCenterOfMassOffset().setToZero();
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, Matrix3DReadOnly momentOfInertia, double mass) {
        this.setBodyFrame(bodyFrame);
        this.setReferenceFrame(expressedInFrame);
        this.getMomentOfInertia().set(momentOfInertia);
        this.setMass(mass);
        this.getCenterOfMassOffset().setToZero();
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, Matrix3DReadOnly momentOfInertia, double mass, Tuple3DReadOnly centerOfMassOffset) {
        this.setBodyFrame(bodyFrame);
        this.setReferenceFrame(expressedInFrame);
        this.getMomentOfInertia().set(momentOfInertia);
        this.setMass(mass);
        this.getCenterOfMassOffset().set(centerOfMassOffset);
    }

    default public void applyTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransform)) {
            throw new UnsupportedOperationException("The feature applyTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyTransform((RigidBodyTransform)transform);
    }

    default public void applyInverseTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransform)) {
            throw new UnsupportedOperationException("The feature applyInverseTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyInverseTransform((RigidBodyTransform)transform);
    }

    default public void applyTransform(RigidBodyTransform transform) {
        if (transform.hasRotation()) {
            MecanoTools.transformSymmetricMatrix3D((RotationMatrixReadOnly)transform.getRotation(), this.getMomentOfInertia());
            this.getCenterOfMassOffset().applyTransform((Transform)transform);
        }
        if (transform.hasTranslation()) {
            MecanoTools.translateMomentOfInertia(this.getMass(), (Tuple3DReadOnly)this.getCenterOfMassOffset(), false, (Tuple3DReadOnly)transform.getTranslation(), this.getMomentOfInertia());
            this.getCenterOfMassOffset().add((Tuple3DReadOnly)transform.getTranslation());
        }
    }

    default public void applyInverseTransform(RigidBodyTransform transform) {
        if (transform.hasTranslation()) {
            MecanoTools.translateMomentOfInertia(this.getMass(), (Tuple3DReadOnly)this.getCenterOfMassOffset(), true, (Tuple3DReadOnly)transform.getTranslation(), this.getMomentOfInertia());
            this.getCenterOfMassOffset().sub((Tuple3DReadOnly)transform.getTranslation());
        }
        if (transform.hasRotation()) {
            MecanoTools.inverseTransformSymmetricMatrix3D((RotationMatrixReadOnly)transform.getRotation(), this.getMomentOfInertia());
            this.getCenterOfMassOffset().applyInverseTransform((Transform)transform);
        }
    }
}

