/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.iterators;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.RigidBodyIterator;

public class RigidBodyIterable<B extends RigidBodyReadOnly>
implements Iterable<B> {
    private final Collection<? extends RigidBodyReadOnly> roots;
    private final Predicate<B> selectionRule;
    private final Class<B> filteringClass;

    public RigidBodyIterable(Class<B> filteringClass, Predicate<B> selectionRule, RigidBodyReadOnly root) {
        this.selectionRule = selectionRule;
        this.roots = Collections.singleton(root);
        this.filteringClass = filteringClass;
    }

    public RigidBodyIterable(Class<B> filteringClass, Predicate<B> selectionRule, Collection<? extends RigidBodyReadOnly> roots) {
        this.filteringClass = filteringClass;
        this.selectionRule = selectionRule;
        this.roots = roots;
    }

    @Override
    public Iterator<B> iterator() {
        return new RigidBodyIterator<B>(this.filteringClass, this.selectionRule, this.roots);
    }

    public Stream<B> toStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

