/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.tools.MecanoTools;

public interface SpatialInertiaReadOnly
extends ReferenceFrameHolder {
    public static final double COM_OFFSET_ZERO_EPSILON = 1.0E-11;

    public Matrix3DReadOnly getMomentOfInertia();

    public double getMass();

    public FrameVector3DReadOnly getCenterOfMassOffset();

    public ReferenceFrame getBodyFrame();

    default public boolean containsNaN() {
        return this.getMomentOfInertia().containsNaN() || Double.isNaN(this.getMass()) || this.getCenterOfMassOffset().containsNaN();
    }

    default public boolean isCenterOfMassOffsetZero() {
        return this.getCenterOfMassOffset().lengthSquared() < 1.0E-11;
    }

    default public void checkReferenceFrameMatch(SpatialInertiaReadOnly other) throws ReferenceFrameMismatchException {
        ReferenceFrame expressedInFrame = other.getReferenceFrame();
        ReferenceFrame bodyFrame = other.getBodyFrame();
        this.checkReferenceFrameMatch(bodyFrame, expressedInFrame);
    }

    default public void checkReferenceFrameMatch(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        super.checkReferenceFrameMatch(expressedInFrame);
        this.checkBodyFrameMatch(bodyFrame);
    }

    default public void checkBodyFrameMatch(ReferenceFrame bodyFrame) {
        if (this.getBodyFrame() != bodyFrame) {
            throw new ReferenceFrameMismatchException("bodyFrame mismatch: this.bodyFrame = " + this.getBodyFrame() + ", other bodyFrame = " + bodyFrame);
        }
    }

    default public void checkIfCenterOfMassOffsetIsZero() {
        if (!this.isCenterOfMassOffsetZero()) {
            throw new RuntimeException("Center of mass does not coincide with " + this.getReferenceFrame() + "'s origin.");
        }
    }

    default public void computeDynamicWrenchFast(SpatialAccelerationReadOnly acceleration, TwistReadOnly twist, WrenchBasics dynamicWrenchToPack) {
        this.checkIfCenterOfMassOffsetIsZero();
        this.computeDynamicWrench(acceleration, twist, dynamicWrenchToPack);
    }

    default public void computeDynamicWrench(SpatialAccelerationReadOnly acceleration, TwistReadOnly twist, WrenchBasics dynamicWrenchToPack) {
        FrameVector3DReadOnly linearAcceleration;
        FrameVector3DReadOnly angularAcceleration;
        FrameVector3DReadOnly linearVelocity;
        FrameVector3DReadOnly angularVelocity;
        this.checkBodyFrameMatch(this.getReferenceFrame());
        if (twist != null) {
            twist.checkBodyFrameMatch(this.getBodyFrame());
            twist.getBaseFrame().checkIsAStationaryFrame();
            twist.checkExpressedInFrameMatch(this.getReferenceFrame());
            angularVelocity = twist.getAngularPart();
            linearVelocity = twist.getLinearPart();
        } else {
            angularVelocity = null;
            linearVelocity = null;
        }
        if (acceleration != null) {
            acceleration.checkBodyFrameMatch(this.getBodyFrame());
            acceleration.getBaseFrame().checkIsAStationaryFrame();
            acceleration.checkExpressedInFrameMatch(this.getReferenceFrame());
            angularAcceleration = acceleration.getAngularPart();
            linearAcceleration = acceleration.getLinearPart();
        } else {
            angularAcceleration = null;
            linearAcceleration = null;
        }
        dynamicWrenchToPack.setToZero(this.getBodyFrame(), this.getReferenceFrame());
        FixedFrameVector3DBasics dynamicMoment = dynamicWrenchToPack.getAngularPart();
        FixedFrameVector3DBasics dynamicForce = dynamicWrenchToPack.getLinearPart();
        if (this.isCenterOfMassOffsetZero()) {
            MecanoTools.computeDynamicMomentFast(this.getMomentOfInertia(), (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DBasics)dynamicMoment);
            MecanoTools.computeDynamicForceFast(this.getMass(), (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce);
        } else {
            MecanoTools.computeDynamicMoment(this.getMomentOfInertia(), this.getMass(), (Vector3DReadOnly)this.getCenterOfMassOffset(), (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicMoment);
            MecanoTools.computeDynamicForce(this.getMass(), (Vector3DReadOnly)this.getCenterOfMassOffset(), (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce);
        }
    }

    default public double computeKineticCoEnergy(TwistReadOnly twist) {
        twist.checkBodyFrameMatch(this.getBodyFrame());
        twist.getBaseFrame().checkIsAStationaryFrame();
        twist.checkExpressedInFrameMatch(this.getReferenceFrame());
        return MecanoTools.computeKineticCoEnergy(this.getMomentOfInertia(), this.getMass(), (Vector3DReadOnly)this.getCenterOfMassOffset(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart());
    }

    default public void transform(SpatialVectorReadOnly vectorOriginal, FixedFrameSpatialVectorBasics vectorTransformed) {
        if (vectorOriginal == vectorTransformed) {
            throw new UnsupportedOperationException("In-place transformation is not supported.");
        }
        this.checkReferenceFrameMatch(vectorOriginal, vectorTransformed);
        if (this.isCenterOfMassOffsetZero()) {
            this.getMomentOfInertia().transform((Tuple3DReadOnly)vectorOriginal.getAngularPart(), (Tuple3DBasics)vectorTransformed.getAngularPart());
            vectorTransformed.getLinearPart().setAndScale(this.getMass(), (FrameTuple3DReadOnly)vectorOriginal.getLinearPart());
        } else {
            vectorTransformed.getAngularPart().cross(this.getCenterOfMassOffset(), vectorOriginal.getLinearPart());
            vectorTransformed.getAngularPart().scale(this.getMass());
            this.getMomentOfInertia().addTransform((Tuple3DReadOnly)vectorOriginal.getAngularPart(), (Tuple3DBasics)vectorTransformed.getAngularPart());
            vectorTransformed.getLinearPart().cross(vectorOriginal.getAngularPart(), this.getCenterOfMassOffset());
            vectorTransformed.getLinearPart().add((FrameTuple3DReadOnly)vectorOriginal.getLinearPart());
            vectorTransformed.getLinearPart().scale(this.getMass());
        }
    }

    default public void get(DMatrix matrixToPack) {
        this.get(0, 0, matrixToPack);
    }

    default public void get(int startRow, int startColumn, DMatrix matrixToPack) {
        this.getMomentOfInertia().get(startRow, startColumn, matrixToPack);
        MecanoTools.toTildeForm(this.getMass(), (Tuple3DReadOnly)this.getCenterOfMassOffset(), false, startRow, startColumn + 3, matrixToPack);
        MecanoTools.toTildeForm(this.getMass(), (Tuple3DReadOnly)this.getCenterOfMassOffset(), true, startRow + 3, startColumn, matrixToPack);
        startRow += 3;
        startColumn += 3;
        for (int i = 0; i < 3; ++i) {
            matrixToPack.set(startRow + i, startColumn + i, this.getMass());
            matrixToPack.set(startRow + i, startColumn + (i + 1) % 3, 0.0);
            matrixToPack.set(startRow + i, startColumn + (i + 2) % 3, 0.0);
        }
    }

    default public boolean epsilonEquals(SpatialInertiaReadOnly other, double epsilon) {
        if (this.getBodyFrame() != other.getBodyFrame()) {
            return false;
        }
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)this.getMass(), (double)other.getMass(), (double)epsilon)) {
            return false;
        }
        if (!this.getCenterOfMassOffset().epsilonEquals((EuclidFrameGeometry)other.getCenterOfMassOffset(), epsilon)) {
            return false;
        }
        return this.getMomentOfInertia().epsilonEquals((EuclidGeometry)other.getMomentOfInertia(), epsilon);
    }

    default public boolean geometricallyEquals(SpatialInertiaReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return this.epsilonEquals(other, epsilon);
    }

    default public boolean equals(SpatialInertiaReadOnly other) {
        if (other == null) {
            return false;
        }
        if (this.getBodyFrame() != other.getBodyFrame()) {
            return false;
        }
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        if (!this.getMomentOfInertia().equals((EuclidGeometry)other.getMomentOfInertia())) {
            return false;
        }
        if (this.getMass() != other.getMass()) {
            return false;
        }
        return this.getCenterOfMassOffset().equals((EuclidFrameGeometry)other.getCenterOfMassOffset());
    }
}

