/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem;

import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MecanoTools;

public abstract class Joint
implements JointBasics {
    protected final String name;
    private final String nameId;
    protected final RigidBodyBasics predecessor;
    protected RigidBodyBasics successor;
    protected final MovingReferenceFrame beforeJointFrame;
    protected final MovingReferenceFrame afterJointFrame;
    protected MovingReferenceFrame loopClosureFrame = null;

    public Joint(String name, RigidBodyBasics predecessor) {
        this(name, predecessor, null);
    }

    public Joint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        JointReadOnly.checkJointNameSanity(name);
        this.name = name;
        this.predecessor = predecessor;
        this.beforeJointFrame = MecanoFactories.newFrameBeforeJoint(this, transformToParent);
        this.afterJointFrame = MecanoFactories.newFrameAfterJoint(this);
        predecessor.addChildJoint(this);
        this.nameId = JointReadOnly.computeNameId(this);
    }

    @Override
    public void setupLoopClosure(RigidBodyBasics successor, RigidBodyTransformReadOnly transformFromSuccessorParentJoint) {
        RigidBodyTransform transformToSuccessorParentJoint = new RigidBodyTransform(transformFromSuccessorParentJoint);
        transformToSuccessorParentJoint.invert();
        this.loopClosureFrame = MovingReferenceFrame.constructFrameFixedInParent(MecanoTools.capitalize(this.getName()) + "LoopClosureFrame", this.getFrameAfterJoint(), (RigidBodyTransformReadOnly)transformToSuccessorParentJoint);
        this.setSuccessor(successor);
        successor.addParentLoopClosureJoint(this);
    }

    @Override
    public MovingReferenceFrame getFrameBeforeJoint() {
        return this.beforeJointFrame;
    }

    @Override
    public MovingReferenceFrame getFrameAfterJoint() {
        return this.afterJointFrame;
    }

    @Override
    public RigidBodyBasics getPredecessor() {
        return this.predecessor;
    }

    @Override
    public RigidBodyBasics getSuccessor() {
        return this.successor;
    }

    @Override
    public MovingReferenceFrame getLoopClosureFrame() {
        return this.loopClosureFrame;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameId() {
        return this.nameId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getName();
    }

    public int hashCode() {
        return this.nameId.hashCode();
    }
}

