/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class CenterOfMassJacobian
implements ReferenceFrameHolder {
    private final boolean isJacobianFrameAtCenterOfMass;
    private final ReferenceFrame jacobianFrame;
    private final ReferenceFrame rootFrame;
    private final MultiBodySystemReadOnly input;
    private final RecursionStep initialRecursionStep;
    private final RecursionStep[] recursionSteps;
    private final DMatrixRMaj jacobianMatrix;
    private final DMatrixRMaj jointVelocityMatrix;
    private final DMatrixRMaj centerOfMassVelocityMatrix = new DMatrixRMaj(3, 1);
    private final FixedFrameVector3DBasics jacobianColumn;
    private final Twist jointUnitTwist = new Twist();
    private final FixedFrameVector3DBasics centerOfMassVelocity = MecanoFactories.newFixedFrameVector3DBasics(this);
    private boolean isJacobianUpToDate = false;
    private boolean isCenterOfMassVelocityUpToDate = false;

    public CenterOfMassJacobian(RigidBodyReadOnly rootBody, String centerOfMassFrameName) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody), centerOfMassFrameName);
    }

    public CenterOfMassJacobian(RigidBodyReadOnly rootBody, ReferenceFrame jacobianFrame) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody), jacobianFrame);
    }

    public CenterOfMassJacobian(MultiBodySystemReadOnly input, String centerOfMassFrameName) {
        this(input, centerOfMassFrameName, true);
    }

    public CenterOfMassJacobian(MultiBodySystemReadOnly input, String centerOfMassFrameName, boolean considerIgnoredSubtreesInertia) {
        this(input, null, centerOfMassFrameName, considerIgnoredSubtreesInertia);
    }

    public CenterOfMassJacobian(MultiBodySystemReadOnly input, ReferenceFrame jacobianFrame) {
        this(input, jacobianFrame, true);
    }

    public CenterOfMassJacobian(MultiBodySystemReadOnly input, ReferenceFrame jacobianFrame, boolean considerIgnoredSubtreesInertia) {
        this(input, jacobianFrame, null, considerIgnoredSubtreesInertia);
    }

    private CenterOfMassJacobian(MultiBodySystemReadOnly input, ReferenceFrame jacobianFrame, String centerOfMassFrameName, boolean considerIgnoredSubtreesInertia) {
        this.input = input;
        this.isJacobianFrameAtCenterOfMass = jacobianFrame == null;
        RigidBodyReadOnly rootBody = input.getRootBody();
        this.rootFrame = rootBody.getBodyFixedFrame().getRootFrame();
        this.jacobianFrame = this.isJacobianFrameAtCenterOfMass ? new ReferenceFrame(centerOfMassFrameName, this.rootFrame){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.setTranslationAndIdentityRotation((Tuple3DReadOnly)CenterOfMassJacobian.this.initialRecursionStep.centerOfMass);
            }
        } : jacobianFrame;
        this.initialRecursionStep = new RecursionStep(rootBody, null);
        this.recursionSteps = this.buildMultiBodyTree(this.initialRecursionStep, input.getJointsToIgnore()).toArray(new RecursionStep[0]);
        if (considerIgnoredSubtreesInertia) {
            this.initialRecursionStep.includeIgnoredSubtreeInertia();
        }
        this.jacobianColumn = new FrameVector3D(this.jacobianFrame);
        int nDegreesOfFreedom = MultiBodySystemTools.computeDegreesOfFreedom(input.getJointsToConsider());
        this.jacobianMatrix = new DMatrixRMaj(3, nDegreesOfFreedom);
        this.jointVelocityMatrix = new DMatrixRMaj(nDegreesOfFreedom, 1);
    }

    /*
     * WARNING - void declaration
     */
    private List<RecursionStep> buildMultiBodyTree(RecursionStep parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        ArrayList<RecursionStep> recursionSteps = new ArrayList<RecursionStep>();
        recursionSteps.add(parent);
        ArrayList<? extends JointReadOnly> childrenJoints = new ArrayList<JointReadOnly>(parent.rigidBody.getChildrenJoints());
        if (childrenJoints.size() > 1) {
            void var6_7;
            ArrayList loopClosureAncestors = new ArrayList();
            boolean bl = false;
            while (var6_7 < childrenJoints.size()) {
                if (MultiBodySystemTools.doesSubtreeContainLoopClosure(((JointReadOnly)childrenJoints.get((int)var6_7)).getSuccessor())) {
                    loopClosureAncestors.add(childrenJoints.remove((int)var6_7));
                    continue;
                }
                ++var6_7;
            }
            childrenJoints.addAll(loopClosureAncestors);
        }
        for (JointReadOnly jointReadOnly : childrenJoints) {
            RigidBodyReadOnly childBody;
            if (jointsToIgnore.contains(jointReadOnly) || jointReadOnly.isLoopClosure() || (childBody = jointReadOnly.getSuccessor()) == null) continue;
            int[] jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(jointReadOnly);
            RecursionStep child = new RecursionStep(childBody, jointIndices);
            parent.children.add(child);
            recursionSteps.addAll(this.buildMultiBodyTree(child, jointsToIgnore));
        }
        return recursionSteps;
    }

    public void reset() {
        this.isJacobianUpToDate = false;
        this.isCenterOfMassVelocityUpToDate = false;
    }

    private void updateJacobian() {
        if (this.isJacobianUpToDate) {
            return;
        }
        this.passOne(this.initialRecursionStep);
        this.passTwo();
        this.passThree(1.0 / this.initialRecursionStep.subTreeMass);
        this.isJacobianUpToDate = true;
    }

    private void passOne(RecursionStep current) {
        for (int childIndex = 0; childIndex < current.children.size(); ++childIndex) {
            RecursionStep child = (RecursionStep)current.children.get(childIndex);
            this.passOne(child);
        }
        current.passOne();
    }

    private void passTwo() {
        if (!this.isJacobianFrameAtCenterOfMass) {
            return;
        }
        this.jacobianFrame.update();
        for (RecursionStep recursionStep : this.recursionSteps) {
            recursionStep.passTwo();
        }
    }

    private void passThree(double inverseOfTotalMass) {
        for (RecursionStep recursionStep : this.recursionSteps) {
            recursionStep.passThree(inverseOfTotalMass);
        }
    }

    private void updateCenterOfMassVelocity() {
        if (this.isCenterOfMassVelocityUpToDate) {
            return;
        }
        List<? extends JointReadOnly> joints = this.input.getJointMatrixIndexProvider().getIndexedJointsInOrder();
        MultiBodySystemTools.extractJointsState(joints, JointStateType.VELOCITY, (DMatrix)this.jointVelocityMatrix);
        CommonOps_DDRM.mult((DMatrix1Row)this.getJacobianMatrix(), (DMatrix1Row)this.jointVelocityMatrix, (DMatrix1Row)this.centerOfMassVelocityMatrix);
        this.centerOfMassVelocity.set((DMatrix)this.centerOfMassVelocityMatrix);
        this.isCenterOfMassVelocityUpToDate = true;
    }

    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    public double getTotalMass() {
        this.updateJacobian();
        return this.initialRecursionStep.subTreeMass;
    }

    public FramePoint3DReadOnly getCenterOfMass() {
        this.updateJacobian();
        return this.initialRecursionStep.centerOfMass;
    }

    public FrameVector3DReadOnly getCenterOfMassVelocity() {
        this.updateCenterOfMassVelocity();
        return this.centerOfMassVelocity;
    }

    public void getCenterOfMassVelocity(DMatrix1Row jointVelocityMatrix, FrameVector3DBasics centerOfMassVelocityToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)this.getJacobianMatrix(), (DMatrix1Row)jointVelocityMatrix, (DMatrix1Row)this.centerOfMassVelocityMatrix);
        centerOfMassVelocityToPack.setIncludingFrame(this.jacobianFrame, (DMatrix)this.centerOfMassVelocityMatrix);
    }

    public DMatrixRMaj getJacobianMatrix() {
        this.updateJacobian();
        return this.jacobianMatrix;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.jacobianFrame;
    }

    private class RecursionStep {
        private final RigidBodyReadOnly rigidBody;
        private final SpatialInertia bodyInertia;
        private double subTreeMass;
        private final FramePoint3D centerOfMassTimesMass = new FramePoint3D();
        private final FramePoint3D centerOfMass = new FramePoint3D();
        private final DMatrixRMaj jacobianJointBlock;
        private final List<RecursionStep> children = new ArrayList<RecursionStep>();
        private final int[] jointIndices;

        public RecursionStep(RigidBodyReadOnly rigidBody, int[] jointIndices) {
            this.rigidBody = rigidBody;
            this.jointIndices = jointIndices;
            if (this.isRoot()) {
                this.bodyInertia = null;
                this.jacobianJointBlock = null;
            } else {
                this.bodyInertia = new SpatialInertia(rigidBody.getInertia());
                this.jacobianJointBlock = new DMatrixRMaj(3, this.getJoint().getDegreesOfFreedom());
            }
        }

        public void includeIgnoredSubtreeInertia() {
            if (!this.isRoot() && this.children.size() != this.rigidBody.getChildrenJoints().size()) {
                for (JointReadOnly jointReadOnly : this.rigidBody.getChildrenJoints()) {
                    if (!CenterOfMassJacobian.this.input.getJointsToIgnore().contains(jointReadOnly)) continue;
                    SpatialInertia subtreeIneria = MultiBodySystemTools.computeSubtreeInertia(jointReadOnly);
                    subtreeIneria.changeFrame(this.rigidBody.getBodyFixedFrame());
                    this.bodyInertia.add(subtreeIneria);
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).includeIgnoredSubtreeInertia();
            }
        }

        public void passOne() {
            ReferenceFrame frameToUse;
            ReferenceFrame referenceFrame = frameToUse = CenterOfMassJacobian.this.isJacobianFrameAtCenterOfMass ? CenterOfMassJacobian.this.rootFrame : CenterOfMassJacobian.this.jacobianFrame;
            if (this.isRoot()) {
                int i;
                this.subTreeMass = this.bodyInertia == null ? 0.0 : this.bodyInertia.getMass();
                for (i = 0; i < this.children.size(); ++i) {
                    this.subTreeMass += this.children.get((int)i).subTreeMass;
                }
                if (this.bodyInertia == null) {
                    this.centerOfMassTimesMass.setToZero(frameToUse);
                } else {
                    this.centerOfMassTimesMass.setIncludingFrame((FrameTuple3DReadOnly)this.bodyInertia.getCenterOfMassOffset());
                    this.centerOfMassTimesMass.changeFrame(frameToUse);
                    this.centerOfMassTimesMass.scale(this.bodyInertia.getMass());
                }
                for (i = 0; i < this.children.size(); ++i) {
                    this.centerOfMassTimesMass.add((FrameTuple3DReadOnly)this.children.get((int)i).centerOfMassTimesMass);
                }
            } else {
                int i;
                this.subTreeMass = this.bodyInertia.getMass();
                for (i = 0; i < this.children.size(); ++i) {
                    this.subTreeMass += this.children.get((int)i).subTreeMass;
                }
                this.centerOfMassTimesMass.setIncludingFrame((FrameTuple3DReadOnly)this.bodyInertia.getCenterOfMassOffset());
                this.centerOfMassTimesMass.changeFrame(frameToUse);
                this.centerOfMassTimesMass.scale(this.bodyInertia.getMass());
                for (i = 0; i < this.children.size(); ++i) {
                    this.centerOfMassTimesMass.add((FrameTuple3DReadOnly)this.children.get((int)i).centerOfMassTimesMass);
                }
            }
            this.centerOfMass.setIncludingFrame((FrameTuple3DReadOnly)this.centerOfMassTimesMass);
            this.centerOfMass.scale(1.0 / this.subTreeMass);
        }

        public void passTwo() {
            this.centerOfMassTimesMass.setIncludingFrame((FrameTuple3DReadOnly)this.centerOfMass);
            this.centerOfMassTimesMass.sub((Tuple3DReadOnly)CenterOfMassJacobian.this.jacobianFrame.getTransformToRoot().getTranslation());
            this.centerOfMassTimesMass.setReferenceFrame(CenterOfMassJacobian.this.jacobianFrame);
            this.centerOfMassTimesMass.scale(this.subTreeMass);
        }

        public void passThree(double inverseOfTotalMass) {
            if (this.isRoot()) {
                return;
            }
            JointReadOnly joint = this.getJoint();
            for (int i = 0; i < joint.getDegreesOfFreedom(); ++i) {
                CenterOfMassJacobian.this.jointUnitTwist.setIncludingFrame(joint.getUnitTwists().get(i));
                CenterOfMassJacobian.this.jointUnitTwist.changeFrame(CenterOfMassJacobian.this.jacobianFrame);
                CenterOfMassJacobian.this.jacobianColumn.cross((FrameTuple3DReadOnly)CenterOfMassJacobian.this.jointUnitTwist.getAngularPart(), (FrameTuple3DReadOnly)this.centerOfMassTimesMass);
                CenterOfMassJacobian.this.jacobianColumn.scaleAdd(this.subTreeMass, (FrameTuple3DReadOnly)CenterOfMassJacobian.this.jointUnitTwist.getLinearPart(), (FrameTuple3DReadOnly)CenterOfMassJacobian.this.jacobianColumn);
                CenterOfMassJacobian.this.jacobianColumn.get(0, i, (DMatrix)this.jacobianJointBlock);
            }
            CommonOps_DDRM.scale((double)inverseOfTotalMass, (DMatrixD1)this.jacobianJointBlock);
            for (int dofIndex = 0; dofIndex < this.getJoint().getDegreesOfFreedom(); ++dofIndex) {
                int column = this.jointIndices[dofIndex];
                CommonOps_DDRM.extract((DMatrix)this.jacobianJointBlock, (int)0, (int)3, (int)dofIndex, (int)(dofIndex + 1), (DMatrix)CenterOfMassJacobian.this.jacobianMatrix, (int)0, (int)column);
            }
        }

        public boolean isRoot() {
            return this.jointIndices == null;
        }

        public JointReadOnly getJoint() {
            return this.rigidBody.getParentJoint();
        }
    }
}

