/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialVectorReadOnlyTest;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;

public abstract class FixedFrameSpatialVectorBasicsTest<T extends FixedFrameSpatialVectorBasics>
extends SpatialVectorReadOnlyTest<SpatialVectorReadOnly> {
    private static final int ITERATIONS = 1000;

    @Override
    public abstract T newEmptySpatialVector();

    @Override
    public abstract T newRandomSpatialVector(Random var1);

    @Override
    public abstract T newSpatialVector(ReferenceFrame var1, Vector3DReadOnly var2, Vector3DReadOnly var3);

    @Override
    public abstract T newCopySpatialVector(SpatialVectorReadOnly var1);

    public abstract void testSetMatchingFrame();

    @Override
    public abstract double getEpsilon();

    @Test
    public void testSetToZeroFixedFrame() {
        Random random = new Random(21623L);
        for (int i = 0; i < 1000; ++i) {
            T randomSpatialVector = this.newRandomSpatialVector(random);
            ReferenceFrame saveReferenceFrame = randomSpatialVector.getReferenceFrame();
            randomSpatialVector.setToZero();
            Assertions.assertEquals((double)randomSpatialVector.getAngularPartX(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialVector.getAngularPartY(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialVector.getAngularPartZ(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialVector.getLinearPartX(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialVector.getLinearPartY(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialVector.getLinearPartZ(), (double)0.0);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)saveReferenceFrame);
        }
    }

    @Test
    public void testSetToNaNFixedFrame() {
        Random random = new Random(31843L);
        for (int i = 0; i < 1000; ++i) {
            T randomSpatialVector = this.newRandomSpatialVector(random);
            ReferenceFrame saveReferenceFrame = randomSpatialVector.getReferenceFrame();
            randomSpatialVector.setToNaN();
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)randomSpatialVector.getAngularPart());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)randomSpatialVector.getLinearPart());
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)saveReferenceFrame);
        }
    }

    @Test
    public void testContainsNaN() throws Exception {
        Random random = new Random(31843L);
        for (int i = 0; i < 1000; ++i) {
            T randomSpatialVector = this.newRandomSpatialVector(random);
            FixedFrameVector3DBasics originalAngularPart = randomSpatialVector.getAngularPart();
            FixedFrameVector3DBasics originalLinearPart = randomSpatialVector.getAngularPart();
            Assertions.assertFalse((boolean)randomSpatialVector.containsNaN());
            randomSpatialVector.setAngularPartX(Double.NaN);
            Assertions.assertTrue((boolean)randomSpatialVector.containsNaN());
            randomSpatialVector.setAngularPartX(originalAngularPart.getX());
            randomSpatialVector.setAngularPartY(Double.NaN);
            Assertions.assertTrue((boolean)randomSpatialVector.containsNaN());
            randomSpatialVector.setAngularPartY(originalAngularPart.getY());
            randomSpatialVector.setAngularPartZ(Double.NaN);
            Assertions.assertTrue((boolean)randomSpatialVector.containsNaN());
            randomSpatialVector.setAngularPartZ(originalAngularPart.getZ());
            randomSpatialVector.setLinearPartX(Double.NaN);
            Assertions.assertTrue((boolean)randomSpatialVector.containsNaN());
            randomSpatialVector.setLinearPartX(originalLinearPart.getX());
            randomSpatialVector.setLinearPartY(Double.NaN);
            Assertions.assertTrue((boolean)randomSpatialVector.containsNaN());
            randomSpatialVector.setLinearPartY(originalLinearPart.getY());
            randomSpatialVector.setLinearPartZ(Double.NaN);
            Assertions.assertTrue((boolean)randomSpatialVector.containsNaN());
        }
    }

    @Test
    public void testSetElement() throws Exception {
        Random random = new Random(31843L);
        for (int i = 0; i < 1000; ++i) {
            Object randomSpatialVector = this.newRandomSpatialVector(random);
            double randomDouble = random.nextDouble();
            randomSpatialVector.setElement(0, randomDouble);
            Assertions.assertEquals((double)randomSpatialVector.getAngularPartX(), (double)randomDouble);
            randomDouble = random.nextDouble();
            randomSpatialVector.setElement(1, randomDouble);
            Assertions.assertEquals((double)randomSpatialVector.getAngularPartY(), (double)randomDouble);
            randomDouble = random.nextDouble();
            randomSpatialVector.setElement(2, randomDouble);
            Assertions.assertEquals((double)randomSpatialVector.getAngularPartZ(), (double)randomDouble);
            randomDouble = random.nextDouble();
            randomSpatialVector.setElement(3, randomDouble);
            Assertions.assertEquals((double)randomSpatialVector.getLinearPartX(), (double)randomDouble);
            randomDouble = random.nextDouble();
            randomSpatialVector.setElement(4, randomDouble);
            Assertions.assertEquals((double)randomSpatialVector.getLinearPartY(), (double)randomDouble);
            randomDouble = random.nextDouble();
            randomSpatialVector.setElement(5, randomDouble);
            Assertions.assertEquals((double)randomSpatialVector.getLinearPartZ(), (double)randomDouble);
            int randomIndex = random.nextInt();
            double randomTestDouble = random.nextDouble();
            if (randomIndex < 0 || randomIndex >= 6) {
                Assertions.assertThrows(IndexOutOfBoundsException.class, () -> randomSpatialVector.setElement(randomIndex, randomTestDouble));
                continue;
            }
            Assertions.assertDoesNotThrow(() -> randomSpatialVector.setElement(randomIndex, randomTestDouble));
        }
    }

    @Test
    public void testSettersFixedFrame() {
        FrameVector3D randomLinearPart;
        FrameVector3D randomAngularPart;
        Object originalSpatialVector;
        int startingMatrixRow;
        int row;
        DMatrixRMaj randomMatrix;
        int startingArrayIndex;
        int index;
        Object[] randomVectorArray;
        ReferenceFrame saveReferenceFrame;
        T randomSpatialVector;
        int i;
        Random random = new Random(21623L);
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            saveReferenceFrame = randomSpatialVector.getReferenceFrame();
            randomVectorArray = new double[6];
            for (index = 0; index < 6; ++index) {
                randomVectorArray[index] = random.nextDouble();
            }
            randomSpatialVector.set(randomVectorArray);
            Assertions.assertEquals((double)randomVectorArray[0], (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomVectorArray[1], (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomVectorArray[2], (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomVectorArray[3], (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomVectorArray[4], (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomVectorArray[5], (double)randomSpatialVector.getLinearPartZ());
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)saveReferenceFrame);
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            saveReferenceFrame = randomSpatialVector.getReferenceFrame();
            randomVectorArray = new double[24];
            for (index = 0; index < 24; ++index) {
                randomVectorArray[index] = random.nextDouble();
            }
            startingArrayIndex = i % 18;
            randomSpatialVector.set(startingArrayIndex, randomVectorArray);
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex], (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 1], (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 2], (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 3], (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 4], (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 5], (double)randomSpatialVector.getLinearPartZ());
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)saveReferenceFrame);
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            saveReferenceFrame = randomSpatialVector.getReferenceFrame();
            randomVectorArray = new float[24];
            for (index = 0; index < 6; ++index) {
                randomVectorArray[index] = random.nextFloat();
            }
            randomSpatialVector.set((float[])randomVectorArray);
            Assertions.assertEquals((double)randomVectorArray[0], (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomVectorArray[1], (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomVectorArray[2], (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomVectorArray[3], (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomVectorArray[4], (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomVectorArray[5], (double)randomSpatialVector.getLinearPartZ());
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)saveReferenceFrame);
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            saveReferenceFrame = randomSpatialVector.getReferenceFrame();
            randomVectorArray = new float[24];
            for (index = 0; index < 24; ++index) {
                randomVectorArray[index] = random.nextFloat();
            }
            startingArrayIndex = i % 18;
            randomSpatialVector.set(startingArrayIndex, (float[])randomVectorArray);
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex], (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 1], (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 2], (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 3], (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 4], (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 5], (double)randomSpatialVector.getLinearPartZ());
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)saveReferenceFrame);
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            saveReferenceFrame = randomSpatialVector.getReferenceFrame();
            randomMatrix = new DMatrixRMaj(6, 1);
            for (row = 0; row < 6; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            randomSpatialVector.set((DMatrix)randomMatrix);
            Assertions.assertEquals((double)randomMatrix.get(0, 0), (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomMatrix.get(1, 0), (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomMatrix.get(2, 0), (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomMatrix.get(3, 0), (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomMatrix.get(4, 0), (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomMatrix.get(5, 0), (double)randomSpatialVector.getLinearPartZ());
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)saveReferenceFrame);
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            saveReferenceFrame = randomSpatialVector.getReferenceFrame();
            randomMatrix = new DMatrixRMaj(24, 1);
            for (row = 0; row < 24; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            startingMatrixRow = i % 18;
            randomSpatialVector.set(startingMatrixRow, (DMatrix)randomMatrix);
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow, 0), (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 1, 0), (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 2, 0), (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 3, 0), (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 4, 0), (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 5, 0), (double)randomSpatialVector.getLinearPartZ());
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)saveReferenceFrame);
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            saveReferenceFrame = randomSpatialVector.getReferenceFrame();
            randomMatrix = new DMatrixRMaj(24, 24);
            for (row = 0; row < 24; ++row) {
                for (int column = 0; column < 24; ++column) {
                    randomMatrix.set(row, column, random.nextDouble());
                }
            }
            startingMatrixRow = i % 18;
            int startingMatrixColumn = Math.abs(random.nextInt()) % 18;
            randomSpatialVector.set(startingMatrixRow, startingMatrixColumn, (DMatrix)randomMatrix);
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow, startingMatrixColumn), (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 1, startingMatrixColumn), (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 2, startingMatrixColumn), (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 3, startingMatrixColumn), (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 4, startingMatrixColumn), (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 5, startingMatrixColumn), (double)randomSpatialVector.getLinearPartZ());
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)saveReferenceFrame);
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            saveReferenceFrame = originalSpatialVector.getReferenceFrame();
            Vector3D randomAngularPart2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D randomLinearPart2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            originalSpatialVector.set((Vector3DReadOnly)randomAngularPart2, (Vector3DReadOnly)randomLinearPart2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalSpatialVector.getAngularPart(), (EuclidGeometry)randomAngularPart2, (double)this.getEpsilon());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalSpatialVector.getLinearPart(), (EuclidGeometry)randomLinearPart2, (double)this.getEpsilon());
            Assertions.assertEquals((Object)originalSpatialVector.getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)originalSpatialVector.getAngularPart().getReferenceFrame(), (Object)saveReferenceFrame);
            Assertions.assertEquals((Object)originalSpatialVector.getLinearPart().getReferenceFrame(), (Object)saveReferenceFrame);
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            Object randomSpatialVectorDifferentReferenceFrame = this.newRandomSpatialVector(random);
            Assertions.assertNotEquals(originalSpatialVector, randomSpatialVectorDifferentReferenceFrame);
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> originalSpatialVector.set((SpatialVectorReadOnly)randomSpatialVectorDifferentReferenceFrame));
            T randomSpatialVectorSameReferenceFrame = this.newSpatialVector(originalSpatialVector.getReferenceFrame(), (Vector3DReadOnly)randomSpatialVectorDifferentReferenceFrame.getAngularPart(), (Vector3DReadOnly)randomSpatialVectorDifferentReferenceFrame.getLinearPart());
            originalSpatialVector.set(randomSpatialVectorSameReferenceFrame);
            Assertions.assertEquals(originalSpatialVector, randomSpatialVectorSameReferenceFrame);
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)originalSpatialVector.getReferenceFrame());
            randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)originalSpatialVector.getReferenceFrame());
            originalSpatialVector.set((FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)originalSpatialVector.getAngularPart(), (Object)randomAngularPart);
            Assertions.assertEquals((Object)originalSpatialVector.getLinearPart(), (Object)randomLinearPart);
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                randomAngularPart.setReferenceFrame(randomFrame);
                originalSpatialVector.set((FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            });
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)originalSpatialVector.getReferenceFrame());
            randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)originalSpatialVector.getReferenceFrame());
            originalSpatialVector.set(originalSpatialVector.getReferenceFrame(), (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)originalSpatialVector.getAngularPart(), (Object)randomAngularPart);
            Assertions.assertEquals((Object)originalSpatialVector.getLinearPart(), (Object)randomLinearPart);
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                randomAngularPart.setReferenceFrame(randomFrame);
                randomLinearPart.setReferenceFrame(randomFrame);
                originalSpatialVector.set(randomFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            });
        }
    }

    @Test
    public void testScale() {
        Random random = new Random(21623L);
        for (int i = 0; i < 1000; ++i) {
            T originalSpatialVector = this.newRandomSpatialVector(random);
            T expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            double randomDouble = random.nextDouble();
            Assertions.assertEquals(originalSpatialVector, expectedSpatialVector);
            expectedSpatialVector.scale(randomDouble);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() * randomDouble), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() * randomDouble), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() * randomDouble), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() * randomDouble), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() * randomDouble), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() * randomDouble), (double)this.getEpsilon());
        }
    }

    @Test
    public void testNegate() {
        Random random = new Random(21623L);
        for (int i = 0; i < 1000; ++i) {
            T originalSpatialVector = this.newRandomSpatialVector(random);
            T expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            Assertions.assertEquals(originalSpatialVector, expectedSpatialVector);
            expectedSpatialVector.negate();
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() * -1.0), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() * -1.0), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() * -1.0), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() * -1.0), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() * -1.0), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() * -1.0), (double)this.getEpsilon());
        }
    }

    @Test
    public void testNormalize() {
        Random random = new Random(21623L);
        for (int i = 0; i < 1000; ++i) {
            T originalSpatialVector = this.newRandomSpatialVector(random);
            T expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            double expectedScaleAfterNormalization = 1.0 / originalSpatialVector.length();
            Assertions.assertEquals(expectedSpatialVector, expectedSpatialVector);
            expectedSpatialVector.normalize();
            Assertions.assertEquals((double)expectedSpatialVector.length(), (double)1.0, (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() * expectedScaleAfterNormalization), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() * expectedScaleAfterNormalization), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() * expectedScaleAfterNormalization), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() * expectedScaleAfterNormalization), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() * expectedScaleAfterNormalization), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() * expectedScaleAfterNormalization), (double)this.getEpsilon());
        }
    }

    @Test
    public void testAdds() {
        int startingMatrixRow;
        int row;
        DMatrixRMaj randomMatrix;
        Object expectedSpatialVector;
        T originalSpatialVector;
        int i;
        Random random = new Random(21723L);
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            T addSpatialVectorSameReferenceFrame = this.newSpatialVector(originalSpatialVector.getReferenceFrame(), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            T expectedSpatialVector2 = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            expectedSpatialVector2.add(addSpatialVectorSameReferenceFrame);
            Assertions.assertEquals((double)expectedSpatialVector2.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() + addSpatialVectorSameReferenceFrame.getAngularPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector2.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() + addSpatialVectorSameReferenceFrame.getAngularPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector2.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() + addSpatialVectorSameReferenceFrame.getAngularPartZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector2.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() + addSpatialVectorSameReferenceFrame.getLinearPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector2.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() + addSpatialVectorSameReferenceFrame.getLinearPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector2.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() + addSpatialVectorSameReferenceFrame.getLinearPartZ()), (double)this.getEpsilon());
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T addSpatialVectorDifferentReferenceFrame = this.newSpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                expectedSpatialVector2.add(addSpatialVectorDifferentReferenceFrame);
            });
        }
        for (i = 0; i < 1000; ++i) {
            T firstSpatialVector = this.newRandomSpatialVector(random);
            T secondSpatialVectorSameReferenceFrame = this.newSpatialVector(firstSpatialVector.getReferenceFrame(), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            T newSpatialVector = this.newSpatialVector(firstSpatialVector.getReferenceFrame(), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            newSpatialVector.add(firstSpatialVector, secondSpatialVectorSameReferenceFrame);
            Assertions.assertEquals((double)newSpatialVector.getAngularPartX(), (double)(firstSpatialVector.getAngularPartX() + secondSpatialVectorSameReferenceFrame.getAngularPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)newSpatialVector.getAngularPartY(), (double)(firstSpatialVector.getAngularPartY() + secondSpatialVectorSameReferenceFrame.getAngularPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)newSpatialVector.getAngularPartZ(), (double)(firstSpatialVector.getAngularPartZ() + secondSpatialVectorSameReferenceFrame.getAngularPartZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)newSpatialVector.getLinearPartX(), (double)(firstSpatialVector.getLinearPartX() + secondSpatialVectorSameReferenceFrame.getLinearPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)newSpatialVector.getLinearPartY(), (double)(firstSpatialVector.getLinearPartY() + secondSpatialVectorSameReferenceFrame.getLinearPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)newSpatialVector.getLinearPartZ(), (double)(firstSpatialVector.getLinearPartZ() + secondSpatialVectorSameReferenceFrame.getLinearPartZ()), (double)this.getEpsilon());
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T secondSpatialVectorDifferentReferenceFrame = this.newSpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                newSpatialVector.add((SpatialVectorReadOnly)firstSpatialVector, secondSpatialVectorDifferentReferenceFrame);
            });
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            randomMatrix = new DMatrixRMaj(6, 1);
            for (row = 0; row < 6; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            expectedSpatialVector.add((DMatrix)randomMatrix);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() + randomMatrix.get(0, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() + randomMatrix.get(1, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() + randomMatrix.get(2, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() + randomMatrix.get(3, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() + randomMatrix.get(4, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() + randomMatrix.get(5, 0)), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            randomMatrix = new DMatrixRMaj(24, 1);
            for (row = 0; row < 24; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            startingMatrixRow = i % 18;
            expectedSpatialVector.add(startingMatrixRow, (DMatrix)randomMatrix);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() + randomMatrix.get(startingMatrixRow, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() + randomMatrix.get(startingMatrixRow + 1, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() + randomMatrix.get(startingMatrixRow + 2, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() + randomMatrix.get(startingMatrixRow + 3, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() + randomMatrix.get(startingMatrixRow + 4, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() + randomMatrix.get(startingMatrixRow + 5, 0)), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            randomMatrix = new DMatrixRMaj(24, 24);
            for (row = 0; row < 24; ++row) {
                for (int column = 0; column < 24; ++column) {
                    randomMatrix.set(row, column, random.nextDouble());
                }
            }
            startingMatrixRow = i % 18;
            int startingMatrixColumn = i % 18;
            expectedSpatialVector.add(startingMatrixRow, startingMatrixColumn, (DMatrix)randomMatrix);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() + randomMatrix.get(startingMatrixRow, startingMatrixColumn)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() + randomMatrix.get(startingMatrixRow + 1, startingMatrixColumn)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() + randomMatrix.get(startingMatrixRow + 2, startingMatrixColumn)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() + randomMatrix.get(startingMatrixRow + 3, startingMatrixColumn)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() + randomMatrix.get(startingMatrixRow + 4, startingMatrixColumn)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() + randomMatrix.get(startingMatrixRow + 5, startingMatrixColumn)), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            FrameVector3D randomAngularPartSameReferenceFrame = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)originalSpatialVector.getReferenceFrame());
            FrameVector3D randomLinearPartSameReferenceFrame = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)originalSpatialVector.getReferenceFrame());
            expectedSpatialVector.add((FrameVector3DReadOnly)randomAngularPartSameReferenceFrame, (FrameVector3DReadOnly)randomLinearPartSameReferenceFrame);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() + randomAngularPartSameReferenceFrame.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() + randomAngularPartSameReferenceFrame.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() + randomAngularPartSameReferenceFrame.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() + randomLinearPartSameReferenceFrame.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() + randomLinearPartSameReferenceFrame.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() + randomLinearPartSameReferenceFrame.getZ()), (double)this.getEpsilon());
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                FrameVector3D randomAngularPartDifferentReferenceFrame = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                FrameVector3D randomLinearPartDifferentReferenceFrame = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                expectedSpatialVector.add((FrameVector3DReadOnly)randomAngularPartDifferentReferenceFrame, (FrameVector3DReadOnly)randomLinearPartDifferentReferenceFrame);
            });
        }
    }

    @Test
    public void testSubs() {
        int startingMatrixRow;
        int row;
        DMatrixRMaj randomMatrix;
        Object expectedSpatialVector;
        T originalSpatialVector;
        int i;
        Random random = new Random(21723L);
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            T subSpatialVectorSameReferenceFrame = this.newSpatialVector(originalSpatialVector.getReferenceFrame(), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            T expectedSpatialVector2 = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            expectedSpatialVector2.sub(subSpatialVectorSameReferenceFrame);
            Assertions.assertEquals((double)expectedSpatialVector2.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() - subSpatialVectorSameReferenceFrame.getAngularPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector2.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() - subSpatialVectorSameReferenceFrame.getAngularPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector2.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() - subSpatialVectorSameReferenceFrame.getAngularPartZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector2.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() - subSpatialVectorSameReferenceFrame.getLinearPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector2.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() - subSpatialVectorSameReferenceFrame.getLinearPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector2.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() - subSpatialVectorSameReferenceFrame.getLinearPartZ()), (double)this.getEpsilon());
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T subSpatialVectorDifferentReferenceFrame = this.newSpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                expectedSpatialVector2.sub(subSpatialVectorDifferentReferenceFrame);
            });
        }
        for (i = 0; i < 1000; ++i) {
            T firstSpatialVector = this.newRandomSpatialVector(random);
            T secondSpatialVectorSameReferenceFrame = this.newSpatialVector(firstSpatialVector.getReferenceFrame(), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            T newSpatialVector = this.newSpatialVector(firstSpatialVector.getReferenceFrame(), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            newSpatialVector.sub(firstSpatialVector, secondSpatialVectorSameReferenceFrame);
            Assertions.assertEquals((double)newSpatialVector.getAngularPartX(), (double)(firstSpatialVector.getAngularPartX() - secondSpatialVectorSameReferenceFrame.getAngularPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)newSpatialVector.getAngularPartY(), (double)(firstSpatialVector.getAngularPartY() - secondSpatialVectorSameReferenceFrame.getAngularPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)newSpatialVector.getAngularPartZ(), (double)(firstSpatialVector.getAngularPartZ() - secondSpatialVectorSameReferenceFrame.getAngularPartZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)newSpatialVector.getLinearPartX(), (double)(firstSpatialVector.getLinearPartX() - secondSpatialVectorSameReferenceFrame.getLinearPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)newSpatialVector.getLinearPartY(), (double)(firstSpatialVector.getLinearPartY() - secondSpatialVectorSameReferenceFrame.getLinearPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)newSpatialVector.getLinearPartZ(), (double)(firstSpatialVector.getLinearPartZ() - secondSpatialVectorSameReferenceFrame.getLinearPartZ()), (double)this.getEpsilon());
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T secondSpatialVectorDifferentReferenceFrame = this.newSpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                newSpatialVector.sub((SpatialVectorReadOnly)firstSpatialVector, secondSpatialVectorDifferentReferenceFrame);
            });
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            randomMatrix = new DMatrixRMaj(6, 1);
            for (row = 0; row < 6; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            expectedSpatialVector.sub((DMatrix)randomMatrix);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() - randomMatrix.get(0, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() - randomMatrix.get(1, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() - randomMatrix.get(2, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() - randomMatrix.get(3, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() - randomMatrix.get(4, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() - randomMatrix.get(5, 0)), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            randomMatrix = new DMatrixRMaj(24, 1);
            for (row = 0; row < 24; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            startingMatrixRow = i % 18;
            expectedSpatialVector.sub(startingMatrixRow, (DMatrix)randomMatrix);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() - randomMatrix.get(startingMatrixRow, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() - randomMatrix.get(startingMatrixRow + 1, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() - randomMatrix.get(startingMatrixRow + 2, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() - randomMatrix.get(startingMatrixRow + 3, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() - randomMatrix.get(startingMatrixRow + 4, 0)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() - randomMatrix.get(startingMatrixRow + 5, 0)), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            randomMatrix = new DMatrixRMaj(24, 24);
            for (row = 0; row < 24; ++row) {
                for (int column = 0; column < 24; ++column) {
                    randomMatrix.set(row, column, random.nextDouble());
                }
            }
            startingMatrixRow = i % 18;
            int startingMatrixColumn = i % 18;
            expectedSpatialVector.sub(startingMatrixRow, startingMatrixColumn, (DMatrix)randomMatrix);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() - randomMatrix.get(startingMatrixRow, startingMatrixColumn)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() - randomMatrix.get(startingMatrixRow + 1, startingMatrixColumn)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() - randomMatrix.get(startingMatrixRow + 2, startingMatrixColumn)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() - randomMatrix.get(startingMatrixRow + 3, startingMatrixColumn)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() - randomMatrix.get(startingMatrixRow + 4, startingMatrixColumn)), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() - randomMatrix.get(startingMatrixRow + 5, startingMatrixColumn)), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            FrameVector3D randomAngularPartSameReferenceFrame = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)originalSpatialVector.getReferenceFrame());
            FrameVector3D randomLinearPartSameReferenceFrame = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)originalSpatialVector.getReferenceFrame());
            expectedSpatialVector.sub((FrameVector3DReadOnly)randomAngularPartSameReferenceFrame, (FrameVector3DReadOnly)randomLinearPartSameReferenceFrame);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() - randomAngularPartSameReferenceFrame.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() - randomAngularPartSameReferenceFrame.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() - randomAngularPartSameReferenceFrame.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() - randomLinearPartSameReferenceFrame.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() - randomLinearPartSameReferenceFrame.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() - randomLinearPartSameReferenceFrame.getZ()), (double)this.getEpsilon());
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                FrameVector3D randomAngularPartDifferentReferenceFrame = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                FrameVector3D randomLinearPartDifferentReferenceFrame = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                expectedSpatialVector.sub((FrameVector3DReadOnly)randomAngularPartDifferentReferenceFrame, (FrameVector3DReadOnly)randomLinearPartDifferentReferenceFrame);
            });
        }
    }

    @Test
    public void testInterpolate() {
        double randomDouble;
        T expectedSpatialVector;
        int i;
        Random random = new Random(21723L);
        for (i = 0; i < 1000; ++i) {
            T originalSpatialVector = this.newRandomSpatialVector(random);
            T interpolateSpatialVectorSameReferenceFrame = this.newSpatialVector(originalSpatialVector.getReferenceFrame(), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            randomDouble = random.nextDouble();
            expectedSpatialVector.interpolate(interpolateSpatialVectorSameReferenceFrame, randomDouble);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)((1.0 - randomDouble) * originalSpatialVector.getAngularPartX() + randomDouble * interpolateSpatialVectorSameReferenceFrame.getAngularPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)((1.0 - randomDouble) * originalSpatialVector.getAngularPartY() + randomDouble * interpolateSpatialVectorSameReferenceFrame.getAngularPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)((1.0 - randomDouble) * originalSpatialVector.getAngularPartZ() + randomDouble * interpolateSpatialVectorSameReferenceFrame.getAngularPartZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)((1.0 - randomDouble) * originalSpatialVector.getLinearPartX() + randomDouble * interpolateSpatialVectorSameReferenceFrame.getLinearPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)((1.0 - randomDouble) * originalSpatialVector.getLinearPartY() + randomDouble * interpolateSpatialVectorSameReferenceFrame.getLinearPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)((1.0 - randomDouble) * originalSpatialVector.getLinearPartZ() + randomDouble * interpolateSpatialVectorSameReferenceFrame.getLinearPartZ()), (double)this.getEpsilon());
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T interpolateSpatialVectorDifferentReferenceFrame = this.newSpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                expectedSpatialVector.interpolate(interpolateSpatialVectorDifferentReferenceFrame, randomDouble);
            });
        }
        for (i = 0; i < 1000; ++i) {
            T firstInterpolateSpatialVectorSameReferenceFrame = this.newRandomSpatialVector(random);
            T secondInterpolateSpatialVectorSameReferenceFrame = this.newSpatialVector(firstInterpolateSpatialVectorSameReferenceFrame.getReferenceFrame(), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expectedSpatialVector = this.newSpatialVector(firstInterpolateSpatialVectorSameReferenceFrame.getReferenceFrame(), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            randomDouble = random.nextDouble();
            expectedSpatialVector.interpolate(firstInterpolateSpatialVectorSameReferenceFrame, secondInterpolateSpatialVectorSameReferenceFrame, randomDouble);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)((1.0 - randomDouble) * firstInterpolateSpatialVectorSameReferenceFrame.getAngularPartX() + randomDouble * secondInterpolateSpatialVectorSameReferenceFrame.getAngularPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)((1.0 - randomDouble) * firstInterpolateSpatialVectorSameReferenceFrame.getAngularPartY() + randomDouble * secondInterpolateSpatialVectorSameReferenceFrame.getAngularPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)((1.0 - randomDouble) * firstInterpolateSpatialVectorSameReferenceFrame.getAngularPartZ() + randomDouble * secondInterpolateSpatialVectorSameReferenceFrame.getAngularPartZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)((1.0 - randomDouble) * firstInterpolateSpatialVectorSameReferenceFrame.getLinearPartX() + randomDouble * secondInterpolateSpatialVectorSameReferenceFrame.getLinearPartX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)((1.0 - randomDouble) * firstInterpolateSpatialVectorSameReferenceFrame.getLinearPartY() + randomDouble * secondInterpolateSpatialVectorSameReferenceFrame.getLinearPartY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)((1.0 - randomDouble) * firstInterpolateSpatialVectorSameReferenceFrame.getLinearPartZ() + randomDouble * secondInterpolateSpatialVectorSameReferenceFrame.getLinearPartZ()), (double)this.getEpsilon());
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T interpolateSpatialVectorDifferentReferenceFrame = this.newSpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                expectedSpatialVector.interpolate(interpolateSpatialVectorDifferentReferenceFrame, (SpatialVectorReadOnly)secondInterpolateSpatialVectorSameReferenceFrame, randomDouble);
            });
        }
    }

    @Test
    public void testAddCrossToAngularPart() {
        Random random = new Random(21723L);
        for (int i = 0; i < 1000; ++i) {
            T originalSpatialVector = this.newRandomSpatialVector(random);
            T expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            Point3D firstTuple3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D secondTuple3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expectedSpatialVector.addCrossToAngularPart((Tuple3DReadOnly)firstTuple3D, (Tuple3DReadOnly)secondTuple3D);
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() + (firstTuple3D.getY() * secondTuple3D.getZ() - firstTuple3D.getZ() * secondTuple3D.getY())), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() + (firstTuple3D.getZ() * secondTuple3D.getX() - firstTuple3D.getX() * secondTuple3D.getZ())), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() + (firstTuple3D.getX() * secondTuple3D.getY() - firstTuple3D.getY() * secondTuple3D.getX())), (double)this.getEpsilon());
        }
    }

    @Test
    public void testAddCrossToLinearPart() {
        Random random = new Random(24213L);
        for (int i = 0; i < 1000; ++i) {
            T originalSpatialVector = this.newRandomSpatialVector(random);
            T expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            Point3D firstTuple3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D secondTuple3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expectedSpatialVector.addCrossToLinearPart((Tuple3DReadOnly)firstTuple3D, (Tuple3DReadOnly)secondTuple3D);
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() + (firstTuple3D.getY() * secondTuple3D.getZ() - firstTuple3D.getZ() * secondTuple3D.getY())), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() + (firstTuple3D.getZ() * secondTuple3D.getX() - firstTuple3D.getX() * secondTuple3D.getZ())), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedSpatialVector.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() + (firstTuple3D.getX() * secondTuple3D.getY() - firstTuple3D.getY() * secondTuple3D.getX())), (double)this.getEpsilon());
        }
    }

    @Test
    public void testApplyTransform() throws Exception {
        T expectedSpatialVector;
        T originalSpatialVector;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(25613L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            Assertions.assertEquals(expectedSpatialVector, originalSpatialVector);
            transform.transform((Vector3DBasics)expectedSpatialVector.getAngularPart());
            transform.transform((Vector3DBasics)expectedSpatialVector.getLinearPart());
            Assertions.assertNotEquals(expectedSpatialVector, originalSpatialVector);
            originalSpatialVector.applyTransform((Transform)transform);
            Assertions.assertEquals(expectedSpatialVector, originalSpatialVector);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            Assertions.assertEquals(expectedSpatialVector, originalSpatialVector);
            transform.transform((Vector3DBasics)expectedSpatialVector.getAngularPart());
            transform.transform((Vector3DBasics)expectedSpatialVector.getLinearPart());
            Assertions.assertNotEquals(expectedSpatialVector, originalSpatialVector);
            originalSpatialVector.applyTransform((Transform)transform);
            Assertions.assertEquals(expectedSpatialVector, originalSpatialVector);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            expectedSpatialVector.set(originalSpatialVector);
            Assertions.assertEquals(expectedSpatialVector, originalSpatialVector);
            transform.transform((Vector3DBasics)expectedSpatialVector.getAngularPart());
            transform.transform((Vector3DBasics)expectedSpatialVector.getLinearPart());
            Assertions.assertNotEquals(expectedSpatialVector, originalSpatialVector);
            originalSpatialVector.applyTransform((Transform)transform);
            Assertions.assertEquals(expectedSpatialVector, originalSpatialVector);
        }
    }

    @Test
    public void testApplyInverseTransform() throws Exception {
        T expectedSpatialVector;
        T originalSpatialVector;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            expectedSpatialVector.set(originalSpatialVector);
            Assertions.assertEquals(originalSpatialVector, expectedSpatialVector);
            expectedSpatialVector.applyTransform((Transform)transform);
            Assertions.assertNotEquals(expectedSpatialVector, originalSpatialVector);
            expectedSpatialVector.applyInverseTransform((Transform)transform);
            Assertions.assertTrue((boolean)expectedSpatialVector.epsilonEquals(originalSpatialVector, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            expectedSpatialVector.set(originalSpatialVector);
            Assertions.assertEquals(originalSpatialVector, expectedSpatialVector);
            expectedSpatialVector.applyTransform((Transform)transform);
            Assertions.assertNotEquals(expectedSpatialVector, originalSpatialVector);
            expectedSpatialVector.applyInverseTransform((Transform)transform);
            Assertions.assertTrue((boolean)expectedSpatialVector.epsilonEquals(originalSpatialVector, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            originalSpatialVector = this.newRandomSpatialVector(random);
            expectedSpatialVector = this.newCopySpatialVector((SpatialVectorReadOnly)originalSpatialVector);
            expectedSpatialVector.set(originalSpatialVector);
            Assertions.assertEquals(originalSpatialVector, expectedSpatialVector);
            expectedSpatialVector.applyTransform((Transform)transform);
            Assertions.assertNotEquals(expectedSpatialVector, originalSpatialVector);
            expectedSpatialVector.applyInverseTransform((Transform)transform);
            Assertions.assertTrue((boolean)expectedSpatialVector.epsilonEquals(originalSpatialVector, this.getEpsilon()));
        }
    }
}

