/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.ArticulatedBodyInertia;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;

public class ArticulatedBodyInertiaTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testApplyTransform() {
        Random random = new Random(2552L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame expressedInFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia spatialInertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)expressedInFrame);
            ArticulatedBodyInertia articulatedBodyInertia = new ArticulatedBodyInertia();
            articulatedBodyInertia.setIncludingFrame((SpatialInertiaReadOnly)spatialInertia);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            spatialInertia.applyTransform((RigidBodyTransformReadOnly)transform);
            articulatedBodyInertia.applyTransform(transform);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            spatialInertia.applyTransform((RigidBodyTransformReadOnly)transform);
            articulatedBodyInertia.applyTransform(transform);
            DMatrixRMaj expected = new DMatrixRMaj(6, 6);
            DMatrixRMaj actual = new DMatrixRMaj(6, 6);
            spatialInertia.get((DMatrix)expected);
            articulatedBodyInertia.get((DMatrix)actual);
            boolean areEqual = MatrixFeatures_DDRM.isEquals((DMatrixD1)expected, (DMatrixD1)actual, (double)1.0E-12);
            if (!areEqual) {
                LogTools.info((String)("expected: " + expected));
                LogTools.info((String)("actual: " + actual));
            }
            Assertions.assertTrue((boolean)areEqual);
        }
    }

    @Test
    public void testApplyInverseTransform() {
        int i;
        Random random = new Random(2552L);
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame expressedInFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia spatialInertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)expressedInFrame);
            ArticulatedBodyInertia articulatedBodyInertia = new ArticulatedBodyInertia();
            articulatedBodyInertia.setIncludingFrame((SpatialInertiaReadOnly)spatialInertia);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            spatialInertia.applyInverseTransform((RigidBodyTransformReadOnly)transform);
            articulatedBodyInertia.applyInverseTransform(transform);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            spatialInertia.applyInverseTransform((RigidBodyTransformReadOnly)transform);
            articulatedBodyInertia.applyInverseTransform(transform);
            DMatrixRMaj expected = new DMatrixRMaj(6, 6);
            DMatrixRMaj actual = new DMatrixRMaj(6, 6);
            spatialInertia.get((DMatrix)expected);
            articulatedBodyInertia.get((DMatrix)actual);
            boolean areEqual = MatrixFeatures_DDRM.isEquals((DMatrixD1)expected, (DMatrixD1)actual, (double)1.0E-12);
            if (!areEqual) {
                LogTools.info((String)("expected: " + expected));
                LogTools.info((String)("actual: " + actual));
            }
            Assertions.assertTrue((boolean)areEqual);
        }
        for (i = 0; i < 1000; ++i) {
            ArticulatedBodyInertia articulatedBodyInertia = new ArticulatedBodyInertia();
            articulatedBodyInertia.getAngularInertia().set(MecanoRandomTools.nextSymmetricPositiveDefiniteMatrix3D((Random)random));
            articulatedBodyInertia.getLinearInertia().set(MecanoRandomTools.nextSymmetricPositiveDefiniteMatrix3D((Random)random));
            articulatedBodyInertia.getCrossInertia().set(EuclidCoreRandomTools.nextMatrix3D((Random)random));
            DMatrixRMaj expected = new DMatrixRMaj(6, 6);
            DMatrixRMaj actual = new DMatrixRMaj(6, 6);
            articulatedBodyInertia.get((DMatrix)expected);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            articulatedBodyInertia.applyTransform(transform);
            articulatedBodyInertia.applyInverseTransform(transform);
            articulatedBodyInertia.get((DMatrix)actual);
            boolean areEqual = MatrixFeatures_DDRM.isEquals((DMatrixD1)expected, (DMatrixD1)actual, (double)1.0E-12);
            if (!areEqual) {
                LogTools.info((String)("expected: " + expected));
                LogTools.info((String)("actual: " + actual));
            }
            Assertions.assertTrue((boolean)areEqual);
        }
    }
}

