/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MultiBodySystemToolsTest {
    public static final int ITERATIONS = 1000;

    @Test
    public void testCreateJointPath() throws Exception {
        Random random = new Random(34535L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 100;
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            RigidBodyBasics bodyA = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            RigidBodyBasics bodyB = (RigidBodyBasics)bodyA.subtreeList().get(random.nextInt(bodyA.subtreeList().size()));
            JointBasics[] jointPath = MultiBodySystemTools.createJointPath((RigidBodyBasics)bodyA, (RigidBodyBasics)bodyB);
            Assertions.assertNotNull((Object)jointPath);
            Assertions.assertEquals((int)MultiBodySystemTools.computeDistanceToAncestor((RigidBodyReadOnly)bodyB, (RigidBodyReadOnly)bodyA), (int)jointPath.length);
            if (bodyA == bodyB) continue;
            Assertions.assertEquals((Object)bodyA, (Object)jointPath[0].getPredecessor());
            RigidBodyReadOnly expectedPredessor = null;
            int nDoFs = 0;
            for (JointBasics joint : jointPath) {
                if (expectedPredessor != null) {
                    Assertions.assertEquals((Object)expectedPredessor, (Object)joint.getPredecessor());
                }
                expectedPredessor = joint.getSuccessor();
                nDoFs += joint.getDegreesOfFreedom();
            }
            Assertions.assertEquals((Object)bodyB, (Object)jointPath[jointPath.length - 1].getSuccessor());
            Assertions.assertEquals((int)nDoFs, (int)MultiBodySystemTools.computeDegreesOfFreedom((RigidBodyReadOnly)bodyA, (RigidBodyReadOnly)bodyB));
        }
    }

    @Test
    public void testCollectJointPath() {
        int i;
        Random random = new Random(5436L);
        for (i = 0; i < 1000; ++i) {
            int numberOfJoints = random.nextInt(100) + 1;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            int startJointIndex = random.nextInt(numberOfJoints);
            int endJointIndex = random.nextInt(numberOfJoints - startJointIndex) + startJointIndex;
            List expectedPath = joints.subList(startJointIndex, endJointIndex + 1);
            RigidBodyBasics start = ((JointBasics)expectedPath.get(0)).getPredecessor();
            RigidBodyBasics end = ((JointBasics)expectedPath.get(expectedPath.size() - 1)).getSuccessor();
            ArrayList actualPathBasics = new ArrayList();
            MultiBodySystemTools.collectJointPath((RigidBodyBasics)start, (RigidBodyBasics)end, actualPathBasics);
            Assertions.assertEquals(expectedPath, actualPathBasics);
            ArrayList actualPathReadOnly = new ArrayList();
            MultiBodySystemTools.collectJointPath((RigidBodyReadOnly)start, (RigidBodyReadOnly)end, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
            Collections.reverse(expectedPath);
            MultiBodySystemTools.collectJointPath((RigidBodyBasics)end, (RigidBodyBasics)start, actualPathBasics);
            Assertions.assertEquals(expectedPath, actualPathBasics);
            MultiBodySystemTools.collectJointPath((RigidBodyReadOnly)end, (RigidBodyReadOnly)start, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
        }
        for (i = 0; i < 1000; ++i) {
            int trunkSize = random.nextInt(20) + 1;
            int branch0Size = random.nextInt(20) + 1;
            int branch1Size = random.nextInt(20) + 1;
            List trunk = MultiBodySystemRandomTools.nextJointChain((Random)random, (String)"trunk", (int)trunkSize);
            RigidBodyBasics bifurcation = ((JointBasics)trunk.get(trunkSize - 1)).getSuccessor();
            List branch0 = MultiBodySystemRandomTools.nextJointChain((Random)random, (String)"branch0", (RigidBodyBasics)bifurcation, (int)branch0Size);
            List branch1 = MultiBodySystemRandomTools.nextJointChain((Random)random, (String)"branch1", (RigidBodyBasics)bifurcation, (int)branch1Size);
            int startIndex = random.nextInt(branch0Size);
            RigidBodyBasics start = ((JointBasics)branch0.get(startIndex)).getSuccessor();
            int endIndex = random.nextInt(branch1Size);
            RigidBodyBasics end = ((JointBasics)branch1.get(endIndex)).getSuccessor();
            ArrayList pathOnBranch0 = new ArrayList(branch0.subList(0, startIndex + 1));
            ArrayList pathOnBranch1 = new ArrayList(branch1.subList(0, endIndex + 1));
            Collections.reverse(pathOnBranch0);
            ArrayList expectedPath = new ArrayList();
            expectedPath.addAll(pathOnBranch0);
            expectedPath.addAll(pathOnBranch1);
            ArrayList actualPath = new ArrayList();
            MultiBodySystemTools.collectJointPath((RigidBodyBasics)start, (RigidBodyBasics)end, actualPath);
            Assertions.assertEquals(expectedPath, actualPath);
            ArrayList actualPathReadOnly = new ArrayList();
            MultiBodySystemTools.collectJointPath((RigidBodyReadOnly)start, (RigidBodyReadOnly)end, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
            Collections.reverse(expectedPath);
            MultiBodySystemTools.collectJointPath((RigidBodyBasics)end, (RigidBodyBasics)start, actualPath);
            Assertions.assertEquals(expectedPath, actualPath);
            MultiBodySystemTools.collectJointPath((RigidBodyReadOnly)end, (RigidBodyReadOnly)start, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
        }
        int numberOfJoints = 500;
        List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
        for (int i2 = 0; i2 < 1000; ++i2) {
            RigidBodyBasics firstBody = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            RigidBodyBasics secondBody = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            RigidBodyBasics ancestor = MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)firstBody, (RigidBodyBasics)secondBody);
            ArrayList<JointBasics> pathFirstHalf = new ArrayList<JointBasics>();
            RigidBodyBasics body = firstBody;
            while (body != ancestor) {
                pathFirstHalf.add(body.getParentJoint());
                body = body.getParentJoint().getPredecessor();
            }
            ArrayList<JointBasics> pathSecondHalf = new ArrayList<JointBasics>();
            RigidBodyBasics body2 = secondBody;
            while (body2 != ancestor) {
                pathSecondHalf.add(body2.getParentJoint());
                body2 = body2.getParentJoint().getPredecessor();
            }
            Collections.reverse(pathSecondHalf);
            ArrayList<JointBasics> expectedPath = new ArrayList<JointBasics>();
            expectedPath.addAll(pathFirstHalf);
            expectedPath.addAll(pathSecondHalf);
            ArrayList actualPath = new ArrayList();
            MultiBodySystemTools.collectJointPath((RigidBodyBasics)firstBody, (RigidBodyBasics)secondBody, actualPath);
            Assertions.assertEquals(expectedPath, actualPath);
            ArrayList actualPathReadOnly = new ArrayList();
            MultiBodySystemTools.collectJointPath((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)secondBody, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
            Collections.reverse(expectedPath);
            MultiBodySystemTools.collectJointPath((RigidBodyBasics)secondBody, (RigidBodyBasics)firstBody, actualPath);
            Assertions.assertEquals(expectedPath, actualPath);
            MultiBodySystemTools.collectJointPath((RigidBodyReadOnly)secondBody, (RigidBodyReadOnly)firstBody, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
        }
    }

    @Test
    public void testCollectRigidBodyPath() {
        int i;
        Random random = new Random(5436L);
        for (i = 0; i < 1000; ++i) {
            int numberOfJoints = random.nextInt(100) + 1;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            int startJointIndex = random.nextInt(numberOfJoints);
            int endJointIndex = random.nextInt(numberOfJoints - startJointIndex) + startJointIndex;
            List expectedPath = joints.subList(startJointIndex, endJointIndex + 1).stream().map(JointBasics::getPredecessor).collect(Collectors.toList());
            RigidBodyBasics start = (RigidBodyBasics)expectedPath.get(0);
            RigidBodyBasics end = (RigidBodyBasics)expectedPath.get(expectedPath.size() - 1);
            ArrayList actualPathBasics = new ArrayList();
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyBasics)start, (RigidBodyBasics)end, actualPathBasics);
            Assertions.assertEquals(expectedPath, actualPathBasics);
            ArrayList actualPathReadOnly = new ArrayList();
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyReadOnly)start, (RigidBodyReadOnly)end, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
            Collections.reverse(expectedPath);
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyBasics)end, (RigidBodyBasics)start, actualPathBasics);
            Assertions.assertEquals(expectedPath, actualPathBasics);
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyReadOnly)end, (RigidBodyReadOnly)start, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
        }
        for (i = 0; i < 1000; ++i) {
            int trunkSize = random.nextInt(20) + 1;
            int branch0Size = random.nextInt(20) + 1;
            int branch1Size = random.nextInt(20) + 1;
            List trunk = MultiBodySystemRandomTools.nextJointChain((Random)random, (String)"trunk", (int)trunkSize);
            RigidBodyBasics bifurcation = ((JointBasics)trunk.get(trunkSize - 1)).getSuccessor();
            List branch0 = MultiBodySystemRandomTools.nextJointChain((Random)random, (String)"branch0", (RigidBodyBasics)bifurcation, (int)branch0Size);
            List branch1 = MultiBodySystemRandomTools.nextJointChain((Random)random, (String)"branch1", (RigidBodyBasics)bifurcation, (int)branch1Size);
            List pathOnBranch0 = branch0.subList(0, random.nextInt(branch0Size) + 1).stream().map(JointBasics::getSuccessor).collect(Collectors.toList());
            List pathOnBranch1 = branch1.subList(0, random.nextInt(branch1Size) + 1).stream().map(JointBasics::getSuccessor).collect(Collectors.toList());
            RigidBodyBasics start = (RigidBodyBasics)pathOnBranch0.get(pathOnBranch0.size() - 1);
            RigidBodyBasics end = (RigidBodyBasics)pathOnBranch1.get(pathOnBranch1.size() - 1);
            Collections.reverse(pathOnBranch0);
            ArrayList expectedPath = new ArrayList();
            expectedPath.addAll(pathOnBranch0);
            expectedPath.addAll(pathOnBranch1);
            ArrayList actualPath = new ArrayList();
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyBasics)start, (RigidBodyBasics)end, actualPath);
            Assertions.assertEquals(expectedPath, actualPath, (String)("Iteration: " + i));
            ArrayList actualPathReadOnly = new ArrayList();
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyReadOnly)start, (RigidBodyReadOnly)end, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
            Collections.reverse(expectedPath);
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyBasics)end, (RigidBodyBasics)start, actualPath);
            Assertions.assertEquals(expectedPath, actualPath);
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyReadOnly)end, (RigidBodyReadOnly)start, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
        }
        int numberOfJoints = 500;
        List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
        for (int i2 = 0; i2 < 1000; ++i2) {
            RigidBodyBasics firstBody = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            RigidBodyBasics secondBody = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            RigidBodyBasics ancestor = MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)firstBody, (RigidBodyBasics)secondBody);
            ArrayList<RigidBodyBasics> pathFirstHalf = new ArrayList<RigidBodyBasics>();
            if (firstBody == ancestor) {
                pathFirstHalf.add(firstBody);
            } else {
                RigidBodyBasics body = firstBody;
                while (body != ancestor) {
                    pathFirstHalf.add(body);
                    body = body.getParentJoint().getPredecessor();
                }
            }
            ArrayList<RigidBodyBasics> pathSecondHalf = new ArrayList<RigidBodyBasics>();
            if (secondBody == ancestor) {
                pathSecondHalf.add(secondBody);
            } else {
                RigidBodyBasics body = secondBody;
                while (body != ancestor) {
                    pathSecondHalf.add(body);
                    body = body.getParentJoint().getPredecessor();
                }
            }
            Collections.reverse(pathSecondHalf);
            ArrayList<RigidBodyBasics> expectedPath = new ArrayList<RigidBodyBasics>();
            expectedPath.addAll(pathFirstHalf);
            if (firstBody != secondBody) {
                expectedPath.addAll(pathSecondHalf);
            }
            ArrayList actualPath = new ArrayList();
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyBasics)firstBody, (RigidBodyBasics)secondBody, actualPath);
            Assertions.assertEquals(expectedPath, actualPath, (String)("Iteration: " + i2));
            ArrayList actualPathReadOnly = new ArrayList();
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)secondBody, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
            Collections.reverse(expectedPath);
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyBasics)secondBody, (RigidBodyBasics)firstBody, actualPath);
            Assertions.assertEquals(expectedPath, actualPath);
            MultiBodySystemTools.collectRigidBodyPath((RigidBodyReadOnly)secondBody, (RigidBodyReadOnly)firstBody, actualPathReadOnly);
            Assertions.assertEquals(expectedPath, actualPathReadOnly);
        }
    }

    @Test
    public void testCollectSuccessors() throws Exception {
        Random random = new Random(235423L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 100;
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            List<JointBasics> jointSelection = joints.stream().filter(j -> random.nextInt(10) < 4).collect(Collectors.toList());
            Collections.shuffle(jointSelection);
            Object[] successors = MultiBodySystemTools.collectSuccessors((JointBasics[])jointSelection.toArray(new JointBasics[0]));
            Assertions.assertArrayEquals((Object[])jointSelection.stream().map(JointBasics::getSuccessor).toArray(RigidBodyBasics[]::new), (Object[])successors);
        }
    }

    @Test
    public void testCollectSubtreeSuccessors() throws Exception {
        Random random = new Random(2354234L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 20;
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            List<JointBasics> jointSelection = joints.stream().filter(j -> random.nextInt(10) < 4).collect(Collectors.toList());
            Collections.shuffle(jointSelection);
            RigidBodyBasics[] subtreeSuccessors = MultiBodySystemTools.collectSubtreeSuccessors((JointBasics[])jointSelection.toArray(new JointBasics[0]));
            ArrayList<JointBasics> reducedJointSelection = new ArrayList<JointBasics>();
            for (JointBasics candidate : jointSelection) {
                if (reducedJointSelection.contains(candidate) || jointSelection.stream().filter(joint -> joint != candidate).anyMatch(joint -> MultiBodySystemTools.isAncestor((RigidBodyReadOnly)candidate.getSuccessor(), (RigidBodyReadOnly)joint.getSuccessor()))) continue;
                reducedJointSelection.add(candidate);
            }
            Set jointPredecessors = reducedJointSelection.stream().map(JointBasics::getPredecessor).collect(Collectors.toSet());
            for (RigidBodyBasics subtreeSuccessor : subtreeSuccessors) {
                Assertions.assertTrue((boolean)jointPredecessors.stream().anyMatch(subtreePredecessor -> MultiBodySystemTools.isAncestor((RigidBodyReadOnly)subtreeSuccessor, (RigidBodyReadOnly)subtreePredecessor)));
                Assertions.assertTrue((boolean)jointPredecessors.stream().noneMatch(subtreePredecessor -> MultiBodySystemTools.isAncestor((RigidBodyReadOnly)subtreePredecessor, (RigidBodyReadOnly)subtreeSuccessor)));
            }
        }
    }

    @Test
    public void testComputeDegreesOfFreedom() {
        int numberOfJoints;
        int i;
        Random random = new Random(1646541L);
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(100) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            int index2 = random.nextInt(numberOfJoints);
            int index1 = random.nextInt(index2 + 1);
            int expectedDoFs = index2 - index1 + 1;
            int actualDoFs = MultiBodySystemTools.computeDegreesOfFreedom((RigidBodyReadOnly)((OneDoFJoint)joints.get(index1)).getPredecessor(), (RigidBodyReadOnly)((OneDoFJoint)joints.get(index2)).getSuccessor());
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
            actualDoFs = MultiBodySystemTools.computeDegreesOfFreedom((RigidBodyReadOnly)((OneDoFJoint)joints.get(index2)).getSuccessor(), (RigidBodyReadOnly)((OneDoFJoint)joints.get(index1)).getPredecessor());
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
            actualDoFs = MultiBodySystemTools.computeDegreesOfFreedom(joints.subList(index1, index2 + 1));
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
            actualDoFs = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])((JointReadOnly[])joints.subList(index1, index2 + 1).toArray(new JointBasics[0])));
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
        }
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(100) + 1;
            List mainBranchJoints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            int branch1ParentJointIndex = random.nextInt(numberOfJoints);
            int branch2ParentJointIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics branch1Root = ((OneDoFJoint)mainBranchJoints.get(branch1ParentJointIndex)).getSuccessor();
            RigidBodyBasics branch2Root = ((OneDoFJoint)mainBranchJoints.get(branch2ParentJointIndex)).getSuccessor();
            List branch1Joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (RigidBodyBasics)branch1Root, (int)numberOfJoints);
            List branch2Joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (RigidBodyBasics)branch2Root, (int)numberOfJoints);
            RigidBodyBasics commonAncestor = MultiBodySystemTools.isAncestor((RigidBodyReadOnly)branch2Root, (RigidBodyReadOnly)branch1Root) ? branch1Root : branch2Root;
            RigidBodyBasics body1 = ((OneDoFJoint)branch1Joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            RigidBodyBasics body2 = ((OneDoFJoint)branch2Joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            int expectedDoFs = MultiBodySystemTools.computeDegreesOfFreedom((RigidBodyReadOnly)commonAncestor, (RigidBodyReadOnly)body1) + MultiBodySystemTools.computeDegreesOfFreedom((RigidBodyReadOnly)commonAncestor, (RigidBodyReadOnly)body2);
            int actualDoFs = MultiBodySystemTools.computeDegreesOfFreedom((RigidBodyReadOnly)body1, (RigidBodyReadOnly)body2);
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
        }
        int numberOfJoints2 = 500;
        List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints2);
        for (int i2 = 0; i2 < 1000; ++i2) {
            RigidBodyBasics firstBody = ((JointBasics)joints.get(random.nextInt(numberOfJoints2))).getSuccessor();
            RigidBodyBasics secondBody = ((JointBasics)joints.get(random.nextInt(numberOfJoints2))).getSuccessor();
            RigidBodyBasics ancestor = MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)firstBody, (RigidBodyBasics)secondBody);
            int expectedDoFs = MultiBodySystemTools.computeDegreesOfFreedom((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)ancestor) + MultiBodySystemTools.computeDegreesOfFreedom((RigidBodyReadOnly)secondBody, (RigidBodyReadOnly)ancestor);
            int actualDoFs = MultiBodySystemTools.computeDegreesOfFreedom((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)secondBody);
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
            actualDoFs = MultiBodySystemTools.computeDegreesOfFreedom((RigidBodyReadOnly)secondBody, (RigidBodyReadOnly)firstBody);
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
        }
    }

    @Test
    public void testComputeNearestCommonAncestor() {
        int i;
        Random random = new Random(4589634L);
        for (i = 0; i < 1000; ++i) {
            int numberOfJoints = random.nextInt(100) + 1;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            List allBodies = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)joints.get(0)).getPredecessor()).subtreeList();
            RigidBodyBasics firstBody = (RigidBodyBasics)allBodies.get(random.nextInt(allBodies.size()));
            RigidBodyBasics secondBody = (RigidBodyBasics)allBodies.get(random.nextInt(allBodies.size()));
            RigidBodyBasics expectedNearestAncestor = MultiBodySystemTools.isAncestor((RigidBodyReadOnly)secondBody, (RigidBodyReadOnly)firstBody) ? firstBody : secondBody;
            RigidBodyBasics actualNearestAncestor = MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)firstBody, (RigidBodyBasics)secondBody);
            Assertions.assertTrue((expectedNearestAncestor == actualNearestAncestor ? 1 : 0) != 0);
            actualNearestAncestor = MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)secondBody, (RigidBodyBasics)firstBody);
            Assertions.assertTrue((expectedNearestAncestor == actualNearestAncestor ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            int trunkSize = random.nextInt(30) + 1;
            int branch1Size = random.nextInt(30) + 1;
            int branch2Size = random.nextInt(30) + 1;
            List trunk = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)trunkSize);
            RigidBodyBasics bifurcation = ((JointBasics)trunk.get(trunkSize - 1)).getSuccessor();
            List branch1 = MultiBodySystemRandomTools.nextJointChain((Random)random, (RigidBodyBasics)bifurcation, (int)branch1Size);
            List branch2 = MultiBodySystemRandomTools.nextJointChain((Random)random, (RigidBodyBasics)bifurcation, (int)branch2Size);
            RigidBodyBasics firstBody = ((JointBasics)branch1.get(random.nextInt(branch1Size))).getSuccessor();
            RigidBodyBasics secondBody = ((JointBasics)branch2.get(random.nextInt(branch2Size))).getSuccessor();
            Assertions.assertFalse((boolean)MultiBodySystemTools.isAncestor((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)secondBody));
            Assertions.assertFalse((boolean)MultiBodySystemTools.isAncestor((RigidBodyReadOnly)secondBody, (RigidBodyReadOnly)firstBody));
            Assertions.assertTrue((bifurcation == MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)firstBody, (RigidBodyBasics)secondBody) ? 1 : 0) != 0);
            Assertions.assertTrue((bifurcation == MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)secondBody, (RigidBodyBasics)firstBody) ? 1 : 0) != 0);
        }
        int numberOfJoints = 500;
        List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
        for (int i2 = 0; i2 < 1000; ++i2) {
            RigidBodyBasics secondBody;
            RigidBodyBasics firstBody = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            RigidBodyBasics ancestor = MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)firstBody, (RigidBodyBasics)(secondBody = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor()));
            Assertions.assertTrue((ancestor == MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)secondBody, (RigidBodyBasics)firstBody) ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)MultiBodySystemTools.isAncestor((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)ancestor));
            Assertions.assertTrue((boolean)MultiBodySystemTools.isAncestor((RigidBodyReadOnly)secondBody, (RigidBodyReadOnly)ancestor));
            if (ancestor == firstBody || ancestor == secondBody) continue;
            Assertions.assertTrue((ancestor.getChildrenJoints().size() > 1 ? 1 : 0) != 0);
            for (JointBasics ancestorChild : ancestor.getChildrenJoints()) {
                boolean isChildAncestorOf2;
                boolean isChildAncestorOf1 = MultiBodySystemTools.isAncestor((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)ancestorChild.getSuccessor());
                Assertions.assertTrue((isChildAncestorOf1 != (isChildAncestorOf2 = MultiBodySystemTools.isAncestor((RigidBodyReadOnly)secondBody, (RigidBodyReadOnly)ancestorChild.getSuccessor())) || !isChildAncestorOf1 && !isChildAncestorOf2 ? 1 : 0) != 0);
            }
        }
        int size1 = random.nextInt(100) + 1;
        int size2 = random.nextInt(100) + 1;
        List system1 = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)size1);
        List system2 = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)size2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)((JointBasics)system1.get(random.nextInt(size1 - 1))).getSuccessor(), (RigidBodyBasics)((JointBasics)system2.get(random.nextInt(size2 - 1))).getSuccessor()));
    }

    @Test
    public void testComputeDistance() {
        int numberOfJoints;
        int i;
        Random random = new Random(1646541L);
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(100) + 1;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            int index2 = random.nextInt(numberOfJoints);
            int index1 = random.nextInt(index2 + 1);
            int expectedDoFs = index2 - index1 + 1;
            int actualDoFs = MultiBodySystemTools.computeDistance((RigidBodyReadOnly)((JointBasics)joints.get(index1)).getPredecessor(), (RigidBodyReadOnly)((JointBasics)joints.get(index2)).getSuccessor());
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
            actualDoFs = MultiBodySystemTools.computeDistance((RigidBodyReadOnly)((JointBasics)joints.get(index2)).getSuccessor(), (RigidBodyReadOnly)((JointBasics)joints.get(index1)).getPredecessor());
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
        }
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(100) + 1;
            List mainBranchJoints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            int branch1ParentJointIndex = random.nextInt(numberOfJoints);
            int branch2ParentJointIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics branch1Root = ((JointBasics)mainBranchJoints.get(branch1ParentJointIndex)).getSuccessor();
            RigidBodyBasics branch2Root = ((JointBasics)mainBranchJoints.get(branch2ParentJointIndex)).getSuccessor();
            List branch1Joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (RigidBodyBasics)branch1Root, (int)numberOfJoints);
            List branch2Joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (RigidBodyBasics)branch2Root, (int)numberOfJoints);
            RigidBodyBasics commonAncestor = MultiBodySystemTools.isAncestor((RigidBodyReadOnly)branch2Root, (RigidBodyReadOnly)branch1Root) ? branch1Root : branch2Root;
            RigidBodyBasics body1 = ((JointBasics)branch1Joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            RigidBodyBasics body2 = ((JointBasics)branch2Joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            int expectedDoFs = MultiBodySystemTools.computeDistance((RigidBodyReadOnly)commonAncestor, (RigidBodyReadOnly)body1) + MultiBodySystemTools.computeDistance((RigidBodyReadOnly)commonAncestor, (RigidBodyReadOnly)body2);
            int actualDoFs = MultiBodySystemTools.computeDistance((RigidBodyReadOnly)body1, (RigidBodyReadOnly)body2);
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
        }
        int numberOfJoints2 = 500;
        List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints2);
        for (int i2 = 0; i2 < 1000; ++i2) {
            RigidBodyBasics firstBody = ((JointBasics)joints.get(random.nextInt(numberOfJoints2))).getSuccessor();
            RigidBodyBasics secondBody = ((JointBasics)joints.get(random.nextInt(numberOfJoints2))).getSuccessor();
            RigidBodyBasics ancestor = MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyBasics)firstBody, (RigidBodyBasics)secondBody);
            int expectedDoFs = MultiBodySystemTools.computeDistance((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)ancestor) + MultiBodySystemTools.computeDistance((RigidBodyReadOnly)secondBody, (RigidBodyReadOnly)ancestor);
            int actualDoFs = MultiBodySystemTools.computeDistance((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)secondBody);
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
            actualDoFs = MultiBodySystemTools.computeDistance((RigidBodyReadOnly)secondBody, (RigidBodyReadOnly)firstBody);
            Assertions.assertEquals((int)expectedDoFs, (int)actualDoFs);
        }
    }

    @Test
    public void testFindJoint() throws Exception {
        Random random = new Random(1646541L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = random.nextInt(100) + 1;
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)joints.get(0)).getPredecessor());
            int expectedJointIndex = random.nextInt(numberOfJoints);
            JointBasics expectedJoint = (JointBasics)joints.get(expectedJointIndex);
            String expectedJointName = expectedJoint.getName();
            List supportBodies = Stream.of(MultiBodySystemTools.collectSupportJoints((RigidBodyBasics)expectedJoint.getSuccessor())).map(JointBasics::getPredecessor).collect(Collectors.toList());
            List nonSupportBodies = rootBody.subtreeStream().filter(body -> !supportBodies.contains(body)).collect(Collectors.toList());
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyBasics)rootBody, (String)expectedJointName) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyBasics)((RigidBodyBasics)supportBodies.get(random.nextInt(supportBodies.size()))), (String)expectedJointName) ? 1 : 0) != 0);
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyBasics)rootBody, (String)expectedJointName.toLowerCase()));
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyBasics)rootBody, (String)expectedJointName.toUpperCase()));
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyBasics)((RigidBodyBasics)nonSupportBodies.get(random.nextInt(nonSupportBodies.size()))), (String)expectedJointName));
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyBasics)rootBody, (String)expectedJointName, (boolean)false) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyBasics)((RigidBodyBasics)supportBodies.get(random.nextInt(supportBodies.size()))), (String)expectedJointName, (boolean)false) ? 1 : 0) != 0);
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyBasics)rootBody, (String)expectedJointName.toLowerCase(), (boolean)false));
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyBasics)rootBody, (String)expectedJointName.toUpperCase(), (boolean)false));
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyBasics)((RigidBodyBasics)nonSupportBodies.get(random.nextInt(nonSupportBodies.size()))), (String)expectedJointName, (boolean)false));
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyBasics)rootBody, (String)expectedJointName.toLowerCase(), (boolean)true) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyBasics)rootBody, (String)expectedJointName.toUpperCase(), (boolean)true) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyReadOnly)rootBody, (String)expectedJointName) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyReadOnly)((RigidBodyReadOnly)supportBodies.get(random.nextInt(supportBodies.size()))), (String)expectedJointName) ? 1 : 0) != 0);
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyReadOnly)rootBody, (String)expectedJointName.toLowerCase()));
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyReadOnly)rootBody, (String)expectedJointName.toUpperCase()));
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyReadOnly)((RigidBodyReadOnly)nonSupportBodies.get(random.nextInt(nonSupportBodies.size()))), (String)expectedJointName));
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyReadOnly)rootBody, (String)expectedJointName, (boolean)false) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyReadOnly)((RigidBodyReadOnly)supportBodies.get(random.nextInt(supportBodies.size()))), (String)expectedJointName, (boolean)false) ? 1 : 0) != 0);
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyReadOnly)rootBody, (String)expectedJointName.toLowerCase(), (boolean)false));
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyReadOnly)rootBody, (String)expectedJointName.toUpperCase(), (boolean)false));
            Assertions.assertNull((Object)MultiBodySystemTools.findJoint((RigidBodyReadOnly)((RigidBodyReadOnly)nonSupportBodies.get(random.nextInt(nonSupportBodies.size()))), (String)expectedJointName, (boolean)false));
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyReadOnly)rootBody, (String)expectedJointName.toLowerCase(), (boolean)true) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedJoint == MultiBodySystemTools.findJoint((RigidBodyReadOnly)rootBody, (String)expectedJointName.toUpperCase(), (boolean)true) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFindRigidBody() throws Exception {
        Random random = new Random(1646541L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = random.nextInt(100) + 1;
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)joints.get(0)).getPredecessor());
            List bodies = rootBody.subtreeList();
            int expectedBodyIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics expectedBody = (RigidBodyBasics)bodies.get(expectedBodyIndex);
            String expectedBodyName = expectedBody.getName();
            List supportBodies = Stream.of(MultiBodySystemTools.collectSupportJoints((RigidBodyBasics)expectedBody)).map(JointBasics::getPredecessor).collect(Collectors.toList());
            supportBodies.add(expectedBody);
            List nonSupportBodies = rootBody.subtreeStream().filter(body -> !supportBodies.contains(body)).collect(Collectors.toList());
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)expectedBodyName) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyBasics)((RigidBodyBasics)supportBodies.get(random.nextInt(supportBodies.size()))), (String)expectedBodyName) ? 1 : 0) != 0);
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)expectedBodyName.toLowerCase()));
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)expectedBodyName.toUpperCase()));
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyBasics)((RigidBodyBasics)nonSupportBodies.get(random.nextInt(nonSupportBodies.size()))), (String)expectedBodyName));
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)expectedBodyName, (boolean)false) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyBasics)((RigidBodyBasics)supportBodies.get(random.nextInt(supportBodies.size()))), (String)expectedBodyName, (boolean)false) ? 1 : 0) != 0);
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)expectedBodyName.toLowerCase(), (boolean)false));
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)expectedBodyName.toUpperCase(), (boolean)false));
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyBasics)((RigidBodyBasics)nonSupportBodies.get(random.nextInt(nonSupportBodies.size()))), (String)expectedBodyName, (boolean)false));
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)expectedBodyName.toLowerCase(), (boolean)true) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)expectedBodyName.toUpperCase(), (boolean)true) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)rootBody, (String)expectedBodyName) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)((RigidBodyReadOnly)supportBodies.get(random.nextInt(supportBodies.size()))), (String)expectedBodyName) ? 1 : 0) != 0);
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)rootBody, (String)expectedBodyName.toLowerCase()));
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)rootBody, (String)expectedBodyName.toUpperCase()));
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)((RigidBodyReadOnly)nonSupportBodies.get(random.nextInt(nonSupportBodies.size()))), (String)expectedBodyName));
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)rootBody, (String)expectedBodyName, (boolean)false) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)((RigidBodyReadOnly)supportBodies.get(random.nextInt(supportBodies.size()))), (String)expectedBodyName, (boolean)false) ? 1 : 0) != 0);
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)rootBody, (String)expectedBodyName.toLowerCase(), (boolean)false));
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)rootBody, (String)expectedBodyName.toUpperCase(), (boolean)false));
            Assertions.assertNull((Object)MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)((RigidBodyReadOnly)nonSupportBodies.get(random.nextInt(nonSupportBodies.size()))), (String)expectedBodyName, (boolean)false));
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)rootBody, (String)expectedBodyName.toLowerCase(), (boolean)true) ? 1 : 0) != 0);
            Assertions.assertTrue((expectedBody == MultiBodySystemTools.findRigidBody((RigidBodyReadOnly)rootBody, (String)expectedBodyName.toUpperCase(), (boolean)true) ? 1 : 0) != 0);
        }
    }
}

