/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.SpatialVectorBasicsTest;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.tools.MecanoTestTools;

public class SpatialVectorTest
extends SpatialVectorBasicsTest<SpatialVector> {
    private static final int ITERATIONS = 1000;

    @Override
    public SpatialVector newEmptySpatialVector() {
        return new SpatialVector();
    }

    @Override
    public SpatialVector newRandomSpatialVector(Random random) {
        return new SpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
    }

    @Override
    public SpatialVector newSpatialVector(ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        return new SpatialVector(expressedInFrame, angularPart, linearPart);
    }

    @Override
    public SpatialVector newCopySpatialVector(SpatialVectorReadOnly other) {
        return new SpatialVector(other);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-5;
    }

    @Test
    public void testConstructors() {
        SpatialVector spatialVectorByReferenceFrameAngularPartLinearPart;
        Vector3D randomLinearPart;
        Vector3D randomAngularPart;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(130375L);
        SpatialVector spatialVector = new SpatialVector();
        Assertions.assertEquals((Object)spatialVector.getReferenceFrame(), (Object)ReferenceFrameTools.getWorldFrame());
        Assertions.assertEquals((Object)spatialVector.getAngularPart().getReferenceFrame(), (Object)ReferenceFrameTools.getWorldFrame());
        Assertions.assertEquals((Object)spatialVector.getLinearPart().getReferenceFrame(), (Object)ReferenceFrameTools.getWorldFrame());
        Assertions.assertEquals((double)spatialVector.getAngularPartX(), (double)0.0);
        Assertions.assertEquals((double)spatialVector.getAngularPartY(), (double)0.0);
        Assertions.assertEquals((double)spatialVector.getAngularPartZ(), (double)0.0);
        Assertions.assertEquals((double)spatialVector.getLinearPartX(), (double)0.0);
        Assertions.assertEquals((double)spatialVector.getLinearPartY(), (double)0.0);
        Assertions.assertEquals((double)spatialVector.getLinearPartZ(), (double)0.0);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialVector spatialVectorByReferenceFrame = new SpatialVector(randomFrame);
            Assertions.assertEquals((Object)spatialVectorByReferenceFrame.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)spatialVectorByReferenceFrame.getAngularPart().getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)spatialVectorByReferenceFrame.getLinearPart().getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((double)spatialVectorByReferenceFrame.getAngularPartX(), (double)0.0);
            Assertions.assertEquals((double)spatialVectorByReferenceFrame.getAngularPartY(), (double)0.0);
            Assertions.assertEquals((double)spatialVectorByReferenceFrame.getAngularPartZ(), (double)0.0);
            Assertions.assertEquals((double)spatialVectorByReferenceFrame.getLinearPartX(), (double)0.0);
            Assertions.assertEquals((double)spatialVectorByReferenceFrame.getLinearPartY(), (double)0.0);
            Assertions.assertEquals((double)spatialVectorByReferenceFrame.getLinearPartZ(), (double)0.0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            spatialVectorByReferenceFrameAngularPartLinearPart = new SpatialVector(randomFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)spatialVectorByReferenceFrameAngularPartLinearPart.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)spatialVectorByReferenceFrameAngularPartLinearPart.getAngularPart().getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)spatialVectorByReferenceFrameAngularPartLinearPart.getLinearPart().getReferenceFrame(), (Object)randomFrame);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)spatialVectorByReferenceFrameAngularPartLinearPart.getAngularPart(), (EuclidGeometry)randomAngularPart, (double)this.getEpsilon());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)spatialVectorByReferenceFrameAngularPartLinearPart.getLinearPart(), (EuclidGeometry)randomLinearPart, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomFrame);
            randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomFrame);
            SpatialVector spatialVectorByAngularPartLinearPart = new SpatialVector((FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)spatialVectorByAngularPartLinearPart.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)spatialVectorByAngularPartLinearPart.getAngularPart().getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)spatialVectorByAngularPartLinearPart.getLinearPart().getReferenceFrame(), (Object)randomFrame);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)spatialVectorByAngularPartLinearPart.getAngularPart(), (EuclidGeometry)randomAngularPart, (double)this.getEpsilon());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)spatialVectorByAngularPartLinearPart.getLinearPart(), (EuclidGeometry)randomLinearPart, (double)this.getEpsilon());
            ReferenceFrame randomDifferentFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomLinearPart.setReferenceFrame(randomDifferentFrame);
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> SpatialVectorTest.lambda$testConstructors$0((FrameVector3D)randomAngularPart, (FrameVector3D)randomLinearPart));
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            spatialVectorByReferenceFrameAngularPartLinearPart = new SpatialVector(randomFrame, (Vector3DReadOnly)(randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random)), (Vector3DReadOnly)(randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random)));
            SpatialVector spatialVectorByCopy = new SpatialVector((SpatialVectorReadOnly)spatialVectorByReferenceFrameAngularPartLinearPart);
            Assertions.assertFalse((spatialVectorByCopy == spatialVectorByReferenceFrameAngularPartLinearPart ? 1 : 0) != 0);
            MecanoTestTools.assertSpatialVectorEquals((SpatialVectorReadOnly)spatialVectorByReferenceFrameAngularPartLinearPart, (SpatialVectorReadOnly)spatialVectorByCopy, (double)this.getEpsilon());
        }
    }

    @Override
    @Test
    public void testSetReferenceFrame() {
        Random random = new Random(15875L);
        ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        SpatialVector spatialVector = new SpatialVector();
        Assertions.assertEquals((Object)spatialVector.getReferenceFrame(), (Object)ReferenceFrameTools.getWorldFrame());
        spatialVector.setReferenceFrame(randomFrame);
        Assertions.assertEquals((Object)spatialVector.getReferenceFrame(), (Object)randomFrame);
    }

    @Test
    public void testEquals() {
        Random random = new Random(130375L);
        for (int i = 0; i < 1000; ++i) {
            SpatialVector originalSpatialVector;
            SpatialVector copySpatialVector = originalSpatialVector = new SpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            Assertions.assertTrue((boolean)originalSpatialVector.equals((SpatialVectorReadOnly)copySpatialVector));
            SpatialVector differentSpatialVector = new SpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            Assertions.assertFalse((boolean)originalSpatialVector.equals((SpatialVectorReadOnly)differentSpatialVector));
            SpatialVector emptySpatialVector = this.newEmptySpatialVector();
            Assertions.assertFalse((boolean)originalSpatialVector.equals((SpatialVectorReadOnly)emptySpatialVector));
        }
    }

    @Test
    public void testToString() {
        Random random = new Random(130375L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector3D randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            SpatialVector spatialVectorByReferenceFrameAngularPartLinearPart = new SpatialVector(randomFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)spatialVectorByReferenceFrameAngularPartLinearPart.toString(), (Object)MecanoIOTools.getSpatialVectorString((SpatialVectorReadOnly)spatialVectorByReferenceFrameAngularPartLinearPart));
        }
    }

    private static /* synthetic */ void lambda$testConstructors$0(FrameVector3D randomAngularPart, FrameVector3D randomLinearPart) throws Throwable {
        SpatialVector spatialVectorByAngularPartLinearPartDifferent = new SpatialVector((FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
    }
}

