/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import java.lang.reflect.Method;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.mecano.fourBar.FourBarTools;

public class FourBarToolsTest {
    private static final int ITERATIONS = 10000;
    private static final double EPSILON = 1.0E-11;
    private static final double FD_DOT_EPSILON = 1.0E-6;
    private static final double FD_DDOT_EPSILON = 5.0E-4;

    @Test
    public void testFastAcos() {
        for (double x = -1.0; x < 1.0; x += 1.0E-6) {
            double expected = Math.acos(x);
            double actual = FourBarTools.fastAcos((double)x);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-14, (String)("x=" + x));
        }
        Assertions.assertEquals((double)Math.acos(-1.0), (double)FourBarTools.fastAcos((double)-1.0), (double)1.0E-14, (String)"x=-1.0");
        Assertions.assertEquals((double)Math.acos(1.0), (double)FourBarTools.fastAcos((double)1.0), (double)1.0E-14, (String)"x=1.0");
    }

    @Test
    public void testAngleWithCosineLaw() {
        double actualAngle;
        int i;
        Random random = new Random(4643675L);
        for (i = 0; i < 10000; ++i) {
            double expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)1.5697963267948967);
            double AB = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double BC = AB * Math.tan(expectedAngle);
            double AC = Math.hypot(AB, BC);
            actualAngle = FourBarTools.angleWithCosineLaw((double)AB, (double)AC, (double)BC);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-11, (String)("error=" + Math.abs(expectedAngle - actualAngle)));
        }
        for (i = 0; i < 10000; ++i) {
            Point2D A = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D B = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D C = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D AB = new Vector2D();
            Vector2D AC = new Vector2D();
            Vector2D BC = new Vector2D();
            AB.sub((Tuple2DReadOnly)B, (Tuple2DReadOnly)A);
            AC.sub((Tuple2DReadOnly)C, (Tuple2DReadOnly)A);
            BC.sub((Tuple2DReadOnly)C, (Tuple2DReadOnly)B);
            double expectedAngle = Math.abs(AB.angle((Vector2DReadOnly)AC));
            actualAngle = FourBarTools.angleWithCosineLaw((double)AB.length(), (double)AC.length(), (double)BC.length());
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-11, (String)("error=" + Math.abs(expectedAngle - actualAngle)));
        }
    }

    @Test
    public void testAngleDotWithCosineLaw(TestInfo testInfo) {
        Random random = new Random(4643675L);
        double dt = 3.0E-6;
        double averageError = 0.0;
        for (int i = 0; i < 10000; ++i) {
            Point2D A = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D B = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D C = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D CDot = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            Point2D CFuture = new Point2D();
            CFuture.scaleAdd(0.5 * dt, (Tuple2DReadOnly)CDot, (Tuple2DReadOnly)C);
            Point2D CPast = new Point2D();
            CPast.scaleAdd(-0.5 * dt, (Tuple2DReadOnly)CDot, (Tuple2DReadOnly)C);
            double ABLength = A.distance((Point2DReadOnly)B);
            double ACLength = A.distance((Point2DReadOnly)C);
            double BCLength = B.distance((Point2DReadOnly)C);
            double ACLengthFuture = A.distance((Point2DReadOnly)CFuture);
            double BCLengthFuture = B.distance((Point2DReadOnly)CFuture);
            double ACLengthPast = A.distance((Point2DReadOnly)CPast);
            double BCLengthPast = B.distance((Point2DReadOnly)CPast);
            double ACLengthDot = (ACLengthFuture - ACLengthPast) / dt;
            double BCLengthDot = (BCLengthFuture - BCLengthPast) / dt;
            double anglePast = FourBarTools.angleWithCosineLaw((double)ABLength, (double)ACLengthPast, (double)BCLengthPast);
            double angleFuture = FourBarTools.angleWithCosineLaw((double)ABLength, (double)ACLengthFuture, (double)BCLengthFuture);
            double expectedAngleDot = (angleFuture - anglePast) / dt;
            double actualAngleDot = FourBarTools.angleDotWithCosineLaw((double)ABLength, (double)ACLength, (double)ACLengthDot, (double)BCLength, (double)BCLengthDot);
            double error = Math.abs(expectedAngleDot - actualAngleDot);
            averageError += error;
            Assertions.assertEquals((double)expectedAngleDot, (double)actualAngleDot, (double)(1.0E-6 * Math.max(1.0, Math.abs(expectedAngleDot))), (String)("error=" + error));
        }
        System.out.println(this.getClass().getSimpleName() + " " + ((Method)testInfo.getTestMethod().get()).getName() + ": Average error = " + (averageError /= 10000.0));
    }

    @Test
    public void testAngleDDotWithCosineLaw(TestInfo testInfo) {
        Random random = new Random(4643675L);
        double dt = 1.0E-6;
        double averageError = 0.0;
        for (int i = 0; i < 10000; ++i) {
            Point2D A = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D B = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D C = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D CDot = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            Vector2D CDDot = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            Vector2D CDotPast = new Vector2D();
            CDotPast.scaleAdd(-0.5 * dt, (Tuple2DReadOnly)CDDot, (Tuple2DReadOnly)CDot);
            Vector2D CDotFuture = new Vector2D();
            CDotFuture.scaleAdd(0.5 * dt, (Tuple2DReadOnly)CDDot, (Tuple2DReadOnly)CDot);
            Point2D CPast = new Point2D();
            CPast.scaleAdd(-0.5 * dt, (Tuple2DReadOnly)CDot, (Tuple2DReadOnly)C);
            CPast.scaleAdd(-0.25 * dt * dt, (Tuple2DReadOnly)CDDot, (Tuple2DReadOnly)CPast);
            Point2D CFuture = new Point2D();
            CFuture.scaleAdd(0.5 * dt, (Tuple2DReadOnly)CDot, (Tuple2DReadOnly)C);
            CFuture.scaleAdd(0.25 * dt * dt, (Tuple2DReadOnly)CDDot, (Tuple2DReadOnly)CFuture);
            double AB = A.distance((Point2DReadOnly)B);
            double AC = A.distance((Point2DReadOnly)C);
            double BC = B.distance((Point2DReadOnly)C);
            double ACDot = FourBarToolsTest.projectOntoSide((Vector2DReadOnly)CDot, (Point2DReadOnly)A, (Point2DReadOnly)C);
            double BCDot = FourBarToolsTest.projectOntoSide((Vector2DReadOnly)CDot, (Point2DReadOnly)B, (Point2DReadOnly)C);
            double ACDDot = FourBarToolsTest.projectOntoSide((Vector2DReadOnly)CDDot, (Point2DReadOnly)A, (Point2DReadOnly)C);
            double BCDDot = FourBarToolsTest.projectOntoSide((Vector2DReadOnly)CDDot, (Point2DReadOnly)B, (Point2DReadOnly)C);
            double ACPast = A.distance((Point2DReadOnly)CPast);
            double BCPast = B.distance((Point2DReadOnly)CPast);
            double ACFuture = A.distance((Point2DReadOnly)CFuture);
            double BCFuture = B.distance((Point2DReadOnly)CFuture);
            double ACDotPast = FourBarToolsTest.projectOntoSide((Vector2DReadOnly)CDotPast, (Point2DReadOnly)A, (Point2DReadOnly)C);
            double BCDotPast = FourBarToolsTest.projectOntoSide((Vector2DReadOnly)CDotPast, (Point2DReadOnly)B, (Point2DReadOnly)C);
            double ACDotFuture = FourBarToolsTest.projectOntoSide((Vector2DReadOnly)CDotFuture, (Point2DReadOnly)A, (Point2DReadOnly)C);
            double BCDotFuture = FourBarToolsTest.projectOntoSide((Vector2DReadOnly)CDotFuture, (Point2DReadOnly)B, (Point2DReadOnly)C);
            double angleDotPast = FourBarTools.angleDotWithCosineLaw((double)AB, (double)ACPast, (double)ACDotPast, (double)BCPast, (double)BCDotPast);
            double angleDotFuture = FourBarTools.angleDotWithCosineLaw((double)AB, (double)ACFuture, (double)ACDotFuture, (double)BCFuture, (double)BCDotFuture);
            double expectedAngleDDot = (angleDotFuture - angleDotPast) / dt;
            double actualAngleDDot = FourBarTools.angleDDotWithCosineLaw((double)AB, (double)AC, (double)ACDot, (double)ACDDot, (double)BC, (double)BCDot, (double)BCDDot);
            double error = Math.abs(expectedAngleDDot - actualAngleDDot);
            averageError += error;
            Assertions.assertEquals((double)expectedAngleDDot, (double)actualAngleDDot, (double)(5.0E-4 * Math.max(1.0, Math.abs(expectedAngleDDot))), (String)("error=" + error));
        }
        System.out.println(this.getClass().getSimpleName() + " " + ((Method)testInfo.getTestMethod().get()).getName() + ": Average error = " + (averageError /= 10000.0));
    }

    private static double projectOntoSide(Vector2DReadOnly vectorToProject, Point2DReadOnly sideStart, Point2DReadOnly sideEnd) {
        Vector2D side = new Vector2D();
        side.sub((Tuple2DReadOnly)sideEnd, (Tuple2DReadOnly)sideStart);
        side.normalize();
        return vectorToProject.dot((Tuple2DReadOnly)side);
    }
}

