/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.algorithms.SpatialAccelerationCalculator;
import us.ihmc.mecano.fourBar.CrossFourBarJointIKBinarySolver;
import us.ihmc.mecano.fourBar.CrossFourBarJointIKSolver;
import us.ihmc.mecano.fourBar.FourBarKinematicLoopFunction;
import us.ihmc.mecano.fourBar.FourBarKinematicLoopFunctionTools;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;

public class CrossFourBarJointTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 1000;
    private static final double SMALL_EPSILON = 1.0E-10;
    private static final double MID_EPSILON = 1.0E-7;
    private static final double LARGE_EPSILON = 1.0E-5;

    @Test
    public void testMotionSubspaceDot() {
        Random random = new Random(4577L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            double dt = 5.0E-7;
            DMatrixRMaj Sprev = new DMatrixRMaj(6, 1);
            DMatrixRMaj Scurr = new DMatrixRMaj(6, 1);
            DMatrixRMaj actualSPrime = new DMatrixRMaj(6, 1);
            DMatrixRMaj expectedSPrime = new DMatrixRMaj(6, 1);
            DMatrixRMaj errorSPrime = new DMatrixRMaj(6, 1);
            for (int i = 0; i < 1000; ++i) {
                double qMin = fourBarJoint.getJointLimitLower();
                double qMax = fourBarJoint.getJointLimitUpper();
                double qRange = qMax - qMin;
                double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)(qMin += 0.05 * qRange), (double)(qMax -= 0.05 * qRange));
                double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.setQ(q);
                fourBarJoint.setQd(qd);
                fourBarJoint.updateFramesRecursively();
                fourBarJoint.getMotionSubspace((DMatrix1Row)Sprev);
                fourBarJoint.getMotionSubspaceDot((DMatrix1Row)actualSPrime);
                fourBarJoint.setQ(q += qd * dt);
                fourBarJoint.updateFramesRecursively();
                fourBarJoint.getMotionSubspace((DMatrix1Row)Scurr);
                CrossFourBarJointTest.numericallyDifferentiate((DMatrix1Row)expectedSPrime, (DMatrix1Row)Sprev, (DMatrix1Row)Scurr, dt);
                CommonOps_DDRM.subtract((DMatrixD1)expectedSPrime, (DMatrixD1)actualSPrime, (DMatrixD1)errorSPrime);
                Assertions.assertTrue((boolean)MatrixFeatures_DDRM.isEquals((DMatrixD1)expectedSPrime, (DMatrixD1)actualSPrime, (double)1.0E-4), (String)String.format("Iteration: %d\nExpected:\n%s\nwas:\n%s\nDifference:\n%s", i, expectedSPrime.toString(), actualSPrime.toString(), errorSPrime.toString()));
            }
        }
    }

    public static void numericallyDifferentiate(DMatrix1Row derivativeToPack, DMatrix1Row previousMatrixToUpdate, DMatrix1Row newMatrix, double dt) {
        derivativeToPack.set((DMatrixD1)newMatrix);
        CommonOps_DDRM.subtractEquals((DMatrixD1)derivativeToPack, (DMatrixD1)previousMatrixToUpdate);
        CommonOps_DDRM.scale((double)(1.0 / dt), (DMatrixD1)derivativeToPack);
        previousMatrixToUpdate.set((DMatrixD1)newMatrix);
    }

    @Test
    public void testSetQ() {
        Random random = new Random(348975L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                double alpha = (double)i / 999.0;
                double expected_qActuated = EuclidCoreTools.interpolate((double)function.getActuatedJoint().getJointLimitLower(), (double)function.getActuatedJoint().getJointLimitUpper(), (double)alpha);
                function.getActuatedJoint().setQ(expected_qActuated);
                function.updateState(false, false);
                double expected_qA = function.getJointA().getQ();
                double expected_qB = function.getJointB().getQ();
                double expected_qC = function.getJointC().getQ();
                double expected_qD = function.getJointD().getQ();
                double theta = expected_qA + expected_qD;
                Assertions.assertEquals((double)theta, (double)(expected_qB + expected_qC), (double)1.0E-10);
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)function.getLoopJoints());
                fourBarJoint.setQ(theta);
                fourBarJoint.updateFramesRecursively();
                double actual_qA = fourBarJoint.getJointA().getQ();
                double actual_qB = fourBarJoint.getJointB().getQ();
                double actual_qC = fourBarJoint.getJointC().getQ();
                double actual_qD = fourBarJoint.getJointD().getQ();
                Assertions.assertEquals((double)expected_qA, (double)actual_qA, (double)1.0E-10);
                Assertions.assertEquals((double)expected_qB, (double)actual_qB, (double)1.0E-10);
                Assertions.assertEquals((double)expected_qC, (double)actual_qC, (double)1.0E-10);
                Assertions.assertEquals((double)expected_qD, (double)actual_qD, (double)1.0E-10);
                Assertions.assertEquals((double)theta, (double)fourBarJoint.getQ(), (double)1.0E-10);
            }
            fourBarJoint.setQ(fourBarJoint.getJointLimitLower() - 0.1);
            fourBarJoint.updateFramesRecursively();
            Assertions.assertEquals((double)function.getJointA().getJointLimitLower(), (double)fourBarJoint.getJointA().getQ());
            Assertions.assertEquals((double)function.getJointB().getJointLimitLower(), (double)fourBarJoint.getJointB().getQ());
            Assertions.assertEquals((double)function.getJointC().getJointLimitLower(), (double)fourBarJoint.getJointC().getQ());
            Assertions.assertEquals((double)function.getJointD().getJointLimitLower(), (double)fourBarJoint.getJointD().getQ());
            Assertions.assertEquals((double)fourBarJoint.getJointLimitLower(), (double)fourBarJoint.getQ(), (double)1.0E-10);
            fourBarJoint.setQ(fourBarJoint.getJointLimitUpper() + 0.1);
            fourBarJoint.updateFramesRecursively();
            Assertions.assertEquals((double)function.getJointA().getJointLimitUpper(), (double)fourBarJoint.getJointA().getQ());
            Assertions.assertEquals((double)function.getJointB().getJointLimitUpper(), (double)fourBarJoint.getJointB().getQ());
            Assertions.assertEquals((double)function.getJointC().getJointLimitUpper(), (double)fourBarJoint.getJointC().getQ());
            Assertions.assertEquals((double)function.getJointD().getJointLimitUpper(), (double)fourBarJoint.getJointD().getQ());
            Assertions.assertEquals((double)fourBarJoint.getJointLimitUpper(), (double)fourBarJoint.getQ(), (double)1.0E-10);
        }
    }

    @Test
    public void testSetJointOrientation() {
        Random random = new Random(7523L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                double theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getJointLimitLower(), (double)fourBarJoint.getJointLimitUpper());
                Vector3D jointAxis = new Vector3D((Tuple3DReadOnly)fourBarJoint.getJointAxis());
                Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)jointAxis, (boolean)true);
                Vector3D rotationVector = new Vector3D();
                rotationVector.setAndScale(theta, (Tuple3DReadOnly)jointAxis);
                rotationVector.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)rotationVector);
                fourBarJoint.setJointOrientation((Orientation3DReadOnly)new Quaternion((Vector3DReadOnly)rotationVector));
                fourBarJoint.updateFramesRecursively();
                Assertions.assertEquals((double)theta, (double)fourBarJoint.getQ(), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testSetJointPosition() {
        Random random = new Random(7523L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (JointBasics)fourBarJoint);
                fourBarJoint.updateFramesRecursively();
                double expected_q = fourBarJoint.getQ();
                fourBarJoint.setJointPosition((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0));
                fourBarJoint.updateFramesRecursively();
                double actual_q = fourBarJoint.getQ();
                Assertions.assertEquals((double)expected_q, (double)actual_q, (double)1.0E-10);
            }
        }
    }

    @Test
    public void testGetJointConfiguration() {
        Random random = new Random(348975L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                RigidBodyTransform expectedConfiguration;
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)function.getActuatedJoint().getJointLimitLower(), (double)function.getActuatedJoint().getJointLimitUpper());
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQ(qActuated);
                fourBarJoint.updateFramesRecursively();
                function.updateState(false, false);
                function.getJointA().getPredecessor().updateFramesRecursively();
                Assertions.assertEquals((double)function.getJointA().getQ(), (double)fourBarJoint.getJointA().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointB().getQ(), (double)fourBarJoint.getJointB().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointC().getQ(), (double)fourBarJoint.getJointC().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointD().getQ(), (double)fourBarJoint.getJointD().getQ(), (double)1.0E-10);
                RigidBodyTransform actualConfiguration = new RigidBodyTransform();
                fourBarJoint.getJointConfiguration(actualConfiguration);
                if (fourBarJoint.getFrameBeforeJoint() == fourBarJoint.getJointA().getFrameBeforeJoint()) {
                    expectedConfiguration = function.getJointD().getFrameAfterJoint().getTransformToDesiredFrame((ReferenceFrame)function.getJointA().getFrameBeforeJoint());
                    EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedConfiguration, (EuclidGeometry)actualConfiguration, (double)1.0E-10);
                    continue;
                }
                expectedConfiguration = function.getJointC().getFrameAfterJoint().getTransformToDesiredFrame((ReferenceFrame)function.getJointB().getFrameBeforeJoint());
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedConfiguration, (EuclidGeometry)actualConfiguration, (double)1.0E-10);
            }
        }
    }

    @Test
    public void testSetQd() {
        Random random = new Random(8623L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)function.getActuatedJoint().getJointLimitLower(), (double)function.getActuatedJoint().getJointLimitUpper());
                double expected_qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                function.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQd(expected_qdActuated);
                function.updateState(true, false);
                double expected_qdA = function.getJointA().getQd();
                double expected_qdB = function.getJointB().getQd();
                double expected_qdC = function.getJointC().getQd();
                double expected_qdD = function.getJointD().getQd();
                double theta = function.getJointA().getQ() + function.getJointD().getQ();
                double thetaDot = expected_qdA + expected_qdD;
                Assertions.assertEquals((double)thetaDot, (double)(expected_qdB + expected_qdC), (double)1.0E-10);
                fourBarJoint.setQ(theta);
                fourBarJoint.setQd(thetaDot);
                fourBarJoint.updateFramesRecursively();
                double actual_qdA = fourBarJoint.getJointA().getQd();
                double actual_qdB = fourBarJoint.getJointB().getQd();
                double actual_qdC = fourBarJoint.getJointC().getQd();
                double actual_qdD = fourBarJoint.getJointD().getQd();
                Assertions.assertEquals((double)theta, (double)fourBarJoint.getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)expected_qdA, (double)actual_qdA, (double)1.0E-7);
                Assertions.assertEquals((double)expected_qdB, (double)actual_qdB, (double)1.0E-7);
                Assertions.assertEquals((double)expected_qdC, (double)actual_qdC, (double)1.0E-7);
                Assertions.assertEquals((double)expected_qdD, (double)actual_qdD, (double)1.0E-7);
                Assertions.assertEquals((double)thetaDot, (double)fourBarJoint.getQd(), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testSetJointAngularVelocity() {
        Random random = new Random(67567L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                double theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getJointLimitLower(), (double)fourBarJoint.getJointLimitUpper());
                double thetaDot = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                Vector3D angularVelocity = new Vector3D();
                angularVelocity.setAndScale(thetaDot, (Tuple3DReadOnly)fourBarJoint.getJointAxis());
                Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)fourBarJoint.getJointAxis(), (boolean)true);
                angularVelocity.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)angularVelocity);
                fourBarJoint.setQ(theta);
                fourBarJoint.setJointAngularVelocity((Vector3DReadOnly)angularVelocity);
                fourBarJoint.updateFramesRecursively();
                Assertions.assertEquals((double)theta, (double)fourBarJoint.getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)thetaDot, (double)fourBarJoint.getQd(), (double)1.0E-7);
            }
        }
    }

    @Test
    public void testSetJointLinearVelocity() {
        Random random = new Random(7523L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (JointBasics)fourBarJoint);
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (JointBasics)fourBarJoint);
                fourBarJoint.updateFramesRecursively();
                double expected_qd = fourBarJoint.getQd();
                fourBarJoint.setJointLinearVelocity((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
                fourBarJoint.updateFramesRecursively();
                double actual_qd = fourBarJoint.getQd();
                Assertions.assertEquals((double)expected_qd, (double)actual_qd, (double)1.0E-10);
            }
        }
    }

    @Test
    public void testGetJointTwist() {
        Random random = new Random(0x488D44L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                RevoluteJointBasics bottomJoint;
                RevoluteJointBasics topJoint;
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                function.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.updateFramesRecursively();
                function.updateState(true, false);
                function.getJointA().getPredecessor().updateFramesRecursively();
                if (fourBarJoint.getFrameBeforeJoint() == fourBarJoint.getJointA().getFrameBeforeJoint()) {
                    topJoint = fourBarJoint.getJointA();
                    bottomJoint = fourBarJoint.getJointD();
                } else {
                    topJoint = fourBarJoint.getJointB();
                    bottomJoint = fourBarJoint.getJointC();
                }
                Twist expectedTwist = new Twist();
                bottomJoint.getFrameAfterJoint().getTwistRelativeToOther((ReferenceFrame)topJoint.getFrameBeforeJoint(), (TwistBasics)expectedTwist);
                TwistReadOnly actualTwist = fourBarJoint.getJointTwist();
                EuclidCoreTestTools.assertEquals((EuclidGeometry)bottomJoint.getFrameAfterJoint().getTransformToDesiredFrame((ReferenceFrame)topJoint.getFrameBeforeJoint()), (EuclidGeometry)bottomJoint.getFrameAfterJoint().getTransformToDesiredFrame((ReferenceFrame)topJoint.getFrameBeforeJoint()), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointA().getQ(), (double)fourBarJoint.getJointA().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointB().getQ(), (double)fourBarJoint.getJointB().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointC().getQ(), (double)fourBarJoint.getJointC().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointD().getQ(), (double)fourBarJoint.getJointD().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointA().getQd(), (double)fourBarJoint.getJointA().getQd(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointB().getQd(), (double)fourBarJoint.getJointB().getQd(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointC().getQd(), (double)fourBarJoint.getJointC().getQd(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointD().getQd(), (double)fourBarJoint.getJointD().getQd(), (double)1.0E-10);
                CrossFourBarJointTest.assertTwistEquals(null, function.getJointA().getJointTwist(), fourBarJoint.getJointA().getJointTwist(), 1.0E-10);
                CrossFourBarJointTest.assertTwistEquals(null, function.getJointB().getJointTwist(), fourBarJoint.getJointB().getJointTwist(), 1.0E-10);
                CrossFourBarJointTest.assertTwistEquals(null, function.getJointC().getJointTwist(), fourBarJoint.getJointC().getJointTwist(), 1.0E-10);
                CrossFourBarJointTest.assertTwistEquals(null, function.getJointD().getJointTwist(), fourBarJoint.getJointD().getJointTwist(), 1.0E-10);
                CrossFourBarJointTest.assertTwistEquals("Iteration " + i, (TwistReadOnly)expectedTwist, actualTwist, 1.0E-10);
            }
        }
    }

    @Test
    public void testGetSuccessorTwist() {
        Random random = new Random(0x488D44L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                function.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.updateFramesRecursively();
                function.updateState(true, false);
                function.getJointA().getPredecessor().updateFramesRecursively();
                Twist expectedTwist = new Twist();
                function.getJointD().getSuccessor().getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)function.getJointA().getPredecessor().getBodyFixedFrame(), (TwistBasics)expectedTwist);
                expectedTwist.setBaseFrame((ReferenceFrame)fourBarJoint.getPredecessor().getBodyFixedFrame());
                expectedTwist.setBodyFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                expectedTwist.setReferenceFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                Twist actualTwist = new Twist();
                fourBarJoint.getSuccessorTwist((TwistBasics)actualTwist);
                CrossFourBarJointTest.assertTwistEquals("Iteration " + i, (TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, 1.0E-7);
            }
        }
    }

    @Test
    public void testGetPredecessorTwist() {
        Random random = new Random(0x488D44L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                function.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.updateFramesRecursively();
                function.updateState(true, false);
                function.getJointA().getPredecessor().updateFramesRecursively();
                Twist expectedTwist = new Twist();
                function.getJointA().getPredecessor().getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)function.getJointD().getSuccessor().getBodyFixedFrame(), (TwistBasics)expectedTwist);
                expectedTwist.setBaseFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                expectedTwist.setBodyFrame((ReferenceFrame)fourBarJoint.getPredecessor().getBodyFixedFrame());
                expectedTwist.setReferenceFrame((ReferenceFrame)fourBarJoint.getPredecessor().getBodyFixedFrame());
                Twist actualTwist = new Twist();
                fourBarJoint.getPredecessorTwist((TwistBasics)actualTwist);
                CrossFourBarJointTest.assertTwistEquals("Iteration " + i, (TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, 1.0E-7);
            }
        }
    }

    @Test
    public void testGetUnitJointTwist() {
        Random random = new Random(8623435L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                RevoluteJointBasics bottomJoint;
                RevoluteJointBasics topJoint;
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                function.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.updateFramesRecursively();
                function.updateState(true, false);
                function.getJointA().getPredecessor().updateFramesRecursively();
                if (fourBarJoint.getFrameBeforeJoint() == fourBarJoint.getJointA().getFrameBeforeJoint()) {
                    topJoint = fourBarJoint.getJointA();
                    bottomJoint = fourBarJoint.getJointD();
                } else {
                    topJoint = fourBarJoint.getJointB();
                    bottomJoint = fourBarJoint.getJointC();
                }
                Twist expectedTwist = new Twist();
                bottomJoint.getFrameAfterJoint().getTwistRelativeToOther((ReferenceFrame)topJoint.getFrameBeforeJoint(), (TwistBasics)expectedTwist);
                expectedTwist.scale(1.0 / (topJoint.getQd() + bottomJoint.getQd()));
                TwistReadOnly actualTwist = fourBarJoint.getUnitJointTwist();
                CrossFourBarJointTest.assertTwistEquals("Iteration " + i, (TwistReadOnly)expectedTwist, actualTwist, 1.0E-10);
            }
        }
    }

    @Test
    public void testGetUnitSuccessorTwist() {
        Random random = new Random(8623435L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                function.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.updateFramesRecursively();
                function.updateState(true, false);
                function.getJointA().getPredecessor().updateFramesRecursively();
                Twist expectedTwist = new Twist();
                function.getJointD().getSuccessor().getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)function.getJointA().getPredecessor().getBodyFixedFrame(), (TwistBasics)expectedTwist);
                expectedTwist.scale(1.0 / (function.getJointA().getQd() + function.getJointD().getQd()));
                expectedTwist.setBaseFrame((ReferenceFrame)fourBarJoint.getPredecessor().getBodyFixedFrame());
                expectedTwist.setBodyFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                expectedTwist.setReferenceFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                TwistReadOnly actualTwist = fourBarJoint.getUnitSuccessorTwist();
                CrossFourBarJointTest.assertTwistEquals("Iteration " + i, (TwistReadOnly)expectedTwist, actualTwist, 1.0E-10);
            }
        }
    }

    @Test
    public void testGetUnitPredecessorTwist() {
        Random random = new Random(8623435L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                function.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.updateFramesRecursively();
                function.updateState(true, false);
                function.getJointA().getPredecessor().updateFramesRecursively();
                Twist expectedTwist = new Twist();
                function.getJointA().getPredecessor().getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)function.getJointD().getSuccessor().getBodyFixedFrame(), (TwistBasics)expectedTwist);
                expectedTwist.scale(1.0 / (function.getJointA().getQd() + function.getJointD().getQd()));
                expectedTwist.setBaseFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                expectedTwist.setBodyFrame((ReferenceFrame)fourBarJoint.getPredecessor().getBodyFixedFrame());
                expectedTwist.setReferenceFrame((ReferenceFrame)fourBarJoint.getPredecessor().getBodyFixedFrame());
                TwistReadOnly actualTwist = fourBarJoint.getUnitPredecessorTwist();
                CrossFourBarJointTest.assertTwistEquals("Iteration " + i, (TwistReadOnly)expectedTwist, actualTwist, 1.0E-10);
            }
        }
    }

    @Test
    public void testSetQdd() {
        Random random = new Random(8623L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            long totalTime = 0L;
            for (int i = 0; i < 1000; ++i) {
                double qActuatedMin = function.getActuatedJoint().getJointLimitLower();
                double qActuatedMax = function.getActuatedJoint().getJointLimitUpper();
                double qActuatedMid = 0.5 * (qActuatedMin + qActuatedMax);
                double qActuatedRange = 0.75 * (qActuatedMax - qActuatedMin);
                double qActuated = qActuatedMid + 0.5 * EuclidCoreRandomTools.nextDouble((Random)random, (double)qActuatedRange);
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double expected_qddActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                function.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQd(qdActuated);
                function.getActuatedJoint().setQdd(expected_qddActuated);
                function.updateState(true, true);
                double expected_qddA = function.getJointA().getQdd();
                double expected_qddB = function.getJointB().getQdd();
                double expected_qddC = function.getJointC().getQdd();
                double expected_qddD = function.getJointD().getQdd();
                double theta = function.getJointA().getQ() + function.getJointD().getQ();
                double thetaDot = function.getJointA().getQd() + function.getJointD().getQd();
                double thetaDDot = expected_qddA + expected_qddD;
                Assertions.assertEquals((double)thetaDDot, (double)(expected_qddB + expected_qddC), (double)1.0E-7);
                long start = System.nanoTime();
                fourBarJoint.setQ(theta);
                fourBarJoint.setQd(thetaDot);
                fourBarJoint.setQdd(thetaDDot);
                fourBarJoint.updateFramesRecursively();
                long end = System.nanoTime();
                totalTime += end - start;
                double actual_qddA = fourBarJoint.getJointA().getQdd();
                double actual_qddB = fourBarJoint.getJointB().getQdd();
                double actual_qddC = fourBarJoint.getJointC().getQdd();
                double actual_qddD = fourBarJoint.getJointD().getQdd();
                Assertions.assertEquals((double)theta, (double)fourBarJoint.getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)thetaDot, (double)fourBarJoint.getQd(), (double)1.0E-10);
                CrossFourBarJointTest.assertEqualsVarEpsilon(thetaDDot, fourBarJoint.getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(expected_qddA, actual_qddA, 1.0E-5);
                CrossFourBarJointTest.assertEqualsVarEpsilon(expected_qddB, actual_qddB, 1.0E-5);
                CrossFourBarJointTest.assertEqualsVarEpsilon(expected_qddC, actual_qddC, 1.0E-5);
                CrossFourBarJointTest.assertEqualsVarEpsilon(expected_qddD, actual_qddD, 1.0E-5);
            }
            LogTools.info((String)("Average time: " + (double)totalTime / 1000000.0 / 1000.0 + "millisec"));
        }
    }

    @Test
    public void testSetJointAngularAcceleration() {
        Random random = new Random(67567L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                double theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getJointLimitLower(), (double)fourBarJoint.getJointLimitUpper());
                double thetaDot = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double thetaDDot = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                Vector3D angularAcceleration = new Vector3D();
                angularAcceleration.setAndScale(thetaDDot, (Tuple3DReadOnly)fourBarJoint.getJointAxis());
                Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)fourBarJoint.getJointAxis(), (boolean)true);
                angularAcceleration.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)angularAcceleration);
                fourBarJoint.setQ(theta);
                fourBarJoint.setQd(thetaDot);
                fourBarJoint.setJointAngularAcceleration((Vector3DReadOnly)angularAcceleration);
                fourBarJoint.updateFramesRecursively();
                Assertions.assertEquals((double)theta, (double)fourBarJoint.getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)thetaDot, (double)fourBarJoint.getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)thetaDDot, (double)fourBarJoint.getQdd(), (double)1.0E-7);
            }
        }
    }

    @Test
    public void testSetJointLinearAcceleration() {
        Random random = new Random(7523L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (JointBasics)fourBarJoint);
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (JointBasics)fourBarJoint);
                fourBarJoint.updateFramesRecursively();
                double expected_qdd = fourBarJoint.getQdd();
                fourBarJoint.setJointLinearAcceleration((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
                fourBarJoint.updateFramesRecursively();
                double actual_qdd = fourBarJoint.getQdd();
                Assertions.assertEquals((double)expected_qdd, (double)actual_qdd, (double)1.0E-10);
            }
        }
    }

    @Test
    public void testGetJointAcceleration() {
        Random random = new Random(0x488D44L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                RevoluteJointBasics bottomJoint;
                RevoluteJointBasics topJoint;
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double qddActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.getActuatedJoint().setQdd(qddActuated);
                function.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQd(qdActuated);
                function.getActuatedJoint().setQdd(qddActuated);
                fourBarJoint.updateFramesRecursively();
                function.updateState(true, true);
                function.getJointA().getPredecessor().updateFramesRecursively();
                Assertions.assertEquals((double)function.getJointA().getQ(), (double)fourBarJoint.getJointA().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointB().getQ(), (double)fourBarJoint.getJointB().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointC().getQ(), (double)fourBarJoint.getJointC().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointD().getQ(), (double)fourBarJoint.getJointD().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointA().getQd(), (double)fourBarJoint.getJointA().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointB().getQd(), (double)fourBarJoint.getJointB().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointC().getQd(), (double)fourBarJoint.getJointC().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointD().getQd(), (double)fourBarJoint.getJointD().getQd(), (double)1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointA().getQdd(), fourBarJoint.getJointA().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointB().getQdd(), fourBarJoint.getJointB().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointC().getQdd(), fourBarJoint.getJointC().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointD().getQdd(), fourBarJoint.getJointD().getQdd(), 1.0E-7);
                if (fourBarJoint.getFrameBeforeJoint() == fourBarJoint.getJointA().getFrameBeforeJoint()) {
                    topJoint = fourBarJoint.getJointA();
                    bottomJoint = fourBarJoint.getJointD();
                } else {
                    topJoint = fourBarJoint.getJointB();
                    bottomJoint = fourBarJoint.getJointC();
                }
                SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)topJoint.getPredecessor(), worldFrame);
                SpatialAcceleration expectedAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)spatialAccelerationCalculator.getRelativeAcceleration((RigidBodyReadOnly)topJoint.getPredecessor(), (RigidBodyReadOnly)bottomJoint.getSuccessor()));
                expectedAcceleration.setBaseFrame((ReferenceFrame)topJoint.getFrameBeforeJoint());
                expectedAcceleration.setBodyFrame((ReferenceFrame)bottomJoint.getFrameAfterJoint());
                expectedAcceleration.changeFrame((ReferenceFrame)bottomJoint.getFrameAfterJoint());
                SpatialAccelerationReadOnly actualAcceleration = fourBarJoint.getJointAcceleration();
                CrossFourBarJointTest.assertSpatialAccelerationEquals("Iteration " + i, (SpatialAccelerationReadOnly)expectedAcceleration, actualAcceleration, Math.max(1.0, expectedAcceleration.length()) * 1.0E-7);
            }
        }
    }

    @Test
    public void testGetSuccessorAcceleration() {
        Random random = new Random(0x488D44L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (int i = 0; i < 1000; ++i) {
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double qddActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.getActuatedJoint().setQdd(qddActuated);
                function.getActuatedJoint().setQ(qActuated);
                function.getActuatedJoint().setQd(qdActuated);
                function.getActuatedJoint().setQdd(qddActuated);
                fourBarJoint.updateFramesRecursively();
                function.updateState(true, true);
                function.getJointA().getPredecessor().updateFramesRecursively();
                Assertions.assertEquals((double)function.getJointA().getQ(), (double)fourBarJoint.getJointA().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointB().getQ(), (double)fourBarJoint.getJointB().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointC().getQ(), (double)fourBarJoint.getJointC().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointD().getQ(), (double)fourBarJoint.getJointD().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointA().getQd(), (double)fourBarJoint.getJointA().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointB().getQd(), (double)fourBarJoint.getJointB().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointC().getQd(), (double)fourBarJoint.getJointC().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointD().getQd(), (double)fourBarJoint.getJointD().getQd(), (double)1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointA().getQdd(), fourBarJoint.getJointA().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointB().getQdd(), fourBarJoint.getJointB().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointC().getQdd(), fourBarJoint.getJointC().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointD().getQdd(), fourBarJoint.getJointD().getQdd(), 1.0E-7);
                SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)function.getJointA().getPredecessor(), worldFrame);
                SpatialAcceleration expectedAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)spatialAccelerationCalculator.getRelativeAcceleration((RigidBodyReadOnly)function.getJointA().getPredecessor(), (RigidBodyReadOnly)function.getJointD().getSuccessor()));
                expectedAcceleration.setBodyFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                expectedAcceleration.setBaseFrame((ReferenceFrame)fourBarJoint.getPredecessor().getBodyFixedFrame());
                expectedAcceleration.setReferenceFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                SpatialAcceleration actualAcceleration = new SpatialAcceleration();
                fourBarJoint.getSuccessorAcceleration((SpatialAccelerationBasics)actualAcceleration);
                CrossFourBarJointTest.assertSpatialAccelerationEquals("Iteration " + i, (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)actualAcceleration, Math.max(1.0, expectedAcceleration.length()) * 1.0E-7);
            }
        }
    }

    @Test
    public void testGetJointBiasAcceleration() {
        Random random = new Random(0x488D44L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            RevoluteJointBasics bottomJoint;
            RevoluteJointBasics topJoint;
            double qdd;
            double qd;
            double q;
            int i;
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            FourBarKinematicLoopFunction function = generator.apply("copy").getFourBarFunction();
            for (i = 0; i < 1000; ++i) {
                q = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getJointLimitLower(), (double)fourBarJoint.getJointLimitUpper());
                qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                qdd = 0.0;
                fourBarJoint.setQ(q);
                fourBarJoint.setQd(qd);
                fourBarJoint.setQdd(qdd);
                fourBarJoint.updateFramesRecursively();
                Assertions.assertEquals((double)qdd, (double)fourBarJoint.getQdd(), (double)1.0E-10);
                function.getActuatedJoint().setQ(fourBarJoint.getActuatedJoint().getQ());
                function.getActuatedJoint().setQd(fourBarJoint.getActuatedJoint().getQd());
                function.getActuatedJoint().setQdd(fourBarJoint.getActuatedJoint().getQdd());
                function.updateState(true, true);
                function.getJointA().getPredecessor().updateFramesRecursively();
                Assertions.assertEquals((double)function.getJointA().getQ(), (double)fourBarJoint.getJointA().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointB().getQ(), (double)fourBarJoint.getJointB().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointC().getQ(), (double)fourBarJoint.getJointC().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointD().getQ(), (double)fourBarJoint.getJointD().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointA().getQd(), (double)fourBarJoint.getJointA().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointB().getQd(), (double)fourBarJoint.getJointB().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointC().getQd(), (double)fourBarJoint.getJointC().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointD().getQd(), (double)fourBarJoint.getJointD().getQd(), (double)1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointA().getQdd(), fourBarJoint.getJointA().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointB().getQdd(), fourBarJoint.getJointB().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointC().getQdd(), fourBarJoint.getJointC().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointD().getQdd(), fourBarJoint.getJointD().getQdd(), 1.0E-7);
                if (fourBarJoint.getFrameBeforeJoint() == fourBarJoint.getJointA().getFrameBeforeJoint()) {
                    topJoint = fourBarJoint.getJointA();
                    bottomJoint = fourBarJoint.getJointD();
                } else {
                    topJoint = fourBarJoint.getJointB();
                    bottomJoint = fourBarJoint.getJointC();
                }
                SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)topJoint.getPredecessor(), worldFrame);
                SpatialAcceleration expectedAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)spatialAccelerationCalculator.getRelativeAcceleration((RigidBodyReadOnly)topJoint.getPredecessor(), (RigidBodyReadOnly)bottomJoint.getSuccessor()));
                expectedAcceleration.setBaseFrame((ReferenceFrame)topJoint.getFrameBeforeJoint());
                expectedAcceleration.setBodyFrame((ReferenceFrame)bottomJoint.getFrameAfterJoint());
                expectedAcceleration.changeFrame((ReferenceFrame)bottomJoint.getFrameAfterJoint());
                SpatialAccelerationReadOnly actualAcceleration = fourBarJoint.getJointBiasAcceleration();
                CrossFourBarJointTest.assertSpatialAccelerationEquals("Iteration " + i, (SpatialAccelerationReadOnly)expectedAcceleration, actualAcceleration, Math.max(1.0, expectedAcceleration.length()) * 1.0E-7);
            }
            for (i = 0; i < 1000; ++i) {
                q = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getJointLimitLower(), (double)fourBarJoint.getJointLimitUpper());
                qd = 0.0;
                qdd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.setQ(q);
                fourBarJoint.setQd(qd);
                fourBarJoint.setQdd(qdd);
                fourBarJoint.updateFramesRecursively();
                function.getActuatedJoint().setQ(fourBarJoint.getActuatedJoint().getQ());
                function.getActuatedJoint().setQd(fourBarJoint.getActuatedJoint().getQd());
                function.getActuatedJoint().setQdd(fourBarJoint.getActuatedJoint().getQdd());
                function.updateState(true, true);
                function.getJointA().getPredecessor().updateFramesRecursively();
                Assertions.assertEquals((double)function.getJointA().getQ(), (double)fourBarJoint.getJointA().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointB().getQ(), (double)fourBarJoint.getJointB().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointC().getQ(), (double)fourBarJoint.getJointC().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointD().getQ(), (double)fourBarJoint.getJointD().getQ(), (double)1.0E-10);
                Assertions.assertEquals((double)function.getJointA().getQd(), (double)fourBarJoint.getJointA().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointB().getQd(), (double)fourBarJoint.getJointB().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointC().getQd(), (double)fourBarJoint.getJointC().getQd(), (double)1.0E-7);
                Assertions.assertEquals((double)function.getJointD().getQd(), (double)fourBarJoint.getJointD().getQd(), (double)1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointA().getQdd(), fourBarJoint.getJointA().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointB().getQdd(), fourBarJoint.getJointB().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointC().getQdd(), fourBarJoint.getJointC().getQdd(), 1.0E-7);
                CrossFourBarJointTest.assertEqualsVarEpsilon(function.getJointD().getQdd(), fourBarJoint.getJointD().getQdd(), 1.0E-7);
                if (fourBarJoint.getFrameBeforeJoint() == fourBarJoint.getJointA().getFrameBeforeJoint()) {
                    topJoint = fourBarJoint.getJointA();
                    bottomJoint = fourBarJoint.getJointD();
                } else {
                    topJoint = fourBarJoint.getJointB();
                    bottomJoint = fourBarJoint.getJointC();
                }
                SpatialAcceleration expectedAcceleration = new SpatialAcceleration((ReferenceFrame)bottomJoint.getFrameAfterJoint(), (ReferenceFrame)topJoint.getFrameBeforeJoint(), (ReferenceFrame)bottomJoint.getFrameAfterJoint());
                SpatialAccelerationReadOnly actualAcceleration = fourBarJoint.getJointBiasAcceleration();
                CrossFourBarJointTest.assertSpatialAccelerationEquals("Iteration " + i, (SpatialAccelerationReadOnly)expectedAcceleration, actualAcceleration, Math.max(1.0, expectedAcceleration.length()) * 1.0E-10);
            }
        }
    }

    @Test
    public void testGetUnitJointAcceleration() {
        Random random = new Random(8623435L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double qddActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(0.0);
                fourBarJoint.getActuatedJoint().setQdd(qddActuated);
                fourBarJoint.updateFramesRecursively();
                SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)fourBarJoint.getJointA().getPredecessor(), worldFrame);
                SpatialAcceleration expectedAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)spatialAccelerationCalculator.getRelativeAcceleration((RigidBodyReadOnly)fourBarJoint.getJointA().getPredecessor(), (RigidBodyReadOnly)fourBarJoint.getJointD().getSuccessor()));
                expectedAcceleration.changeFrame((ReferenceFrame)fourBarJoint.getFrameAfterJoint());
                expectedAcceleration.setBaseFrame((ReferenceFrame)fourBarJoint.getFrameBeforeJoint());
                expectedAcceleration.setBodyFrame((ReferenceFrame)fourBarJoint.getFrameAfterJoint());
                expectedAcceleration.scale(1.0 / fourBarJoint.getQdd());
                MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)fourBarJoint.getUnitJointAcceleration(), (double)1.0E-10);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.updateFramesRecursively();
                MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)fourBarJoint.getUnitJointAcceleration(), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testGetUnitSuccessorAcceleration() {
        Random random = new Random(8623435L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double qddActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(0.0);
                fourBarJoint.getActuatedJoint().setQdd(qddActuated);
                fourBarJoint.updateFramesRecursively();
                SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)fourBarJoint.getJointA().getPredecessor(), worldFrame);
                SpatialAcceleration expectedAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)spatialAccelerationCalculator.getRelativeAcceleration((RigidBodyReadOnly)fourBarJoint.getJointA().getPredecessor(), (RigidBodyReadOnly)fourBarJoint.getJointD().getSuccessor()));
                expectedAcceleration.setBaseFrame((ReferenceFrame)fourBarJoint.getPredecessor().getBodyFixedFrame());
                expectedAcceleration.setBodyFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                expectedAcceleration.changeFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                expectedAcceleration.scale(1.0 / fourBarJoint.getQdd());
                MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)fourBarJoint.getUnitSuccessorAcceleration(), (double)1.0E-10);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.updateFramesRecursively();
                MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)fourBarJoint.getUnitSuccessorAcceleration(), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testGetUnitPredecessorAcceleration() {
        Random random = new Random(8623435L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                double qActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getActuatedJoint().getJointLimitLower(), (double)fourBarJoint.getActuatedJoint().getJointLimitUpper());
                double qdActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double qddActuated = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.getActuatedJoint().setQ(qActuated);
                fourBarJoint.getActuatedJoint().setQd(0.0);
                fourBarJoint.getActuatedJoint().setQdd(qddActuated);
                fourBarJoint.updateFramesRecursively();
                SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)fourBarJoint.getJointA().getPredecessor(), worldFrame);
                SpatialAcceleration expectedAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)spatialAccelerationCalculator.getRelativeAcceleration((RigidBodyReadOnly)fourBarJoint.getJointD().getSuccessor(), (RigidBodyReadOnly)fourBarJoint.getJointA().getPredecessor()));
                expectedAcceleration.setBaseFrame((ReferenceFrame)fourBarJoint.getSuccessor().getBodyFixedFrame());
                expectedAcceleration.setBodyFrame((ReferenceFrame)fourBarJoint.getPredecessor().getBodyFixedFrame());
                expectedAcceleration.setReferenceFrame((ReferenceFrame)fourBarJoint.getPredecessor().getBodyFixedFrame());
                expectedAcceleration.scale(1.0 / fourBarJoint.getQdd());
                MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)fourBarJoint.getUnitPredecessorAcceleration(), (double)1.0E-10);
                fourBarJoint.getActuatedJoint().setQd(qdActuated);
                fourBarJoint.updateFramesRecursively();
                MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)fourBarJoint.getUnitPredecessorAcceleration(), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testSetTau() {
        Random random = new Random(3453897L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getJointLimitLower(), (double)fourBarJoint.getJointLimitUpper());
                double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double qdd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double tau = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                fourBarJoint.setQ(q);
                fourBarJoint.setQd(qd);
                fourBarJoint.setQdd(qdd);
                fourBarJoint.setTau(tau);
                Assertions.assertEquals((double)tau, (double)fourBarJoint.getTau(), (double)1.0E-10, (String)("Iteration " + i));
            }
        }
    }

    @Test
    public void testSetJointTorque() {
        Random random = new Random(3453897L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getJointLimitLower(), (double)fourBarJoint.getJointLimitUpper());
                double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double qdd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double tau = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                Vector3D jointTorque = new Vector3D();
                jointTorque.setAndScale(tau, (Tuple3DReadOnly)fourBarJoint.getJointAxis());
                Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)fourBarJoint.getJointAxis(), (boolean)true);
                jointTorque.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)jointTorque);
                fourBarJoint.setQ(q);
                fourBarJoint.setQd(qd);
                fourBarJoint.setQdd(qdd);
                fourBarJoint.setJointTorque((Vector3DReadOnly)jointTorque);
                Assertions.assertEquals((double)tau, (double)fourBarJoint.getTau(), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testSetJointForce() {
        Random random = new Random(3453897L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            for (int i = 0; i < 1000; ++i) {
                double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getJointLimitLower(), (double)fourBarJoint.getJointLimitUpper());
                double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double qdd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double tau = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                Vector3D jointForce = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
                fourBarJoint.setQ(q);
                fourBarJoint.setQd(qd);
                fourBarJoint.setQdd(qdd);
                fourBarJoint.setTau(tau);
                Assertions.assertEquals((double)tau, (double)fourBarJoint.getTau(), (double)1.0E-10);
                fourBarJoint.setJointForce((Vector3DReadOnly)jointForce);
                Assertions.assertEquals((double)tau, (double)fourBarJoint.getTau(), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testGetJointWrench() {
        Random random = new Random(3453897L);
        for (Function<String, CrossFourBarJoint> generator : CrossFourBarJointTest.createCrossFourBarExampleGenerators()) {
            CrossFourBarJoint fourBarJoint = generator.apply("fourBar1");
            GeometricJacobianCalculator jacobian = new GeometricJacobianCalculator();
            jacobian.setKinematicChain((JointReadOnly[])new OneDoFJointBasics[]{fourBarJoint});
            jacobian.setJacobianFrame((ReferenceFrame)fourBarJoint.getFrameAfterJoint());
            for (int i = 0; i < 1000; ++i) {
                double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBarJoint.getJointLimitLower(), (double)fourBarJoint.getJointLimitUpper());
                double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double qdd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                double tau = EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0);
                fourBarJoint.setQ(q);
                fourBarJoint.setQd(qd);
                fourBarJoint.setQdd(qdd);
                fourBarJoint.setTau(tau);
                Assertions.assertEquals((double)tau, (double)fourBarJoint.getTau(), (double)1.0E-10);
                fourBarJoint.updateFramesRecursively();
                Wrench jointWrench = new Wrench(fourBarJoint.getJointWrench());
                jointWrench.setBodyFrame((ReferenceFrame)fourBarJoint.getFrameAfterJoint());
                double actualTau = fourBarJoint.getUnitJointTwist().dot((WrenchReadOnly)jointWrench);
                Assertions.assertEquals((double)fourBarJoint.getTau(), (double)actualTau, (double)1.0E-10);
                jacobian.reset();
                DMatrixRMaj jointTorque = new DMatrixRMaj(1, 0);
                jacobian.getJointTorques(fourBarJoint.getJointWrench(), (DMatrix1Row)jointTorque);
                Assertions.assertEquals((double)fourBarJoint.getTau(), (double)jointTorque.get(0), (double)1.0E-10);
            }
        }
    }

    private static void assertEqualsVarEpsilon(double expected, double actual, double epsilon) {
        double varEpsilon = Math.max(1.0, Math.abs(expected)) * epsilon;
        Assertions.assertEquals((double)expected, (double)actual, (double)varEpsilon);
    }

    private static void assertTwistEquals(String messagePrefix, TwistReadOnly expectedTwist, TwistReadOnly actualTwist, double epsilon) {
        try {
            Assertions.assertEquals((Object)expectedTwist.getBodyFrame().getName(), (Object)actualTwist.getBodyFrame().getName());
            Assertions.assertEquals((Object)expectedTwist.getBaseFrame().getName(), (Object)actualTwist.getBaseFrame().getName());
            Assertions.assertEquals((Object)expectedTwist.getReferenceFrame().getName(), (Object)actualTwist.getReferenceFrame().getName());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTwist.getAngularPart(), (EuclidGeometry)actualTwist.getAngularPart(), (double)epsilon);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTwist.getLinearPart(), (EuclidGeometry)actualTwist.getLinearPart(), (double)epsilon);
        }
        catch (AssertionError e) {
            Vector3D angularError = new Vector3D();
            Vector3D linearError = new Vector3D();
            angularError.sub((Tuple3DReadOnly)expectedTwist.getAngularPart(), (Tuple3DReadOnly)actualTwist.getAngularPart());
            linearError.sub((Tuple3DReadOnly)expectedTwist.getLinearPart(), (Tuple3DReadOnly)actualTwist.getLinearPart());
            String errorMessage = String.format("Expected:\n%s\nbut was:\n%s\nDifference: angular=%s, linear=%s", MecanoIOTools.getTwistString((String)EuclidCoreTestTools.DEFAULT_FORMAT, (TwistReadOnly)expectedTwist), MecanoIOTools.getTwistString((String)EuclidCoreTestTools.DEFAULT_FORMAT, (TwistReadOnly)actualTwist), Double.toString(angularError.length()), Double.toString(linearError.length()));
            throw new AssertionFailedError(EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)errorMessage));
        }
    }

    private static void assertSpatialAccelerationEquals(String messagePrefix, SpatialAccelerationReadOnly expectedAcceleration, SpatialAccelerationReadOnly actualAcceleration, double epsilon) {
        try {
            Assertions.assertEquals((Object)expectedAcceleration.getBodyFrame().getName(), (Object)actualAcceleration.getBodyFrame().getName());
            Assertions.assertEquals((Object)expectedAcceleration.getBaseFrame().getName(), (Object)actualAcceleration.getBaseFrame().getName());
            Assertions.assertEquals((Object)expectedAcceleration.getReferenceFrame().getName(), (Object)actualAcceleration.getReferenceFrame().getName());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAcceleration.getAngularPart(), (EuclidGeometry)actualAcceleration.getAngularPart(), (double)epsilon);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAcceleration.getLinearPart(), (EuclidGeometry)actualAcceleration.getLinearPart(), (double)epsilon);
        }
        catch (AssertionError e) {
            Vector3D angularError = new Vector3D();
            Vector3D linearError = new Vector3D();
            angularError.sub((Tuple3DReadOnly)expectedAcceleration.getAngularPart(), (Tuple3DReadOnly)actualAcceleration.getAngularPart());
            linearError.sub((Tuple3DReadOnly)expectedAcceleration.getLinearPart(), (Tuple3DReadOnly)actualAcceleration.getLinearPart());
            String errorMessage = String.format("Expected:\n%s\nbut was:\n%s\nDifference: angular=%s, linear=%s", MecanoIOTools.getSpatialAccelerationString((String)EuclidCoreTestTools.DEFAULT_FORMAT, (SpatialAccelerationReadOnly)expectedAcceleration), MecanoIOTools.getSpatialAccelerationString((String)EuclidCoreTestTools.DEFAULT_FORMAT, (SpatialAccelerationReadOnly)actualAcceleration), Double.toString(angularError.length()), Double.toString(linearError.length()));
            throw new AssertionFailedError(EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)errorMessage));
        }
    }

    static RevoluteJoint[] nextCrossFourBar(Random random, String prefix, Vector3DReadOnly axis, int actuatedJointIndex, boolean flipAxesRandomly) {
        return CrossFourBarJointTest.nextCrossFourBar(random, prefix, (RigidBodyBasics)new RigidBody(prefix + "Root", worldFrame), joint -> MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)(prefix + "BodyCD"), (JointBasics)joint), axis, actuatedJointIndex, flipAxesRandomly);
    }

    private static RevoluteJoint[] nextCrossFourBar(Random random, String prefix, RigidBodyBasics predecessor, Function<RevoluteJointBasics, RigidBodyBasics> successorFactory, Vector3DReadOnly axis, int actuatedJointIndex, boolean flipAxesRandomly) {
        List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
        int flippedIndex = random.nextInt(4);
        Collections.swap(vertices, flippedIndex, (flippedIndex + 1) % 4);
        Point2D A = (Point2D)vertices.get(0);
        Point2D B = (Point2D)vertices.get(1);
        Point2D C = (Point2D)vertices.get(2);
        Point2D D = (Point2D)vertices.get(3);
        Vector2D AB = new Vector2D();
        Vector2D AC = new Vector2D();
        Vector2D AD = new Vector2D();
        AB.sub((Tuple2DReadOnly)B, (Tuple2DReadOnly)A);
        AC.sub((Tuple2DReadOnly)C, (Tuple2DReadOnly)A);
        AD.sub((Tuple2DReadOnly)D, (Tuple2DReadOnly)A);
        Vector3D axisA = new Vector3D((Tuple3DReadOnly)axis);
        Vector3D axisB = new Vector3D((Tuple3DReadOnly)axis);
        Vector3D axisC = new Vector3D((Tuple3DReadOnly)axis);
        Vector3D axisD = new Vector3D((Tuple3DReadOnly)axis);
        FramePoint3D jointAPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame fourBarLocalFrame = FourBarKinematicLoopFunctionTools.constructReferenceFrameFromPointAndAxis((String)"LocalFrame", (FramePoint3DReadOnly)jointAPosition, (Axis3D)Axis3D.Z, (FrameVector3DReadOnly)new FrameVector3D(worldFrame, (Tuple3DReadOnly)axis));
        FramePoint3D jointBPosition = new FramePoint3D(fourBarLocalFrame, (Tuple2DReadOnly)AB);
        jointBPosition.setZ(EuclidCoreRandomTools.nextDouble((Random)random));
        jointBPosition.changeFrame(worldFrame);
        FramePoint3D jointCPosition = new FramePoint3D(fourBarLocalFrame, (Tuple2DReadOnly)AC);
        jointCPosition.setZ(EuclidCoreRandomTools.nextDouble((Random)random));
        jointCPosition.changeFrame(worldFrame);
        FramePoint3D jointDPosition = new FramePoint3D(fourBarLocalFrame, (Tuple2DReadOnly)AD);
        jointDPosition.setZ(EuclidCoreRandomTools.nextDouble((Random)random));
        jointDPosition.changeFrame(worldFrame);
        if (flipAxesRandomly) {
            if (actuatedJointIndex != 0 && random.nextBoolean()) {
                axisA.negate();
            }
            if (actuatedJointIndex != 1 && random.nextBoolean()) {
                axisB.negate();
            }
            if (actuatedJointIndex != 2 && random.nextBoolean()) {
                axisC.negate();
            }
            if (actuatedJointIndex != 3 && random.nextBoolean()) {
                axisD.negate();
            }
        }
        RevoluteJoint jointA = new RevoluteJoint(prefix + "JointA", predecessor, (Tuple3DReadOnly)jointAPosition, (Vector3DReadOnly)axisA);
        RevoluteJoint jointB = new RevoluteJoint(prefix + "JointB", predecessor, (Tuple3DReadOnly)jointBPosition, (Vector3DReadOnly)axisB);
        RigidBody bodyDA = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)(prefix + "BodyDA"), (JointBasics)jointA);
        RigidBody bodyBC = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)(prefix + "BodyBC"), (JointBasics)jointB);
        jointCPosition.changeFrame((ReferenceFrame)jointB.getFrameAfterJoint());
        RevoluteJoint jointC = new RevoluteJoint(prefix + "JointC", (RigidBodyBasics)bodyBC, (Tuple3DReadOnly)jointCPosition, (Vector3DReadOnly)axisC);
        jointDPosition.changeFrame((ReferenceFrame)jointA.getFrameAfterJoint());
        RevoluteJoint jointD = new RevoluteJoint(prefix + "JointD", (RigidBodyBasics)bodyDA, (Tuple3DReadOnly)jointDPosition, (Vector3DReadOnly)axisD);
        RigidBodyBasics bodyCD = successorFactory.apply((RevoluteJointBasics)jointD);
        jointCPosition.changeFrame((ReferenceFrame)jointD.getFrameAfterJoint());
        jointC.setupLoopClosure(bodyCD, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)jointCPosition));
        return new RevoluteJoint[]{jointA, jointB, jointC, jointD};
    }

    private static List<Function<String, CrossFourBarJoint>> createCrossFourBarExampleGenerators() {
        ArrayList<Function<String, CrossFourBarJoint>> generators = new ArrayList<Function<String, CrossFourBarJoint>>();
        generators.add(name -> CrossFourBarJointTest.createKnownCrossFourBarJoint1(name, 0, 1.0E-10));
        generators.add(name -> CrossFourBarJointTest.createKnownCrossFourBarJoint2(name, 0, 1.0E-10));
        return generators;
    }

    private static CrossFourBarJoint createKnownCrossFourBarJoint1(String name, int actuatedJointIndex, double solverTolerance) {
        Point2D A = new Point2D(0.002, -0.189);
        Point2D B = new Point2D(-0.019, -0.144);
        Point2D C = new Point2D(0.023, -0.245);
        Point2D D = new Point2D(-0.015, -0.278);
        return CrossFourBarJointTest.createCrossFourBarJoint(name, (Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D, actuatedJointIndex, solverTolerance);
    }

    private static CrossFourBarJoint createKnownCrossFourBarJoint2(String name, int actuatedJointIndex, double solverTolerance) {
        Point2D A = new Point2D(0.227, 0.1);
        Point2D B = new Point2D(0.227, -0.1);
        Point2D C = new Point2D(0.427, 0.1);
        Point2D D = new Point2D(0.427, -0.1);
        return CrossFourBarJointTest.createCrossFourBarJoint(name, (Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D, actuatedJointIndex, solverTolerance);
    }

    private static CrossFourBarJoint createCrossFourBarJoint(String name, Point2DReadOnly A, Point2DReadOnly B, Point2DReadOnly C, Point2DReadOnly D, int actuatedJointIndex, double solverTolerance) {
        RigidBody rootBody = new RigidBody("root", worldFrame);
        RigidBodyTransform transformAToPredecessor = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D((Tuple2DReadOnly)A));
        RigidBodyTransform transformBToPredecessor = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D((Tuple2DReadOnly)B));
        Vector2D AD = new Vector2D();
        AD.sub((Tuple2DReadOnly)D, (Tuple2DReadOnly)A);
        Vector2D BC = new Vector2D();
        BC.sub((Tuple2DReadOnly)C, (Tuple2DReadOnly)B);
        RigidBodyTransform transformCToB = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D((Tuple2DReadOnly)BC));
        RigidBodyTransform transformDToA = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D((Tuple2DReadOnly)AD));
        CrossFourBarJoint joint = new CrossFourBarJoint(name, (RigidBodyBasics)rootBody, "jointA", "jointB", "jointC", "jointD", "bodyDA", "bodyBC", (RigidBodyTransformReadOnly)transformAToPredecessor, (RigidBodyTransformReadOnly)transformBToPredecessor, (RigidBodyTransformReadOnly)transformDToA, (RigidBodyTransformReadOnly)transformCToB, null, null, 0.0, 0.0, null, null, actuatedJointIndex, 3, (Vector3DReadOnly)Axis3D.Z);
        joint.setIKSolver((CrossFourBarJointIKSolver)new CrossFourBarJointIKBinarySolver(solverTolerance));
        new RigidBody("bodyCD", (JointBasics)joint, (Matrix3DReadOnly)new Matrix3D(), 0.0, (RigidBodyTransformReadOnly)new RigidBodyTransform());
        return joint;
    }
}

