/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.PlanarJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.SphericalJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;

public class MultiBodySystemStateIntegratorTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;
    private static final double LARGE_EPSILON = 1.0E-10;

    @Test
    public void testSixDoFJointAgainstFiniteDifference() {
        Random random = new Random(5464576L);
        Pose3D initialPose = new Pose3D();
        Twist initialTwist = new Twist();
        SpatialAcceleration initialAcceleration = new SpatialAcceleration();
        Quaternion difference = new Quaternion();
        FrameVector3D angularVelocityFD = new FrameVector3D();
        FrameVector3D linearVelocityFD = new FrameVector3D();
        for (int i = 0; i < 1000; ++i) {
            String messagePrefix = "Iteration " + i;
            RigidBody root = new RigidBody("root", worldFrame);
            SixDoFJoint joint = new SixDoFJoint("joint", (RigidBodyBasics)root);
            RigidBody object = new RigidBody("object", (JointBasics)joint, (Matrix3DReadOnly)new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0), 1.0, (Tuple3DReadOnly)new Vector3D());
            Pose3DBasics jointPose = joint.getJointPose();
            FixedFrameTwistBasics jointTwist = joint.getJointTwist();
            FixedFrameSpatialAccelerationBasics jointAcceleration = joint.getJointAcceleration();
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-5, (double)0.001);
            MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (JointBasics)joint);
            double expectedKineticCoEnergy = 0.0;
            initialPose.set((Pose3DReadOnly)jointPose);
            initialTwist.setIncludingFrame((SpatialMotionReadOnly)jointTwist);
            initialAcceleration.setIncludingFrame((SpatialMotionReadOnly)jointAcceleration);
            integrator.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
            root.updateFramesRecursively();
            EuclidGeometryTestTools.assertPose3DEquals((String)messagePrefix, (Pose3DReadOnly)initialPose, (Pose3DReadOnly)jointPose, (double)1.0E-12);
            MecanoTestTools.assertTwistEquals((String)messagePrefix, (TwistReadOnly)initialTwist, (TwistReadOnly)jointTwist, (double)1.0E-12);
            MecanoTestTools.assertSpatialAccelerationEquals((String)messagePrefix, (SpatialAccelerationReadOnly)initialAcceleration, (SpatialAccelerationReadOnly)jointAcceleration, (double)1.0E-12);
            double actualKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            Assertions.assertEquals((double)expectedKineticCoEnergy, (double)actualKineticCoEnergy, (double)1.0E-12);
            jointTwist.getAngularPart().setToZero();
            jointTwist.getLinearPart().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
            jointAcceleration.setToZero();
            root.updateFramesRecursively();
            expectedKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            initialPose.set((Pose3DReadOnly)jointPose);
            initialTwist.setIncludingFrame((SpatialMotionReadOnly)jointTwist);
            initialAcceleration.setIncludingFrame((SpatialMotionReadOnly)jointAcceleration);
            integrator.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
            root.updateFramesRecursively();
            angularVelocityFD.setReferenceFrame((ReferenceFrame)joint.getFrameAfterJoint());
            difference.difference((QuaternionReadOnly)initialPose.getOrientation(), (QuaternionReadOnly)jointPose.getOrientation());
            difference.getRotationVector((Vector3DBasics)angularVelocityFD);
            angularVelocityFD.scale(1.0 / dt);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(), (Tuple3DReadOnly)angularVelocityFD, (double)1.0E-10);
            linearVelocityFD.setReferenceFrame(worldFrame);
            linearVelocityFD.sub((Tuple3DReadOnly)jointPose.getPosition(), (Tuple3DReadOnly)initialPose.getPosition());
            linearVelocityFD.scale(1.0 / dt);
            linearVelocityFD.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)angularVelocityFD, (FrameTuple3DReadOnly)jointTwist.getAngularPart(), (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)linearVelocityFD, (FrameTuple3DReadOnly)jointTwist.getLinearPart(), (double)1.0E-10);
            MecanoTestTools.assertTwistEquals((String)messagePrefix, (TwistReadOnly)initialTwist, (TwistReadOnly)jointTwist, (double)1.0E-12);
            MecanoTestTools.assertSpatialAccelerationEquals((String)messagePrefix, (SpatialAccelerationReadOnly)initialAcceleration, (SpatialAccelerationReadOnly)jointAcceleration, (double)1.0E-12);
            actualKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            Assertions.assertEquals((double)expectedKineticCoEnergy, (double)actualKineticCoEnergy, (double)1.0E-12);
            jointTwist.getAngularPart().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
            jointTwist.getLinearPart().setToZero();
            jointAcceleration.setToZero();
            root.updateFramesRecursively();
            expectedKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            initialPose.set((Pose3DReadOnly)jointPose);
            initialTwist.setIncludingFrame((SpatialMotionReadOnly)jointTwist);
            initialAcceleration.setIncludingFrame((SpatialMotionReadOnly)jointAcceleration);
            integrator.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
            root.updateFramesRecursively();
            angularVelocityFD.setReferenceFrame((ReferenceFrame)joint.getFrameAfterJoint());
            difference.difference((QuaternionReadOnly)initialPose.getOrientation(), (QuaternionReadOnly)jointPose.getOrientation());
            difference.getRotationVector((Vector3DBasics)angularVelocityFD);
            angularVelocityFD.scale(1.0 / dt);
            linearVelocityFD.setReferenceFrame(worldFrame);
            linearVelocityFD.sub((Tuple3DReadOnly)jointPose.getPosition(), (Tuple3DReadOnly)initialPose.getPosition());
            linearVelocityFD.scale(1.0 / dt);
            linearVelocityFD.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)angularVelocityFD, (FrameTuple3DReadOnly)jointTwist.getAngularPart(), (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)linearVelocityFD, (FrameTuple3DReadOnly)jointTwist.getLinearPart(), (double)1.0E-12);
            MecanoTestTools.assertSpatialAccelerationEquals((String)messagePrefix, (SpatialAccelerationReadOnly)initialAcceleration, (SpatialAccelerationReadOnly)jointAcceleration, (double)1.0E-12);
            actualKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            Assertions.assertEquals((double)expectedKineticCoEnergy, (double)actualKineticCoEnergy, (double)1.0E-12);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (JointBasics)joint);
            root.updateFramesRecursively();
            ForwardDynamicsCalculator calculator = new ForwardDynamicsCalculator((RigidBodyReadOnly)root);
            calculator.compute();
            calculator.writeComputedJointAcceleration((JointBasics)joint);
            double expectedKineticCoEnergy2 = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            initialPose.set((Pose3DReadOnly)jointPose);
            initialTwist.setIncludingFrame((SpatialMotionReadOnly)jointTwist);
            initialAcceleration.setIncludingFrame((SpatialMotionReadOnly)jointAcceleration);
            FrameVector3D expectedLinearAccelerationInWorld = new FrameVector3D((FrameTuple3DReadOnly)jointAcceleration.getLinearPart());
            expectedLinearAccelerationInWorld.changeFrame(worldFrame);
            FrameVector3D actualLinearAccelerationInWorld = new FrameVector3D(worldFrame);
            SpatialVector initialVelocityInWorld = new SpatialVector((SpatialVectorReadOnly)jointTwist);
            initialVelocityInWorld.changeFrame(worldFrame);
            integrator.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
            root.updateFramesRecursively();
            angularVelocityFD.setReferenceFrame((ReferenceFrame)joint.getFrameAfterJoint());
            difference.difference((QuaternionReadOnly)initialPose.getOrientation(), (QuaternionReadOnly)jointPose.getOrientation());
            difference.getRotationVector((Vector3DBasics)angularVelocityFD);
            angularVelocityFD.scale(1.0 / dt);
            linearVelocityFD.setReferenceFrame(worldFrame);
            linearVelocityFD.sub((Tuple3DReadOnly)jointPose.getPosition(), (Tuple3DReadOnly)initialPose.getPosition());
            linearVelocityFD.scale(1.0 / dt);
            linearVelocityFD.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)angularVelocityFD, (FrameTuple3DReadOnly)jointTwist.getAngularPart(), (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)linearVelocityFD, (FrameTuple3DReadOnly)jointTwist.getLinearPart(), (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)initialAcceleration.getAngularPart(), (FrameTuple3DReadOnly)jointAcceleration.getAngularPart(), (double)1.0E-10);
            actualLinearAccelerationInWorld.setMatchingFrame((FrameTuple3DReadOnly)jointAcceleration.getLinearPart());
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)expectedLinearAccelerationInWorld, (FrameTuple3DReadOnly)actualLinearAccelerationInWorld, (double)1.0E-12);
            SpatialVector finalVelocityInWorld = new SpatialVector((SpatialVectorReadOnly)jointTwist);
            finalVelocityInWorld.changeFrame(worldFrame);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)initialVelocityInWorld.getLinearPart(), (FrameTuple3DReadOnly)finalVelocityInWorld.getLinearPart(), (double)1.0E-12);
            double actualKineticCoEnergy2 = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            Assertions.assertEquals((double)expectedKineticCoEnergy2, (double)actualKineticCoEnergy2, (double)1.0E-12);
        }
    }

    @Test
    public void testSixDoFJointBallistic() {
        Random random = new Random(4366346L);
        for (int i = 0; i < 1000; ++i) {
            double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-100.0, (double)-10.0);
            RigidBody root = new RigidBody("root", worldFrame);
            SixDoFJoint joint = new SixDoFJoint("joint", (RigidBodyBasics)root);
            new RigidBody("object", (JointBasics)joint, (Matrix3DReadOnly)new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0), 1.0, (Tuple3DReadOnly)new Vector3D());
            Pose3DBasics jointPose = joint.getJointPose();
            FixedFrameTwistBasics jointTwist = joint.getJointTwist();
            FixedFrameSpatialAccelerationBasics jointAcceleration = joint.getJointAcceleration();
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-5, (double)0.001);
            MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (JointBasics)joint);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (JointBasics)joint);
            root.updateFramesRecursively();
            Pose3D initialPose = new Pose3D((Pose3DReadOnly)jointPose);
            Twist initialTwist = new Twist((SpatialMotionReadOnly)jointTwist);
            Point3D expectedPosition = new Point3D((Tuple3DReadOnly)jointPose.getPosition());
            FrameVector3D expectedLinearVelocity = new FrameVector3D((FrameTuple3DReadOnly)jointTwist.getLinearPart());
            expectedLinearVelocity.changeFrame(worldFrame);
            FrameVector3D expectedLinearAcceleration = new FrameVector3D(worldFrame, 0.0, 0.0, gravity);
            double x0 = initialPose.getX();
            double y0 = initialPose.getY();
            double z0 = initialPose.getZ();
            double zd0 = expectedLinearVelocity.getZ();
            ForwardDynamicsCalculator calculator = new ForwardDynamicsCalculator((RigidBodyReadOnly)root);
            calculator.setGravitionalAcceleration(gravity);
            FrameVector3D actualLinearVelocity = new FrameVector3D();
            FrameVector3D actualLinearAcceleration = new FrameVector3D();
            FrameVector3D expectedAngularAcceleration = new FrameVector3D((ReferenceFrame)joint.getFrameAfterJoint());
            for (int j = 0; j < 1000; ++j) {
                double t = ((double)j + 1.0) * dt;
                String messagePrefix = "Iteration " + i + ", time " + t;
                expectedLinearVelocity.setZ(zd0 + gravity * t);
                expectedPosition.setX(x0 + expectedLinearVelocity.getX() * t);
                expectedPosition.setY(y0 + expectedLinearVelocity.getY() * t);
                expectedPosition.setZ(z0 + zd0 * t + 0.5 * gravity * t * t);
                calculator.compute();
                calculator.writeComputedJointAcceleration((JointBasics)joint);
                integrator.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
                root.updateFramesRecursively();
                EuclidCoreTestTools.assertTuple3DEquals((String)messagePrefix, (Tuple3DReadOnly)expectedPosition, (Tuple3DReadOnly)jointPose.getPosition(), (double)1.0E-12);
                EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)initialTwist.getAngularPart(), (FrameTuple3DReadOnly)jointTwist.getAngularPart(), (double)1.0E-12);
                actualLinearVelocity.setMatchingFrame((FrameTuple3DReadOnly)jointTwist.getLinearPart());
                EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)expectedLinearVelocity, (FrameTuple3DReadOnly)actualLinearVelocity, (double)1.0E-12);
                EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)expectedAngularAcceleration, (FrameTuple3DReadOnly)jointAcceleration.getAngularPart(), (double)1.0E-12);
                jointAcceleration.getLinearAccelerationAtBodyOrigin((TwistReadOnly)jointTwist, (FrameVector3DBasics)actualLinearAcceleration);
                actualLinearAcceleration.changeFrame(worldFrame);
                EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)expectedLinearAcceleration, (FrameTuple3DReadOnly)actualLinearAcceleration, (double)1.0E-12);
            }
        }
    }

    @Test
    public void testPlanarJointAgainstFiniteDifference() {
        Random random = new Random(5464576L);
        Pose3D initialPose = new Pose3D();
        Twist initialTwist = new Twist();
        SpatialAcceleration initialAcceleration = new SpatialAcceleration();
        Quaternion difference = new Quaternion();
        FrameVector3D angularVelocityFD = new FrameVector3D();
        FrameVector3D linearVelocityFD = new FrameVector3D();
        for (int i = 0; i < 1000; ++i) {
            String messagePrefix = "Iteration " + i;
            RigidBody root = new RigidBody("root", worldFrame);
            PlanarJoint joint = new PlanarJoint("joint", (RigidBodyBasics)root);
            RigidBody object = new RigidBody("object", (JointBasics)joint, (Matrix3DReadOnly)new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0), 1.0, (Tuple3DReadOnly)new Vector3D());
            Pose3DBasics jointPose = joint.getJointPose();
            FixedFrameTwistBasics jointTwist = joint.getJointTwist();
            FixedFrameSpatialAccelerationBasics jointAcceleration = joint.getJointAcceleration();
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-5, (double)0.001);
            MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (JointBasics)joint);
            double expectedKineticCoEnergy = 0.0;
            initialPose.set((Pose3DReadOnly)jointPose);
            initialTwist.setIncludingFrame((SpatialMotionReadOnly)jointTwist);
            initialAcceleration.setIncludingFrame((SpatialMotionReadOnly)jointAcceleration);
            integrator.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
            root.updateFramesRecursively();
            EuclidGeometryTestTools.assertPose3DEquals((String)messagePrefix, (Pose3DReadOnly)initialPose, (Pose3DReadOnly)jointPose, (double)1.0E-12);
            MecanoTestTools.assertTwistEquals((String)messagePrefix, (TwistReadOnly)initialTwist, (TwistReadOnly)jointTwist, (double)1.0E-12);
            MecanoTestTools.assertSpatialAccelerationEquals((String)messagePrefix, (SpatialAccelerationReadOnly)initialAcceleration, (SpatialAccelerationReadOnly)jointAcceleration, (double)1.0E-12);
            double actualKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            Assertions.assertEquals((double)expectedKineticCoEnergy, (double)actualKineticCoEnergy, (double)1.0E-12);
            jointTwist.getAngularPart().setToZero();
            jointTwist.getLinearPart().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
            jointAcceleration.setToZero();
            root.updateFramesRecursively();
            expectedKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            initialPose.set((Pose3DReadOnly)jointPose);
            initialTwist.setIncludingFrame((SpatialMotionReadOnly)jointTwist);
            initialAcceleration.setIncludingFrame((SpatialMotionReadOnly)jointAcceleration);
            integrator.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
            root.updateFramesRecursively();
            angularVelocityFD.setReferenceFrame((ReferenceFrame)joint.getFrameAfterJoint());
            difference.difference((QuaternionReadOnly)initialPose.getOrientation(), (QuaternionReadOnly)jointPose.getOrientation());
            difference.getRotationVector((Vector3DBasics)angularVelocityFD);
            angularVelocityFD.scale(1.0 / dt);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(), (Tuple3DReadOnly)angularVelocityFD, (double)1.0E-10);
            linearVelocityFD.setReferenceFrame(worldFrame);
            linearVelocityFD.sub((Tuple3DReadOnly)jointPose.getPosition(), (Tuple3DReadOnly)initialPose.getPosition());
            linearVelocityFD.scale(1.0 / dt);
            linearVelocityFD.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)angularVelocityFD, (FrameTuple3DReadOnly)jointTwist.getAngularPart(), (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)linearVelocityFD, (FrameTuple3DReadOnly)jointTwist.getLinearPart(), (double)1.0E-10);
            MecanoTestTools.assertTwistEquals((String)messagePrefix, (TwistReadOnly)initialTwist, (TwistReadOnly)jointTwist, (double)1.0E-12);
            MecanoTestTools.assertSpatialAccelerationEquals((String)messagePrefix, (SpatialAccelerationReadOnly)initialAcceleration, (SpatialAccelerationReadOnly)jointAcceleration, (double)1.0E-12);
            actualKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            Assertions.assertEquals((double)expectedKineticCoEnergy, (double)actualKineticCoEnergy, (double)1.0E-12);
            jointTwist.getAngularPart().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
            jointTwist.getLinearPart().setToZero();
            jointAcceleration.setToZero();
            root.updateFramesRecursively();
            expectedKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            initialPose.set((Pose3DReadOnly)jointPose);
            initialTwist.setIncludingFrame((SpatialMotionReadOnly)jointTwist);
            initialAcceleration.setIncludingFrame((SpatialMotionReadOnly)jointAcceleration);
            integrator.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
            root.updateFramesRecursively();
            angularVelocityFD.setReferenceFrame((ReferenceFrame)joint.getFrameAfterJoint());
            difference.difference((QuaternionReadOnly)initialPose.getOrientation(), (QuaternionReadOnly)jointPose.getOrientation());
            difference.getRotationVector((Vector3DBasics)angularVelocityFD);
            angularVelocityFD.scale(1.0 / dt);
            linearVelocityFD.setReferenceFrame(worldFrame);
            linearVelocityFD.sub((Tuple3DReadOnly)jointPose.getPosition(), (Tuple3DReadOnly)initialPose.getPosition());
            linearVelocityFD.scale(1.0 / dt);
            linearVelocityFD.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)angularVelocityFD, (FrameTuple3DReadOnly)jointTwist.getAngularPart(), (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)linearVelocityFD, (FrameTuple3DReadOnly)jointTwist.getLinearPart(), (double)1.0E-12);
            MecanoTestTools.assertSpatialAccelerationEquals((String)messagePrefix, (SpatialAccelerationReadOnly)initialAcceleration, (SpatialAccelerationReadOnly)jointAcceleration, (double)1.0E-12);
            actualKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            Assertions.assertEquals((double)expectedKineticCoEnergy, (double)actualKineticCoEnergy, (double)1.0E-12);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (JointBasics)joint);
            root.updateFramesRecursively();
            ForwardDynamicsCalculator calculator = new ForwardDynamicsCalculator((RigidBodyReadOnly)root);
            calculator.compute();
            calculator.writeComputedJointAcceleration((JointBasics)joint);
            double expectedKineticCoEnergy2 = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            initialPose.set((Pose3DReadOnly)jointPose);
            initialTwist.setIncludingFrame((SpatialMotionReadOnly)jointTwist);
            initialAcceleration.setIncludingFrame((SpatialMotionReadOnly)jointAcceleration);
            FrameVector3D expectedLinearAccelerationInWorld = new FrameVector3D((FrameTuple3DReadOnly)jointAcceleration.getLinearPart());
            expectedLinearAccelerationInWorld.changeFrame(worldFrame);
            FrameVector3D actualLinearAccelerationInWorld = new FrameVector3D(worldFrame);
            SpatialVector initialVelocityInWorld = new SpatialVector((SpatialVectorReadOnly)jointTwist);
            initialVelocityInWorld.changeFrame(worldFrame);
            integrator.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
            root.updateFramesRecursively();
            angularVelocityFD.setReferenceFrame((ReferenceFrame)joint.getFrameAfterJoint());
            difference.difference((QuaternionReadOnly)initialPose.getOrientation(), (QuaternionReadOnly)jointPose.getOrientation());
            difference.getRotationVector((Vector3DBasics)angularVelocityFD);
            angularVelocityFD.scale(1.0 / dt);
            linearVelocityFD.setReferenceFrame(worldFrame);
            linearVelocityFD.sub((Tuple3DReadOnly)jointPose.getPosition(), (Tuple3DReadOnly)initialPose.getPosition());
            linearVelocityFD.scale(1.0 / dt);
            linearVelocityFD.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)angularVelocityFD, (FrameTuple3DReadOnly)jointTwist.getAngularPart(), (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)linearVelocityFD, (FrameTuple3DReadOnly)jointTwist.getLinearPart(), (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)initialAcceleration.getAngularPart(), (FrameTuple3DReadOnly)jointAcceleration.getAngularPart(), (double)1.0E-10);
            actualLinearAccelerationInWorld.setMatchingFrame((FrameTuple3DReadOnly)jointAcceleration.getLinearPart());
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)expectedLinearAccelerationInWorld, (FrameTuple3DReadOnly)actualLinearAccelerationInWorld, (double)1.0E-12);
            SpatialVector finalVelocityInWorld = new SpatialVector((SpatialVectorReadOnly)jointTwist);
            finalVelocityInWorld.changeFrame(worldFrame);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)initialVelocityInWorld.getLinearPart(), (FrameTuple3DReadOnly)finalVelocityInWorld.getLinearPart(), (double)1.0E-12);
            double actualKineticCoEnergy2 = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            Assertions.assertEquals((double)expectedKineticCoEnergy2, (double)actualKineticCoEnergy2, (double)1.0E-12);
        }
    }

    @Test
    public void testPlanarJointBallistic() {
        Random random = new Random(4366346L);
        for (int i = 0; i < 1000; ++i) {
            double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-100.0, (double)-10.0);
            RigidBody root = new RigidBody("root", worldFrame);
            PlanarJoint joint = new PlanarJoint("joint", (RigidBodyBasics)root);
            new RigidBody("object", (JointBasics)joint, (Matrix3DReadOnly)new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0), 1.0, (Tuple3DReadOnly)new Vector3D());
            Pose3DBasics jointPose = joint.getJointPose();
            FixedFrameTwistBasics jointTwist = joint.getJointTwist();
            FixedFrameSpatialAccelerationBasics jointAcceleration = joint.getJointAcceleration();
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-5, (double)0.001);
            MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (JointBasics)joint);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (JointBasics)joint);
            root.updateFramesRecursively();
            Pose3D initialPose = new Pose3D((Pose3DReadOnly)jointPose);
            Twist initialTwist = new Twist((SpatialMotionReadOnly)jointTwist);
            Point3D expectedPosition = new Point3D((Tuple3DReadOnly)jointPose.getPosition());
            FrameVector3D expectedLinearVelocity = new FrameVector3D((FrameTuple3DReadOnly)jointTwist.getLinearPart());
            expectedLinearVelocity.changeFrame(worldFrame);
            FrameVector3D expectedLinearAcceleration = new FrameVector3D(worldFrame, 0.0, 0.0, gravity);
            double x0 = initialPose.getX();
            double y0 = initialPose.getY();
            double z0 = initialPose.getZ();
            double zd0 = expectedLinearVelocity.getZ();
            ForwardDynamicsCalculator calculator = new ForwardDynamicsCalculator((RigidBodyReadOnly)root);
            calculator.setGravitionalAcceleration(gravity);
            FrameVector3D actualLinearVelocity = new FrameVector3D();
            FrameVector3D actualLinearAcceleration = new FrameVector3D();
            FrameVector3D expectedAngularAcceleration = new FrameVector3D((ReferenceFrame)joint.getFrameAfterJoint());
            for (int j = 0; j < 1000; ++j) {
                double t = ((double)j + 1.0) * dt;
                String messagePrefix = "Iteration " + i + ", time " + t;
                expectedLinearVelocity.setZ(zd0 + gravity * t);
                expectedPosition.setX(x0 + expectedLinearVelocity.getX() * t);
                expectedPosition.setY(y0 + expectedLinearVelocity.getY() * t);
                expectedPosition.setZ(z0 + zd0 * t + 0.5 * gravity * t * t);
                calculator.compute();
                calculator.writeComputedJointAcceleration((JointBasics)joint);
                integrator.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
                root.updateFramesRecursively();
                EuclidCoreTestTools.assertTuple3DEquals((String)messagePrefix, (Tuple3DReadOnly)expectedPosition, (Tuple3DReadOnly)jointPose.getPosition(), (double)1.0E-12);
                EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)initialTwist.getAngularPart(), (FrameTuple3DReadOnly)jointTwist.getAngularPart(), (double)1.0E-12);
                actualLinearVelocity.setMatchingFrame((FrameTuple3DReadOnly)jointTwist.getLinearPart());
                EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)expectedLinearVelocity, (FrameTuple3DReadOnly)actualLinearVelocity, (double)1.0E-12);
                EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)expectedAngularAcceleration, (FrameTuple3DReadOnly)jointAcceleration.getAngularPart(), (double)1.0E-12);
                jointAcceleration.getLinearAccelerationAtBodyOrigin((TwistReadOnly)jointTwist, (FrameVector3DBasics)actualLinearAcceleration);
                actualLinearAcceleration.changeFrame(worldFrame);
                EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)expectedLinearAcceleration, (FrameTuple3DReadOnly)actualLinearAcceleration, (double)1.0E-12);
            }
        }
    }

    @Test
    public void testSphericalJointAgainstFiniteDifference() {
        Random random = new Random(5464576L);
        Quaternion initialOrientation = new Quaternion();
        FrameVector3D initialAngularVelocity = new FrameVector3D();
        FrameVector3D initialAngularAcceleration = new FrameVector3D();
        Quaternion difference = new Quaternion();
        FrameVector3D angularVelocityFD = new FrameVector3D();
        for (int i = 0; i < 1000; ++i) {
            String messagePrefix = "Iteration " + i;
            RigidBody root = new RigidBody("root", worldFrame);
            SphericalJoint joint = new SphericalJoint("joint", (RigidBodyBasics)root, (RigidBodyTransformReadOnly)new RigidBodyTransform());
            RigidBody object = new RigidBody("object", (JointBasics)joint, (Matrix3DReadOnly)new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0), 1.0, (Tuple3DReadOnly)new Vector3D());
            QuaternionBasics jointOrientation = joint.getJointOrientation();
            FixedFrameVector3DBasics jointAngularVelocity = joint.getJointAngularVelocity();
            FixedFrameVector3DBasics jointAngularAcceleration = joint.getJointAngularAcceleration();
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-5, (double)0.001);
            MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (JointBasics)joint);
            double expectedKineticCoEnergy = 0.0;
            initialOrientation.set((QuaternionReadOnly)jointOrientation);
            initialAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)jointAngularVelocity);
            initialAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)jointAngularAcceleration);
            integrator.doubleIntegrateFromAcceleration((SphericalJointBasics)joint);
            root.updateFramesRecursively();
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((String)messagePrefix, (QuaternionReadOnly)initialOrientation, (QuaternionReadOnly)jointOrientation, (double)1.0E-12);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)initialAngularVelocity, (FrameTuple3DReadOnly)jointAngularVelocity, (double)1.0E-12);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)initialAngularAcceleration, (FrameTuple3DReadOnly)jointAngularAcceleration, (double)1.0E-12);
            double actualKineticCoEnergy = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            Assertions.assertEquals((double)expectedKineticCoEnergy, (double)actualKineticCoEnergy, (double)1.0E-12);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (JointBasics)joint);
            root.updateFramesRecursively();
            ForwardDynamicsCalculator calculator = new ForwardDynamicsCalculator((RigidBodyReadOnly)root);
            calculator.compute();
            calculator.writeComputedJointAcceleration((JointBasics)joint);
            double expectedKineticCoEnergy2 = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            initialOrientation.set((QuaternionReadOnly)jointOrientation);
            initialAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)jointAngularVelocity);
            initialAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)jointAngularAcceleration);
            integrator.doubleIntegrateFromAcceleration((SphericalJointBasics)joint);
            root.updateFramesRecursively();
            angularVelocityFD.setReferenceFrame((ReferenceFrame)joint.getFrameAfterJoint());
            difference.difference((QuaternionReadOnly)initialOrientation, (QuaternionReadOnly)jointOrientation);
            difference.getRotationVector((Vector3DBasics)angularVelocityFD);
            angularVelocityFD.scale(1.0 / dt);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)angularVelocityFD, (FrameTuple3DReadOnly)jointAngularVelocity, (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple3DEquals((String)messagePrefix, (FrameTuple3DReadOnly)initialAngularAcceleration, (FrameTuple3DReadOnly)jointAngularAcceleration, (double)1.0E-10);
            double actualKineticCoEnergy2 = object.getInertia().computeKineticCoEnergy(object.getBodyFixedFrame().getTwistOfFrame());
            Assertions.assertEquals((double)expectedKineticCoEnergy2, (double)actualKineticCoEnergy2, (double)1.0E-12);
        }
    }
}

